/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.objects.ObjectDefinitionTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class CompilerEnvironment
implements Environment.EnvironmentImpl {
    private final Map<String, Construct> constants = new HashMap<String, Construct>();
    private final List<ParseTree> includes = new ArrayList<ParseTree>();
    private final Stack<Set<String>> knownVars = new Stack();
    private final ObjectDefinitionTable objectDefinitionTable = ObjectDefinitionTable.GetBlankInstance();
    private final List<CompilerWarning> compilerWarnings = new ArrayList<CompilerWarning>();
    private boolean logCompilerWarnings = true;

    public void setConstant(String name, Construct value) {
        this.constants.put(name, value);
    }

    public void setConstant(String name, String value) {
        this.setConstant(name, new CString(value, Target.UNKNOWN));
    }

    public Construct getConstant(String name) {
        return this.constants.get(name);
    }

    public void pushVariableStack() {
        this.knownVars.push(new HashSet());
    }

    public void popVariableStack() {
        this.knownVars.pop();
    }

    public void addKnownVar(String name) {
        this.knownVars.peek().add(name);
    }

    public boolean isVarKnown(String name) {
        for (Set set : this.knownVars) {
            if (!set.contains(name)) continue;
            return true;
        }
        return false;
    }

    public void addInclude(ParseTree tree) {
        this.includes.add(tree);
    }

    public List<ParseTree> getIncludes() {
        return new ArrayList<ParseTree>(this.includes);
    }

    @Override
    public Environment.EnvironmentImpl clone() throws CloneNotSupportedException {
        return this;
    }

    public ObjectDefinitionTable getObjectDefinitionTable() {
        return this.objectDefinitionTable;
    }

    public void setLogCompilerWarnings(boolean logCompilerWarnings) {
        this.logCompilerWarnings = logCompilerWarnings;
    }

    public void addCompilerWarning(FileOptions fileOptions, CompilerWarning warning) {
        boolean isSuppressed = fileOptions == null || warning.getSuppressCategory() == null ? false : fileOptions.isWarningSuppressed(warning.getSuppressCategory());
        if (isSuppressed) {
            return;
        }
        this.compilerWarnings.add(warning);
        if (this.logCompilerWarnings) {
            MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.COMPILER, LogLevel.WARNING, warning.getMessage(), warning.getTarget());
        }
    }

    public void addCodeUpgradeNotice(FileOptions fileOptions, CompilerWarning warning) {
        if (fileOptions == null) {
            return;
        }
        if (!fileOptions.isStrict()) {
            return;
        }
        if (fileOptions.isWarningSuppressed(FileOptions.SuppressWarning.CodeUpgradeNotices)) {
            return;
        }
        this.compilerWarnings.add(warning);
        if (this.logCompilerWarnings) {
            MSLog.GetLogger().Log((MSLog.Tag)MSLog.Tags.COMPILER, LogLevel.WARNING, warning.getMessage(), warning.getTarget());
        }
    }

    public List<CompilerWarning> getCompilerWarnings() {
        return new ArrayList<CompilerWarning>(this.compilerWarnings);
    }
}

