/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.constructs.CPackage;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREUnsupportedOperationException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Iterable;
import com.laytonsmith.core.natives.interfaces.MEnumType;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.ObjectDefinition;
import com.laytonsmith.core.objects.ObjectDefinitionNotFoundException;
import com.laytonsmith.core.objects.ObjectDefinitionTable;
import com.laytonsmith.core.objects.UserObject;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@typeof(value="ms.lang.ClassType")
public final class CClassType
extends Construct
implements Iterable {
    public static final String PATH_SEPARATOR = ".";
    private static final Map<FullyQualifiedClassName, CClassType> CACHE = new HashMap<FullyQualifiedClassName, CClassType>();
    public static final CClassType TYPE;
    public static final CClassType AUTO;
    public static final CClassType[] EMPTY_CLASS_ARRAY;
    private final boolean isTypeUnion;
    private final FullyQualifiedClassName fqcn;
    private static final Mixed[] UNINITIALIZED;
    private Mixed[] invalidType = UNINITIALIZED;
    private Class<? extends Mixed> nativeClass = null;
    private final SortedSet<FullyQualifiedClassName> types = new TreeSet<FullyQualifiedClassName>();

    public static CClassType get(Class<? extends Mixed> type) {
        try {
            CClassType t = CClassType.get(FullyQualifiedClassName.forNativeClass(type));
            t.nativeClass = type;
            return t;
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }

    public static CClassType get(FullyQualifiedClassName type) throws ClassNotFoundException {
        assert (type != null);
        CClassType ctype = CACHE.get(type);
        if (ctype == null) {
            ctype = new CClassType(type, Target.UNKNOWN, false);
            CACHE.put(type, ctype);
        }
        return ctype;
    }

    public static CClassType get(FullyQualifiedClassName ... types) throws ClassNotFoundException {
        TreeSet<FullyQualifiedClassName> t = new TreeSet<FullyQualifiedClassName>(Arrays.asList(types));
        FullyQualifiedClassName type = FullyQualifiedClassName.forFullyQualifiedClass(StringUtils.Join(t, "|", e -> e.getFQCN()));
        CClassType ctype = CACHE.get(type);
        if (ctype == null) {
            ctype = new CClassType(type, Target.UNKNOWN, false);
            CACHE.put(type, ctype);
        }
        return ctype;
    }

    public static CClassType get(CClassType ... types) throws ClassNotFoundException {
        return CClassType.get(Stream.of(types).map(e -> e.getFQCN()).sorted().collect(Collectors.toSet()).toArray(new FullyQualifiedClassName[types.length]));
    }

    public static CClassType defineClass(FullyQualifiedClassName fqcn) {
        try {
            CClassType type = new CClassType(fqcn, Target.UNKNOWN, true);
            CACHE.put(fqcn, type);
            return type;
        }
        catch (ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }

    private CClassType(String type, Target t) throws ClassNotFoundException {
        this(FullyQualifiedClassName.forFullyQualifiedClass(type), t, false);
    }

    private CClassType(FullyQualifiedClassName type, Target t, boolean newDefinition) throws ClassNotFoundException {
        super(type.getFQCN(), Construct.ConstructType.CLASS_TYPE, t);
        this.isTypeUnion = type.isTypeUnion();
        this.fqcn = type;
        if (this.isTypeUnion) {
            this.types.addAll(Stream.of(type.getFQCN().split("\\|")).map(e -> FullyQualifiedClassName.forFullyQualifiedClass(e.trim())).collect(Collectors.toList()));
        } else {
            this.types.add(type);
        }
        if (!newDefinition) {
            boolean found = false;
            String localFQCN = this.fqcn.getFQCN();
            if (localFQCN.equals("auto") || localFQCN.equals("ms.lang.ClassType")) {
                found = true;
            }
            if (!found) {
                if (this.isTypeUnion) {
                    boolean foundAllTypeUnion = true;
                    for (FullyQualifiedClassName c : this.types) {
                        if (null != NativeTypeList.resolveNativeType(c.getFQCN())) continue;
                        foundAllTypeUnion = false;
                        break;
                    }
                    if (foundAllTypeUnion) {
                        found = true;
                    }
                } else if (this.fqcn.getNativeClass() != null) {
                    found = true;
                } else {
                    boolean bl = found = null != NativeTypeList.resolveNativeType(this.fqcn.getFQCN());
                }
            }
            if (!found) {
                throw new ClassNotFoundException("Could not find class of type " + type);
            }
        }
    }

    private void instantiateInvalidType(Environment env) {
        if (this.invalidType != UNINITIALIZED) {
            return;
        }
        String fqcn = this.fqcn.getFQCN();
        try {
            if ("auto".equals(fqcn)) {
                this.invalidType = null;
            } else if ("ms.lang.ClassType".equals(fqcn)) {
                this.invalidType = new Mixed[]{this};
            } else {
                this.invalidType = new Mixed[this.types.size()];
                for (int i = 0; i < this.invalidType.length; ++i) {
                    if (NativeTypeList.getNativeTypeList().contains(this.fqcn)) {
                        this.invalidType[i] = NativeTypeList.getInvalidInstanceForUse(this.fqcn);
                        continue;
                    }
                    ObjectDefinitionTable odt = env.getEnv(CompilerEnvironment.class).getObjectDefinitionTable();
                    ObjectDefinition od = odt.get(this.fqcn);
                    this.invalidType[i] = new UserObject(Target.UNKNOWN, null, env, od, null);
                }
            }
        }
        catch (ObjectDefinitionNotFoundException | ClassNotFoundException ex) {
            throw new Error(ex);
        }
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isTypeUnion() {
        return this.isTypeUnion;
    }

    public static boolean doesExtend(CClassType checkClass, CClassType superClass) {
        if (checkClass.equals(superClass)) {
            return true;
        }
        if (checkClass.nativeClass != null && superClass.nativeClass != null && superClass.nativeClass.isAssignableFrom(checkClass.nativeClass)) {
            return true;
        }
        for (CClassType tCheck : checkClass.getTypes()) {
            for (CClassType tSuper : superClass.getTypes()) {
                try {
                    Class<? extends Mixed> cCheck;
                    Class<? extends Mixed> cSuper = NativeTypeList.getNativeClass(tSuper.getFQCN());
                    if (cSuper.isAssignableFrom(cCheck = NativeTypeList.getNativeClass(tCheck.getFQCN()))) continue;
                    return false;
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return true;
    }

    public boolean doesExtend(CClassType superClass) {
        return CClassType.doesExtend(this, superClass);
    }

    public static boolean unsafeDoesExtend(CClassType checkClass, CClassType superClass) {
        return CClassType.doesExtend(checkClass, superClass);
    }

    public boolean unsafeDoesExtend(CClassType superClass) {
        return CClassType.unsafeDoesExtend(this, superClass);
    }

    public boolean isExtendedBy(CClassType checkClass) throws ClassNotFoundException {
        return CClassType.doesExtend(checkClass, this);
    }

    public boolean unsafeIsExtendedBy(CClassType checkClass) {
        return CClassType.unsafeDoesExtend(checkClass, this);
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return EMPTY_CLASS_ARRAY;
    }

    public CClassType[] getSuperclassesForType(Environment env) {
        this.instantiateInvalidType(env);
        return Stream.of(this.invalidType).flatMap(e -> Stream.of(e.getSuperclasses())).collect(Collectors.toSet()).toArray(EMPTY_CLASS_ARRAY);
    }

    public CClassType[] getInterfacesForType(Environment env) {
        this.instantiateInvalidType(env);
        return Stream.of(this.invalidType).flatMap(e -> Stream.of(e.getInterfaces())).collect(Collectors.toSet()).toArray(EMPTY_CLASS_ARRAY);
    }

    protected Set<CClassType> getTypes() {
        TreeSet<CClassType> t = new TreeSet<CClassType>(Comparator.comparing(CClassType::getFQCN));
        for (FullyQualifiedClassName type : this.types) {
            try {
                t.add(CClassType.get(type));
            }
            catch (ClassNotFoundException ex) {
                throw new Error(ex);
            }
        }
        return t;
    }

    public CPackage getPackage() {
        if (this.isTypeUnion) {
            return null;
        }
        if (!this.val().contains(PATH_SEPARATOR)) {
            return null;
        }
        String[] parts = this.val().split(Pattern.quote(PATH_SEPARATOR));
        return new CPackage(Target.UNKNOWN, ArrayUtils.slice(parts, 0, parts.length - 2));
    }

    public String getSimpleName() {
        return this.fqcn.getSimpleName();
    }

    @Override
    public String docs() {
        return "A ClassType is a value that represents an object type. This includes primitives or other value types.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }

    public FullyQualifiedClassName getFQCN() {
        return this.fqcn;
    }

    public boolean isEnum() {
        if ("ms.lang.enum".equals(this.fqcn.getFQCN())) {
            return false;
        }
        return this.doesExtend(MEnumType.TYPE);
    }

    @Override
    public CClassType typeof() {
        return TYPE;
    }

    @Override
    public Mixed get(String index, Target t) throws ConfigRuntimeException {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).get(index, t);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new CREUnsupportedOperationException("Unsupported operation", t);
    }

    @Override
    public Mixed get(int index, Target t) throws ConfigRuntimeException {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).get(index, t);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new CREUnsupportedOperationException("Unsupported operation", t);
    }

    @Override
    public Mixed get(Mixed index, Target t) throws ConfigRuntimeException {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).get(index, t);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new CREUnsupportedOperationException("Unsupported operation", t);
    }

    @Override
    public Set<Mixed> keySet() {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).keySet();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return new HashSet<Mixed>();
    }

    @Override
    public long size() {
        if (this.isEnum()) {
            try {
                return NativeTypeList.getNativeEnumType(this.fqcn).size();
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return 0L;
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean canBeAssociative() {
        return true;
    }

    @Override
    public Mixed slice(int begin, int end, Target t) {
        throw new CREUnsupportedOperationException("Unsupported operation", t);
    }

    public Class<? extends Mixed> getNativeType() {
        return this.nativeClass;
    }

    static {
        try {
            TYPE = new CClassType("ms.lang.ClassType", Target.UNKNOWN);
            AUTO = new CClassType("auto", Target.UNKNOWN);
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        EMPTY_CLASS_ARRAY = new CClassType[0];
        CACHE.put(FullyQualifiedClassName.forNativeClass(CClassType.class), TYPE);
        UNINITIALIZED = new Mixed[0];
    }
}

