/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CResource;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Command;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.MarshalException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.AccessModifier;
import com.laytonsmith.core.objects.ObjectModifier;
import com.laytonsmith.core.objects.ObjectType;
import java.io.File;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class Construct
implements Cloneable,
Comparable<Construct>,
Mixed {
    private final ConstructType ctype;
    private final String value;
    private Target target;
    private transient boolean wasIdentifier = false;

    public ConstructType getCType() {
        return this.ctype;
    }

    public static boolean IsCType(Mixed m, ConstructType type) {
        if (m instanceof Construct) {
            return ((Construct)m).getCType() == type;
        }
        return false;
    }

    @Override
    public void setTarget(Target target) {
        this.target = target;
    }

    public int getLineNum() {
        return this.target.line();
    }

    public File getFile() {
        return this.target.file();
    }

    public int getColumn() {
        return this.target.col();
    }

    @Override
    public Target getTarget() {
        return this.target;
    }

    public Construct(String value, ConstructType ctype, int lineNum, File file, int column) {
        this.value = value;
        Static.AssertNonNull(value, "The string value may not be null.");
        this.ctype = ctype;
        this.target = new Target(lineNum, file, column);
    }

    public Construct(String value, ConstructType ctype, Target t) {
        this.value = value;
        Static.AssertNonNull(value, "The string value may not be null.");
        this.ctype = ctype;
        this.target = t;
    }

    @Override
    public String val() {
        return this.value;
    }

    public void setWasIdentifier(boolean b) {
        this.wasIdentifier = b;
    }

    public boolean wasIdentifier() {
        return this.wasIdentifier;
    }

    public static void SetWasIdentifierHelper(Mixed left, Mixed right, Boolean defaultValue) {
        if (right instanceof Construct) {
            defaultValue = ((Construct)right).wasIdentifier();
        }
        if (left instanceof Construct && defaultValue != null) {
            ((Construct)left).setWasIdentifier(defaultValue);
        }
    }

    public static String nval(Mixed value) {
        if (value instanceof CNull) {
            return null;
        }
        return value.val();
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Construct clone() throws CloneNotSupportedException {
        return (Construct)super.clone();
    }

    public static String json_encode(Mixed c, Target t) throws MarshalException {
        return JSONValue.toJSONString((Object)Construct.json_encode0(c, t));
    }

    private static Object json_encode0(Mixed c, Target t) throws MarshalException {
        if (c.isInstanceOf(CString.TYPE) || c instanceof Command) {
            return c.val();
        }
        if (c instanceof CVoid) {
            return "";
        }
        if (c instanceof CInt) {
            return ((CInt)c).getInt();
        }
        if (c instanceof CDouble) {
            return ((CDouble)c).getDouble();
        }
        if (c instanceof CBoolean) {
            return ((CBoolean)c).getBoolean();
        }
        if (c instanceof CNull) {
            return null;
        }
        if (c.isInstanceOf(CArray.TYPE)) {
            CArray ca = (CArray)c;
            if (!ca.inAssociativeMode()) {
                ArrayList<Object> list = new ArrayList<Object>();
                int i = 0;
                while ((long)i < ca.size()) {
                    list.add(Construct.json_encode0(ca.get(i, t), t));
                    ++i;
                }
                return list;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : ca.stringKeySet()) {
                map.put(key, Construct.json_encode0(ca.get(key, t), t));
            }
            return map;
        }
        throw new MarshalException("The type of " + c.getClass().getSimpleName() + " is not currently supported", c);
    }

    public static Construct json_decode(String s, Target t) throws MarshalException {
        if (s == null) {
            return CNull.NULL;
        }
        if ("".equals(s.trim())) {
            throw new MarshalException();
        }
        if (s.startsWith("{")) {
            JSONObject obj = (JSONObject)JSONValue.parse((String)s);
            CArray ca = CArray.GetAssociativeArray(t);
            if (obj == null) {
                throw new MarshalException();
            }
            for (Object key : obj.keySet()) {
                ca.set(Construct.convertJSON(key, t), (Mixed)Construct.convertJSON(obj.get(key), t), t);
            }
            return ca;
        }
        if (s.startsWith("[")) {
            JSONArray array2 = (JSONArray)JSONValue.parse((String)s);
            if (array2 == null) {
                throw new MarshalException();
            }
            CArray carray = new CArray(t);
            for (int i = 0; i < array2.size(); ++i) {
                carray.push(Construct.convertJSON(array2.get(i), t), t);
            }
            return carray;
        }
        s = "[" + s + "]";
        JSONArray array3 = (JSONArray)JSONValue.parse((String)s);
        if (array3 == null) {
            return CNull.NULL;
        }
        Object o = array3.get(0);
        return Construct.convertJSON(o, t);
    }

    private static Construct convertJSON(Object o, Target t) throws MarshalException {
        if (o instanceof String) {
            return new CString((String)o, Target.UNKNOWN);
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            if ((double)n.longValue() == n.doubleValue()) {
                return new CInt(n.longValue(), Target.UNKNOWN);
            }
            return new CDouble(n.doubleValue(), Target.UNKNOWN);
        }
        if (o instanceof Boolean) {
            return CBoolean.get((Boolean)o);
        }
        if (o instanceof List) {
            List l = (List)o;
            CArray ca = new CArray(t);
            for (Object l1 : l) {
                ca.push(Construct.convertJSON(l1, t), t);
            }
            return ca;
        }
        if (o == null) {
            return CNull.NULL;
        }
        if (o instanceof Map) {
            CArray ca = CArray.GetAssociativeArray(t);
            for (Object key : ((Map)o).keySet()) {
                ca.set(Construct.convertJSON(key, t), (Mixed)Construct.convertJSON(((Map)o).get(key), t), t);
            }
            return ca;
        }
        throw new MarshalException(o.getClass().getSimpleName() + " are not currently supported");
    }

    @Override
    public int compareTo(Construct c) {
        if (this.value.contains(" ") || this.value.contains("\t") || c.value.contains(" ") || c.value.contains("\t")) {
            return this.value.compareTo(c.value);
        }
        try {
            Double d1 = Double.valueOf(this.value);
            Double d2 = Double.valueOf(c.value);
            return d1.compareTo(d2);
        }
        catch (NumberFormatException e) {
            return this.value.compareTo(c.value);
        }
    }

    public static Construct GetConstruct(Object o) throws ClassCastException {
        return Construct.GetConstruct(o, false);
    }

    public static Construct GetConstruct(Object o, boolean allowResources) throws ClassCastException {
        if (o == null) {
            return CNull.NULL;
        }
        if (o instanceof CharSequence) {
            return new CString((CharSequence)o, Target.UNKNOWN);
        }
        if (o instanceof Number) {
            if (o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof BigInteger || o instanceof AtomicInteger || o instanceof Short) {
                return new CInt(((Number)o).longValue(), Target.UNKNOWN);
            }
            return new CDouble(((Number)o).doubleValue(), Target.UNKNOWN);
        }
        if (o instanceof Boolean) {
            return CBoolean.get((Boolean)o);
        }
        if (o instanceof Map) {
            CArray a = CArray.GetAssociativeArray(Target.UNKNOWN);
            Map m = (Map)o;
            for (Map.Entry entry : m.entrySet()) {
                a.set(entry.getKey().toString(), (Mixed)Construct.GetConstruct(entry.getValue(), allowResources), Target.UNKNOWN);
            }
            return a;
        }
        if (o instanceof Collection) {
            CArray a = new CArray(Target.UNKNOWN);
            Collection l = (Collection)o;
            for (Object obj : l) {
                a.push(Construct.GetConstruct(obj, allowResources), Target.UNKNOWN);
            }
            return a;
        }
        throw new ClassCastException(o.getClass().getName() + " cannot be cast to a Construct type");
    }

    public static Object GetPOJO(Mixed c) throws ClassCastException {
        if (c instanceof CNull) {
            return null;
        }
        if (c instanceof CString) {
            return c.val();
        }
        if (c instanceof CBoolean) {
            return ((CBoolean)c).getBoolean();
        }
        if (c instanceof CInt) {
            return ((CInt)c).getInt();
        }
        if (c instanceof CDouble) {
            return ((CDouble)c).getDouble();
        }
        if (c.isInstanceOf(CArray.TYPE)) {
            CArray ca = (CArray)c;
            if (ca.inAssociativeMode()) {
                TreeMap<String, Object> map = new TreeMap<String, Object>();
                for (Map.Entry<String, Mixed> entry : ca.getAssociativeArray().entrySet()) {
                    map.put(entry.getKey(), Construct.GetPOJO(entry.getValue()));
                }
                return map;
            }
            ArrayList<Object> list = new ArrayList<Object>((int)ca.size());
            for (Mixed construct : ca.getArray()) {
                list.add(Construct.GetPOJO(construct));
            }
            return list;
        }
        if (c instanceof CResource) {
            return ((CResource)c).getResource();
        }
        throw new ClassCastException(c.getClass().getName() + " cannot be cast to a POJO");
    }

    public CString asString() {
        return new CString(this.val(), this.target);
    }

    public abstract boolean isDynamic();

    public static boolean IsDynamicHelper(Mixed m) {
        if (m instanceof Construct) {
            return ((Construct)m).isDynamic();
        }
        return true;
    }

    protected String getQuote() {
        return "'" + this.val().replace("\\", "\\\\").replace("'", "\\'") + "'";
    }

    @Override
    public CClassType typeof() {
        return Construct.typeof(this);
    }

    public static CClassType typeof(Mixed that) {
        return CClassType.get(that.getClass());
    }

    @Override
    public final String getName() {
        typeof t = ClassDiscovery.GetClassAnnotation(this.getClass(), typeof.class);
        return t.value();
    }

    @Override
    public String docs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Version since() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(this.getClass());
    }

    @Override
    public Class<? extends Documentation>[] seeAlso() {
        return new Class[0];
    }

    @Override
    public CClassType[] getInterfaces() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CClassType[] getSuperclasses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectType getObjectType() {
        return ObjectType.CLASS;
    }

    @Override
    public Set<ObjectModifier> getObjectModifiers() {
        return EnumSet.noneOf(ObjectModifier.class);
    }

    @Override
    public AccessModifier getAccessModifier() {
        return AccessModifier.PUBLIC;
    }

    @Override
    public CClassType getContainingClass() {
        return null;
    }

    public static boolean isInstanceof(Mixed that, CClassType type) {
        return that.getClass().isAnnotationPresent(typeof.class) && that.typeof().doesExtend(type);
    }

    public static boolean isInstanceof(Mixed that, Class<? extends Mixed> type) {
        if (ClassDiscovery.GetClassAnnotation(that.getClass(), typeof.class) == null) {
            return false;
        }
        return that.typeof().doesExtend(CClassType.get(type));
    }

    @Override
    public boolean isInstanceOf(CClassType type) {
        return Construct.isInstanceof((Mixed)this, type);
    }

    @Override
    public boolean isInstanceOf(Class<? extends Mixed> type) {
        return Construct.isInstanceof((Mixed)this, type);
    }

    public int hashCode() {
        return Objects.hash(ClassDiscovery.GetClassAnnotation(this.getClass(), typeof.class), this.val());
    }

    public static enum ConstructType {
        TOKEN,
        COMMAND,
        FUNCTION,
        VARIABLE,
        LITERAL,
        ARRAY,
        MAP,
        ENTRY,
        INT,
        DOUBLE,
        BOOLEAN,
        NULL,
        STRING,
        VOID,
        IVARIABLE,
        CLOSURE,
        LABEL,
        SLICE,
        SYMBOL,
        IDENTIFIER,
        BRACE,
        BRACKET,
        BYTE_ARRAY,
        RESOURCE,
        LOCK,
        MUTABLE_PRIMITIVE,
        CLASS_TYPE,
        FULLY_QUALIFIED_CLASS_NAME;

    }
}

