/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashSet;
import java.util.Set;

public class InstanceofUtil {
    public static Set<CClassType> getAllCastableClasses(CClassType c, Environment env) {
        HashSet<CClassType> ret = new HashSet<CClassType>();
        InstanceofUtil.getAllCastableClassesWithBlacklist(c, ret, env);
        return ret;
    }

    private static Set<CClassType> getAllCastableClassesWithBlacklist(CClassType c, Set<CClassType> blacklist, Environment env) {
        block5: {
            if (blacklist.contains(c)) {
                return blacklist;
            }
            blacklist.add(c);
            try {
                for (CClassType s : c.getSuperclassesForType(env)) {
                    blacklist.addAll(InstanceofUtil.getAllCastableClassesWithBlacklist(s, blacklist, env));
                }
                for (CClassType iface : c.getInterfacesForType(env)) {
                    blacklist.addAll(InstanceofUtil.getAllCastableClassesWithBlacklist(iface, blacklist, env));
                }
            }
            catch (UnsupportedOperationException ex) {
                if (ClassDiscovery.GetClassAnnotation(c.getClass(), typeof.class) == null) break block5;
                throw new RuntimeException("Unexpected UnsupportedOperationException from " + c.getName());
            }
        }
        return blacklist;
    }

    public static boolean isInstanceof(Mixed value, FullyQualifiedClassName instanceofThis, Environment env) {
        Static.AssertNonNull(instanceofThis, "instanceofThis may not be null");
        if (instanceofThis.getFQCN().equals("auto")) {
            return true;
        }
        if (value instanceof CFunction) {
            return false;
        }
        for (CClassType c : InstanceofUtil.getAllCastableClasses(value.typeof(), env)) {
            FullyQualifiedClassName typeof2 = c.getFQCN();
            if (typeof2 == null || !typeof2.equals(instanceofThis)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceof(Mixed value, Class<? extends Mixed> instanceofThis, Environment env) {
        FullyQualifiedClassName typeof2 = InstanceofUtil.typeof(instanceofThis);
        return typeof2 == null ? false : InstanceofUtil.isInstanceof(value, typeof2, env);
    }

    public static boolean isInstanceof(Mixed value, CClassType instanceofThis, Environment env) {
        return InstanceofUtil.isInstanceof(value, instanceofThis.getFQCN(), env);
    }

    private static FullyQualifiedClassName typeof(Class<? extends Mixed> c) {
        typeof type = ClassDiscovery.GetClassAnnotation(c, typeof.class);
        if (type == null) {
            return null;
        }
        return FullyQualifiedClassName.forNativeClass(c);
    }
}

