/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events;

import com.laytonsmith.PureUtilities.Common.DateUtils;
import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.events.EventList;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.profiler.ProfilePoint;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BoundEvent
implements Comparable<BoundEvent> {
    private final String eventName;
    private final String id;
    private final Priority priority;
    private final Map<String, Mixed> prefilter;
    private final String eventObjName;
    private final Environment originalEnv;
    private final ParseTree tree;
    private final Driver driver;
    private static int eventId = 0;
    private final Target target;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int GetUniqueID() {
        Class<BoundEvent> clazz = BoundEvent.class;
        synchronized (BoundEvent.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++eventId;
        }
    }

    public Environment getEnvironment() {
        try {
            return this.originalEnv.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BoundEvent) {
            return this.id.equals(((BoundEvent)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "(" + this.eventName + ") " + this.id;
    }

    public BoundEvent(String name, CArray options, CArray prefilter, String eventObjName, Environment env, ParseTree tree, Target t) throws EventException {
        this.eventName = name;
        if (options != null && options.containsKey("id")) {
            this.id = options.get("id", t).val();
            if (this.id.matches(".*?:\\d*?")) {
                throw new EventException("The id given may not match the format\"string:number\"");
            }
        } else {
            this.id = name + ":" + BoundEvent.GetUniqueID();
        }
        if (options != null && options.containsKey("priority")) {
            try {
                this.priority = Priority.valueOf(options.get("priority", t).val().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new EventException("Priority must be one of: LOWEST, LOW, NORMAL, HIGH, HIGHEST, MONITOR");
            }
        } else {
            this.priority = Priority.NORMAL;
        }
        this.prefilter = new HashMap<String, Mixed>();
        if (prefilter != null) {
            for (String key : prefilter.stringKeySet()) {
                this.prefilter.put(key, prefilter.get(key, Target.UNKNOWN));
            }
        }
        this.originalEnv = env;
        this.tree = tree;
        if (EventList.getEvent(this.eventName) == null) {
            throw new EventException("No event named \"" + this.eventName + "\" is registered!");
        }
        this.driver = EventList.getEvent(this.eventName).driver();
        this.eventObjName = eventObjName;
        this.target = t;
    }

    public int getLineNum() {
        return this.target.line();
    }

    public File getFile() {
        return this.target.file();
    }

    public int getCol() {
        return this.target.col();
    }

    public Target getTarget() {
        return this.target;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getEventObjName() {
        return this.eventObjName;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Mixed> getPrefilter() {
        return this.prefilter;
    }

    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(BoundEvent o) {
        if (this.getPriority().getId() < o.getPriority().getId()) {
            return -1;
        }
        if (this.getPriority().getId() > o.getPriority().getId()) {
            return 1;
        }
        return this.id.compareTo(o.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(ActiveEvent activeEvent) throws EventException {
        try {
            Environment env = this.originalEnv.clone();
            CArray ca = CArray.GetAssociativeArray(Target.UNKNOWN);
            for (Map.Entry entry : activeEvent.parsedEvent.entrySet()) {
                ca.set(new CString((String)entry.getKey(), Target.UNKNOWN), (Mixed)entry.getValue(), Target.UNKNOWN);
            }
            env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, this.eventObjName, ca, Target.UNKNOWN));
            env.getEnv(GlobalEnv.class).SetEvent(activeEvent);
            activeEvent.addHistory("Triggering bound event: " + this);
            try {
                ProfilePoint p2 = env.getEnv(GlobalEnv.class).GetProfiler().start("Executing event handler for " + this.getEventName() + " defined at " + this.getTarget(), LogLevel.ERROR);
                try {
                    this.execute(env, activeEvent);
                }
                finally {
                    p2.stop();
                }
            }
            catch (ConfigRuntimeException e) {
                e.setEnv(env);
                throw e;
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(BoundEvent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void manual_trigger(CArray event) throws EventException {
        try {
            Environment env = this.originalEnv.clone();
            env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(CArray.TYPE, this.eventObjName, event, Target.UNKNOWN, env));
            HashMap<String, Mixed> map = new HashMap<String, Mixed>();
            for (String key : event.stringKeySet()) {
                map.put(key, event.get(key, Target.UNKNOWN));
            }
            ActiveEvent activeEvent = new ActiveEvent(null);
            activeEvent.setParsedEvent(map);
            activeEvent.setBoundEvent(this);
            env.getEnv(GlobalEnv.class).SetEvent(activeEvent);
            this.execute(env, activeEvent);
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(BoundEvent.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void execute(Environment env, ActiveEvent activeEvent) throws EventException {
        ParseTree superRoot = new ParseTree(null);
        superRoot.addChild(this.tree);
        Event myDriver = this.getEventDriver();
        myDriver.execute(superRoot, this, env, activeEvent);
    }

    public ParseTree getParseTree() {
        return this.tree;
    }

    public Event getEventDriver() {
        return EventList.getEvent(this.getDriver(), this.getEventName());
    }

    public static class ActiveEvent {
        private final BindableEvent underlyingEvent;
        private Map<String, Mixed> parsedEvent;
        private BoundEvent boundEvent;
        private Boolean cancelled;
        private BoundEvent consumedAt;
        private final Map<String, BoundEvent> lockedAt;
        private final List<Pair<CClosure, Environment>> whenCancelled;
        private final List<Pair<CClosure, Environment>> whenTriggered;
        private final List<String> history;

        public ActiveEvent(BindableEvent underlyingEvent) {
            this.underlyingEvent = underlyingEvent;
            this.cancelled = null;
            this.whenCancelled = new ArrayList<Pair<CClosure, Environment>>();
            this.whenTriggered = new ArrayList<Pair<CClosure, Environment>>();
            this.lockedAt = new HashMap<String, BoundEvent>();
            this.history = new ArrayList<String>();
        }

        public void addHistory(String history) {
            if (Prefs.DebugMode().booleanValue()) {
                this.history.add(DateUtils.ParseCalendarNotation("%Y-%M-%D %h:%m.%s - ") + history);
            }
        }

        public List<String> getHistory() {
            return this.history;
        }

        public Map<String, Mixed> getParsedEvent() {
            return this.parsedEvent;
        }

        public BindableEvent getUnderlyingEvent() {
            return this.underlyingEvent;
        }

        public BoundEvent getBoundEvent() {
            return this.boundEvent;
        }

        public void setBoundEvent(BoundEvent boundEvent) {
            this.boundEvent = boundEvent;
        }

        public void setParsedEvent(Map<String, Mixed> parsedEvent) {
            this.parsedEvent = parsedEvent;
        }

        public boolean isCancelled() {
            if (this.cancelled != null) {
                return this.cancelled;
            }
            if (this.boundEvent.getEventDriver().isCancellable(this.underlyingEvent)) {
                return this.boundEvent.getEventDriver().isCancelled(this.underlyingEvent);
            }
            return false;
        }

        public void setCancelled(boolean cancelled) {
            this.addHistory("Setting cancelled flag to " + cancelled + " " + this.boundEvent);
            this.cancelled = cancelled;
            try {
                this.boundEvent.getEventDriver().cancel(this.underlyingEvent, cancelled);
            }
            catch (EventException eventException) {
                // empty catch block
            }
        }

        public Event getEventDriver() {
            return this.boundEvent.getEventDriver();
        }

        public boolean isCancellable() {
            return this.boundEvent.getEventDriver().isCancellable(this.underlyingEvent);
        }

        public void consume() {
            this.addHistory("Consuming event" + this.boundEvent);
            if (this.consumedAt == null) {
                this.consumedAt = this.boundEvent;
            }
        }

        public boolean canReceive() {
            if (this.consumedAt == null) {
                return true;
            }
            return this.consumedAt.getPriority().isLowerPriority(this.boundEvent.getPriority());
        }

        public boolean isConsumed() {
            return this.consumedAt != null;
        }

        public Priority consumedAt() {
            return this.consumedAt.getPriority();
        }

        public void lock(String parameter) {
            this.addHistory("Locking " + (parameter == null ? "the whole event" : parameter) + " " + this.boundEvent);
            if (this.lockedAt.containsKey(null)) {
                return;
            }
            if (parameter == null && !this.lockedAt.containsKey(null)) {
                this.lockedAt.put(null, this.boundEvent);
            } else if (!this.lockedAt.containsKey(parameter)) {
                this.lockedAt.put(parameter, this.boundEvent);
            }
        }

        public boolean isLocked(String parameter) {
            Priority global;
            Priority param = this.lockedAt.get(parameter) == null ? null : this.lockedAt.get(parameter).getPriority();
            Priority priority = global = this.lockedAt.get(parameter) == null ? null : this.lockedAt.get(null).getPriority();
            if (param == null && global == null) {
                return false;
            }
            if (param == null) {
                return global.isHigherPriority(this.boundEvent.getPriority());
            }
            if (global == null) {
                return param.isHigherPriority(this.boundEvent.getPriority());
            }
            if (param.isHigherPriority(global)) {
                return param.isHigherPriority(this.boundEvent.getPriority());
            }
            return global.isHigherPriority(this.boundEvent.getPriority());
        }

        public Priority lockedAt(String parameter) {
            Priority global;
            Priority param = this.lockedAt.get(parameter) == null ? null : this.lockedAt.get(parameter).getPriority();
            Priority priority = global = this.lockedAt.get(parameter) == null ? null : this.lockedAt.get(null).getPriority();
            if (param == null && global == null) {
                return null;
            }
            if (param == null) {
                return global;
            }
            if (global == null) {
                return param;
            }
            if (param.isHigherPriority(global)) {
                return param;
            }
            return global;
        }

        public void addWhenTriggered(CClosure tree) {
            this.addHistory("Adding a whenTriggered callback. " + this.boundEvent);
            try {
                this.whenTriggered.add(new Pair<CClosure, Environment>(tree, this.boundEvent.originalEnv.clone()));
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(BoundEvent.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void addWhenCancelled(CClosure tree) {
            this.addHistory("Adding a whenCancelled callback. " + this.boundEvent);
            try {
                this.whenCancelled.add(new Pair<CClosure, Environment>(tree, this.boundEvent.originalEnv.clone()));
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(BoundEvent.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void executeTriggered() {
        }

        public void executeCancelled() {
        }
    }

    public static enum Priority {
        LOWEST(5),
        LOW(4),
        NORMAL(3),
        HIGH(2),
        HIGHEST(1),
        MONITOR(1000);

        private final int id;

        private Priority(int i) {
            this.id = i;
        }

        public int getId() {
            return this.id;
        }

        public boolean isHigherPriority(Priority other) {
            return other.getId() > this.getId();
        }

        public boolean isLowerPriority(Priority other) {
            return other.getId() < this.getId();
        }
    }
}

