/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.annotations.noboilerplate;
import com.laytonsmith.annotations.noprofile;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.CBracket;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CEntry;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CSymbol;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.core.functions.DummyFunction;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.functions.StringHandling;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@core
public class Compiler {
    public static String docs() {
        return "Compiler internal functions should be declared here. If you're reading this from anywhere but the source code, there's a bug, because these functions shouldn't be public or used in a script.";
    }

    @api
    @hide(value="This is more of a compiler feature, rather than a function, and so it is hidden from normal documentation.")
    public static class smart_string
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            throw new UnsupportedOperationException(this.getName() + " should have been compiled out. If you are reaching this, an error has occured in the parser. Please report this error to the developers.");
        }

        @Override
        public String getName() {
            return "smart_string";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "none {string} This is a compiler construct, and is not normally used directly. It is created via double quoted strings.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() != 1) {
                throw new ConfigCompileException(this.getName() + " can only take one parameter", t);
            }
            if (!children.get(0).getData().isInstanceOf(CString.TYPE)) {
                throw new ConfigCompileException("Only hardcoded strings may be passed into " + this.getName(), t);
            }
            String value = children.get(0).getData().val();
            StringBuilder b = new StringBuilder();
            boolean inBrace = false;
            boolean inSimpleVar = false;
            ParseTree root = new ParseTree(new CFunction(new StringHandling.concat().getName(), t), fileOptions);
            for (int i = 0; i < value.length(); ++i) {
                char c2;
                char c = value.charAt(i);
                char c3 = c2 = i + 1 < value.length() ? value.charAt(i + 1) : (char)'\u0000';
                if (c == '\\' && c2 == '@') {
                    b.append("@");
                    ++i;
                    continue;
                }
                if (c == '@') {
                    if (c2 == '{') {
                        inBrace = true;
                        ++i;
                    } else if (Character.isLetterOrDigit(c2) || c2 == '_') {
                        inSimpleVar = true;
                    } else {
                        throw new ConfigCompileException("Unexpected \"@\" in string. If you want a literal at sign, escape it with \"\\@\".", t);
                    }
                    if (b.length() <= 0) continue;
                    root.addChild(new ParseTree(new CString(b.toString(), t), fileOptions));
                    b = new StringBuilder();
                    continue;
                }
                if (inSimpleVar && !Character.isLetterOrDigit(c) && c != '_') {
                    String vname = b.toString();
                    b = new StringBuilder();
                    root.addChild(new ParseTree(new IVariable("@" + vname, t), fileOptions));
                    inSimpleVar = false;
                }
                if (inBrace && c == '}') {
                    String complex = b.toString().trim();
                    b = new StringBuilder();
                    inBrace = false;
                    if (!complex.matches("[a-zA-Z0-9_]+")) continue;
                    root.addChild(new ParseTree(new IVariable("@" + complex, t), fileOptions));
                    continue;
                }
                b.append(c);
            }
            if (inBrace) {
                throw new ConfigCompileException("Missing end brace (}) in double string", t);
            }
            if (inSimpleVar) {
                root.addChild(new ParseTree(new IVariable("@" + b.toString(), t), fileOptions));
            } else if (b.length() > 0) {
                root.addChild(new ParseTree(new CString(b.toString(), t), fileOptions));
            }
            if (root.numberOfChildren() == 1) {
                return root.getChildAt(0);
            }
            return root;
        }
    }

    @api
    @hide(value="This is only used internally by the compiler, and will be removed at some point.")
    public static class __cbrace__
    extends DummyFunction
    implements Optimizable {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            throw new ConfigCompileException("Unexpected use of braces", t);
        }
    }

    @api
    @hide(value="This is only used internally by the compiler, and will be removed at some point.")
    public static class __cbracket__
    extends DummyFunction
    implements Optimizable {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            ParseTree node;
            if (children.isEmpty()) {
                node = new ParseTree(CVoid.VOID, fileOptions);
            } else if (children.size() == 1) {
                node = children.get(0);
            } else {
                throw new ConfigCompileException("Unexpected children. This appears to be an error, as __autoconcat__ should have already been processed. Please report this error to the developer.", t);
            }
            return new ParseTree(new CBracket(node), fileOptions);
        }
    }

    @api
    @noprofile
    @hide(value="This is only used for testing.")
    public static class dyn
    extends DummyFunction {
        @Override
        public String docs() {
            return "exception {[argument]} Registers as a dynamic component, for optimization testing; that is to say, this will not be optimizable ever. It simply returns the argument provided, or void if none.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args.length == 0) {
                return CVoid.VOID;
            }
            return args[0];
        }
    }

    @api
    @hide(value="This is only used for testing unexpected error handling.")
    @noboilerplate
    public static class npe
    extends DummyFunction {
        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            String s = null;
            if (args.length == 1) {
                s = args[0].val();
            }
            if (s == null) {
                throw new NullPointerException();
            }
            throw new NullPointerException(s);
        }
    }

    @api
    @noprofile
    @hide(value="This is only used internally by the compiler.")
    public static class __autoconcat__
    extends DummyFunction
    implements Optimizable {
        private static final String ASSIGN = new DataHandling.assign().getName();

        public static ParseTree getParseTree(List<ParseTree> children, FileOptions fo, Target t) {
            CFunction ac = new CFunction(new __autoconcat__().getName(), t);
            ParseTree tree = new ParseTree(ac, fo);
            tree.setChildren(children);
            return tree;
        }

        public static ParseTree getParseTree(ParseTree child, FileOptions fo, Target t) {
            CFunction ac = new CFunction(new __autoconcat__().getName(), t);
            ParseTree tree = new ParseTree(ac, fo);
            ArrayList<ParseTree> children = new ArrayList<ParseTree>();
            children.add(child);
            tree.setChildren(children);
            return tree;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            throw new Error("Should not have gotten here, __autoconcat__ was not removed before runtime.");
        }

        @Override
        public String docs() {
            return "string {var1, [var2...]} This function should only be used by the compiler, behavior may be undefined if it is used in code.";
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> list, FileOptions fileOptions) throws ConfigCompileException {
            return this.optimizeSpecial(list, true, envs);
        }

        public ParseTree optimizeSpecial(List<ParseTree> list, boolean returnSConcat, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException {
            ParseTree node;
            ParseTree conversion;
            CSymbol sy;
            Object node2;
            int i;
            boolean inSymbolMode = false;
            for (i = list.size() - 2; i >= 0; --i) {
                node2 = list.get(i + 1);
                if (!(((ParseTree)node2).getData() instanceof CSymbol) || !((CSymbol)((ParseTree)node2).getData()).isAssignment()) continue;
                ParseTree lhs = list.get(i);
                ParseTree assign2 = new ParseTree(new CFunction("assign", ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                if (i < list.size() - 3) {
                    ParseTree ac = new ParseTree(new CFunction("__autoconcat__", ((ParseTree)node2).getTarget()), lhs.getFileOptions());
                    int index = i + 2;
                    while (list.size() > index + 1 && list.get(index).getData() instanceof CSymbol) {
                        ac.addChild(list.get(index));
                        list.remove(index);
                    }
                    ac.addChild(list.get(index));
                    list.remove(index);
                    while (list.size() > index + 1 && list.get(index).getData() instanceof CSymbol) {
                        do {
                            ac.addChild(list.get(index));
                            list.remove(index);
                        } while (list.size() > index && list.get(index).getData() instanceof CSymbol);
                        if (list.size() <= index) {
                            throw new ConfigCompileException("Unexpected end of statement", list.get(list.size() - 1).getTarget());
                        }
                        ac.addChild(list.get(index));
                        list.remove(index);
                    }
                    list.add(i + 2, ac);
                }
                if (list.size() <= i + 2) {
                    throw new ConfigCompileException("Unexpected end of statement", list.get(i).getTarget());
                }
                CSymbol sy2 = (CSymbol)((ParseTree)node2).getData();
                String conversionFunction = sy2.convertAssignment();
                if (conversionFunction != null) {
                    ParseTree conversion2 = new ParseTree(new CFunction(conversionFunction, ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                    conversion2.addChild(lhs);
                    conversion2.addChild(list.get(i + 2));
                    list.set(i + 2, conversion2);
                }
                ParseTree rhs = list.get(i + 2);
                assign2.addChild(lhs);
                assign2.addChild(rhs);
                list.set(i, assign2);
                list.remove(i + 1);
                list.remove(i + 1);
            }
            for (i = 0; i < list.size(); ++i) {
                node2 = list.get(i);
                if (((ParseTree)node2).getData() instanceof CSymbol) {
                    inSymbolMode = true;
                }
                if (!(((ParseTree)node2).getData() instanceof CSymbol) || !((CSymbol)((ParseTree)node2).getData()).isPostfix() || i - 1 < 0 || list.get(i - 1).getData() instanceof CSymbol) continue;
                sy = (CSymbol)((ParseTree)node2).getData();
                conversion = sy.val().equals("++") ? new ParseTree(new CFunction("postinc", ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions()) : new ParseTree(new CFunction("postdec", ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                conversion.addChild(list.get(i - 1));
                list.set(i - 1, conversion);
                list.remove(i);
                --i;
            }
            if (inSymbolMode) {
                try {
                    ParseTree next;
                    ParseTree conversion3;
                    for (i = 0; i < list.size() - 1; ++i) {
                        node2 = list.get(i);
                        if (!(((ParseTree)node2).getData() instanceof CSymbol) || !((CSymbol)((ParseTree)node2).getData()).isUnary()) continue;
                        if (((ParseTree)node2).getData().val().equals("-") || ((ParseTree)node2).getData().val().equals("+")) {
                            if (i != 0 && !(list.get(i - 1).getData() instanceof CSymbol) || list.get(i + 1).getData() instanceof CSymbol) continue;
                            conversion3 = ((ParseTree)node2).getData().val().equals("-") ? new ParseTree(new CFunction("neg", ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions()) : new ParseTree(new CFunction("p", ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                        } else {
                            conversion3 = new ParseTree(new CFunction(((CSymbol)((ParseTree)node2).getData()).convert(), ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                        }
                        ArrayList<ParseTree> ac = new ArrayList<ParseTree>();
                        list.set(i, conversion3);
                        for (int k = i + 1; k < list.size(); ++k) {
                            ParseTree m = list.get(k);
                            if (m.getData() instanceof CSymbol && ((CSymbol)m.getData()).isUnary()) {
                                ac.add(m);
                                list.remove(k);
                                --k;
                                --i;
                                continue;
                            }
                            ac.add(m);
                            list.remove(k);
                            break;
                        }
                        conversion3.addChild(this.optimizeSpecial(ac, returnSConcat, envs));
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        if (!(next.getData() instanceof CSymbol) || !((CSymbol)next.getData()).isExponential()) continue;
                        conversion3 = new ParseTree(new CFunction(((CSymbol)next.getData()).convert(), next.getTarget()), next.getFileOptions());
                        conversion3.addChild(list.get(i));
                        conversion3.addChild(list.get(i + 2));
                        list.set(i, conversion3);
                        list.remove(i + 1);
                        list.remove(i + 1);
                        --i;
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        CSymbol nextData;
                        next = list.get(i + 1);
                        if (!(next.getData() instanceof CSymbol) || !(nextData = (CSymbol)next.getData()).isMultaplicative() || nextData.isAssignment()) continue;
                        conversion = new ParseTree(new CFunction(((CSymbol)next.getData()).convert(), next.getTarget()), next.getFileOptions());
                        conversion.addChild(list.get(i));
                        conversion.addChild(list.get(i + 2));
                        list.set(i, conversion);
                        list.remove(i + 1);
                        list.remove(i + 1);
                        --i;
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        next = list.get(i + 1);
                        if (!(next.getData() instanceof CSymbol) || !((CSymbol)next.getData()).isAdditive() || ((CSymbol)next.getData()).isAssignment()) continue;
                        conversion3 = new ParseTree(new CFunction(((CSymbol)next.getData()).convert(), next.getTarget()), next.getFileOptions());
                        conversion3.addChild(list.get(i));
                        conversion3.addChild(list.get(i + 2));
                        list.set(i, conversion3);
                        list.remove(i + 1);
                        list.remove(i + 1);
                        --i;
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        node2 = list.get(i + 1);
                        if (!(((ParseTree)node2).getData() instanceof CSymbol) || !((CSymbol)((ParseTree)node2).getData()).isRelational()) continue;
                        sy = (CSymbol)((ParseTree)node2).getData();
                        conversion = new ParseTree(new CFunction(sy.convert(), ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                        conversion.addChild(list.get(i));
                        conversion.addChild(list.get(i + 2));
                        list.set(i, conversion);
                        list.remove(i + 1);
                        list.remove(i + 1);
                        --i;
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        node2 = list.get(i + 1);
                        if (!(((ParseTree)node2).getData() instanceof CSymbol) || !((CSymbol)((ParseTree)node2).getData()).isEquality()) continue;
                        sy = (CSymbol)((ParseTree)node2).getData();
                        conversion = new ParseTree(new CFunction(sy.convert(), ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                        conversion.addChild(list.get(i));
                        conversion.addChild(list.get(i + 2));
                        list.set(i, conversion);
                        list.remove(i + 1);
                        list.remove(i + 1);
                        --i;
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        node2 = list.get(i + 1);
                        if (!(((ParseTree)node2).getData() instanceof CSymbol) || !((CSymbol)((ParseTree)node2).getData()).isDefaultAnd()) continue;
                        sy = (CSymbol)((ParseTree)node2).getData();
                        conversion = new ParseTree(new CFunction(sy.convert(), ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                        conversion.addChild(list.get(i));
                        conversion.addChild(list.get(i + 2));
                        list.set(i, conversion);
                        list.remove(i + 1);
                        list.remove(i + 1);
                        --i;
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        node2 = list.get(i + 1);
                        if (!(((ParseTree)node2).getData() instanceof CSymbol) || !((CSymbol)((ParseTree)node2).getData()).isDefaultOr()) continue;
                        sy = (CSymbol)((ParseTree)node2).getData();
                        conversion = new ParseTree(new CFunction(sy.convert(), ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                        conversion.addChild(list.get(i));
                        conversion.addChild(list.get(i + 2));
                        list.set(i, conversion);
                        list.remove(i + 1);
                        list.remove(i + 1);
                        --i;
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        node2 = list.get(i + 1);
                        if (!(((ParseTree)node2).getData() instanceof CSymbol) || !((CSymbol)((ParseTree)node2).getData()).isLogicalAnd()) continue;
                        sy = (CSymbol)((ParseTree)node2).getData();
                        conversion = new ParseTree(new CFunction(sy.convert(), ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                        conversion.addChild(list.get(i));
                        conversion.addChild(list.get(i + 2));
                        list.set(i, conversion);
                        list.remove(i + 1);
                        list.remove(i + 1);
                        --i;
                    }
                    for (i = 0; i < list.size() - 1; ++i) {
                        node2 = list.get(i + 1);
                        if (!(((ParseTree)node2).getData() instanceof CSymbol) || !((CSymbol)((ParseTree)node2).getData()).isLogicalOr()) continue;
                        sy = (CSymbol)((ParseTree)node2).getData();
                        conversion = new ParseTree(new CFunction(sy.convert(), ((ParseTree)node2).getTarget()), ((ParseTree)node2).getFileOptions());
                        conversion.addChild(list.get(i));
                        conversion.addChild(list.get(i + 2));
                        list.set(i, conversion);
                        list.remove(i + 1);
                        list.remove(i + 1);
                        --i;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConfigCompileException("Unexpected symbol (" + list.get(list.size() - 1).getData().val() + "). Did you forget to quote your symbols?", list.get(list.size() - 1).getTarget());
                }
            }
            for (int k = 0; k < list.size(); ++k) {
                if (!list.get(k).getData().equals(CVoid.VOID) && !list.get(k).getData().isInstanceOf(CClassType.TYPE)) continue;
                if (k == list.size() - 1) break;
                if (list.get(k + 1).getData() instanceof CFunction) {
                    switch (list.get(k + 1).getData().val()) {
                        case "assign": 
                        case "proc": {
                            if (list.get(k + 1).getData().val().equals("assign") && list.get(k).getData().equals(CVoid.VOID)) {
                                throw new ConfigCompileException("Variables may not be of type void", list.get(k).getTarget());
                            }
                            ParseTree type = list.remove(k);
                            List<ParseTree> children = list.get(k).getChildren();
                            children.add(0, type);
                            list.get(k).setChildren(children);
                            break;
                        }
                        default: {
                            throw new ConfigCompileException("Unexpected ClassType \"" + list.get(k).getData().val() + "\"", list.get(k).getTarget());
                        }
                    }
                    continue;
                }
                if (list.get(k + 1).getData() instanceof IVariable) {
                    node2 = new ParseTree(new CFunction(ASSIGN, list.get(k).getTarget()), list.get(k).getFileOptions());
                    ((ParseTree)node2).addChild(list.get(k));
                    ((ParseTree)node2).addChild(list.get(k + 1));
                    ((ParseTree)node2).addChild(new ParseTree(CNull.UNDEFINED, list.get(k).getFileOptions()));
                    list.set(k, (ParseTree)node2);
                    list.remove(k + 1);
                    continue;
                }
                if (list.get(k + 1).getData() instanceof CLabel) {
                    node2 = new ParseTree(new CFunction(ASSIGN, list.get(k).getTarget()), list.get(k).getFileOptions());
                    ParseTree labelNode = new ParseTree(new CLabel(((ParseTree)node2).getData()), list.get(k).getFileOptions());
                    labelNode.addChild(list.get(k));
                    labelNode.addChild(new ParseTree(((CLabel)list.get(k + 1).getData()).cVal(), list.get(k).getFileOptions()));
                    labelNode.addChild(new ParseTree(CNull.UNDEFINED, list.get(k).getFileOptions()));
                    list.set(k, labelNode);
                    list.remove(k + 1);
                    continue;
                }
                throw new ConfigCompileException("Unexpected ClassType", list.get(k).getTarget());
            }
            if (list.size() >= 1 && (node = list.get(0)).getData() instanceof CLabel) {
                ParseTree value = new ParseTree(new CFunction("__autoconcat__", node.getTarget()), node.getFileOptions());
                for (int i2 = 1; i2 < list.size(); ++i2) {
                    value.addChild(list.get(i2));
                }
                ParseTree ce = new ParseTree(new CFunction("centry", node.getTarget()), node.getFileOptions());
                ce.addChild(node);
                ce.addChild(value);
                return ce;
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            for (int i3 = 0; i3 < list.size(); ++i3) {
                if (!Construct.IsCType(list.get(i3).getData(), Construct.ConstructType.IDENTIFIER)) continue;
                if (i3 == 0) {
                    CFunction identifier = new CFunction(list.get(i3).getData().val(), list.get(i3).getTarget());
                    list.remove(0);
                    ParseTree child = list.get(0);
                    if (list.size() > 1) {
                        child = new ParseTree(new CFunction("sconcat", child.getTarget()), child.getFileOptions());
                        child.setChildren(list);
                    }
                    try {
                        Function f = (Function)FunctionList.getFunction(identifier, envs);
                        ParseTree node3 = new ParseTree(f.execs(identifier.getTarget(), null, null, child), child.getFileOptions());
                        return node3;
                    }
                    catch (Exception e) {
                        throw new Error("Unknown function " + identifier.val() + "?");
                    }
                }
                throw new ConfigCompileException("Unexpected IDENTIFIER? O.o Please report a bug, and include the script you used to get this error. At or around:", list.get(i3).getTarget());
            }
            FileOptions options = new FileOptions(new HashMap<String, String>());
            Target t = Target.UNKNOWN;
            if (!list.isEmpty()) {
                options = list.get(0).getFileOptions();
                t = list.get(0).getTarget();
            }
            ParseTree tree = returnSConcat ? new ParseTree(new CFunction("sconcat", t), options) : new ParseTree(new CFunction("concat", t), options);
            tree.setChildren(list);
            return tree;
        }
    }

    @api
    @noprofile
    @hide(value="This is only used internally by the compiler.")
    public static class centry
    extends DummyFunction {
        @Override
        public String docs() {
            return "CEntry {label, content} Dynamically creates a CEntry. This is used internally by the compiler.";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CEntry(args[0], args[1], t);
        }
    }

    @api
    @noprofile
    @hide(value="This is only used internally by the compiler.")
    public static class p
    extends DummyFunction {
        @Override
        public String getName() {
            return "p";
        }

        @Override
        public String docs() {
            return "mixed {c...} Used internally by the compiler. You shouldn't use it.";
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            switch (nodes.length) {
                case 0: {
                    return CVoid.VOID;
                }
                case 1: {
                    return parent.eval(nodes[0], env);
                }
            }
            return new __autoconcat__().execs(t, env, parent, nodes);
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            return CVoid.VOID;
        }
    }
}

