/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.annotations.MEnum;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.tools.SimpleSyntaxHighlighter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SyntaxHighlighters {
    public static final String HELP_TEXT = "File for the following syntax highlighters are currently available:\n\tNotepad++ - Use type \"npp\". You may also select a theme, either \"default\" or \"obsidian\"\n\tTextWrangler - Use type \"textwrangler\". Only the default theme is available.\n\t\tTo install: put the generated file in ~/Library/Application Support/TextWrangler/Language Modules/\n\t\tNote that this output file can also be used for BBEdit.\n\tGeSHi - Use type \"geshi\". Only the default theme is available.\n\tViM - Use type \"vim\". Only the default theme is available.\n\t\tTo install: put in ~/.vim/syntax/commandhelper.vim then edit\n\t\t~/.vim/ftdetect/commandhelper.vim and add the line \n\t\tau BufRead,BufNewFile *.ms set filetype=commandhelper\n\t\tThen, if you're on linux and use cmdline mode, in ~/.vim/scripts.vim, add the following lines:\n\t\t\tif did_filetype()\n\t\t\t\tfinish\n\t\t\tendif\n\t\t\tif getline(1) =~# '^#!.*\\(/bin/env\\s\\+mscript\\|/bin/mscript\\)\\>'\n\t\t\t\tsetfiletype commandhelper\n\t\t\tendif\t\t(Create directories and files as needed)\n\tnano - Use type \"nano\". Only the default theme is available.\n\tSublime Text - Use type \"sublime\". Only the default theme is available.\n\t\tTo install: Place in Sublime Text's ./SublimeText/data/Packages/User folder.\n\tSublime Text 3 - Use type \"sublime3\".\n\tAtom - Use type \"atom\". Only the default theme is available.\n\t\tTo install: Install package language-mscript from the Atom package manager.\n\nKnow how to write a syntax highlighter file for your favorite text editor? Let me know, and we\ncan work to get it included in CommandHelper!";

    public static String generate(String type, String theme) {
        Implementation.forceServerType(Implementation.Type.BUKKIT);
        if ("npp".equals(type) || "notepad++".equals(type)) {
            if ("default".equals(theme)) {
                return SyntaxHighlighters.template("/syntax-templates/notepad++/default.xml");
            }
            if ("obsidian".equals(theme)) {
                return SyntaxHighlighters.template("/syntax-templates/notepad++/obsidian.xml");
            }
            if ("solarized-dark".equals(theme)) {
                return SyntaxHighlighters.template("/syntax-templates/notepad++/solarized_dark.xml");
            }
            if ("solarized-light".equals(theme)) {
                return SyntaxHighlighters.template("/syntax-templates/notepad++/solarized_light.xml");
            }
            return "Available themes for Notepad++: default, obsidian, solarized-dark, solarized-light";
        }
        if ("textwrangler".equals(type)) {
            return SyntaxHighlighters.template("/syntax-templates/text-wrangler/default.plist");
        }
        if ("geshi".equals(type)) {
            return SyntaxHighlighters.template("/syntax-templates/geshi/default.php");
        }
        if ("vim".equals(type)) {
            return SyntaxHighlighters.template("/syntax-templates/vim/default.vim");
        }
        if ("nano".equals(type)) {
            return SyntaxHighlighters.template("/syntax-templates/nano/default.txt");
        }
        if ("atom".equals(type)) {
            return SyntaxHighlighters.template("/syntax-templates/atom/default.cson");
        }
        if ("sublime".equals(type)) {
            return SyntaxHighlighters.template("/syntax-templates/sublime/default.xml");
        }
        if ("sublime3".equals(type)) {
            return SyntaxHighlighters.template("/syntax-templates/sublime3/default.sublime-syntax");
        }
        return HELP_TEXT;
    }

    private static String template(String location) {
        String template = Static.GetStringResource(location);
        template = template.replace("///!", "");
        Pattern p2 = Pattern.compile("%%(.*?)%%");
        Matcher m = p2.matcher(template);
        while (m.find()) {
            template = template.replaceAll("%%" + m.group(1) + "%%", SyntaxHighlighters.macro(m.group(1)));
        }
        return template;
    }

    /*
     * WARNING - void declaration
     */
    private static String macro(String macroName) {
        void var7_23;
        String[] split2 = macroName.split(":");
        String type = split2[0];
        String datalist = split2[1];
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 2; i < split2.length; ++i) {
            params.add(split2[i].toLowerCase());
        }
        ArrayList<String> base = new ArrayList<String>();
        if (datalist.equalsIgnoreCase("colors")) {
            for (MCChatColor c : MCChatColor.values()) {
                base.add(c.name());
            }
        } else if (datalist.equalsIgnoreCase("keywords")) {
            for (String string : SimpleSyntaxHighlighter.KEYWORDS) {
                base.add(string);
            }
        } else if (datalist.equalsIgnoreCase("functions")) {
            for (Function function : SyntaxHighlighters.GetFunctions()) {
                if (SimpleSyntaxHighlighter.KEYWORDS.contains(function.getName()) || !function.appearInDocumentation()) continue;
                if (params.contains("restricted") || params.contains("unrestricted")) {
                    if (params.contains("restricted") && function.isRestricted()) {
                        base.add(function.getName());
                        continue;
                    }
                    if (!params.contains("unrestricted") || function.isRestricted()) continue;
                    base.add(function.getName());
                    continue;
                }
                base.add(function.getName());
            }
        } else if (datalist.equalsIgnoreCase("events")) {
            for (Documentation documentation : SyntaxHighlighters.GetEvents()) {
                base.add(documentation.getName());
            }
        } else if (datalist.equalsIgnoreCase("exceptions")) {
            for (Class clazz : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(typeof.class, CREThrowable.class)) {
                base.add(ClassDiscovery.GetClassAnnotation(clazz, typeof.class).value());
            }
        } else if (datalist.equalsIgnoreCase("types")) {
            base.addAll(NativeTypeList.getNativeTypeList().stream().map(e -> e.getFQCN()).collect(Collectors.toList()));
            base.addAll(NativeTypeList.getNativeTypeList().stream().map(e -> e.getSimpleName()).collect(Collectors.toList()));
            base.remove("null");
        } else if (datalist.equalsIgnoreCase("enums")) {
            HashSet<String> set = new HashSet<String>();
            Set<Class<Enum>> set2 = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(MEnum.class, Enum.class);
            for (Class<Enum> e2 : set2) {
                Enum[] es;
                for (Enum ee : es = e2.getEnumConstants()) {
                    set.add(ee.name());
                }
            }
            base.addAll(set);
        } else if (datalist.equalsIgnoreCase("fileOptions")) {
            base.addAll(FileOptions.getKnownOptions());
        }
        String header = "";
        String string = "IMPROPER FORMATTING";
        String footer = "";
        if (type.equalsIgnoreCase("space")) {
            if (params.contains("quoted")) {
                header = "'";
                String string2 = "' '";
                footer = "'";
            } else {
                String string3 = " ";
            }
        } else if (type.equalsIgnoreCase("comma")) {
            if (params.contains("quoted")) {
                header = "'";
                String string4 = "', '";
                footer = "'";
            } else {
                String string5 = ", ";
            }
        } else if (type.equalsIgnoreCase("pipe")) {
            if (params.contains("quoted")) {
                header = "'";
                String string6 = "|";
                footer = "'";
            } else {
                String string7 = "|";
            }
        } else if (type.equalsIgnoreCase("xml")) {
            String tag = "PLEASE INCLUDE THE TAG NAME USING tag=tagname AS A PARAMETER";
            for (String param : params) {
                if (!param.matches("tag=.*")) continue;
                tag = param.substring(4);
                break;
            }
            if (params.contains("quoted")) {
                header = "<" + tag + ">'";
                String string8 = "'</" + tag + "><" + tag + ">'";
                footer = "'</" + tag + ">";
            } else {
                header = "<" + tag + ">";
                String string9 = "</" + tag + "><" + tag + ">";
                footer = "</" + tag + ">";
            }
        }
        return header + SyntaxHighlighters.Join(base, (String)var7_23) + footer;
    }

    private static List<Documentation> GetEvents() {
        ArrayList<Documentation> l = new ArrayList<Documentation>();
        Set<Class<?>> classes = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(api.class);
        for (Class<?> c : classes) {
            if (!Event.class.isAssignableFrom(c) || !Documentation.class.isAssignableFrom(c)) continue;
            try {
                Constructor<?> m = c.getConstructor(new Class[0]);
                Documentation e = (Documentation)m.newInstance(new Object[0]);
                l.add(e);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                StreamUtils.GetSystemErr().println(ex.getMessage());
            }
        }
        return l;
    }

    private static List<Function> GetFunctions() {
        ArrayList<Function> fl = new ArrayList<Function>();
        Set<Class<?>> functions = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(api.class);
        for (Class<?> c : functions) {
            if (!Function.class.isAssignableFrom(c)) continue;
            try {
                fl.add((Function)c.newInstance());
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(SyntaxHighlighters.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoClassDefFoundError e) {
                StreamUtils.GetSystemErr().println(e.getMessage());
            }
        }
        return fl;
    }

    private static String Join(List<?> l, String joiner) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < l.size(); ++i) {
            if (i == 0) {
                b.append(l.get(i).toString());
                continue;
            }
            b.append(joiner).append(l.get(i).toString());
        }
        return b.toString();
    }
}

