/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.sitedeploy;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.MethodMirror;
import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.GNUErrorMessageFormat;
import com.laytonsmith.PureUtilities.Common.HTMLUtils;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.Preferences;
import com.laytonsmith.PureUtilities.Web.HTTPMethod;
import com.laytonsmith.PureUtilities.Web.HTTPResponse;
import com.laytonsmith.PureUtilities.Web.RequestSettings;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import com.laytonsmith.PureUtilities.ZipReader;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.PersistenceNetwork;
import com.laytonsmith.persistence.PersistenceNetworkImpl;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import com.laytonsmith.tools.Interpreter;
import com.laytonsmith.tools.docgen.DocGen;
import com.laytonsmith.tools.docgen.DocGenTemplates;
import com.laytonsmith.tools.docgen.localization.TranslationMaster;
import com.laytonsmith.tools.docgen.sitedeploy.APIBuilder;
import com.laytonsmith.tools.docgen.sitedeploy.DeploymentMethod;
import com.laytonsmith.tools.docgen.sitedeploy.LocalDeploymentMethod;
import com.laytonsmith.tools.docgen.sitedeploy.RemoteDeploymentMethod;
import com.laytonsmith.tools.docgen.templates.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import jline.console.ConsoleReader;
import org.json.simple.JSONValue;

public final class SiteDeploy {
    private static final String USERNAME = "username";
    private static final String HOSTNAME = "hostname";
    private static final String PORT = "port";
    private static final String DIRECTORY = "directory";
    private static final String PASSWORD = "use-password";
    private static final String DOCSBASE = "docs-base";
    private static final String SITEBASE = "site-base";
    private static final String SHOW_TEMPLATE_CREDIT = "show-template-credit";
    private static final String GITHUB_BASE_URL = "github-base-url";
    private static final String VALIDATOR_URL = "validator-url";
    private static final String POST_SCRIPT = "post-script";
    private static final String TRANSLATION_MEMORY_DB = "translation-memory-db";
    private static final String PRODUCTION_TRANSLATIONS = "production-translations";
    private static final String INSTALL_URL = "install-url";
    private static final String INSTALL_PEM_FILE = "install-pem-file";
    private static final String INSTALL_PUB_KEYS = "install-pub-keys";
    private static final String PRODUCTION_TRANSLATIONS_URL = "https://raw.githubusercontent.com/LadyCailin/MethodScriptTranslationDB/master/";
    String apiJson;
    String apiJsonVersion;
    private final String siteBase;
    private final String docsBase;
    private final String resourceBase;
    private final String productionTranslations;
    private final ConsoleReader reader;
    private final ThreadPoolExecutor generateQueue;
    private final ThreadPoolExecutor uploadQueue;
    private final AtomicInteger currentUploadTask = new AtomicInteger(0);
    private final AtomicInteger totalUploadTasks = new AtomicInteger(0);
    private final AtomicInteger currentGenerateTask = new AtomicInteger(0);
    private final AtomicInteger totalGenerateTasks = new AtomicInteger(0);
    private final List<String> filesChanged = new ArrayList<String>();
    private final PersistenceNetwork pn;
    private final boolean useLocalCache;
    private final DaemonManager dm = new DaemonManager();
    private Map<String, String> lc = null;
    private DeploymentMethod deploymentMethod;
    private final boolean doValidation;
    private final Map<String, String> uploadedPages = new HashMap<String, String>();
    private final boolean showTemplateCredit;
    private final String githubBaseUrl;
    private final String validatorUrl;
    private final File finalizerScript;
    private final boolean clearProgressBar;
    private final String overrideIdRsa;
    private final File translationMemoryDb;
    private final TranslationMaster masterMemories;
    private static final String EDIT_THIS_PAGE_PREAMBLE = "Find a bug in this page? <a rel=\"noopener noreferrer\" target=\"_blank\" href=\"";
    private static final String EDIT_THIS_PAGE_POSTAMBLE = "\">Edit this page yourself, then submit a pull request.</a>";
    private static final String DEFAULT_GITHUB_BASE_URL = "https://github.com/EngineHub/CommandHelper/edit/master/src/main/%s";
    private boolean notificationAboutLocalCache = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(boolean generatePrefs, boolean useLocalCache, File sitedeploy, String password, boolean doValidation, boolean clearProgressBar, String overridePostScript, String overrideIdRsa) throws Exception {
        DeploymentMethod deploymentMethod;
        ArrayList<Preferences.Preference> defaults = new ArrayList<Preferences.Preference>();
        defaults.add(new Preferences.Preference(USERNAME, "", Preferences.Type.STRING, "The username to scp with"));
        defaults.add(new Preferences.Preference(HOSTNAME, "", Preferences.Type.STRING, "The hostname to scp to (not the hostname of the site). If the hostname is \"localhost\", this triggers special handling, which skips the upload, and simply saves to the specified location on local disk. This should work with all OSes, otherwise the host that this connects to must support ssh, though it does not necessarily have to be a unix based system. If the value is localhost, the values username, port, and use-password are irrelevant, and not used. This should NOT begin with a protocol, i.e. http://"));
        defaults.add(new Preferences.Preference(PORT, "22", Preferences.Type.INT, "The port to use for SCP"));
        defaults.add(new Preferences.Preference(DIRECTORY, "/var/www/docs", Preferences.Type.STRING, "The root location of the remote web server. This must be an absolute path. Note that this is the location of the *docs* folder. Files may be created one directory above this folder, in this folder, and in lower folders that are created by the site deploy tool. So if /var/www is your web root, then you should put /var/www/docs here. It will create an index file in /var/www, as well as in /var/www/docs, but the majority of files will be put in /var/www/docs/."));
        defaults.add(new Preferences.Preference(PASSWORD, "false", Preferences.Type.BOOLEAN, "Whether or not to use password authentication. If false, public key authentication will be used instead, and your system must be pre-configured for that. The password is interactively prompted for. If you wish to use non-interactive mode, you must use public key authentication."));
        defaults.add(new Preferences.Preference(DOCSBASE, "", Preferences.Type.STRING, "The base url of the docs. This should begin with http:// or https://"));
        defaults.add(new Preferences.Preference(SITEBASE, "", Preferences.Type.STRING, "The base url of the site (where \"home\" should be). This should begin with http:// or https://"));
        defaults.add(new Preferences.Preference(SHOW_TEMPLATE_CREDIT, "true", Preferences.Type.BOOLEAN, "Whether or not to show the template credit. (Design by TEMPLATED logo in bottom.) If you set this to false, you agree that you have purchased a license for your deployment, and are legally allowed to supress this from the templates."));
        defaults.add(new Preferences.Preference(GITHUB_BASE_URL, "", Preferences.Type.STRING, "The base url for the github project. If empty string, then the value https://github.com/EngineHub/CommandHelper/edit/master/src/main/%s is used."));
        defaults.add(new Preferences.Preference(VALIDATOR_URL, "", Preferences.Type.STRING, "The validator url. This service must be based on the https://validator.github.io/validator/ service. If the url is left blank, then using the --do-validation flag is an error. Generally, you will need to host your own validator for this solution to work, as running against a public service will undoubtably result in being blacklisted from the service. This should be something like http://localhost:8888/"));
        defaults.add(new Preferences.Preference(POST_SCRIPT, "", Preferences.Type.FILE, "The path to a shell script, or an mscript. This will be executed after the upload (and validation, if specified) is complete, and can be used to run custom procedures afterwards, for instance clearing any systems' caches as might be necessary. The script will be sent a list of all the the changed files as arguments. If the file name ends with .ms, it will be executed with the MethodScript engine. Otherwise, the file will be executed using the system shell. Leave this option empty to skip this step. If the file is specified, it must exist, and if it does not end in .ms, it must be executable."));
        defaults.add(new Preferences.Preference(INSTALL_URL, "", Preferences.Type.STRING, "The ec2 instance public url. NOTE: The security group of the instance must be configured to allow access to port 22. Ports 80 and 443 are also used, and should be opened, but that will not affect the installation process."));
        defaults.add(new Preferences.Preference(INSTALL_PEM_FILE, "", Preferences.Type.STRING, "The path to the PEM file used for initial login."));
        defaults.add(new Preferences.Preference(INSTALL_PUB_KEYS, "", Preferences.Type.STRING, "A list of public keys to upload to, and add to the authorized_keys file on the server. These keys will not be used by this script, but can allow easier login in the future. If blank, no additional keys will be uploaded."));
        defaults.add(new Preferences.Preference(TRANSLATION_MEMORY_DB, "", Preferences.Type.FILE, "The path to a local checkout of a translation memory database. This may be empty, in which case internationalization options will not be available on the deployed site."));
        defaults.add(new Preferences.Preference(PRODUCTION_TRANSLATIONS, "", Preferences.Type.STRING, "The base url for the production version of the localization database. If blank, the official url is used, but this should be set to your fork of the official repository, or a local server that serves the translations if you are testing localizations."));
        Preferences prefs = new Preferences("Site-Deploy", Logger.getLogger(SiteDeploy.class.getName()), defaults);
        if (generatePrefs) {
            prefs.init(sitedeploy);
            System.out.println("Preferences file is now located at " + sitedeploy.getAbsolutePath() + ". Please fill in the values, then re-run this command without the --generate-prefs option.");
            System.exit(0);
        }
        prefs.init(sitedeploy);
        String username = prefs.getStringPreference(USERNAME);
        String hostname = prefs.getStringPreference(HOSTNAME);
        Integer port = prefs.getIntegerPreference(PORT);
        String directory = prefs.getStringPreference(DIRECTORY);
        Boolean usePassword = prefs.getBooleanPreference(PASSWORD);
        String docsBase = prefs.getStringPreference(DOCSBASE);
        String siteBase = prefs.getStringPreference(SITEBASE);
        Boolean showTemplateCredit = prefs.getBooleanPreference(SHOW_TEMPLATE_CREDIT);
        String githubBaseUrl = prefs.getStringPreference(GITHUB_BASE_URL);
        String validatorUrl = prefs.getStringPreference(VALIDATOR_URL);
        File finalizerScript = prefs.getFilePreference(POST_SCRIPT);
        File translationMemoryDb = prefs.getFilePreference(TRANSLATION_MEMORY_DB);
        String productionTranslations = prefs.getStringPreference(PRODUCTION_TRANSLATIONS);
        if (!overridePostScript.equals("")) {
            finalizerScript = new File(overridePostScript);
        }
        ArrayList<String> configErrors = new ArrayList<String>();
        if ("".equals(directory)) {
            configErrors.add("Directory cannot be empty.");
        }
        if ("".equals(docsBase)) {
            configErrors.add("DocsBase cannot be empty.");
        }
        if ("".equals(hostname)) {
            configErrors.add("Hostname cannot be empty.");
        }
        if (!docsBase.startsWith("https://") && !docsBase.startsWith("http://")) {
            configErrors.add("DocsBase must begin with either http:// or https://");
        }
        if (!siteBase.startsWith("https://") && !siteBase.startsWith("http://")) {
            configErrors.add("SiteBase must begin with either http:// or https://");
        }
        if (!"localhost".equals(hostname)) {
            if (port < 0 || port > 65535) {
                configErrors.add("Port must be a number between 0 and 65535.");
            }
            if ("".equals(username)) {
                configErrors.add("Username cannot be empty.");
            }
        }
        if (doValidation && "".equals(validatorUrl)) {
            configErrors.add("Validation cannot occur while an empty validation url is specified in the config. Either set a validator url, or re-run without the --do-validation flag.");
        }
        if (finalizerScript != null) {
            if (!finalizerScript.exists()) {
                configErrors.add("post-script file specified does not exist (" + finalizerScript.getCanonicalPath() + ")");
            } else if (!finalizerScript.getPath().endsWith(".ms") && !finalizerScript.canExecute()) {
                configErrors.add("post-script does not end in .ms, and is not executable");
            }
        }
        if (overrideIdRsa != null && !new File(overrideIdRsa).exists()) {
            configErrors.add("override-id-rsa parameter points to a non-existent file.");
        }
        if (translationMemoryDb != null && !translationMemoryDb.exists()) {
            configErrors.add("Translation memory db must point to an existing database. (" + translationMemoryDb + ")");
        }
        if ("".equals(productionTranslations)) {
            productionTranslations = PRODUCTION_TRANSLATIONS_URL;
        }
        try {
            new URL(productionTranslations);
        }
        catch (MalformedURLException e) {
            configErrors.add("Invalid URL for production-translations value: " + productionTranslations);
        }
        if (!configErrors.isEmpty()) {
            System.err.println("Invalid input. Check preferences in " + sitedeploy.getAbsolutePath() + " and re-run");
            System.err.println(StringUtils.PluralTemplateHelper(configErrors.size(), "Here is the %d error:", "Here are the %d errors:"));
            System.err.println(" - " + StringUtils.Join(configErrors, "\n - "));
            System.exit(1);
        }
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        if (!docsBase.endsWith("/")) {
            docsBase = docsBase + "/";
        }
        directory = directory + MSVersion.LATEST;
        docsBase = docsBase + MSVersion.LATEST + "/";
        System.out.println("Using the following settings, loaded from " + sitedeploy.getCanonicalPath());
        System.out.println("username: " + username);
        System.out.println("hostname: " + hostname);
        System.out.println("port: " + port);
        System.out.println("directory: " + directory);
        System.out.println("docs-base: " + docsBase);
        System.out.println("site-base: " + siteBase);
        System.out.println("github-base-url: " + githubBaseUrl);
        if (translationMemoryDb != null) {
            System.out.println("Translation memory database: " + translationMemoryDb);
        }
        if (productionTranslations != null) {
            System.out.println("Production translations url: " + productionTranslations);
        }
        if (finalizerScript != null) {
            System.out.println("post-script: " + finalizerScript.getCanonicalPath());
        }
        if (doValidation) {
            System.out.println("validator-url: " + validatorUrl);
        }
        if (usePassword.booleanValue() && password != null) {
            try (ConsoleReader reader = null;){
                Character cha = Character.valueOf('\u0000');
                reader = new ConsoleReader();
                reader.setExpandEvents(false);
                password = reader.readLine("Please enter your password: ", cha);
            }
        }
        if ("localhost".equals(hostname)) {
            deploymentMethod = new LocalDeploymentMethod(directory + "/");
        } else {
            String remote = username + "@" + hostname + ":" + port + (password == null || "".equals(password) ? "" : ":" + password) + ":" + directory + "/";
            deploymentMethod = new RemoteDeploymentMethod(remote);
        }
        SiteDeploy.deploy(useLocalCache, siteBase, docsBase, deploymentMethod, doValidation, showTemplateCredit, githubBaseUrl, validatorUrl, finalizerScript, clearProgressBar, overrideIdRsa, translationMemoryDb, productionTranslations);
    }

    private static void deploy(boolean useLocalCache, String siteBase, String docsBase, DeploymentMethod deploymentMethod, boolean doValidation, boolean showTemplateCredit, String githubBaseUrl, String validatorUrl, File finalizerScript, boolean clearProgressBar, String overrideIdRsa, File translationMemoryDb, String productionTranslations) throws IOException, InterruptedException {
        new SiteDeploy(siteBase, docsBase, useLocalCache, deploymentMethod, doValidation, showTemplateCredit, githubBaseUrl, validatorUrl, finalizerScript, clearProgressBar, overrideIdRsa, translationMemoryDb, productionTranslations).deploy();
    }

    private void deploy() throws InterruptedException, IOException {
        this.apiJson = JSONValue.toJSONString(new APIBuilder().build());
        this.apiJsonVersion = SiteDeploy.getLocalMD5(StreamUtils.GetInputStream(this.apiJson));
        this.deployAPI();
        this.deployEventAPI();
        this.deployAPIJSON();
        this.deployFrontPages();
        this.deployLearningTrail();
        this.deployEvents();
        this.deployObjects();
        this.deployResources();
        this.deployJar();
        Runnable generateFinalizer = new Runnable(){

            @Override
            public void run() {
                if (SiteDeploy.this.generateQueue.getQueue().isEmpty()) {
                    SiteDeploy.this.generateQueue.shutdown();
                } else {
                    SiteDeploy.this.generateQueue.submit(this);
                }
            }
        };
        this.generateQueue.submit(generateFinalizer);
        this.generateQueue.awaitTermination(1L, TimeUnit.DAYS);
        Runnable uploadFinalizer = new Runnable(){

            @Override
            public void run() {
                if (SiteDeploy.this.uploadQueue.getQueue().isEmpty()) {
                    try {
                        SiteDeploy.this.writeMasterTranslations();
                    }
                    catch (Throwable ex) {
                        SiteDeploy.this.writeLog("Could not write out translations!", ex);
                    }
                    SiteDeploy.this.uploadQueue.shutdown();
                } else {
                    SiteDeploy.this.uploadQueue.submit(this);
                }
            }
        };
        this.uploadQueue.submit(uploadFinalizer);
        this.uploadQueue.awaitTermination(1L, TimeUnit.DAYS);
        this.dm.waitForThreads();
        this.deploymentMethod.finish();
        System.out.println();
        if (this.doValidation) {
            System.out.println("Upload complete, running html5 validation");
            int filesValidated = 0;
            int specifiedErrors = 0;
            try {
                for (Map.Entry<String, String> e : this.uploadedPages.entrySet()) {
                    HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
                    RequestSettings settings = new RequestSettings();
                    settings.setFollowRedirects(true);
                    headers.put("Content-Type", Arrays.asList("text/html; charset=utf-8"));
                    headers.put("Content-Encoding", Arrays.asList("gzip"));
                    headers.put("Accept-Encoding", Arrays.asList("gzip"));
                    settings.setHeaders(headers);
                    byte[] outStream = e.getValue().getBytes("UTF-8");
                    ByteArrayOutputStream out = new ByteArrayOutputStream(outStream.length);
                    try (GZIPOutputStream gz = new GZIPOutputStream(out);){
                        gz.write(outStream);
                    }
                    byte[] param = out.toByteArray();
                    settings.setRawParameter(param);
                    settings.setTimeout(10000);
                    settings.setMethod(HTTPMethod.POST);
                    HTTPResponse response = WebUtility.GetPage(new URL(this.validatorUrl + "?out=gnu"), settings);
                    if (response.getResponseCode() != 200) {
                        System.out.println(Static.MCToANSIColors("Response for " + (Object)((Object)MCChatColor.AQUA) + e.getKey() + (Object)((Object)MCChatColor.PLAIN_WHITE) + ":"));
                        System.out.println(response.getContent());
                        throw new IOException("Response was non-200, refusing to continue with validation");
                    }
                    String[] errors = response.getContentAsString().split("\n");
                    int errorsDisplayed = 0;
                    String[] stringArray = errors;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        int i2;
                        String supressWarning = "info warning: Section lacks heading. Consider using \u201ch2\u201d-\u201ch6\u201d elements to add identifying headings to all sections.";
                        String error = stringArray[i];
                        GNUErrorMessageFormat gnuError = new GNUErrorMessageFormat(error);
                        if (supressWarning.equals(gnuError.message())) continue;
                        if (error == errors[0]) {
                            System.out.println(Static.MCToANSIColors("Response for " + (Object)((Object)MCChatColor.AQUA) + e.getKey() + (Object)((Object)MCChatColor.PLAIN_WHITE) + ":"));
                        }
                        StringBuilder output = new StringBuilder();
                        switch (gnuError.messageType()) {
                            case ERROR: {
                                output.append((Object)MCChatColor.RED);
                                break;
                            }
                            case WARNING: {
                                output.append((Object)MCChatColor.GOLD);
                            }
                        }
                        output.append("line ").append(gnuError.fromLine()).append(" ").append(gnuError.message()).append((Object)MCChatColor.PLAIN_WHITE);
                        String[] page = e.getValue().split("\n");
                        for (i2 = gnuError.fromLine(); i2 < gnuError.toLine() + 1; ++i2) {
                            output.append("\n").append(page[i2 - 1]);
                        }
                        output.append("\n");
                        for (i2 = 0; i2 < gnuError.fromColumn() - 1; ++i2) {
                            output.append(" ");
                        }
                        output.append((Object)MCChatColor.RED).append("^").append((Object)MCChatColor.PLAIN_WHITE);
                        System.out.println(Static.MCToANSIColors(output.toString()));
                        ++specifiedErrors;
                        ++errorsDisplayed;
                    }
                    ++filesValidated;
                }
            }
            catch (IOException ex) {
                System.err.println("Validation could not occur due to the following exception: " + ex.getMessage());
                ex.printStackTrace(System.err);
            }
            System.out.println("Files validated: " + filesValidated);
            System.out.println("Errors found: " + specifiedErrors);
        }
        if (this.finalizerScript != null) {
            System.out.println("Running post-script");
            if (this.finalizerScript.getPath().endsWith(".ms")) {
                try {
                    Interpreter.startWithTTY(this.finalizerScript, this.filesChanged, false);
                }
                catch (Profiles.InvalidProfileException | DataSourceException | URISyntaxException ex) {
                    ex.printStackTrace(System.err);
                }
            } else {
                ArrayList<String> args = new ArrayList<String>();
                args.add(this.finalizerScript.getCanonicalPath());
                args.addAll(this.filesChanged);
                CommandExecutor exec = new CommandExecutor(args.toArray(new String[args.size()]));
                exec.setSystemInputsAndOutputs();
                exec.start();
                exec.waitFor();
            }
        }
        System.out.println("Done!");
        System.out.println("Summary of changed files (" + this.filesChanged.size() + ")");
        System.out.println(StringUtils.Join(this.filesChanged, "\n"));
        if (this.masterMemories != null) {
            System.out.println(this.masterMemories.size() + " translation segments exist.");
        }
    }

    private SiteDeploy(String siteBase, String docsBase, boolean useLocalCache, DeploymentMethod deploymentMethod, boolean doValidation, boolean showTemplateCredit, String githubBaseUrl, String validatorUrl, File finalizerScript, boolean clearProgressBar, String overrideIdRsa, File translationMemoryDb, String productionTranslations) throws IOException {
        this.siteBase = siteBase;
        this.docsBase = docsBase;
        this.resourceBase = docsBase + "resources/";
        this.finalizerScript = finalizerScript;
        this.reader = new ConsoleReader();
        this.generateQueue = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "generateQueue");
            }
        });
        this.uploadQueue = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "uploadQueue");
            }
        });
        this.useLocalCache = useLocalCache;
        this.deploymentMethod = deploymentMethod;
        this.doValidation = doValidation;
        this.showTemplateCredit = showTemplateCredit;
        this.validatorUrl = validatorUrl;
        if (githubBaseUrl.isEmpty()) {
            githubBaseUrl = DEFAULT_GITHUB_BASE_URL;
        }
        this.githubBaseUrl = githubBaseUrl;
        this.clearProgressBar = clearProgressBar;
        this.pn = SiteDeploy.getPersistenceNetwork();
        if (this.pn != null) {
            try {
                String localCache = this.pn.get(new String[]{"site_deploy", "local_cache"});
                if (localCache == null) {
                    localCache = "{}";
                }
                this.lc = (Map)JSONValue.parse((String)localCache);
            }
            catch (DataSourceException | IllegalArgumentException ex) {
                this.writeLog("Could not read in local cache", ex);
                this.notificationAboutLocalCache = false;
            }
        }
        this.overrideIdRsa = overrideIdRsa;
        this.translationMemoryDb = translationMemoryDb;
        this.productionTranslations = productionTranslations;
        if (translationMemoryDb != null) {
            this.writeStatus("Loading translation memories, this may take a while.");
            this.masterMemories = new TranslationMaster(translationMemoryDb, (current, total) -> {
                if (!clearProgressBar) {
                    return;
                }
                this.writeStatus("Loading translation memories, this may take a while (" + (int)current + "/" + (int)total + ")");
            });
            this.writeStatus("Done loading translation memories.");
        } else {
            this.masterMemories = null;
        }
    }

    public static PersistenceNetwork getPersistenceNetwork() {
        PersistenceNetworkImpl p2;
        try {
            p2 = new PersistenceNetworkImpl(MethodScriptFileLocations.getDefault().getPersistenceConfig(), new URI("sqlite://" + MethodScriptFileLocations.getDefault().getDefaultPersistenceDBFile().getCanonicalFile().toURI().getRawSchemeSpecificPart().replace('\\', '/')), new ConnectionMixinFactory.ConnectionMixinOptions());
        }
        catch (DataSourceException | IOException | URISyntaxException ex) {
            p2 = null;
        }
        return p2;
    }

    private void resetLine() throws IOException {
        if (this.clearProgressBar) {
            this.reader.getOutput().write("\u001b[1G\u001b[K");
            this.reader.flush();
        } else {
            this.reader.getOutput().write("\n");
            this.reader.flush();
        }
    }

    private synchronized void writeLog(String log, Throwable e) {
        try {
            this.reader.getOutput().write("\n" + log + "\n");
            e.printStackTrace(new PrintWriter(this.reader.getOutput()));
            this.reader.getOutput().write("\n");
            this.reader.flush();
        }
        catch (IOException ex) {
            System.err.println("Failure while logging exception!");
            System.err.println("Original exception:");
            e.printStackTrace(System.err);
            System.err.println("Logging exception:");
            ex.printStackTrace(System.err);
        }
    }

    private synchronized void writeStatus(String additionalInfo) {
        int generatePercent = 0;
        if (this.totalGenerateTasks.get() != 0) {
            generatePercent = (int)((double)this.currentGenerateTask.get() / (double)this.totalGenerateTasks.get() * 100.0);
        }
        int uploadPercent = 0;
        if (this.totalUploadTasks.get() != 0) {
            uploadPercent = (int)((double)this.currentUploadTask.get() / (double)this.totalUploadTasks.get() * 100.0);
        }
        String message = "Generate progress: " + this.currentGenerateTask.get() + "/" + this.totalGenerateTasks.get() + " (" + generatePercent + "%); Upload progress: " + this.currentUploadTask.get() + "/" + this.totalUploadTasks.get() + " (" + uploadPercent + "%); " + additionalInfo;
        try {
            this.resetLine();
            this.reader.getOutput().write(message);
            this.reader.flush();
        }
        catch (IOException ex) {
            System.out.println(message);
        }
    }

    private Map<String, DocGenTemplates.Generator> getStandardGenerators() {
        HashMap<String, DocGenTemplates.Generator> g2 = new HashMap<String, DocGenTemplates.Generator>();
        g2.put("resourceBase", args -> this.resourceBase);
        g2.put("branding", args -> Implementation.GetServerType().getBranding());
        g2.put("siteRoot", args -> this.siteBase);
        g2.put("productionTranslations", args -> this.productionTranslations);
        g2.put("docsBase", args -> this.docsBase);
        g2.put("apiJsonVersion", args -> this.apiJsonVersion);
        g2.put("cacheBuster", args -> {
            String resourceLoc = this.resourceBase + args[0];
            String loc = args[0];
            if (!loc.startsWith("/")) {
                loc = "/siteDeploy/resources/" + loc;
            } else {
                resourceLoc = this.resourceBase + args[1];
            }
            String hash2 = "0";
            try {
                InputStream in = SiteDeploy.class.getResourceAsStream(loc);
                if (in == null) {
                    throw new RuntimeException("Could not find " + loc + " in resources folder for cacheBuster template");
                }
                hash2 = SiteDeploy.getLocalMD5(in);
            }
            catch (IOException ex) {
                this.writeLog(null, ex);
            }
            return resourceLoc + "?v=" + hash2;
        });
        DocGenTemplates.Generator learningTrailGen = args -> {
            String learningTrail = StreamUtils.GetString(SiteDeploy.class.getResourceAsStream("/siteDeploy/LearningTrail.json"));
            ArrayList ret = new ArrayList();
            List lt2 = (List)JSONValue.parse((String)learningTrail);
            for (Map l : lt2) {
                for (Map.Entry e : l.entrySet()) {
                    String category = (String)e.getKey();
                    ArrayList catInfo = new ArrayList();
                    for (Object ll : (List)e.getValue()) {
                        LinkedHashMap<String, String> pageInfo = new LinkedHashMap<String, String>();
                        String page = null;
                        String name = null;
                        if (ll instanceof String) {
                            name = page = (String)ll;
                        } else if (ll instanceof Map) {
                            Map p2 = (Map)ll;
                            if (p2.entrySet().size() != 1) {
                                throw new RuntimeException("Invalid JSON for learning trail");
                            }
                            for (Map.Entry ee : p2.entrySet()) {
                                page = (String)ee.getKey();
                                name = (String)ee.getValue();
                            }
                        } else {
                            throw new RuntimeException("Invalid JSON for learning trail");
                        }
                        assert (page != null && name != null);
                        boolean exists = page.contains(".") ? true : SiteDeploy.class.getResourceAsStream("/docs/" + page) != null;
                        pageInfo.put("name", name);
                        pageInfo.put("page", page);
                        pageInfo.put("category", category);
                        pageInfo.put("exists", Boolean.toString(exists));
                        catInfo.add(pageInfo);
                    }
                    HashMap m = new HashMap();
                    m.put(category, catInfo);
                    ret.add(m);
                }
            }
            return JSONValue.toJSONString(ret);
        };
        g2.put("js_string_learning_trail", args -> {
            String g1 = learningTrailGen.generate(args);
            g1 = g1.replaceAll("\\\\", "\\\\");
            g1 = g1.replaceAll("\"", "\\\\\"");
            return g1;
        });
        g2.put("learning_trail", learningTrailGen);
        g2.put("showTemplateCredit", args -> this.showTemplateCredit ? "" : "display: none;");
        return g2;
    }

    private void writeFromString(String contents, String toLocation) {
        this.writeFromStream(StreamUtils.GetInputStream(contents), toLocation);
    }

    private void writeFromStream(InputStream contents, String toLocation) {
        this.uploadQueue.submit(() -> {
            try {
                this.writeStatus("Currently uploading " + toLocation);
                byte[] c = StreamUtils.GetBytes(contents);
                contents.close();
                boolean skipUpload = false;
                String hash2 = null;
                if (this.pn != null && this.notificationAboutLocalCache) {
                    hash2 = SiteDeploy.getLocalMD5(new ByteArrayInputStream(c));
                    try {
                        String cacheHash;
                        if (this.lc.containsKey(this.deploymentMethod.getID() + toLocation) && this.useLocalCache && (cacheHash = this.lc.get(this.deploymentMethod.getID() + toLocation)).equals(hash2)) {
                            skipUpload = true;
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        this.writeLog("Could not use local cache", ex);
                        this.notificationAboutLocalCache = false;
                    }
                }
                if (!skipUpload && this.deploymentMethod.deploy(new ByteArrayInputStream(c), toLocation, this.overrideIdRsa)) {
                    this.filesChanged.add(toLocation);
                }
                if (this.pn != null && this.notificationAboutLocalCache && hash2 != null) {
                    try {
                        this.lc.put(this.deploymentMethod.getID() + toLocation, hash2);
                        this.pn.set(this.dm, new String[]{"site_deploy", "local_cache"}, JSONValue.toJSONString(this.lc));
                    }
                    catch (DataSourceException | ReadOnlyException | IllegalArgumentException ex) {
                        this.writeLog(null, ex);
                        this.notificationAboutLocalCache = false;
                    }
                }
                this.currentUploadTask.addAndGet(1);
                this.writeStatus("");
            }
            catch (Throwable ex) {
                this.writeLog("Failed while uploading " + toLocation, ex);
                this.generateQueue.shutdownNow();
                this.uploadQueue.shutdownNow();
            }
        });
        this.totalUploadTasks.addAndGet(1);
    }

    static synchronized String getLocalMD5(InputStream localFile) throws IOException {
        try {
            String hash2;
            byte[] f = StreamUtils.GetBytes(localFile);
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(f);
            String string = hash2 = StringUtils.toHex(digest.digest()).toLowerCase();
            return string;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            localFile.close();
        }
    }

    private void writeResource(String resource, String toLocation) {
        this.writeFromStream(SiteDeploy.class.getResourceAsStream(resource), toLocation);
    }

    private void writePageFromResource(String title2, String resource, String toLocation, List<String> keywords, String description) {
        String s = StreamUtils.GetString(SiteDeploy.class.getResourceAsStream(resource.replace('\\', '/')));
        s = s + "<p id=\"edit_this_page\">Find a bug in this page? <a rel=\"noopener noreferrer\" target=\"_blank\" href=\"" + String.format(this.githubBaseUrl, "resources" + resource) + EDIT_THIS_PAGE_POSTAMBLE + "</p>";
        this.writePage(title2.replace("_", " "), s, toLocation, keywords, description);
    }

    private void writePageFromResource(String title2, String resource, String toLocation) {
        this.writePageFromResource(title2, resource, toLocation, null, "");
    }

    private void writePage(String title2, String body, String toLocation) {
        this.writePage(title2, body, toLocation, null, "");
    }

    private void writePage(String title2, String body, String toLocation, List<String> keywords, String description) {
        if (keywords == null) {
            keywords = new ArrayList<String>();
        }
        List<String> kw = keywords;
        this.generateQueue.submit(() -> {
            try {
                String bW = body;
                if (!bW.contains(EDIT_THIS_PAGE_PREAMBLE)) {
                    bW = bW + "<p id=\"edit_this_page\">Find a bug in this page? <a rel=\"noopener noreferrer\" target=\"_blank\" href=\"" + String.format(this.githubBaseUrl, "java/" + SiteDeploy.class.getName().replace(".", "/")) + ".java" + EDIT_THIS_PAGE_POSTAMBLE + "</p>";
                }
                try {
                    String b;
                    this.writeStatus("Currently generating " + toLocation);
                    if (this.translationMemoryDb != null) {
                        this.generateQueue.submit(() -> {
                            try {
                                this.createTranslationMemory(toLocation, body);
                            }
                            catch (Throwable t) {
                                this.writeLog("While generating translation memory for " + toLocation + "an error occured: ", t);
                            }
                            this.currentGenerateTask.addAndGet(1);
                        });
                        this.totalGenerateTasks.addAndGet(1);
                    }
                    try {
                        Map<String, DocGenTemplates.Generator> standard = this.getStandardGenerators();
                        standard.putAll(DocGenTemplates.GetGenerators());
                        b = DocGenTemplates.DoTemplateReplacement(bW, standard);
                    }
                    catch (Exception ex) {
                        if (ex instanceof DocGenTemplates.Generator.GenerateException) {
                            this.writeLog("Failed to substitute template while trying to upload resource to " + toLocation, ex);
                        } else {
                            this.writeLog(null, ex);
                        }
                        this.reader.flush();
                        this.generateQueue.shutdownNow();
                        this.uploadQueue.shutdownNow();
                        return;
                    }
                    HashMap<String, DocGenTemplates.Generator> g2 = new HashMap<String, DocGenTemplates.Generator>();
                    g2.put("body", args -> b);
                    g2.put("bodyEscaped", args -> {
                        String s = b.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'").replaceAll("\r", "").replaceAll("\n", "\\\\n");
                        s = s.replaceAll("<script.*?</script>", "");
                        return s;
                    });
                    g2.put("title", args -> title2);
                    g2.put("useHttps", args -> this.siteBase.startsWith("https") ? "true" : "false");
                    g2.put("keywords", args -> {
                        ArrayList<String> k = new ArrayList<String>(kw);
                        k.add(Implementation.GetServerType().getBranding());
                        return StringUtils.Join(k, ", ");
                    });
                    g2.put("description", args -> description);
                    g2.putAll(this.getStandardGenerators());
                    g2.putAll(DocGenTemplates.GetGenerators());
                    String frame = StreamUtils.GetString(SiteDeploy.class.getResourceAsStream("/siteDeploy/frame.html"));
                    String bb = DocGenTemplates.DoTemplateReplacement(frame, g2);
                    this.uploadedPages.put(toLocation, bb);
                    this.writeFromString(bb, toLocation);
                    this.currentGenerateTask.addAndGet(1);
                    this.writeStatus("");
                }
                catch (Exception ex) {
                    this.writeLog("While writing " + toLocation + " the following error occured:", ex);
                }
            }
            catch (Throwable t) {
                this.writeLog("Failure!", t);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
    }

    private void createTranslationMemory(String toLocation, String inputString) throws IOException {
        toLocation = StringUtils.replaceLast(toLocation, "\\.html", ".tmem.xml");
        String location = "%s/docs/" + MSVersion.V3_3_4 + "/" + toLocation;
        this.writeStatus("Creating memory file for " + location);
        this.masterMemories.createTranslationMemory(location, inputString);
    }

    private void writeMasterTranslations() throws IOException {
        if (this.masterMemories != null) {
            this.writeStatus("Writing out translation database");
            this.masterMemories.save((current, total) -> {
                if (!this.clearProgressBar) {
                    return;
                }
                this.writeStatus("Writing out translation database (" + (int)current + "/" + (int)total + ")");
            });
        }
    }

    private void deployResources() {
        this.generateQueue.submit(() -> {
            try {
                this.writeStatus("Generating resources");
                File root = new File(SiteDeploy.class.getResource("/siteDeploy/resources").toExternalForm());
                ZipReader reader1 = new ZipReader(root);
                LinkedList<File> q = new LinkedList<File>();
                q.addAll(Arrays.asList(reader1.listFiles()));
                while (q.peek() != null) {
                    ZipReader r = new ZipReader((File)q.poll());
                    if (r.isDirectory()) {
                        q.addAll(Arrays.asList(r.listFiles()));
                        continue;
                    }
                    String fileName = r.getFile().getAbsolutePath().replaceFirst(Pattern.quote(reader1.getFile().getAbsolutePath()), "");
                    this.writeStatus("Generating " + fileName);
                    this.writeFromStream(r.getInputStream(), "resources" + fileName);
                }
            }
            catch (IOException ex) {
                this.writeLog(null, ex);
            }
            String indexJs = StreamUtils.GetString(SiteDeploy.class.getResourceAsStream("/siteDeploy/index.js"));
            try {
                this.writeFromString(DocGenTemplates.DoTemplateReplacement(indexJs, this.getStandardGenerators()), "resources/js/index.js");
            }
            catch (DocGenTemplates.Generator.GenerateException ex) {
                this.writeLog("GenerateException in /siteDeploy/index.js", ex);
            }
            this.currentGenerateTask.addAndGet(1);
        });
        this.totalGenerateTasks.addAndGet(1);
    }

    private void deployFrontPages() {
        this.generateQueue.submit(() -> {
            try {
                this.writePageFromResource(MSVersion.LATEST.toString() + " - Docs", "/siteDeploy/VersionFrontPage", "index.html", Arrays.asList(MSVersion.LATEST.toString(), "better than skript"), "Front page for " + MSVersion.LATEST.toString());
                this.currentGenerateTask.addAndGet(1);
            }
            catch (Throwable t) {
                this.writeLog("Failure!", t);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
        this.generateQueue.submit(() -> {
            try {
                this.writePageFromResource("Privacy Policy", "/siteDeploy/privacy_policy.html", "privacy_policy.html", Arrays.asList("privacy policy"), "Privacy policy for the site");
                this.currentGenerateTask.addAndGet(1);
            }
            catch (Throwable t) {
                this.writeLog("Failure!", t);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
        this.generateQueue.submit(() -> {
            try {
                this.writePageFromResource(Implementation.GetServerType().getBranding(), "/siteDeploy/FrontPage", "../../index.html", Arrays.asList("index", "front page"), "The front page for " + Implementation.GetServerType().getBranding());
                this.currentGenerateTask.addAndGet(1);
            }
            catch (Throwable t) {
                this.writeLog("Failure!", t);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
        this.generateQueue.submit(() -> {
            try {
                this.writePageFromResource(Implementation.GetServerType().getBranding(), "/siteDeploy/Sponsors", "../../sponsors.html", Arrays.asList("index", "front page"), "Sponsors of MethodScript");
                this.currentGenerateTask.addAndGet(1);
            }
            catch (Throwable t) {
                this.writeLog("Failure!", t);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
        this.generateQueue.submit(() -> {
            try {
                this.writePageFromResource("Doc Directory", "/siteDeploy/DocDirectory", "../index.html", Arrays.asList(DIRECTORY), "The directory for all documented versions");
                this.currentGenerateTask.addAndGet(1);
            }
            catch (Throwable t) {
                this.writeLog("Failure!", t);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
        this.generateQueue.submit(() -> {
            try {
                this.writePageFromResource("404 Not Found", "/siteDeploy/404", "../../404.html", Arrays.asList("404"), "Page not found");
                this.currentGenerateTask.addAndGet(1);
            }
            catch (Throwable t) {
                this.writeLog("Failure!", t);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
    }

    private void deployLearningTrail() {
        this.generateQueue.submit(() -> {
            try {
                File root = new File(SiteDeploy.class.getResource("/docs").toExternalForm());
                ZipReader zReader = new ZipReader(root);
                String path = Pattern.quote(zReader.getFile().getAbsolutePath());
                for (File r : zReader.listFiles()) {
                    String filename = r.getAbsolutePath().replaceFirst(path, "");
                    this.writePageFromResource(r.getName(), "/docs" + filename, r.getName() + ".html", Arrays.asList(r.getName().replace("_", " ")), "Learning trail page for " + r.getName().replace("_", " "));
                }
            }
            catch (IOException ex) {
                this.writeLog(null, ex);
            }
            this.currentGenerateTask.addAndGet(1);
        });
        this.totalGenerateTasks.addAndGet(1);
    }

    private void deployAPI() {
        this.generateQueue.submit(() -> {
            try {
                this.writeStatus("Generating API");
                TreeSet<Class<Function>> functionClasses = new TreeSet<Class<Function>>((o1, o2) -> {
                    Function f1 = (Function)ReflectionUtils.instantiateUnsafe(o1);
                    Function f2 = (Function)ReflectionUtils.instantiateUnsafe(o2);
                    return f1.getName().compareTo(f2.getName());
                });
                functionClasses.addAll(ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(api.class, Function.class));
                TreeMap data = new TreeMap((o1, o2) -> o1.getCanonicalName().compareTo(o2.getCanonicalName()));
                ArrayList<String> hiddenFunctions = new ArrayList<String>();
                for (Class clazz : functionClasses) {
                    try {
                        Function f;
                        if (!data.containsKey(clazz.getEnclosingClass())) {
                            data.put(clazz.getEnclosingClass(), new ArrayList());
                        }
                        List list = (List)data.get(clazz.getEnclosingClass());
                        ArrayList<String> c = new ArrayList<String>();
                        try {
                            f = (Function)ReflectionUtils.instantiateUnsafe(clazz);
                        }
                        catch (ReflectionUtils.ReflectionException ex) {
                            throw new RuntimeException("While trying to construct " + clazz + ", got the following", ex);
                        }
                        DocGen.DocInfo di = new DocGen.DocInfo(f.docs());
                        this.generateQueue.submit(() -> {
                            try {
                                this.generateFunctionDocs(f, di);
                            }
                            catch (Throwable ex) {
                                ex.printStackTrace(System.err);
                            }
                        });
                        if (f.since().equals(MSVersion.V0_0_0)) continue;
                        if (f.getClass().getAnnotation(hide.class) != null) {
                            hiddenFunctions.add(f.getName());
                        }
                        c.add("[[API/functions/" + f.getName() + "|" + f.getName() + "]]()");
                        c.add(di.ret);
                        c.add(di.args);
                        ArrayList<String> exc = new ArrayList<String>();
                        if (f.thrown() != null) {
                            for (Class<? extends CREThrowable> e : f.thrown()) {
                                String[] splitType = ReflectionUtils.instantiateUnsafe(e).getName().split("\\.");
                                exc.add("{{object|" + splitType[splitType.length - 1] + "}}");
                            }
                        }
                        c.add(StringUtils.Join(exc, "<br>"));
                        StringBuilder desc = new StringBuilder();
                        desc.append(HTMLUtils.escapeHTML(di.desc));
                        if (di.extendedDesc != null) {
                            desc.append(" [[API/functions/").append(f.getName()).append("|See more...]]<br>\n");
                        }
                        try {
                            if (f.examples() != null && f.examples().length > 0) {
                                desc.append("<br>([[API/functions/").append(f.getName()).append("#Examples|Examples...]])\n");
                            }
                        }
                        catch (ConfigCompileException | NoClassDefFoundError ex) {
                            this.writeLog(null, ex);
                        }
                        c.add(desc.toString());
                        c.add("<span class=\"api_" + (f.isRestricted() ? "yes" : "no") + "\">" + (f.isRestricted() ? "Yes" : "No") + "</span>");
                        list.add(c);
                    }
                    catch (Throwable throwable) {
                        this.writeLog("Failure while generating " + clazz, throwable);
                    }
                }
                StringBuilder b = new StringBuilder();
                b.append("<ul id=\"TOC\">");
                for (Class clazz : data.keySet()) {
                    b.append("<li><a href=\"#").append(clazz.getSimpleName()).append("\">").append(clazz.getSimpleName()).append("</a></li>");
                }
                b.append("</ul>\n");
                for (Map.Entry entry : data.entrySet()) {
                    Class clazz = (Class)entry.getKey();
                    List clazzData = (List)entry.getValue();
                    if (clazzData.isEmpty()) continue;
                    try {
                        b.append("== ").append(clazz.getSimpleName()).append(" ==\n");
                        String docs = (String)ReflectionUtils.invokeMethod(clazz, null, "docs");
                        b.append("<div>").append(docs).append("</div>\n\n");
                        b.append("{|\n|-\n");
                        b.append("! scope=\"col\" width=\"8%\" | Function Name\n! scope=\"col\" width=\"4%\" | Returns\n! scope=\"col\" width=\"16%\" | Arguments\n! scope=\"col\" width=\"8%\" | Throws\n! scope=\"col\" width=\"62%\" | Description\n! scope=\"col\" width=\"2%\" | <span class=\"abbr\" title=\"Restricted\">Res</span>\n");
                        for (List row : clazzData) {
                            b.append("|-");
                            if (hiddenFunctions.contains(row.get(0))) {
                                b.append(" class=\"hiddenFunction\"");
                            }
                            b.append("\n");
                            for (String cell : row) {
                                b.append("| ").append(cell).append("\n");
                            }
                        }
                        b.append("|}\n");
                        b.append("<p><a href=\"#TOC\">Back to top</a></p>\n");
                    }
                    catch (Error ex) {
                        this.writeLog("While processing " + clazz + " got:", ex);
                    }
                }
                b.append("<div><a href=\"#\" id=\"showHidden\">Show hidden</a></div>");
                b.append("<script type=\"text/javascript\">\npageRender.then(function() {\n$('#showHidden').click(function(event){\n$('.hiddenFunction').removeClass('hiddenFunction');\n$('#showHidden').remove();\nevent.preventDefault();\nreturn false;\n});\n});\n</script>");
                this.writePage("API", b.toString(), "API.html", Arrays.asList("API", "functions"), "A list of all " + Implementation.GetServerType().getBranding() + " functions");
                this.currentGenerateTask.addAndGet(1);
            }
            catch (Throwable ex) {
                ex.printStackTrace(System.err);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
    }

    private void generateFunctionDocs(Function f, DocGen.DocInfo docs) {
        this.writeStatus("Generating function docs for " + f.getName());
        StringBuilder page = new StringBuilder();
        page.append("== ").append(f.getName()).append(" ==\n");
        page.append("<div>").append(docs.desc).append("</div>\n");
        page.append("=== Vital Info ===\n");
        page.append("{| style=\"width: 40%;\" cellspacing=\"1\" cellpadding=\"1\" border=\"1\" class=\"wikitable\"\n");
        page.append("|-\n! scope=\"col\" width=\"20%\" | \n! scope=\"col\" width=\"80%\" | \n|-\n! scope=\"row\" | Name\n| ").append(f.getName()).append("\n|-\n! scope=\"row\" | Returns\n| ").append(docs.ret).append("\n|-\n! scope=\"row\" | Usages\n| ").append(docs.args).append("\n|-\n! scope=\"row\" | Throws\n| ");
        ArrayList<String> exceptions = new ArrayList<String>();
        if (f.thrown() != null) {
            for (Class<? extends CREThrowable> clazz : f.thrown()) {
                String t = ClassDiscovery.GetClassAnnotation(clazz, typeof.class).value();
                exceptions.add("[[../objects/" + t + "|" + t + "]]");
            }
        }
        page.append(StringUtils.Join(exceptions, "<br>"));
        page.append("\n|-\n! scope=\"row\" | Since\n| ").append(f.since()).append("\n|-\n! scope=\"row\" | Restricted\n");
        page.append("| <div style=\"background-color: ");
        page.append(f.isRestricted() ? "red" : "green");
        page.append("; font-weight: bold; text-align: center;\">").append(f.isRestricted() ? "Yes" : "No").append("</div>\n|-\n! scope=\"row\" | Optimizations\n| ");
        String optimizationMessage = "None";
        if (f instanceof Optimizable) {
            Set<Optimizable.OptimizationOption> options = ((Optimizable)f).optimizationOptions();
            ArrayList<String> list = new ArrayList<String>();
            for (Optimizable.OptimizationOption option : options) {
                list.add("[[../../Optimizer#" + option.name() + "|" + option.name() + "]]");
            }
            optimizationMessage = StringUtils.Join(list, " <br /> ");
        }
        page.append(optimizationMessage);
        page.append("\n|}");
        if (docs.extendedDesc != null) {
            page.append("<div>").append(docs.extendedDesc).append("</div>");
        }
        String[] usages = docs.originalArgs.split("\\|");
        StringBuilder usageBuilder = new StringBuilder();
        for (String usage : usages) {
            usageBuilder.append("<pre>\n").append(f.getName()).append("(").append(usage.trim()).append(")\n</pre>");
        }
        page.append("\n=== Usages ===\n");
        page.append(usageBuilder.toString());
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (f.examples() != null && f.examples().length > 0) {
                int count = 1;
                for (ExampleScript es : f.examples()) {
                    stringBuilder.append("====Example ").append(count).append("====\n").append(HTMLUtils.escapeHTML(es.getDescription())).append("\n\nGiven the following code:\n");
                    stringBuilder.append("<%CODE|").append(es.getScript()).append("%>\n");
                    String style = "";
                    stringBuilder.append("\n\nThe output ");
                    if (es.isAutomatic()) {
                        style = " background-color: #BDC7E9;";
                        stringBuilder.append("would");
                    } else {
                        stringBuilder.append("might");
                    }
                    stringBuilder.append(" be:\n<pre class=\"pre\" style=\"border-top: 1px solid blue; border-bottom: 1px solid blue;").append(style).append("\"");
                    stringBuilder.append("><%NOWIKI|").append(es.getOutput()).append("%>").append("</pre>\n");
                    ++count;
                }
            } else {
                stringBuilder.append("Sorry, there are no examples for this function! :(\n");
            }
        }
        catch (Exception ex) {
            stringBuilder.append("Error while compiling the examples for ").append(f.getName());
        }
        page.append("\n=== Examples ===\n");
        page.append(stringBuilder.toString());
        Class<? extends Documentation>[] seeAlso = f.seeAlso();
        String seeAlsoText = "";
        if (seeAlso != null && seeAlso.length > 0) {
            seeAlsoText = seeAlsoText + "===See Also===\n";
            boolean first = true;
            for (Class<? extends Documentation> c : seeAlso) {
                if (!first) {
                    seeAlsoText = seeAlsoText + ", ";
                }
                first = false;
                if (Function.class.isAssignableFrom(c)) {
                    Function f2 = (Function)ReflectionUtils.newInstance(c);
                    seeAlsoText = seeAlsoText + "<code>[[API/functions/" + f2.getName() + ".html|" + f2.getName() + "]]</code>";
                    continue;
                }
                if (Template.class.isAssignableFrom(c)) {
                    Template t = (Template)((Object)ReflectionUtils.newInstance(c));
                    seeAlsoText = seeAlsoText + "[[" + t.getPath() + t.getName() + "|Learning Trail: " + t.getDisplayName() + "]]";
                    continue;
                }
                throw new Error("Unsupported class found in @seealso annotation: " + c.getName());
            }
        }
        page.append(seeAlsoText);
        Class<?> container = f.getClass();
        while (container.getEnclosingClass() != null) {
            container = container.getEnclosingClass();
        }
        int lineNum = 0;
        try {
            MethodMirror m = ClassDiscovery.getDefaultInstance().forName(f.getClass().getName()).getMethod("docs", new Class[0]);
            lineNum = m.getLineNumber();
        }
        catch (ClassNotFoundException | NoSuchMethodException m) {
            // empty catch block
        }
        String bW = "<p id=\"edit_this_page\">Find a bug in this page? <a rel=\"noopener noreferrer\" target=\"_blank\" href=\"" + String.format(this.githubBaseUrl, "java/" + container.getName().replace(".", "/")) + ".java#L" + (lineNum < 10 ? lineNum : lineNum + 10) + EDIT_THIS_PAGE_POSTAMBLE + " (Note this page is automatically generated from the documentation in the source code.)</p>";
        page.append(bW);
        String description = f.getName() + "() api page";
        this.writePage(f.getName(), page.toString(), "API/functions/" + f.getName() + ".html", Arrays.asList(f.getName(), f.getName() + " api", f.getName() + " example", f.getName() + " description"), description);
    }

    private void deployEventAPI() {
        this.generateQueue.submit(() -> {
            try {
                TreeSet<Class<Event>> eventClasses = new TreeSet<Class<Event>>((o1, o2) -> {
                    Event f1 = (Event)ReflectionUtils.instantiateUnsafe(o1);
                    Event f2 = (Event)ReflectionUtils.instantiateUnsafe(o2);
                    return f1.getName().compareTo(f2.getName());
                });
                eventClasses.addAll(ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(api.class, Event.class));
                TreeMap data = new TreeMap((o1, o2) -> o1.getCanonicalName().compareTo(o2.getCanonicalName()));
                for (Class clazz : eventClasses) {
                    Event e;
                    if (!data.containsKey(clazz.getEnclosingClass())) {
                        data.put(clazz.getEnclosingClass(), new ArrayList());
                    }
                    List list = (List)data.get(clazz.getEnclosingClass());
                    ArrayList<String> c = new ArrayList<String>();
                    try {
                        e = (Event)ReflectionUtils.instantiateUnsafe(clazz);
                    }
                    catch (ReflectionUtils.ReflectionException ex) {
                        throw new RuntimeException("While trying to construct " + clazz + ", got the following", ex);
                    }
                    DocGen.EventDocInfo edi = new DocGen.EventDocInfo(e.docs(), e.getName());
                    if (e.since().equals(MSVersion.V0_0_0)) continue;
                    c.add(e.getName());
                    c.add(edi.description);
                    ArrayList<String> pre = new ArrayList<String>();
                    if (!edi.prefilter.isEmpty()) {
                        for (DocGen.EventDocInfo.PrefilterData prefilterData : edi.prefilter) {
                            pre.add("<p><strong>" + prefilterData.name + "</strong>: " + prefilterData.formatDescription(DocGen.MarkupType.HTML) + "</p>");
                        }
                    }
                    c.add(StringUtils.Join(pre, ""));
                    ArrayList<String> ed = new ArrayList<String>();
                    if (!edi.eventData.isEmpty()) {
                        for (Object edata : edi.eventData) {
                            ed.add("<p><strong>" + ((DocGen.EventDocInfo.EventData)edata).name + "</strong>" + (!((DocGen.EventDocInfo.EventData)edata).description.isEmpty() ? ": " + ((DocGen.EventDocInfo.EventData)edata).description : "") + "</p>");
                        }
                    }
                    c.add(StringUtils.Join(ed, ""));
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (!edi.mutability.isEmpty()) {
                        for (DocGen.EventDocInfo.MutabilityData mdata : edi.mutability) {
                            arrayList.add("<p><strong>" + mdata.name + "</strong>" + (!mdata.description.isEmpty() ? ": " + mdata.description : "") + "</p>");
                        }
                    }
                    c.add(StringUtils.Join(arrayList, ""));
                    list.add(c);
                }
                StringBuilder b = new StringBuilder();
                b.append("<ul id=\"TOC\">");
                for (Class clazz : data.keySet()) {
                    b.append("<li><a href=\"#").append(clazz.getSimpleName()).append("\">").append(clazz.getSimpleName()).append("</a></li>");
                }
                b.append("</ul>\n");
                for (Map.Entry entry : data.entrySet()) {
                    Class clazz = (Class)entry.getKey();
                    List clazzData = (List)entry.getValue();
                    if (clazzData.isEmpty()) continue;
                    try {
                        b.append("== ").append(clazz.getSimpleName()).append(" ==\n");
                        String docs = (String)ReflectionUtils.invokeMethod(clazz, null, "docs");
                        b.append("<div>").append(docs).append("</div>\n\n");
                        b.append("{|\n|-\n");
                        b.append("! scope=\"col\" width=\"7%\" | Event Name\n! scope=\"col\" width=\"30%\" | Description\n! scope=\"col\" width=\"20%\" | Prefilters\n! scope=\"col\" width=\"25%\" | Event Data\n! scope=\"col\" width=\"18%\" | Mutable Fields\n");
                        for (List row : clazzData) {
                            b.append("|-");
                            b.append("\n");
                            for (String cell : row) {
                                b.append("| ").append(cell).append("\n");
                            }
                        }
                        b.append("|}\n");
                        b.append("<p><a href=\"#TOC\">Back to top</a></p>\n");
                    }
                    catch (Error ex) {
                        this.writeLog("While processing " + clazz + " got:", ex);
                    }
                }
                this.writePage("Event API", b.toString(), "Event_API.html", Arrays.asList("API", "events"), "A list of all " + Implementation.GetServerType().getBranding() + " events");
                this.currentGenerateTask.addAndGet(1);
            }
            catch (Error ex) {
                ex.printStackTrace(System.err);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
    }

    private void deployEvents() {
    }

    private void deployObjects() {
    }

    private void deployAPIJSON() {
        this.generateQueue.submit(() -> {
            try {
                this.writeStatus("Generating api.json");
                this.writeFromString(this.apiJson, "api.json");
                this.currentGenerateTask.addAndGet(1);
            }
            catch (Throwable t) {
                this.writeLog("Failure!", t);
            }
        });
        this.totalGenerateTasks.addAndGet(1);
    }

    private void deployJar() {
        this.uploadQueue.submit(() -> {
            try {
                this.writeFromStream(ClassDiscovery.GetClassContainer(SiteDeploy.class).openStream(), "MethodScript.jar");
                this.writeFromStream(ClassDiscovery.GetClassContainer(SiteDeploy.class).openStream(), "../../MethodScript.jar");
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
        });
    }
}

