/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.langserv;

import com.laytonsmith.PureUtilities.ArgumentParser;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Triplet;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.hide;
import com.laytonsmith.core.AbstractCommandLineTool;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Security;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.TokenStream;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Token;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.events.EventList;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.functions.DocumentLinkProvider;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.tool;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.tools.docgen.DocGen;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkOptions;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class LangServ
implements LanguageServer,
LanguageClientAware,
TextDocumentService,
WorkspaceService {
    @MSLog.LogTag
    public static final MSLog.Tag LANGSERVLOGTAG = new MSLog.Tag(){

        @Override
        public String getName() {
            return "langserv";
        }

        @Override
        public String getDescription() {
            return "Logs events related to the Language Server";
        }

        @Override
        public LogLevel getLevel() {
            return LogLevel.WARNING;
        }
    };
    private final boolean usingStdio;
    private LanguageClient client;
    private final Executor highPriorityProcessors = Executors.newCachedThreadPool(new ThreadFactory(){
        private int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "HighPriority-thread-pool-" + ++this.count);
        }
    });
    private final Executor lowPriorityProcessors = Executors.newFixedThreadPool(5, new ThreadFactory(){
        private int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "LowPriority-thread-pool-" + ++this.count);
        }
    });
    private List<CompletionItem> functionCompletionItems = null;
    private List<CompletionItem> objectCompletionItems = null;
    private List<CompletionItem> eventCompletionItems = null;
    private List<CompletionItem> allCompletionItems = null;
    private Map<String, CommandProvider> commandProviders = new HashMap<String, CommandProvider>();
    private static final int COMPILATION_DELAY = 3;
    private final Map<String, Triplet<Long, Executor, CompletableFuture<ParseTree>>> compileDelays = new HashMap<String, Triplet<Long, Executor, CompletableFuture<ParseTree>>>();
    private Thread compilerDelayThread = null;
    private final Map<String, String> documents = new HashMap<String, String>();

    public void log(String s, LogLevel level) {
        this.log(() -> s, level);
    }

    public void log(MSLog.StringProvider s, LogLevel level) {
        MSLog.GetLogger().Log(LANGSERVLOGTAG, level, s, Target.UNKNOWN);
        if (this.client != null && MSLog.GetLogger().WillLog(LANGSERVLOGTAG, level)) {
            MessageType type;
            switch (level) {
                case DEBUG: {
                    type = MessageType.Log;
                    break;
                }
                case INFO: {
                    type = MessageType.Info;
                    break;
                }
                case WARNING: {
                    type = MessageType.Warning;
                    break;
                }
                case ERROR: {
                    type = MessageType.Error;
                    break;
                }
                default: {
                    type = MessageType.Log;
                }
            }
            String full = s.getString();
            this.client.logMessage(new MessageParams(type, full));
            if (level == LogLevel.ERROR) {
                this.client.showMessage(new MessageParams(MessageType.Error, full));
            }
        }
    }

    public void loge(Throwable t) {
        this.log(StackTraceUtils.GetStacktrace(t), LogLevel.ERROR);
    }

    public void loge(String s) {
        this.log(s, LogLevel.ERROR);
    }

    public void loge(MSLog.StringProvider s) {
        this.log(s, LogLevel.ERROR);
    }

    public void logw(String s) {
        this.log(s, LogLevel.WARNING);
    }

    public void logw(MSLog.StringProvider s) {
        this.log(s, LogLevel.WARNING);
    }

    public void logi(String s) {
        this.log(s, LogLevel.INFO);
    }

    public void logi(MSLog.StringProvider s) {
        this.log(s, LogLevel.INFO);
    }

    public void logd(String s) {
        this.log(s, LogLevel.DEBUG);
    }

    public void logd(MSLog.StringProvider s) {
        this.log(s, LogLevel.DEBUG);
    }

    public void logv(String s) {
        this.log(s, LogLevel.VERBOSE);
    }

    public void logv(MSLog.StringProvider s) {
        this.log(s, LogLevel.VERBOSE);
    }

    public LangServ(boolean useStdio) {
        this.usingStdio = useStdio;
    }

    public void connect(LanguageClient client) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.client = client;
        this.highPriorityProcessors.execute(() -> {
            CompletionItem ci;
            ArrayList<Object> list = new ArrayList<CompletionItem>();
            for (FunctionBase fb : FunctionList.getFunctionList(api.Platforms.INTERPRETER_JAVA, null)) {
                DocGen.DocInfo di;
                if (fb.getClass().getAnnotation(hide.class) != null) continue;
                try {
                    di = new DocGen.DocInfo(fb.docs());
                }
                catch (IllegalArgumentException ex) {
                    MSLog.GetLogger().Log(LANGSERVLOGTAG, LogLevel.ERROR, "Error parsing function \"" + fb.getName() + "\". " + ex.getMessage(), Target.UNKNOWN);
                    continue;
                }
                ci = new CompletionItem(fb.getName());
                ci.setKind(CompletionItemKind.Function);
                ci.setDetail(di.ret);
                ci.setDocumentation(di.originalArgs + "\n\n" + di.desc + (di.extendedDesc == null ? "" : "\n\n" + di.extendedDesc));
                list.add(ci);
            }
            this.functionCompletionItems = list;
            this.logv("Function completion list completed. (" + list.size() + ")");
            list = new ArrayList();
            for (Event e : EventList.GetEvents()) {
                DocGen.EventDocInfo edi;
                try {
                    edi = new DocGen.EventDocInfo(e.docs(), e.getName());
                }
                catch (IllegalArgumentException ex) {
                    MSLog.GetLogger().Log(LANGSERVLOGTAG, LogLevel.ERROR, ex.getMessage(), Target.UNKNOWN);
                    continue;
                }
                ci = new CompletionItem(e.getName());
                ci.setCommitCharacters(Arrays.asList("'", "\""));
                ci.setKind(CompletionItemKind.Function);
                ci.setDetail("Event Type");
                StringBuilder description = new StringBuilder();
                description.append(edi.description).append("\n");
                if (!edi.prefilter.isEmpty()) {
                    for (DocGen.EventDocInfo.PrefilterData pdata : edi.prefilter) {
                        description.append(pdata.name).append(": ").append(pdata.formatDescription(DocGen.MarkupType.TEXT)).append("\n");
                    }
                    description.append("\n");
                }
                if (!edi.eventData.isEmpty()) {
                    for (DocGen.EventDocInfo.EventData edata : edi.eventData) {
                        description.append(edata.name).append(!edata.description.isEmpty() ? ": " + edata.description : "").append("\n");
                    }
                    description.append("\n");
                }
                if (!edi.mutability.isEmpty()) {
                    for (DocGen.EventDocInfo.MutabilityData mdata : edi.mutability) {
                        description.append(mdata.name).append(!mdata.description.isEmpty() ? ": " + mdata.description : "").append("\n");
                    }
                    description.append("\n");
                }
                ci.setDocumentation(description.toString());
                list.add(ci);
            }
            this.eventCompletionItems = list;
            this.logv("Event completion list completed. (" + list.size() + ")");
            list = new ArrayList();
            for (FullyQualifiedClassName fqcn : NativeTypeList.getNativeTypeList()) {
                try {
                    Mixed m = NativeTypeList.getInvalidInstanceForUse(fqcn);
                    ci = new CompletionItem(m.typeof().getSimpleName());
                    ci.setKind(CompletionItemKind.TypeParameter);
                    ci.setDetail(m.getName());
                    ci.setDocumentation(m.docs());
                    ci.setCommitCharacters(Arrays.asList(" "));
                    list.add(ci);
                }
                catch (Throwable throwable) {}
            }
            this.objectCompletionItems = list;
            this.logv("Object completion list completed. (" + list.size() + ")");
            this.allCompletionItems = new ArrayList<CompletionItem>();
            this.allCompletionItems.addAll(this.functionCompletionItems);
            this.allCompletionItems.addAll(this.eventCompletionItems);
            this.allCompletionItems.addAll(this.objectCompletionItems);
            this.logd("Completion list generated.");
        });
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        Security.setSecurityEnabled(false);
        CompletableFuture<InitializeResult> cf = new CompletableFuture<InitializeResult>();
        ServerCapabilities sc = new ServerCapabilities();
        sc.setTextDocumentSync(TextDocumentSyncKind.Full);
        DocumentLinkOptions documentLinkOptions = new DocumentLinkOptions();
        documentLinkOptions.setResolveProvider(Boolean.valueOf(false));
        sc.setDocumentLinkProvider(documentLinkOptions);
        ExecuteCommandOptions eco = new ExecuteCommandOptions();
        ArrayList<String> commands = new ArrayList<String>();
        for (Class<CommandProvider> c : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(Command.class, CommandProvider.class)) {
            CommandProvider cp;
            try {
                cp = c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(LangServ.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            String command = c.getAnnotation(Command.class).value();
            commands.add(command);
            this.commandProviders.put(command, cp);
        }
        eco.setCommands(commands);
        sc.setExecuteCommandProvider(eco);
        CompletionOptions co = new CompletionOptions(Boolean.valueOf(true), Arrays.asList("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "_"));
        sc.setCompletionProvider(co);
        cf.complete(new InitializeResult(sc));
        if (this.usingStdio) {
            System.err.println("Language Server Connected");
        }
        return cf;
    }

    public void initialized(InitializedParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.client.workspaceFolders().thenAccept(t -> {
            for (WorkspaceFolder f : t) {
                File workspace = new File(f.getUri().replaceFirst("file://", ""));
                try {
                    FileUtil.recursiveFind(workspace, f1 -> {
                        if (f1.isFile() && (f1.getName().endsWith(".ms") || f1.getName().endsWith(".msa"))) {
                            this.doCompilation(null, this.lowPriorityProcessors, f1.toURI().toString(), false);
                        }
                    });
                }
                catch (IOException ex) {
                    this.client.logMessage(new MessageParams(MessageType.Warning, ex.getMessage()));
                }
            }
        });
    }

    public CompletableFuture<Object> shutdown() {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        CompletableFuture<Object> cf = new CompletableFuture<Object>();
        cf.complete(null);
        return cf;
    }

    public void exit() {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        System.exit(0);
    }

    public TextDocumentService getTextDocumentService() {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        return this;
    }

    private static DiagnosticSeverity getSeverity(CompilerWarning warning) {
        if (warning.getSuppressCategory() == null) {
            return DiagnosticSeverity.Warning;
        }
        switch (warning.getSuppressCategory().getSeverityLevel()) {
            case HIGH: {
                return DiagnosticSeverity.Warning;
            }
            case MEDIUM: {
                return DiagnosticSeverity.Information;
            }
            case LOW: {
                return DiagnosticSeverity.Hint;
            }
        }
        throw new Error("Unaccounted for case: " + warning.getSuppressCategory());
    }

    public void doCompilation(CompletableFuture<ParseTree> future, Executor threadPool, String uri, boolean withDelay) {
        threadPool.execute(() -> {
            try {
                List<CompilerWarning> warnings;
                Environment env;
                HashSet<ConfigCompileException> exceptions = new HashSet<ConfigCompileException>();
                HashSet<Class<? extends Environment.EnvironmentImpl>> envs = new HashSet<Class<? extends Environment.EnvironmentImpl>>();
                for (Class<Environment.EnvironmentImpl> c : ClassDiscovery.getDefaultInstance().loadClassesThatExtend(Environment.EnvironmentImpl.class)) {
                    envs.add(c);
                }
                try {
                    env = Static.GenerateStandaloneEnvironment(false);
                    env = env.cloneAndAdd(new CommandHelperEnvironment());
                }
                catch (Profiles.InvalidProfileException | DataSourceException | IOException | URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
                CompilerEnvironment compilerEnv = env.getEnv(CompilerEnvironment.class);
                compilerEnv.setLogCompilerWarnings(false);
                GlobalEnv gEnv = env.getEnv(GlobalEnv.class);
                gEnv.SetCustom("cmdline", true);
                URI uuri = new URI(uri);
                File f = "untitled".equals(uuri.getScheme()) ? new File(uuri.getSchemeSpecificPart()).getAbsoluteFile() : Paths.get(uuri).toFile();
                gEnv.SetRootFolder(f.getParentFile());
                TokenStream tokens = null;
                ParseTree tree = null;
                try {
                    ParseTree fTree;
                    this.logd(() -> "Compiling " + f);
                    String code = this.getDocument(uri);
                    if (f.getName().endsWith(".msa")) {
                        tokens = MethodScriptCompiler.lex(code, env, f, false);
                        fTree = new ParseTree(null);
                        MethodScriptCompiler.preprocess(tokens, envs).forEach(script -> {
                            try {
                                script.compile();
                            }
                            catch (ConfigCompileException ex) {
                                exceptions.add(ex);
                            }
                            catch (ConfigCompileGroupException ex) {
                                exceptions.addAll(ex.getList());
                            }
                            script.getTrees().forEach(r -> fTree.addChild((ParseTree)r));
                        });
                    } else {
                        tokens = MethodScriptCompiler.lex(code, env, f, true);
                        fTree = MethodScriptCompiler.compile(tokens, env, envs);
                    }
                    tree = fTree;
                }
                catch (ConfigCompileException e) {
                    exceptions.add(e);
                }
                catch (ConfigCompileGroupException e) {
                    exceptions.addAll(e.getList());
                }
                catch (Throwable e) {
                    this.loge(() -> StackTraceUtils.GetStacktrace(e));
                }
                ArrayList<Diagnostic> diagnosticsList = new ArrayList<Diagnostic>();
                if (!exceptions.isEmpty()) {
                    this.logi(() -> "Errors found, reporting " + exceptions.size() + " errors");
                    for (ConfigCompileException configCompileException : exceptions) {
                        Diagnostic d = new Diagnostic();
                        d.setRange(this.convertTargetToRange(tokens, configCompileException.getTarget()));
                        d.setSeverity(DiagnosticSeverity.Error);
                        d.setMessage(configCompileException.getMessage());
                        diagnosticsList.add(d);
                    }
                }
                if (!(warnings = compilerEnv.getCompilerWarnings()).isEmpty()) {
                    for (CompilerWarning c : warnings) {
                        Diagnostic d = new Diagnostic();
                        d.setRange(this.convertTargetToRange(tokens, c.getTarget()));
                        d.setSeverity(LangServ.getSeverity(c));
                        d.setMessage(c.getMessage());
                        diagnosticsList.add(d);
                    }
                }
                PublishDiagnosticsParams publishDiagnosticsParams = new PublishDiagnosticsParams(uri, diagnosticsList);
                this.client.publishDiagnostics(publishDiagnosticsParams);
                if (future != null && tree != null) {
                    future.complete(tree);
                }
            }
            catch (Throwable t) {
                this.client.logMessage(new MessageParams(MessageType.Error, t.getMessage() + "\n" + StackTraceUtils.GetStacktrace(t)));
            }
        });
    }

    public String getDocument(String uri) throws IOException {
        File f;
        if (this.documents.containsKey(uri)) {
            return this.documents.get(uri);
        }
        try {
            f = Paths.get(new URI(uri)).toFile();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        return FileUtil.read(f);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        String uri = params.getTextDocument().getUri();
        this.documents.put(uri, params.getTextDocument().getText());
        this.doCompilation(null, this.highPriorityProcessors, uri, false);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> "Changing " + params);
        String uri = params.getTextDocument().getUri();
        if (params.getContentChanges().size() > 1) {
            this.logw("Unexpected size from didChange event.");
        }
        for (TextDocumentContentChangeEvent change : params.getContentChanges()) {
            String newText = change.getText();
            this.documents.put(uri, newText);
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.documents.remove(params.getTextDocument().getUri());
    }

    public void didSave(DidSaveTextDocumentParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.doCompilation(null, this.highPriorityProcessors, params.getTextDocument().getUri(), false);
    }

    public Range convertTargetToRange(ParseTree node) {
        String val = Construct.nval(node.getData());
        if (val == null) {
            val = "null";
        }
        int tokenLength = val.length();
        Target t = node.getTarget();
        if (tokenLength < 1) {
            tokenLength = 1;
        }
        Position start = new Position(t.line() - 1, t.col() - 2);
        Position end = new Position(t.line() - 1, t.col() + tokenLength - 2);
        if (start.getLine() < 0) {
            start.setLine(0);
        }
        if (start.getCharacter() < 0) {
            start.setCharacter(0);
        }
        if (end.getLine() < 0) {
            end.setLine(0);
        }
        if (end.getCharacter() < 0) {
            end.setCharacter(1);
        }
        return new Range(start, end);
    }

    public Range convertTargetToRange(TokenStream tokens, Target t) {
        int tokenLength = 5;
        if (tokens != null) {
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = (Token)tokens.get(i);
                if (token.lineNum != t.line() || token.column != t.col()) continue;
                tokenLength = token.value.length();
                break;
            }
        }
        if (tokenLength < 1) {
            tokenLength = 1;
        }
        Position start = new Position(t.line() - 1, t.col() - 2);
        Position end = new Position(t.line() - 1, t.col() + tokenLength - 2);
        if (start.getLine() < 0) {
            start.setLine(0);
        }
        if (start.getCharacter() < 0) {
            start.setCharacter(0);
        }
        if (end.getLine() < 0) {
            end.setLine(0);
        }
        if (end.getCharacter() < 0) {
            end.setCharacter(1);
        }
        return new Range(start, end);
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams position) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> String.format("Completion request sent: %s", position));
        CompletableFuture<Either<List<CompletionItem>, CompletionList>> result = new CompletableFuture<Either<List<CompletionItem>, CompletionList>>();
        this.highPriorityProcessors.execute(() -> {
            result.complete(Either.forLeft(this.functionCompletionItems));
            this.logv(() -> "Completion list returned with " + this.functionCompletionItems.size() + " items");
        });
        return result;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> unresolved.toString());
        CompletableFuture<CompletionItem> result = new CompletableFuture<CompletionItem>();
        result.complete(unresolved);
        return result;
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        String uri = params.getTextDocument().getUri();
        this.logv(this.getClass().getName() + "." + StackTraceUtils.currentMethod() + " called");
        this.logv(() -> "Requested " + uri);
        CompletableFuture<ParseTree> future = new CompletableFuture<ParseTree>();
        CompletableFuture<List<DocumentLink>> result = new CompletableFuture<List<DocumentLink>>();
        this.doCompilation(future, this.lowPriorityProcessors, uri, false);
        future.thenAccept(tree -> {
            Environment env;
            try {
                env = Static.GenerateStandaloneEnvironment(false);
            }
            catch (Profiles.InvalidProfileException | DataSourceException | IOException | URISyntaxException ex) {
                this.loge(ex);
                result.cancel(true);
                return;
            }
            ArrayList links = new ArrayList();
            tree.getAllNodes().forEach(node -> {
                if (node.getData() instanceof CFunction && ((CFunction)node.getData()).hasFunction()) {
                    try {
                        Function f = ((CFunction)node.getData()).getFunction();
                        if (f instanceof DocumentLinkProvider) {
                            this.logv(() -> "Found DocumentLinkProvider " + f.getName());
                            for (ParseTree link : ((DocumentLinkProvider)((Object)f)).getDocumentLinks(node.getChildren())) {
                                File file;
                                if (!link.isConst() || (file = Static.GetFileFromArgument(link.getData().val(), env, link.getTarget(), null)) == null || !file.exists() || !file.isFile()) continue;
                                this.logv(() -> "Found document link to " + file.toURI());
                                DocumentLink docLink = new DocumentLink();
                                docLink.setRange(this.convertTargetToRange(link));
                                docLink.setTarget(file.toURI().toString());
                                links.add(docLink);
                            }
                        }
                    }
                    catch (ConfigCompileException configCompileException) {
                        // empty catch block
                    }
                }
            });
            result.complete(links);
        });
        return result;
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        return this.commandProviders.get(params.getCommand()).execute(this.client, params);
    }

    public static interface CommandProvider {
        public CompletableFuture<Object> execute(LanguageClient var1, ExecuteCommandParams var2);
    }

    @java.lang.annotation.Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Command {
        public String value();
    }

    @tool(value="lang-serv")
    public static class LangServMode
    extends AbstractCommandLineTool {
        @Override
        public ArgumentParser getArgumentParser() {
            return ArgumentParser.GetParser().addDescription("Starts up the language server, which implements the Language Server Protocol").addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The host location that the client is running on.").setUsageName("host").setOptional().setName("host").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.STRING)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("The port the client is running on.").setUsageName("port").setOptional().setName("port").setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.NUMBER)).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("If set, stdio is used instead of socket connections.").asFlag().setName("stdio")).setErrorOnUnknownArgs(false).addArgument(new ArgumentParser.ArgumentBuilder().setDescription("For future compatibility reasons, unrecognized arguments are not an error, but they are not supported unless otherwise noted.").setUsageName("unrecognizedArgs").setOptionalAndDefault().setArgType(ArgumentParser.ArgumentBuilder.BuilderTypeNonFlag.ARRAY_OF_STRINGS));
        }

        @Override
        public boolean startupExtensionManager() {
            return false;
        }

        @Override
        public void execute(ArgumentParser.ArgumentParserResults parsedArgs) throws Exception {
            boolean useStdio = parsedArgs.isFlagSet("stdio");
            String hostname = null;
            int port = 0;
            if (!useStdio) {
                hostname = parsedArgs.getStringArgument("host");
                port = parsedArgs.getNumberArgument("port").intValue();
            }
            LangServ langserv = new LangServ(useStdio);
            langserv.log("Starting up Language Server: " + parsedArgs.getRawArguments(), LogLevel.INFO);
            try {
                OutputStream os;
                InputStream is;
                if (!useStdio) {
                    Socket socket = new Socket(hostname, port);
                    socket.setKeepAlive(true);
                    is = socket.getInputStream();
                    os = socket.getOutputStream();
                } else {
                    is = System.in;
                    os = System.out;
                }
                Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)langserv, (InputStream)is, (OutputStream)os);
                LanguageClient client = (LanguageClient)launcher.getRemoteProxy();
                langserv.connect(client);
                RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                List<String> arguments = runtimeMxBean.getInputArguments();
                langserv.log("Java started with args: " + arguments.toString(), LogLevel.DEBUG);
                langserv.log("Starting language server", LogLevel.INFO);
                if (useStdio) {
                    System.err.println("Started Language Server, awaiting connections");
                }
                launcher.startListening();
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                System.exit(1);
            }
        }

        @Override
        public boolean noExitOnReturn() {
            return true;
        }
    }
}

