/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.Annotations;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscoveryURLCache;
import com.laytonsmith.PureUtilities.Common.Annotations.AnnotationChecks;
import com.laytonsmith.PureUtilities.Common.Annotations.InterfaceRunnerFor;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.SimpleDocumentation;
import com.laytonsmith.core.functions.DummyFunction;
import com.laytonsmith.core.natives.interfaces.MixedInterfaceRunner;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class CacheAnnotations {
    public static void main(String[] args) throws Exception {
        File outputDir = new File(args[0]);
        File scanDir = new File(args[1]);
        if (outputDir.toString().startsWith("-classpath") || outputDir.toString().startsWith("-Xdebug")) {
            StreamUtils.GetSystemOut().println("Skipping annotation caching, running locally.");
            return;
        }
        StreamUtils.GetSystemOut().println("-- Caching annotations --");
        StreamUtils.GetSystemOut().println("Scanning for classes in " + scanDir.getAbsolutePath());
        StreamUtils.GetSystemOut().println("Outputting file to directory " + outputDir.getAbsolutePath());
        long start = System.currentTimeMillis();
        URL cacheFile = new URL("file:" + scanDir.getCanonicalPath());
        ClassDiscoveryURLCache cache = new ClassDiscoveryURLCache(cacheFile);
        cache.writeDescriptor(new FileOutputStream(new File(outputDir, "jarInfo.ser")));
        StreamUtils.GetSystemOut().println("Done writing jarInfo.ser, which took " + (System.currentTimeMillis() - start) + " ms.");
        ClassDiscovery.getDefaultInstance().addPreCache(cacheFile, cache);
        ClassDiscovery.getDefaultInstance().addDiscoveryLocation(cacheFile);
        StreamUtils.GetSystemOut().println("-- Checking for custom compile errors --");
        AnnotationChecks.checkForceImplementation();
        AnnotationChecks.checkForTypeInTypeofClasses();
        AnnotationChecks.verifyExhaustiveVisitors();
        AnnotationChecks.verifyNonInheritImplements();
        Implementation.setServerType(Implementation.Type.SHELL);
        ArrayList<String> uhohs = new ArrayList<String>();
        HashSet apiClasses = new HashSet();
        apiClasses.addAll(ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(api.class));
        apiClasses.addAll(ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(typeof.class));
        for (Class<?> c : apiClasses) {
            boolean isGetNameExempt = false;
            if (c.isInterface()) {
                for (Class<?> r : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(InterfaceRunnerFor.class)) {
                    InterfaceRunnerFor f = r.getAnnotation(InterfaceRunnerFor.class);
                    if (f.value() != c) continue;
                    isGetNameExempt = ClassDiscovery.GetClassAnnotation(c, typeof.class) != null;
                    c = r;
                    break;
                }
            }
            if (DummyFunction.class.isAssignableFrom(c)) continue;
            if (!SimpleDocumentation.class.isAssignableFrom(c) && !MixedInterfaceRunner.class.isAssignableFrom(c)) {
                uhohs.add(c.getName() + " must implement SimpleDocumentation");
                continue;
            }
            for (Method m : SimpleDocumentation.class.getDeclaredMethods()) {
                try {
                    c.getDeclaredMethod(m.getName(), m.getParameterTypes());
                }
                catch (NoSuchMethodException ex) {
                    if (m.getName().equals("getName") || ClassDiscovery.GetClassAnnotation(c, typeof.class) == null || isGetNameExempt) continue;
                    uhohs.add(c.getName() + " must implement " + m.getName() + "().");
                }
                catch (SecurityException ex) {
                    throw new Error(ex);
                }
            }
        }
        if (!uhohs.isEmpty()) {
            Collections.sort(uhohs);
            throw new Exception("There " + StringUtils.PluralHelper(uhohs.size(), "compile error") + ":\n" + StringUtils.Join(uhohs, "\n"));
        }
        StreamUtils.GetSystemOut().println("-- Finished with custom compiler checks --");
    }
}

