/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.FileWriteMode;
import com.laytonsmith.PureUtilities.Common.MutableObject;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.GCUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.mozilla.intl.chardet.nsDetector;

public final class FileUtil {
    public static final int OVERWRITE = 0;
    public static final int APPEND = 1;
    private static final Map<String, Object> FILE_LOCKS = new HashMap<String, Object>();
    private static final Map<String, Integer> FILE_LOCK_COUNTER = new HashMap<String, Integer>();

    private FileUtil() {
    }

    private static synchronized Object getLock(File file) throws IOException {
        String canonical = file.getAbsoluteFile().getCanonicalPath();
        if (!FILE_LOCKS.containsKey(canonical)) {
            FILE_LOCKS.put(canonical, new Object());
            FILE_LOCK_COUNTER.put(canonical, 0);
        }
        FILE_LOCK_COUNTER.put(canonical, FILE_LOCK_COUNTER.get(canonical) + 1);
        return FILE_LOCKS.get(canonical);
    }

    private static synchronized void freeLock(File file) throws IOException {
        String canonical = file.getAbsoluteFile().getCanonicalPath();
        FILE_LOCK_COUNTER.put(canonical, FILE_LOCK_COUNTER.get(canonical) - 1);
        if (FILE_LOCK_COUNTER.get(canonical) == 0) {
            FILE_LOCK_COUNTER.remove(canonical);
            FILE_LOCKS.remove(canonical);
        }
    }

    public static String read(File f) throws IOException {
        return FileUtils.readFileToString((File)f, (String)"UTF-8");
    }

    public static String read(FileChannel channel) throws IOException {
        return new String(FileUtil.readData(channel), "UTF-8");
    }

    public static String read(File file, String charset) throws IOException {
        return StreamUtils.GetString(FileUtil.readAsStream(file), charset);
    }

    public static byte[] readData(FileChannel channel) throws IOException {
        if (channel.size() > Integer.MAX_VALUE) {
            throw new IOException("File too large to read into memory. Use a stream reader.");
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
        channel.read(buffer);
        return buffer.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream readAsStream(File file) throws IOException {
        try {
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            return new ByteArrayInputStream(bytes);
        }
        catch (IOException ex) {
            if (ex.getMessage().startsWith("Unexpected readed size.")) {
                FileInputStream fis = new FileInputStream(file);
                try {
                    byte[] bytes = StreamUtils.GetBytes(fis);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                    return byteArrayInputStream;
                }
                finally {
                    fis.close();
                    fis = null;
                    GCUtil.BlockUntilGC();
                }
            }
            throw ex;
        }
    }

    public static void write(String data, File file, int mode2) throws IOException {
        FileUtil.write(data, file, mode2, false);
    }

    public static void write(String data, File file, int mode2, boolean create) throws IOException {
        FileUtil.write(data.getBytes("UTF-8"), file, mode2, create);
    }

    public static void write(String data, File file, FileWriteMode mode2, boolean create) throws IOException {
        FileUtil.write(data.getBytes("UTF-8"), file, mode2, create);
    }

    public static void write(byte[] data, File file, FileWriteMode mode2, boolean create) throws IOException {
        if (mode2 == FileWriteMode.SAFE_WRITE) {
            if (file.exists()) {
                throw new IOException("Cannot create file, SAFE_WRITE set, and file already exists [" + file + "]");
            }
            mode2 = FileWriteMode.OVERWRITE;
        }
        if (mode2 == FileWriteMode.OVERWRITE) {
            FileUtil.write(data, file, 0, create);
        } else if (mode2 == FileWriteMode.APPEND) {
            FileUtil.write(data, file, 1, create);
        } else {
            throw new Error("Unaccounted for FileWriteMode");
        }
    }

    public static void write(byte[] data, File file, int mode2, boolean create) throws IOException {
        boolean append;
        boolean bl = append = mode2 != 0;
        if (create && !file.exists()) {
            if (file.getAbsoluteFile().getParentFile() != null) {
                file.getAbsoluteFile().getParentFile().mkdirs();
            }
            file.getAbsoluteFile().createNewFile();
        }
        FileUtils.writeByteArrayToFile((File)file, (byte[])data, (boolean)append);
    }

    public static void write(FileChannel fileChannel, String data) throws IOException {
        try {
            FileUtil.write(fileChannel, data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static void write(FileChannel fileChannel, byte[] data) throws IOException {
        fileChannel.write(ByteBuffer.wrap(data));
    }

    public static void write(String s, File f) throws IOException {
        FileUtil.write(s, f, 0);
    }

    public static void write(String s, File f, boolean create) throws IOException {
        FileUtil.write(s, f, 0, create);
    }

    public static void copy(File fromFile, File toFile, Boolean overwrite) throws IOException {
        if (!fromFile.exists()) {
            throw new IOException("FileCopy: no such source file: " + fromFile.getName());
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + fromFile.getName());
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + fromFile.getName());
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        if (toFile.exists()) {
            if (!toFile.canWrite()) {
                throw new IOException("FileCopy: destination file is unwriteable: " + toFile.getName());
            }
            String response = null;
            if (overwrite == null) {
                StreamUtils.GetSystemOut().print("Overwrite existing file " + toFile.getName() + "? (Y/N): ");
                StreamUtils.GetSystemOut().flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                response = in.readLine();
            }
            if (overwrite != null && !overwrite.booleanValue() || response != null && !response.equals("Y") && !response.equals("y")) {
                throw new IOException("FileCopy: existing file was not overwritten.");
            }
        } else {
            File dir;
            String parent = toFile.getParent();
            if (parent == null) {
                parent = System.getProperty("user.dir");
            }
            if (!(dir = new File(parent)).exists()) {
                throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
            }
            if (dir.isFile()) {
                throw new IOException("FileCopy: destination is not a directory: " + parent);
            }
            if (!dir.canWrite()) {
                throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
            }
        }
        FileUtils.copyFile((File)fromFile, (File)toFile);
    }

    public static boolean move(File from, File to) throws IOException {
        FileUtils.moveFile((File)from, (File)to);
        return true;
    }

    public static boolean recursiveDelete(File file) {
        GCUtil.BlockUntilGC();
        if (file.isDirectory()) {
            boolean ret = true;
            for (File f : file.listFiles()) {
                if (FileUtil.recursiveDelete(f)) continue;
                ret = false;
            }
            if (!file.delete()) {
                ret = false;
            }
            return ret;
        }
        return file.delete();
    }

    public static void recursiveFind(File file, FileHandler handler) throws IOException {
        handler.handle(file);
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                FileUtil.recursiveFind(f, handler);
            }
        }
    }

    public static void recursiveDeleteOnExit(File file) {
        System.gc();
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                FileUtil.recursiveDelete(f);
            }
            file.deleteOnExit();
        } else {
            file.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharset(File file) throws IOException {
        int lang = 0;
        nsDetector det = new nsDetector(lang);
        MutableObject<String> result = new MutableObject<String>("ASCII");
        det.Init(charset -> result.setObject(charset));
        try (BufferedInputStream imp = null;){
            int len;
            imp = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[1024];
            boolean done = false;
            boolean isAscii = true;
            while ((len = imp.read(buf, 0, buf.length)) != -1) {
                if (isAscii) {
                    isAscii = det.isAscii(buf, len);
                }
                if (isAscii || done) continue;
                done = det.DoIt(buf, len, false);
            }
            det.DataEnd();
            String string = result.getObject();
            return string;
        }
    }

    public static interface FileHandler {
        public void handle(File var1) throws IOException;
    }
}

