/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.MSP;

import com.laytonsmith.PureUtilities.MSP.Connection;
import java.util.HashMap;
import java.util.Map;

public class CapabilityList {
    private final Map<Capability, CapabilityValue> caps = new HashMap<Capability, CapabilityValue>();
    private final Connection connection;

    public CapabilityList(Connection connection) {
        this.connection = connection;
    }

    public void clear() {
        this.caps.clear();
    }

    public void setCapability(Capability capability, CapabilityValue value) {
        if (!value.serverReturnable()) {
            throw new RuntimeException("An error occurred during runtime, the server returned an invalid capability: " + (Object)((Object)value));
        }
        this.caps.put(capability, value);
    }

    public CapabilityValue hasCapability(Capability capability) {
        CapabilityValue value = this.caps.get(capability);
        if (value == null) {
            this.setCapability(capability, this.connection.getCapability(capability));
            return this.hasCapability(capability);
        }
        if (value == CapabilityValue.DYNAMIC) {
            return this.connection.getCapability(capability);
        }
        return value;
    }

    public static enum CapabilityValue {
        ALWAYS_SUPPORTED(true),
        ALWAYS_UNSUPPORTED(true),
        SUPPORTED(true),
        UNSUPPORTED(true),
        DYNAMIC(true),
        UNKNOWN(false);

        private final boolean serverReturnable;

        private CapabilityValue(boolean serverReturnable) {
            this.serverReturnable = serverReturnable;
        }

        public boolean serverReturnable() {
            return this.serverReturnable;
        }
    }

    public static interface Capability {
        public String namespace();

        public String name();
    }
}

