/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCChunk;
import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCFireworkEffect;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.MCWorldBorder;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCBlockFace;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCChunk;
import com.laytonsmith.abstraction.bukkit.BukkitMCColor;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCMetadatable;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorldBorder;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCFallingBlock;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCFirework;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCHorse;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCItem;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLightningStrike;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLivingEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.entities.MCFallingBlock;
import com.laytonsmith.abstraction.entities.MCFirework;
import com.laytonsmith.abstraction.entities.MCHorse;
import com.laytonsmith.abstraction.entities.MCItem;
import com.laytonsmith.abstraction.entities.MCLightningStrike;
import com.laytonsmith.abstraction.enums.MCBiomeType;
import com.laytonsmith.abstraction.enums.MCCreeperType;
import com.laytonsmith.abstraction.enums.MCDifficulty;
import com.laytonsmith.abstraction.enums.MCDyeColor;
import com.laytonsmith.abstraction.enums.MCEffect;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCGameRule;
import com.laytonsmith.abstraction.enums.MCMobs;
import com.laytonsmith.abstraction.enums.MCOcelotType;
import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.abstraction.enums.MCPigType;
import com.laytonsmith.abstraction.enums.MCProfession;
import com.laytonsmith.abstraction.enums.MCSound;
import com.laytonsmith.abstraction.enums.MCSoundCategory;
import com.laytonsmith.abstraction.enums.MCTreeType;
import com.laytonsmith.abstraction.enums.MCWolfType;
import com.laytonsmith.abstraction.enums.MCWorldEnvironment;
import com.laytonsmith.abstraction.enums.MCWorldType;
import com.laytonsmith.abstraction.enums.MCZombieType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCBiomeType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCDifficulty;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCDyeColor;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEntityType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCOcelotType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCSound;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCSoundCategory;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCTreeType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCWorldEnvironment;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCWorldType;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Chunk;
import org.bukkit.Color;
import org.bukkit.Difficulty;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.metadata.Metadatable;
import org.bukkit.util.Consumer;

public class BukkitMCWorld
extends BukkitMCMetadatable
implements MCWorld {
    World w;

    public BukkitMCWorld(World w) {
        super((Metadatable)w);
        this.w = w;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MCWorld && this.w.equals(((BukkitMCWorld)o).w);
    }

    @Override
    public int hashCode() {
        return this.w.hashCode();
    }

    @Override
    public String toString() {
        return this.w.toString();
    }

    public BukkitMCWorld(AbstractionObject a) {
        this((World)null);
        if (!(a instanceof MCWorld)) {
            throw new ClassCastException();
        }
        this.w = (World)a.getHandle();
    }

    public World getHandle() {
        return this.w;
    }

    public World __World() {
        return this.w;
    }

    @Override
    public List<MCPlayer> getPlayers() {
        ArrayList<MCPlayer> list = new ArrayList<MCPlayer>();
        for (Player p2 : this.w.getPlayers()) {
            list.add(new BukkitMCPlayer((Entity)p2));
        }
        return list;
    }

    @Override
    public List<MCEntity> getEntities() {
        ArrayList<MCEntity> list = new ArrayList<MCEntity>();
        for (Entity e : this.w.getEntities()) {
            list.add(new BukkitMCEntity(e));
        }
        return list;
    }

    @Override
    public List<MCLivingEntity> getLivingEntities() {
        ArrayList<MCLivingEntity> list = new ArrayList<MCLivingEntity>();
        for (LivingEntity e : this.w.getLivingEntities()) {
            list.add(new BukkitMCLivingEntity((Entity)e));
        }
        return list;
    }

    @Override
    public String getName() {
        return this.w.getName();
    }

    @Override
    public long getSeed() {
        return this.w.getSeed();
    }

    @Override
    public MCDifficulty getDifficulty() {
        return (MCDifficulty)((Object)BukkitMCDifficulty.getConvertor().getAbstractedEnum(this.w.getDifficulty()));
    }

    @Override
    public void setDifficulty(MCDifficulty difficulty) {
        this.w.setDifficulty((Difficulty)BukkitMCDifficulty.getConvertor().getConcreteEnum(difficulty));
    }

    @Override
    public boolean getPVP() {
        return this.w.getPVP();
    }

    @Override
    public void setPVP(boolean pvp) {
        this.w.setPVP(pvp);
    }

    @Override
    public String[] getGameRules() {
        return this.w.getGameRules();
    }

    @Override
    public String getGameRuleValue(String gameRule) {
        return this.w.getGameRuleValue(gameRule);
    }

    @Override
    public boolean setGameRuleValue(MCGameRule gameRule, String value) {
        return this.w.setGameRuleValue(gameRule.getGameRule(), value);
    }

    @Override
    public MCWorldBorder getWorldBorder() {
        return new BukkitMCWorldBorder(this.w.getWorldBorder());
    }

    @Override
    public MCWorldEnvironment getEnvironment() {
        return (MCWorldEnvironment)((Object)BukkitMCWorldEnvironment.getConvertor().getAbstractedEnum(this.w.getEnvironment()));
    }

    @Override
    public String getGenerator() {
        try {
            return this.w.getGenerator().toString();
        }
        catch (NullPointerException npe2) {
            return "default";
        }
    }

    @Override
    public MCWorldType getWorldType() {
        return (MCWorldType)((Object)BukkitMCWorldType.getConvertor().getAbstractedEnum(this.w.getWorldType()));
    }

    @Override
    public int getSeaLevel() {
        return this.getHandle().getSeaLevel();
    }

    @Override
    public int getMaxHeight() {
        return this.getHandle().getMaxHeight();
    }

    @Override
    public MCBlock getBlockAt(int x, int y, int z) {
        return new BukkitMCBlock(this.w.getBlockAt(x, y, z));
    }

    @Override
    public MCEntity spawn(MCLocation l, Class mobType) {
        return BukkitConvertor.BukkitGetCorrectEntity(this.w.spawn(((BukkitMCLocation)l).l, mobType));
    }

    @Override
    public MCEntity spawn(MCLocation l, MCEntityType entType) {
        return BukkitConvertor.BukkitGetCorrectEntity(this.w.spawnEntity(((BukkitMCLocation)l).asLocation(), (EntityType)((BukkitMCEntityType)entType).getConcrete()));
    }

    @Override
    public MCEntity spawn(MCLocation l, MCEntityType entType, CClosure closure2) {
        EntityType type = (EntityType)entType.getConcrete();
        Consumer consumer = entity -> {
            MCEntity temp = BukkitConvertor.BukkitGetCorrectEntity(entity);
            Static.InjectEntity(temp);
            try {
                closure2.executeCallable(null, Target.UNKNOWN, new CString(entity.getUniqueId().toString(), Target.UNKNOWN));
            }
            finally {
                Static.UninjectEntity(temp);
            }
        };
        Entity ent = this.spawn((Location)l.getHandle(), type.getEntityClass(), (Consumer<? extends Entity>)consumer);
        return BukkitConvertor.BukkitGetCorrectEntity(ent);
    }

    private <T extends Entity> Entity spawn(Location location, Class<T> clazz, Consumer<? extends Entity> consumer) {
        return this.w.spawn(location, clazz, consumer);
    }

    @Override
    public MCEntity spawn(MCLocation l, MCEntityType.MCVanillaEntityType entityType) {
        return BukkitConvertor.BukkitGetCorrectEntity(this.w.spawnEntity(((BukkitMCLocation)l).asLocation(), (EntityType)MCEntityType.valueOfVanillaType(entityType).getConcrete()));
    }

    @Override
    public boolean generateTree(MCLocation l, MCTreeType treeType) {
        return this.w.generateTree(((BukkitMCLocation)l).asLocation(), (TreeType)BukkitMCTreeType.getConvertor().getConcreteEnum(treeType));
    }

    @Override
    public void playEffect(MCLocation l, MCEffect mCEffect, int data, int radius) {
        this.w.playEffect(((BukkitMCLocation)l).l, Effect.valueOf((String)mCEffect.name()), data, radius);
    }

    @Override
    public void playEffect(MCLocation l, MCEffect mcEffect, Object data, int radius) {
        Effect effect = Effect.valueOf((String)mcEffect.name());
        switch (effect) {
            case RECORD_PLAY: 
            case STEP_SOUND: {
                this.w.playEffect((Location)l.getHandle(), effect, ((MCMaterial)data).getHandle(), radius);
                return;
            }
            case SMOKE: {
                this.w.playEffect((Location)l.getHandle(), effect, (Object)BlockFace.valueOf((String)((MCBlockFace)((Object)data)).name()), radius);
                return;
            }
        }
        this.w.playEffect((Location)l.getHandle(), effect, data, radius);
    }

    @Override
    public void spawnParticle(MCLocation l, MCParticle pa, int count, double offsetX, double offsetY, double offsetZ, double velocity, Object data) {
        Particle type = (Particle)pa.getConcrete();
        Location loc = (Location)l.getHandle();
        switch (type) {
            case BLOCK_DUST: 
            case BLOCK_CRACK: 
            case FALLING_DUST: {
                BlockData bd = data instanceof MCBlockData ? (BlockData)((MCBlockData)data).getHandle() : Material.STONE.createBlockData();
                this.w.spawnParticle(type, loc, count, offsetX, offsetY, offsetZ, velocity, (Object)bd);
                return;
            }
            case ITEM_CRACK: {
                ItemStack is = data instanceof MCItemStack ? (ItemStack)((MCItemStack)data).getHandle() : new ItemStack(Material.STONE, 1);
                this.w.spawnParticle(type, loc, count, offsetX, offsetY, offsetZ, velocity, (Object)is);
                return;
            }
            case REDSTONE: {
                Particle.DustOptions color2 = data instanceof MCColor ? new Particle.DustOptions(BukkitMCColor.GetColor((MCColor)data), 1.0f) : new Particle.DustOptions(Color.RED, 1.0f);
                this.w.spawnParticle(type, loc, count, offsetX, offsetY, offsetZ, velocity, (Object)color2);
                return;
            }
        }
        this.w.spawnParticle(type, loc, count, offsetX, offsetY, offsetZ, velocity);
    }

    @Override
    public void playSound(MCLocation l, MCSound sound, float volume, float pitch) {
        this.w.playSound(((BukkitMCLocation)l).asLocation(), (Sound)((BukkitMCSound)sound).getConcrete(), volume, pitch);
    }

    @Override
    public void playSound(MCLocation l, String sound, float volume, float pitch) {
        this.w.playSound((Location)l.getHandle(), sound, volume, pitch);
    }

    @Override
    public void playSound(MCLocation l, MCSound sound, MCSoundCategory category, float volume, float pitch) {
        this.w.playSound((Location)l.getHandle(), (Sound)((BukkitMCSound)sound).getConcrete(), (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category), volume, pitch);
    }

    @Override
    public void playSound(MCLocation l, String sound, MCSoundCategory category, float volume, float pitch) {
        this.w.playSound((Location)l.getHandle(), sound, (SoundCategory)BukkitMCSoundCategory.getConvertor().getConcreteEnum(category), volume, pitch);
    }

    @Override
    public MCItem dropItemNaturally(MCLocation l, MCItemStack is) {
        return new BukkitMCItem((Entity)this.w.dropItemNaturally(((BukkitMCLocation)l).l, ((BukkitMCItemStack)is).is));
    }

    @Override
    public MCItem dropItem(MCLocation l, MCItemStack is) {
        return new BukkitMCItem((Entity)this.w.dropItem(((BukkitMCLocation)l).l, ((BukkitMCItemStack)is).is));
    }

    @Override
    public MCLightningStrike strikeLightning(MCLocation location) {
        return new BukkitMCLightningStrike((Entity)this.w.strikeLightning(((BukkitMCLocation)location).l));
    }

    @Override
    public MCLightningStrike strikeLightningEffect(MCLocation location) {
        return new BukkitMCLightningStrike((Entity)this.w.strikeLightningEffect(((BukkitMCLocation)location).l));
    }

    @Override
    public void setStorm(boolean b) {
        this.w.setStorm(b);
    }

    @Override
    public MCLocation getSpawnLocation() {
        return new BukkitMCLocation(this.w.getSpawnLocation());
    }

    @Override
    public void refreshChunk(int x, int z) {
        this.w.refreshChunk(x, z);
    }

    @Override
    public void loadChunk(int x, int z) {
        this.w.loadChunk(x, z);
    }

    @Override
    public void unloadChunk(int x, int z) {
        this.w.unloadChunk(x, z);
    }

    @Override
    public void setTime(long time2) {
        this.w.setTime(time2);
    }

    @Override
    public long getTime() {
        return this.w.getTime();
    }

    @Override
    public MCBiomeType getBiome(int x, int z) {
        return BukkitMCBiomeType.valueOfConcrete(this.w.getBiome(x, z));
    }

    @Override
    public void setBiome(int x, int z, MCBiomeType type) {
        this.w.setBiome(x, z, (Biome)((BukkitMCBiomeType)type).getConcrete());
    }

    @Override
    public MCBlock getHighestBlockAt(int x, int z) {
        Block b = this.w.getBlockAt(x, this.w.getMaxHeight() - 1, z);
        while (b.getType() == Material.AIR && b.getY() > 0) {
            b = b.getRelative(BlockFace.DOWN);
        }
        return new BukkitMCBlock(b);
    }

    @Override
    public void explosion(double x, double y, double z, float size, boolean safe) {
        this.w.createExplosion(x, y, z, size, !safe, !safe);
    }

    @Override
    public void setSpawnLocation(int x, int y, int z) {
        this.w.setSpawnLocation(x, y, z);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CArray spawnMob(MCMobs name, String subClass, int qty, MCLocation l, Target t) {
        int n;
        String[] stringArray;
        Class<Bat> mobType = null;
        CArray ids = new CArray(t);
        Location location = (Location)l.getHandle();
        String[] subTypes = subClass.toUpperCase().split("-");
        try {
            switch (name) {
                case BAT: {
                    mobType = Bat.class;
                    break;
                }
                case BEE: {
                    mobType = Bee.class;
                    break;
                }
                case BLAZE: {
                    mobType = Blaze.class;
                    break;
                }
                case CAVESPIDER: {
                    mobType = CaveSpider.class;
                    break;
                }
                case CHICKEN: {
                    mobType = Chicken.class;
                    break;
                }
                case COW: {
                    mobType = Cow.class;
                    break;
                }
                case CREEPER: {
                    mobType = Creeper.class;
                    break;
                }
                case DONKEY: {
                    mobType = Donkey.class;
                    break;
                }
                case ELDERGUARDIAN: {
                    mobType = ElderGuardian.class;
                    break;
                }
                case ENDERDRAGON: {
                    mobType = EnderDragon.class;
                    break;
                }
                case ENDERMAN: {
                    mobType = Enderman.class;
                    break;
                }
                case ENDERMITE: {
                    mobType = Endermite.class;
                    break;
                }
                case EVOKER: {
                    mobType = Evoker.class;
                    break;
                }
                case GHAST: {
                    mobType = Ghast.class;
                    break;
                }
                case GUARDIAN: {
                    mobType = Guardian.class;
                    break;
                }
                case GIANT: {
                    mobType = Giant.class;
                    break;
                }
                case HORSE: {
                    mobType = Horse.class;
                    if (!subClass.isEmpty()) {
                        String[] stringArray2;
                        int n2 = 0;
                        String[] stringArray3 = subTypes;
                        int n3 = stringArray3.length;
                        if (n2 >= n3) break;
                        stringArray = stringArray2 = stringArray3[n2];
                        n = -1;
                        switch (stringArray.hashCode()) {
                            case 2022138428: {
                                if (!stringArray.equals("DONKEY")) break;
                                n = 0;
                                break;
                            }
                            case 2378017: {
                                if (!stringArray.equals("MULE")) break;
                                n = 1;
                                break;
                            }
                            case -1484593075: {
                                if (!stringArray.equals("SKELETON")) break;
                                n = 2;
                                break;
                            }
                            case -1643025882: {
                                if (!stringArray.equals("ZOMBIE")) break;
                                n = 3;
                                break;
                            }
                        }
                        switch (n) {
                            case 0: {
                                mobType = Donkey.class;
                                break;
                            }
                            case 1: {
                                mobType = Mule.class;
                                break;
                            }
                            case 2: {
                                mobType = SkeletonHorse.class;
                                break;
                            }
                            case 3: {
                                mobType = ZombieHorse.class;
                                break;
                            }
                        }
                        subClass = "";
                    }
                    break;
                }
                case HUSK: {
                    mobType = Husk.class;
                    break;
                }
                case ILLUSIONER: {
                    mobType = Illusioner.class;
                    break;
                }
                case IRONGOLEM: {
                    mobType = IronGolem.class;
                    break;
                }
                case LLAMA: {
                    mobType = Llama.class;
                    break;
                }
                case MAGMACUBE: {
                    mobType = MagmaCube.class;
                    break;
                }
                case MOOSHROOM: 
                case MUSHROOMCOW: {
                    mobType = MushroomCow.class;
                    break;
                }
                case MULE: {
                    mobType = Mule.class;
                    break;
                }
                case OCELOT: {
                    mobType = Ocelot.class;
                    break;
                }
                case PARROT: {
                    mobType = Parrot.class;
                    break;
                }
                case PIG: {
                    mobType = Pig.class;
                    break;
                }
                case PIGZOMBIE: {
                    mobType = PigZombie.class;
                    break;
                }
                case POLARBEAR: {
                    mobType = PolarBear.class;
                    break;
                }
                case RABBIT: {
                    mobType = Rabbit.class;
                    break;
                }
                case SHEEP: {
                    mobType = Sheep.class;
                    break;
                }
                case SHULKER: {
                    mobType = Shulker.class;
                    break;
                }
                case SILVERFISH: {
                    mobType = Silverfish.class;
                    break;
                }
                case SKELETON: {
                    mobType = Skeleton.class;
                    if (!subClass.isEmpty()) {
                        String type = subTypes[subTypes.length - 1];
                        if (type.equals("WITHER")) {
                            mobType = WitherSkeleton.class;
                        } else if (type.equals("STRAY")) {
                            mobType = Stray.class;
                        }
                        subClass = "";
                    }
                    break;
                }
                case SKELETONHORSE: {
                    mobType = SkeletonHorse.class;
                    break;
                }
                case SLIME: {
                    mobType = Slime.class;
                    break;
                }
                case SNOWGOLEM: 
                case SNOWMAN: {
                    mobType = Snowman.class;
                    break;
                }
                case SPIDER: {
                    mobType = Spider.class;
                    break;
                }
                case SPIDERJOCKEY: {
                    mobType = Spider.class;
                    break;
                }
                case SQUID: {
                    mobType = Squid.class;
                    break;
                }
                case STRAY: {
                    mobType = Stray.class;
                    break;
                }
                case WITCH: {
                    mobType = Witch.class;
                    break;
                }
                case WITHER: {
                    mobType = Wither.class;
                    break;
                }
                case WITHERSKELETON: {
                    mobType = WitherSkeleton.class;
                    break;
                }
                case WOLF: {
                    mobType = Wolf.class;
                    break;
                }
                case VEX: {
                    mobType = Vex.class;
                    break;
                }
                case VILLAGER: {
                    mobType = Villager.class;
                    break;
                }
                case VINDICATOR: {
                    mobType = Vindicator.class;
                    break;
                }
                case ZOMBIE: {
                    mobType = Zombie.class;
                    if (!subClass.isEmpty()) {
                        block123: for (int i = 0; i < subTypes.length; ++i) {
                            switch (subTypes[i]) {
                                case "HUSK": {
                                    mobType = Husk.class;
                                    continue block123;
                                }
                                case "BABY": {
                                    continue block123;
                                }
                                case "VILLAGER_BLACKSMITH": {
                                    subTypes[i] = "BLACKSMITH";
                                    break;
                                }
                                case "VILLAGER_BUTCHER": {
                                    subTypes[i] = "BUTCHER";
                                    break;
                                }
                                case "VILLAGER_LIBRARIAN": {
                                    subTypes[i] = "LIBRARIAN";
                                    break;
                                }
                                case "VILLAGER_PRIEST": {
                                    subTypes[i] = "PRIEST";
                                    break;
                                }
                                case "VILLAGER": {
                                    subTypes[i] = "FARMER";
                                }
                            }
                            mobType = ZombieVillager.class;
                        }
                    }
                    break;
                }
                case ZOMBIEHORSE: {
                    mobType = ZombieHorse.class;
                    break;
                }
                case ZOMBIEVILLAGER: {
                    mobType = ZombieVillager.class;
                    break;
                }
            }
        }
        catch (NoClassDefFoundError e) {
            throw new CREFormatException("No mob of type " + (Object)((Object)name) + " exists", t);
        }
        int i = 0;
        while (true) {
            Entity e;
            block149: {
                int n4;
                String[] stringArray4;
                Horse h;
                block171: {
                    int n5;
                    String[] stringArray5;
                    Pig p2;
                    block170: {
                        int n6;
                        String[] stringArray6;
                        Zombie z;
                        block168: {
                            int n7;
                            String[] stringArray7;
                            ZombieVillager zv;
                            block167: {
                                int n8;
                                String[] stringArray8;
                                PigZombie pz;
                                block165: {
                                    int n9;
                                    String[] stringArray9;
                                    Slime sl;
                                    block162: {
                                        String type;
                                        Villager v;
                                        block159: {
                                            int n10;
                                            String[] stringArray10;
                                            Wolf w;
                                            block157: {
                                                int n11;
                                                String[] stringArray11;
                                                Creeper c;
                                                block155: {
                                                    int n12;
                                                    Ocelot o;
                                                    block153: {
                                                        Sheep s;
                                                        block151: {
                                                            block169: {
                                                                block163: {
                                                                    block166: {
                                                                        block164: {
                                                                            block161: {
                                                                                block160: {
                                                                                    block158: {
                                                                                        block156: {
                                                                                            block154: {
                                                                                                block152: {
                                                                                                    block150: {
                                                                                                        if (i >= qty) {
                                                                                                            return ids;
                                                                                                        }
                                                                                                        e = this.w.spawn(location, mobType);
                                                                                                        if (name == MCMobs.SPIDERJOCKEY) {
                                                                                                            e.addPassenger(this.w.spawn(location, Skeleton.class));
                                                                                                        }
                                                                                                        if (subClass.isEmpty()) break block149;
                                                                                                        if (!(e instanceof Sheep)) break block150;
                                                                                                        s = (Sheep)e;
                                                                                                        stringArray = subTypes;
                                                                                                        n = stringArray.length;
                                                                                                        break block151;
                                                                                                    }
                                                                                                    if (!(e instanceof Ocelot)) break block152;
                                                                                                    o = (Ocelot)e;
                                                                                                    stringArray = subTypes;
                                                                                                    n = stringArray.length;
                                                                                                    break block153;
                                                                                                }
                                                                                                if (!(e instanceof Creeper)) break block154;
                                                                                                c = (Creeper)e;
                                                                                                stringArray11 = subTypes;
                                                                                                n11 = stringArray11.length;
                                                                                                break block155;
                                                                                            }
                                                                                            if (!(e instanceof Wolf)) break block156;
                                                                                            w = (Wolf)e;
                                                                                            stringArray10 = subTypes;
                                                                                            n10 = stringArray10.length;
                                                                                            break block157;
                                                                                        }
                                                                                        if (!(e instanceof Villager)) break block158;
                                                                                        v = (Villager)e;
                                                                                        stringArray = subTypes;
                                                                                        n = stringArray.length;
                                                                                        break block159;
                                                                                    }
                                                                                    if (!(e instanceof Enderman)) break block160;
                                                                                    Enderman en = (Enderman)e;
                                                                                    String[] stringArray12 = subTypes;
                                                                                    int n13 = stringArray12.length;
                                                                                    for (n = 0; n < n13; ++n) {
                                                                                        String type2 = stringArray12[n];
                                                                                        Material mat = Material.getMaterial((String)type2);
                                                                                        if (mat == null) {
                                                                                            throw new CREFormatException(type2 + " is not a valid material", t);
                                                                                        }
                                                                                        en.setCarriedBlock(mat.createBlockData());
                                                                                    }
                                                                                    break block149;
                                                                                }
                                                                                if (!(e instanceof Slime)) break block161;
                                                                                sl = (Slime)e;
                                                                                stringArray9 = subTypes;
                                                                                n9 = stringArray9.length;
                                                                                break block162;
                                                                            }
                                                                            if (!(e instanceof Zombie)) break block163;
                                                                            if (!(e instanceof PigZombie)) break block164;
                                                                            pz = (PigZombie)e;
                                                                            stringArray8 = subTypes;
                                                                            n8 = stringArray8.length;
                                                                            break block165;
                                                                        }
                                                                        if (!(e instanceof ZombieVillager)) break block166;
                                                                        zv = (ZombieVillager)e;
                                                                        stringArray7 = subTypes;
                                                                        n7 = stringArray7.length;
                                                                        break block167;
                                                                    }
                                                                    z = (Zombie)e;
                                                                    stringArray6 = subTypes;
                                                                    n6 = stringArray6.length;
                                                                    break block168;
                                                                }
                                                                if (!(e instanceof Pig)) break block169;
                                                                p2 = (Pig)e;
                                                                stringArray5 = subTypes;
                                                                n5 = stringArray5.length;
                                                                break block170;
                                                            }
                                                            if (!(e instanceof Horse)) break block149;
                                                            h = (Horse)e;
                                                            stringArray4 = subTypes;
                                                            n4 = stringArray4.length;
                                                            break block171;
                                                        }
                                                        for (n12 = 0; n12 < n; ++n12) {
                                                            type = stringArray[n12];
                                                            try {
                                                                MCDyeColor mCDyeColor = MCDyeColor.valueOf(type);
                                                                s.setColor((DyeColor)BukkitMCDyeColor.getConvertor().getConcreteEnum(mCDyeColor));
                                                                continue;
                                                            }
                                                            catch (IllegalArgumentException ex) {
                                                                throw new CREFormatException(type + " is not a valid color", t);
                                                            }
                                                        }
                                                        break block149;
                                                    }
                                                    for (n12 = 0; n12 < n; ++n12) {
                                                        type = stringArray[n12];
                                                        try {
                                                            MCOcelotType mCOcelotType = MCOcelotType.valueOf(type);
                                                            o.setCatType((Ocelot.Type)BukkitMCOcelotType.getConvertor().getConcreteEnum(mCOcelotType));
                                                            continue;
                                                        }
                                                        catch (IllegalArgumentException ex) {
                                                            throw new CREFormatException(type + " is not an ocelot type", t);
                                                        }
                                                        catch (UnsupportedOperationException ex) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    break block149;
                                                }
                                                for (n = 0; n < n11; ++n) {
                                                    String type3 = stringArray11[n];
                                                    try {
                                                        MCCreeperType ctype = MCCreeperType.valueOf(type3);
                                                        switch (ctype) {
                                                            case POWERED: {
                                                                c.setPowered(true);
                                                                break;
                                                            }
                                                        }
                                                        continue;
                                                    }
                                                    catch (IllegalArgumentException ex) {
                                                        throw new CREFormatException(type3 + " is not a creeper state", t);
                                                    }
                                                }
                                                break block149;
                                            }
                                            for (n = 0; n < n10; ++n) {
                                                String type4 = stringArray10[n];
                                                try {
                                                    MCWolfType wtype = MCWolfType.valueOf(type4);
                                                    switch (wtype) {
                                                        case ANGRY: {
                                                            w.setAngry(true);
                                                            break;
                                                        }
                                                        case TAMED: {
                                                            w.setTamed(true);
                                                            break;
                                                        }
                                                    }
                                                    continue;
                                                }
                                                catch (IllegalArgumentException ex) {
                                                    throw new CREFormatException(type4 + " is not a wolf state", t);
                                                }
                                            }
                                            break block149;
                                        }
                                        for (int type4 = 0; type4 < n; ++type4) {
                                            type = stringArray[type4];
                                            try {
                                                MCProfession mCProfession = MCProfession.valueOf(type);
                                                v.setProfession((Villager.Profession)mCProfession.getConcrete());
                                                continue;
                                            }
                                            catch (IllegalArgumentException ex) {
                                                throw new CREFormatException(type + " is not a valid profession", t);
                                            }
                                        }
                                        break block149;
                                    }
                                    for (n = 0; n < n9; ++n) {
                                        String type = stringArray9[n];
                                        if ("".equals(type)) continue;
                                        try {
                                            sl.setSize(Integer.parseInt(type));
                                            continue;
                                        }
                                        catch (IllegalArgumentException ex) {
                                            throw new CREFormatException(type + " is not a valid size", t);
                                        }
                                    }
                                    break block149;
                                }
                                for (n = 0; n < n8; ++n) {
                                    String value = stringArray8[n];
                                    if (value.equals("BABY")) {
                                        pz.setBaby(true);
                                        continue;
                                    }
                                    try {
                                        pz.setAnger(Integer.valueOf(value).intValue());
                                        continue;
                                    }
                                    catch (IllegalArgumentException iae) {
                                        throw new CREFormatException(value + " is not a number.", t);
                                    }
                                }
                                break block149;
                            }
                            for (n = 0; n < n7; ++n) {
                                String type = stringArray7[n];
                                if (type.equals("BABY")) {
                                    zv.setBaby(true);
                                    continue;
                                }
                                try {
                                    MCProfession job = MCProfession.valueOf(type);
                                    zv.setVillagerProfession((Villager.Profession)job.getConcrete());
                                    continue;
                                }
                                catch (IllegalArgumentException ex) {
                                    throw new CREFormatException(type + " is not a valid profession", t);
                                }
                            }
                            break block149;
                        }
                        for (n = 0; n < n6; ++n) {
                            String type = stringArray6[n];
                            try {
                                MCZombieType ztype = MCZombieType.valueOf(type);
                                switch (ztype) {
                                    case BABY: {
                                        z.setBaby(true);
                                        break;
                                    }
                                }
                                continue;
                            }
                            catch (IllegalArgumentException ex) {
                                throw new CREFormatException(type + " is not a zombie state", t);
                            }
                        }
                        break block149;
                    }
                    for (n = 0; n < n5; ++n) {
                        String type = stringArray5[n];
                        try {
                            MCPigType ptype = MCPigType.valueOf(type);
                            switch (ptype) {
                                case SADDLED: {
                                    p2.setSaddle(true);
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (IllegalArgumentException ex) {
                            throw new CREFormatException(type + " is not a pig state", t);
                        }
                    }
                    break block149;
                }
                for (n = 0; n < n4; ++n) {
                    String type = stringArray4[n];
                    try {
                        MCHorse.MCHorseColor hcolor = MCHorse.MCHorseColor.valueOf(type);
                        h.setColor((Horse.Color)BukkitMCHorse.BukkitMCHorseColor.getConvertor().getConcreteEnum(hcolor));
                        continue;
                    }
                    catch (IllegalArgumentException hcolor) {
                        try {
                            MCHorse.MCHorsePattern hpattern = MCHorse.MCHorsePattern.valueOf(type);
                            h.setStyle((Horse.Style)BukkitMCHorse.BukkitMCHorsePattern.getConvertor().getConcreteEnum(hpattern));
                            continue;
                        }
                        catch (IllegalArgumentException notAnything) {
                            throw new CREFormatException("Type " + type + " did not match any horse variants, colors, or patterns.", t);
                        }
                    }
                }
            }
            ids.push(new CString(e.getUniqueId().toString(), t), t);
            ++i;
        }
    }

    @Override
    public boolean exists() {
        try {
            this.w.getName();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public MCFallingBlock spawnFallingBlock(MCLocation loc, MCBlockData data) {
        return new BukkitMCFallingBlock((Entity)this.w.spawnFallingBlock((Location)loc.getHandle(), (BlockData)data.getHandle()));
    }

    @Override
    public MCFirework launchFirework(MCLocation l, int strength, List<MCFireworkEffect> effects) {
        Firework firework = (Firework)this.w.spawnEntity(((BukkitMCLocation)l).asLocation(), EntityType.FIREWORK);
        FireworkMeta meta = firework.getFireworkMeta();
        meta.setPower(strength);
        for (MCFireworkEffect effect : effects) {
            meta.addEffect((FireworkEffect)effect.getHandle());
        }
        firework.setFireworkMeta(meta);
        return new BukkitMCFirework((Entity)firework);
    }

    @Override
    public boolean regenerateChunk(int x, int z) {
        return this.w.regenerateChunk(x, z);
    }

    @Override
    public MCChunk getChunkAt(int x, int z) {
        return new BukkitMCChunk(this.w.getChunkAt(x, z));
    }

    @Override
    public MCChunk getChunkAt(MCBlock b) {
        return new BukkitMCChunk(this.w.getChunkAt(((BukkitMCBlock)b).__Block()));
    }

    @Override
    public MCChunk getChunkAt(MCLocation l) {
        return new BukkitMCChunk(this.w.getChunkAt(((BukkitMCLocation)l).asLocation()));
    }

    @Override
    public MCChunk[] getLoadedChunks() {
        Chunk[] chunks = this.w.getLoadedChunks();
        MCChunk[] mcChunks = new MCChunk[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            mcChunks[i] = new BukkitMCChunk(chunks[i]);
        }
        return mcChunks;
    }

    @Override
    public boolean isChunkLoaded(int x, int z) {
        return this.w.isChunkLoaded(x, z);
    }

    @Override
    public void setThundering(boolean b) {
        this.w.setThundering(b);
    }

    @Override
    public void setWeatherDuration(int time2) {
        this.w.setWeatherDuration(time2);
    }

    @Override
    public void setThunderDuration(int time2) {
        this.w.setThunderDuration(time2);
    }

    @Override
    public boolean isStorming() {
        return this.w.hasStorm();
    }

    @Override
    public boolean isThundering() {
        return this.w.isThundering();
    }

    @Override
    public void save() {
        this.w.save();
    }

    @Override
    public void setKeepSpawnInMemory(boolean keepLoaded) {
        this.w.setKeepSpawnInMemory(keepLoaded);
    }
}

