/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCInventory;
import com.laytonsmith.abstraction.MCMerchant;
import com.laytonsmith.abstraction.bukkit.BukkitMCInventory;
import com.laytonsmith.abstraction.bukkit.BukkitMCMerchant;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCTrader;
import com.laytonsmith.abstraction.entities.MCVillager;
import com.laytonsmith.abstraction.enums.MCProfession;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCProfession;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.Merchant;

public class BukkitMCVillager
extends BukkitMCTrader
implements MCVillager {
    public BukkitMCVillager(Entity villager) {
        super(villager);
    }

    public BukkitMCVillager(AbstractionObject ao) {
        this((Entity)((Villager)ao.getHandle()));
    }

    public Villager getHandle() {
        return (Villager)super.getHandle();
    }

    @Override
    public MCProfession getProfession() {
        return BukkitMCProfession.valueOfConcrete(this.getHandle().getProfession());
    }

    @Override
    public void setProfession(MCProfession profession) {
        this.getHandle().setProfession((Villager.Profession)profession.getConcrete());
    }

    @Override
    public int getLevel() {
        try {
            return this.getHandle().getVillagerLevel();
        }
        catch (NoSuchMethodError ex) {
            return 1;
        }
    }

    @Override
    public void setLevel(int level) {
        try {
            this.getHandle().setVillagerLevel(level);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public int getExperience() {
        try {
            return this.getHandle().getVillagerExperience();
        }
        catch (NoSuchMethodError ex) {
            return 0;
        }
    }

    @Override
    public void setExperience(int exp) {
        try {
            this.getHandle().setVillagerExperience(exp);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public MCMerchant asMerchant() {
        Villager villager = this.getHandle();
        String title2 = villager.getCustomName() == null ? this.getHandle().getProfession().name() : villager.getCustomName();
        return new BukkitMCMerchant((Merchant)villager, title2);
    }

    @Override
    public MCInventory getInventory() {
        return new BukkitMCInventory(this.getHandle().getInventory());
    }
}

