/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Preferences;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class MSLog {
    private static final String HEADER = "The logger preferences allow you to granularly define what information\nis written out to file, to assist you in debugging or general logging.\nYou may set the granularity of all the tags individually, to any one of\nthe following values:\nOFF - Turns off all logging for this module.\nON - Synonym for ERRORS\n\nERROR - Logs errors, or other high importance messages.\nWARNING - Logs warnings and above.\nINFO - Logs informational notices, and above.\nDEBUG - Logs useful debugging information, and above.\nVERBOSE - Logs every little detail.\n\n\nIn many cases, components will only use the ERROR level, therefore, ON is a synonym.\nHowever, in some cases, a component may give you more information if you set it lower.";
    private static Preferences prefs;
    private static final Map<Tag, LogLevel> LOOKUP;
    private static final Set<Tag> KNOWN_TAGS;
    private static File root;
    private static MSLog instance;

    private MSLog() {
    }

    public static MSLog GetLogger() {
        if (root == null) {
            throw new RuntimeException("Logger is not initialized! Call " + MSLog.class.getSimpleName() + ".initialize before using the logger.");
        }
        if (instance == null) {
            instance = new MSLog();
        }
        return instance;
    }

    public static void initialize(File root) {
        MSLog.root = root;
        ArrayList<Preferences.Preference> myPrefs = new ArrayList<Preferences.Preference>();
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (Field f : ClassDiscovery.getDefaultInstance().loadFieldsWithAnnotation(LogTag.class)) {
            try {
                Object o = f.get(null);
                if (o instanceof Tag) {
                    tags.add((Tag)o);
                    continue;
                }
                System.err.println("Element tagged with LogTag, but is not an instance of Tag: " + f.getDeclaringClass() + "." + f.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                System.err.println("Could not properly configure logger tag: " + ex.getMessage());
            }
        }
        for (Tag t : tags) {
            myPrefs.add(new Preferences.Preference(t.getName(), t.getLevel().name(), Preferences.Type.STRING, t.getDescription()));
        }
        KNOWN_TAGS.addAll(tags);
        prefs = new Preferences("CommandHelper", Static.getLogger(), myPrefs, HEADER);
        try {
            prefs.init(MethodScriptFileLocations.getDefault().getLoggerPreferencesFile());
        }
        catch (IOException e) {
            Static.getLogger().log(Level.SEVERE, "Could not create logger preferences", e);
        }
    }

    private static LogLevel GetLevel(Tag tag) {
        LogLevel level;
        if (!KNOWN_TAGS.contains(tag)) {
            String message = "Logging tag that was not properly configured: " + tag.getName() + ". Tags must be registered with the @LogTag annotation, otherwise they are not configurable by the user!";
            System.err.println(message);
            MSLog.GetLogger().e((Tag)Tags.GENERAL, message, Target.UNKNOWN);
        }
        if (LOOKUP.containsKey(tag)) {
            return LOOKUP.get(tag);
        }
        try {
            String pref = prefs.getStringPreference(tag.getName());
            level = "ON".equals(pref) ? LogLevel.ERROR : LogLevel.valueOf(pref);
        }
        catch (IllegalArgumentException e) {
            level = LogLevel.ERROR;
        }
        LOOKUP.put(tag, level);
        return level;
    }

    public boolean WillLog(Tag tag, LogLevel l) {
        LogLevel level = MSLog.GetLevel(tag);
        if (level == LogLevel.OFF) {
            return false;
        }
        return l.getLevel() <= level.getLevel();
    }

    public void LogOne(Tag tag, Target t, MsgBundle ... messages) {
        LogLevel[] levels;
        if (MSLog.GetLevel(tag) == LogLevel.OFF) {
            return;
        }
        LogLevel tagLevel = MSLog.GetLevel(tag);
        for (LogLevel l : levels = new LogLevel[]{LogLevel.VERBOSE, LogLevel.DEBUG, LogLevel.INFO, LogLevel.WARNING, LogLevel.ERROR}) {
            for (MsgBundle b : messages) {
                if (b.level != l || b.level != tagLevel) continue;
                this.Log(tag, l, HEADER, t);
                return;
            }
        }
    }

    public void LogAll(Tag tag, Target t, MsgBundle ... messages) {
        if (MSLog.GetLevel(tag) == LogLevel.OFF) {
            return;
        }
        for (MsgBundle b : messages) {
            this.Log(tag, b.level, b.message, t);
        }
    }

    public void Log(Tag module, String message, Target t) {
        this.Log(module, LogLevel.ERROR, message, t);
    }

    public void Log(Tag modules, LogLevel level, String message, Target t) {
        this.Log(modules, level, message, t, true);
    }

    public void Log(Tag modules, LogLevel level, StringProvider message, Target t) {
        this.Log(modules, level, message, t, true);
    }

    public void Log(Tag modules, LogLevel level, String message, Target t, boolean printScreen) {
        this.Log(modules, level, () -> message, t, printScreen);
    }

    public void Log(Tag modules, LogLevel level, StringProvider message, Target t, boolean printScreen) {
        block4: {
            LogLevel moduleLevel = MSLog.GetLevel(modules);
            if (moduleLevel == LogLevel.OFF && !Prefs.ScreamErrors().booleanValue()) {
                return;
            }
            if (moduleLevel.level >= level.level || moduleLevel == LogLevel.ERROR && Prefs.ScreamErrors().booleanValue()) {
                try {
                    Static.LogDebug(root, "[" + level.name() + "][" + modules.getName() + "] " + message.getString() + (t != Target.UNKNOWN ? " " + t.toString() : ""), level, printScreen);
                }
                catch (IOException e) {
                    if (level.level > 1) break block4;
                    StreamUtils.GetSystemErr().println("Was going to print information to the log, but instead, there was an IOException: ");
                    e.printStackTrace(StreamUtils.GetSystemErr());
                }
            }
        }
    }

    public void e(Tag modules, Throwable throwable, Target t) {
        this.Log(modules, LogLevel.ERROR, StackTraceUtils.GetStacktrace(throwable), t, true);
    }

    public void e(Tag modules, String message, Target t) {
        this.Log(modules, LogLevel.ERROR, message, t, true);
    }

    public void w(Tag modules, String message, Target t) {
        this.Log(modules, LogLevel.WARNING, message, t, true);
    }

    public void i(Tag modules, String message, Target t) {
        this.Log(modules, LogLevel.INFO, message, t, true);
    }

    public void d(Tag modules, String message, Target t) {
        this.Log(modules, LogLevel.DEBUG, message, t, true);
    }

    public void v(Tag modules, String message, Target t) {
        this.Log(modules, LogLevel.VERBOSE, message, t, true);
    }

    static {
        LOOKUP = new HashMap<Tag, LogLevel>();
        KNOWN_TAGS = new HashSet<Tag>();
        root = null;
        instance = null;
    }

    public static class MsgBundle {
        private LogLevel level;
        private String message;

        public MsgBundle(LogLevel level, String message) {
            this.level = level;
            this.message = message;
        }
    }

    public static enum Tags implements Tag
    {
        COMPILER("compiler", "Logs compiler errors (but not runtime errors)", LogLevel.WARNING),
        RUNTIME("runtime", "Logs runtime errors, (exceptions that bubble all the way to the top)", LogLevel.ERROR),
        FALSESTRING("falsestring", "Logs coercion of the string \"false\" to boolean, which is actually true", LogLevel.ERROR),
        DEPRECATION("deprecation", "Shows deprecation warnings", LogLevel.WARNING),
        PERSISTENCE("persistence", "Logs when any persistence actions occur.", LogLevel.ERROR),
        INCLUDES("includes", "Logs what file is requested when include() is used", LogLevel.ERROR),
        GENERAL("general", "Anything that doesn't fit in a more specific category is logged here.", LogLevel.ERROR),
        META("meta", "Functions in the meta class use this tag", LogLevel.ERROR),
        EXTENSIONS("extensions", "Extension related logs use this tag", LogLevel.ERROR);

        private final String name;
        private final String description;
        private final LogLevel level;

        private Tags(String name, String description, LogLevel defaultLevel) {
            this.name = name;
            this.description = description;
            this.level = defaultLevel;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public LogLevel getLevel() {
            return this.level;
        }
    }

    @java.lang.annotation.Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LogTag {
    }

    public static interface Tag {
        public String getName();

        public String getDescription();

        public LogLevel getLevel();
    }

    public static interface StringProvider {
        public String getString();
    }
}

