/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.OSUtils;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.InternalException;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.asm.LLVMEnvironment;
import com.laytonsmith.core.asm.LLVMFunction;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.persistence.DataSourceException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;

public class AsmCompiler {
    private static final Set<Class<? extends Environment.EnvironmentImpl>> ENVS = new HashSet<Class<? extends Environment.EnvironmentImpl>>();
    private final File llc;
    private final File lld;

    public AsmCompiler(File llc, File lld) {
        this.llc = llc;
        this.lld = lld;
    }

    public AsmCompiler() {
        if (!OSUtils.GetOS().isWindows()) {
            throw new UnsupportedOperationException("OS not yet supported");
        }
        File llc = new File("C:\\Program Files\\LLVM\\bin\\llc.exe");
        File lld = new File("C:\\Program Files\\LLVM\\bin\\lld-link.exe");
        this.llc = llc;
        this.lld = lld;
    }

    public void compileEntryPoint(File file, File outputDirectory, String exeName) throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException, ConfigCompileException, ConfigCompileGroupException, InterruptedException {
        StringBuilder ir = new StringBuilder();
        StringBuilder strings = new StringBuilder();
        strings.append("\n");
        String irTop = "@exit = global i64 0\ndeclare i32 @puts(i8* nocapture) nounwind\ndefine i64* @main() {\n";
        String irBottom = "exit:\nret i64* @exit\n}\ndefine i32* @mainCRTStartup() {\n%ret = call i64* @main()\n%ret32 = bitcast i64* @exit to i32*\nret i32* %ret32\n}";
        ir.append(strings.toString());
        ir.append(irTop);
        this.compileFile(file, ir);
        ir.append(irBottom);
        File ll = new File(outputDirectory, exeName + ".ll");
        File obj = new File(outputDirectory, exeName + ".obj");
        FileUtil.write(ir.toString(), ll);
        String[] args = new String[]{this.llc.getAbsolutePath(), "--filetype=obj", "-o=\"" + obj.getAbsolutePath() + "\"", ll.getAbsolutePath()};
        CommandExecutor ex = new CommandExecutor(args);
        String error = "Not yet implemented!";
        if (!"".equals(error)) {
            throw new InternalException("Assembly failed:\n" + error);
        }
        String error2 = CommandExecutor.Execute(outputDirectory, this.lld.getAbsolutePath(), obj.getAbsolutePath());
        if (!"".equals(error2)) {
            throw new InternalException("Linking failed:\n" + error2);
        }
    }

    private void compileFile(File file, StringBuilder ir) throws IOException, DataSourceException, Profiles.InvalidProfileException, ConfigCompileException, URISyntaxException, ConfigCompileGroupException {
        String script = FileUtil.read(file);
        Environment env = Static.GenerateStandaloneEnvironment(true);
        env = env.cloneAndAdd(new LLVMEnvironment());
        ParseTree tree = MethodScriptCompiler.compile(MethodScriptCompiler.lex(script, env, file, true), env, ENVS);
        ir.append(this.getIR(tree.getChildAt(0), env));
    }

    private String getIR(ParseTree node, Environment env) throws ConfigCompileException {
        if (!(node.getData() instanceof CFunction)) {
            return api.Platforms.COMPILER_LLVM.getResolver().outputConstant(node.getData(), env);
        }
        CFunction cf = (CFunction)node.getData();
        FunctionBase fb = FunctionList.getFunction(cf, api.Platforms.COMPILER_LLVM, ENVS);
        if (fb instanceof LLVMFunction) {
            return ((LLVMFunction)fb).getIR(node.getTarget(), env, null, node.getChildren().toArray(new ParseTree[0]));
        }
        throw new ConfigCompileException("Unsupported function " + cf.getName(), node.getTarget());
    }

    static {
        ENVS.add(GlobalEnv.class);
        ENVS.add(CompilerEnvironment.class);
        ENVS.add(LLVMEnvironment.class);
    }
}

