/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.Token;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TokenStream
extends LinkedList<Token> {
    private FileOptions fileOptions;

    public TokenStream() {
        this.fileOptions = null;
    }

    public TokenStream(List<Token> list, FileOptions options) {
        super(list);
        this.fileOptions = options;
    }

    public TokenStream(List<Token> list, String fileOptions, Map<String, String> defaults) {
        super(list);
        this.fileOptions = TokenStream.parseFileOptions(fileOptions, defaults);
    }

    public void setFileOptions(String fileOptions, Map<String, String> defaults) {
        this.fileOptions = TokenStream.parseFileOptions(fileOptions, defaults);
    }

    public void setFileOptions(FileOptions fileOptions) {
        this.fileOptions = fileOptions;
    }

    public FileOptions getFileOptions() {
        return this.fileOptions;
    }

    public static FileOptions parseFileOptions(String options, Map<String, String> defaults) {
        HashMap<String, String> map = new HashMap<String, String>(defaults);
        boolean inKey = true;
        StringBuilder buffer = new StringBuilder();
        String keyName = "";
        for (int i = 0; i < options.length(); ++i) {
            Character c = Character.valueOf(options.charAt(i));
            Character c2 = null;
            if (i < options.length() - 1) {
                c2 = Character.valueOf(options.charAt(i + 1));
            }
            if (inKey) {
                if (c.charValue() == ':') {
                    keyName = buffer.toString();
                    buffer = new StringBuilder();
                    inKey = false;
                    continue;
                }
                if (c.charValue() == ';') {
                    map.put(buffer.toString().trim().toLowerCase(), "true");
                    buffer = new StringBuilder();
                    keyName = "";
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c.charValue() == '\\' && c2.charValue() == ';') {
                buffer.append(';');
                ++i;
                continue;
            }
            if (c.charValue() == ';') {
                inKey = true;
                map.put(keyName.trim().toLowerCase(), buffer.toString());
                buffer = new StringBuilder();
                continue;
            }
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            if (!inKey) {
                map.put(keyName.trim().toLowerCase(), buffer.toString());
            } else if (!buffer.toString().trim().isEmpty()) {
                map.put(buffer.toString().trim().toLowerCase(), "true");
            }
        }
        FileOptions fo = new FileOptions(map);
        return fo;
    }
}

