/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.extensions;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.ZipReader;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.core.AliasCore;
import com.laytonsmith.core.extensions.Extension;
import com.laytonsmith.core.extensions.ExtensionManager;
import com.laytonsmith.core.extensions.ExtensionTracker;
import com.laytonsmith.core.extensions.MSExtension;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class AbstractExtension
implements Extension {
    @Override
    public final String getName() {
        for (Annotation a : this.getClass().getAnnotations()) {
            if (!(a instanceof MSExtension)) continue;
            MSExtension e = (MSExtension)a;
            return e.value();
        }
        return "<unknown>";
    }

    @Override
    public final ExtensionTracker getExtensionTracker() {
        return ExtensionManager.getTrackers().get(ClassDiscovery.GetClassContainer(this.getClass()));
    }

    @Override
    public File getConfigDir() {
        File f = new File(CommandHelperFileLocations.getDefault().getExtensionsDirectory(), this.getName());
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    @Override
    public void onStartup() {
    }

    @Override
    public void onPreReloadAliases(AliasCore.ReloadOptions options) {
    }

    @Override
    public void onPostReloadAliases() {
    }

    @Override
    public void onShutdown() {
    }

    @Override
    public Map<String, String> getHelpTopics() {
        return new HashMap<String, String>();
    }

    protected Map<String, String> getDocsResourceFolder(Class<?> forClass) {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            File root = new File(ClassDiscovery.GetClassContainer(forClass).toExternalForm() + "/docs");
            ZipReader zReader = new ZipReader(root);
            String path = Pattern.quote(zReader.getFile().getAbsolutePath());
            for (File r : zReader.listFiles()) {
                String filename = r.getAbsolutePath().replaceFirst(path, "");
                String s = StreamUtils.GetString(forClass.getResourceAsStream(("/docs" + filename).replace('\\', '/')));
                m.put(r.getName(), s);
            }
            return m;
        }
        catch (IOException ex) {
            return new HashMap<String, String>();
        }
    }
}

