/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.breakable;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.noboilerplate;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Procedure;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.BranchStatement;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.CompilerWarning;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.VariableScope;
import com.laytonsmith.core.compiler.analysis.Scope;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.compiler.keywords.InKeyword;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CIdentifier;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CSlice;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREInsufficientArgumentsException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidProcedureException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.FunctionReturnException;
import com.laytonsmith.core.exceptions.LoopBreakException;
import com.laytonsmith.core.exceptions.LoopContinueException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.ArrayHandling;
import com.laytonsmith.core.functions.BasicLogic;
import com.laytonsmith.core.functions.Compiler;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.StringHandling;
import com.laytonsmith.core.natives.interfaces.Iterable;
import com.laytonsmith.core.natives.interfaces.Iterator;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.tools.docgen.templates.ArrayIteration;
import com.laytonsmith.tools.docgen.templates.Loops;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@core
public class ControlFlow {
    public static String docs() {
        return "This class provides various functions to manage control flow.";
    }

    @api
    @noboilerplate
    public static class die
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException {
            if (args.length == 0) {
                throw new CancelCommandException("", t);
            }
            StringBuilder b = new StringBuilder();
            for (Mixed arg : args) {
                b.append(arg.val());
            }
            try {
                if (env.hasEnv(CommandHelperEnvironment.class)) {
                    Static.SendMessage(env.getEnv(CommandHelperEnvironment.class).GetCommandSender(), b.toString(), t);
                }
                String mes = Static.MCToANSIColors(b.toString());
                if (mes.contains("\u001b")) {
                    mes = mes + TermColors.reset();
                }
                StreamUtils.GetSystemOut().println(mes);
            }
            finally {
                throw new CancelCommandException("", t);
            }
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public String getName() {
            return "die";
        }

        @Override
        public String docs() {
            return "nothing {[var1, var2...,]} Kills the command immediately, without completing it. A message is optional, but if provided, displayed to the user.";
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.TERMINAL);
        }
    }

    @api
    public static class call_proc_array
    extends call_proc {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CArray ca = ArgumentValidation.getArray(args[1], t);
            if (ca.inAssociativeMode()) {
                throw new CRECastException("Expected the array passed to " + this.getName() + " to be non-associative.", t);
            }
            Mixed[] args2 = new Mixed[(int)ca.size() + 1];
            args2[0] = args[0];
            for (int i = 1; i < args2.length; ++i) {
                args2[i] = ca.get(i - 1, t);
            }
            return super.exec(t, environment, args2);
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidProcedureException.class, CRECastException.class};
        }

        @Override
        public String getName() {
            return "call_proc_array";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "mixed {proc_name, array} Works like call_proc, but allows for variable or unknown number of arguments to be passed to a proc. The array parameter is \"flattened\", and call_proc is essentially called. If the array is associative, an exception is thrown.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            return null;
        }
    }

    @api
    public static class call_proc
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "call_proc";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "mixed {proc_name, [var1...]} Dynamically calls a user defined procedure. call_proc(_myProc, 'var1') is the equivalent of _myProc('var1'), except you could dynamically build the procedure name if need be. This is useful for dynamic coding, however, closures work best for callbacks. Throws an InvalidProcedureException if the procedure isn't defined. If you are hardcoding the first parameter, a warning will be issued, because it is much more efficient and safe to directly use a procedure if you know what its name is beforehand.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInvalidProcedureException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_2_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            if (args.length < 1) {
                throw new CREInsufficientArgumentsException("Expecting at least one argument to " + this.getName(), t);
            }
            Procedure proc2 = env.getEnv(GlobalEnv.class).GetProcs().get(args[0].val());
            if (proc2 != null) {
                ArrayList<Mixed> vars = new ArrayList<Mixed>(Arrays.asList(args));
                vars.remove(0);
                return proc2.execute(vars, env, t);
            }
            throw new CREInvalidProcedureException("Unknown procedure \"" + args[0].val() + "\"", t);
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() < 1) {
                throw new CREInsufficientArgumentsException("Expecting at least one argument to " + this.getName(), t);
            }
            if (children.get(0).isConst()) {
                env.getEnv(CompilerEnvironment.class).addCompilerWarning(fileOptions, new CompilerWarning("Hardcoding procedure name in " + this.getName() + ", which is inefficient. Consider calling the procedure directly if the procedure name is known at compile time.", t, FileOptions.SuppressWarning.HardcodedDynamicParameter));
            }
            return null;
        }
    }

    @api
    public static class _return
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "return";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "nothing {mixed} Returns the specified value from this procedure or closure. It cannot be called outside a procedure or closure. The function itself does not return a value as such, as it is a terminal function, and prevents further execution within the calling code. Instead it causes the host procedure or closure to return the specified value, and ends termination. (There are exceptions to this rule, see the docs on try/catch, particularly the finally clause for example).";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_2_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.TERMINAL);
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws ConfigRuntimeException {
            CVoid ret = args.length == 1 ? args[0] : CVoid.VOID;
            throw new FunctionReturnException(ret, t);
        }
    }

    @api
    public static class _continue
    extends AbstractFunction {
        @Override
        public String getName() {
            return "continue";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "void {[int]} Skips the rest of the code in this loop, and starts the loop over, with it continuing at the next index. If this function is called outside of a loop, the command will fail. If int is set, it will skip 'int' repetitions. If no argument is specified, 1 is used.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            int num = 1;
            if (args.length == 1) {
                num = ArgumentValidation.getInt32(args[0], t);
            }
            throw new LoopContinueException(num, t);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "for(assign(@i, 0), @i < 5, @i++){\n\tif(@i == 2, continue())\n\tmsg(@i)\n}"), new ExampleScript("Argument specified", "for(assign(@i, 0), @i < 5, @i++){\n\tif(@i == 2, continue(2))\n\tmsg(@i)\n}")};
        }
    }

    @api
    public static class _break
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "break";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1};
        }

        @Override
        public String docs() {
            return "nothing {[int]} Stops the current loop. If int is specified, and is greater than 1, the break travels that many loops up. So, if you had a loop embedded in a loop, and you wanted to break in both loops, you would call break(2). If this function is called outside a loop (or the number specified would cause the break to travel up further than any loops are defined), the function will fail. If no argument is specified, it is the same as calling break(1). This function has special compilation rules. The break number must not be dynamic, or a compile error will occur. An integer must be hard coded into the function.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            int num = 1;
            if (args.length == 1) {
                num = ArgumentValidation.getInt32(args[0], t);
            }
            throw new LoopBreakException(num, t);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "for(assign(@i, 0), @i < 1000, @i++,\n\tfor(assign(@j, 0), @j < 1000, @j++,\n\t\tmsg('This will only display once')\n\t\tbreak(2)\n\t))"), new ExampleScript("Invalid number", "for(assign(@i, 0), @i < 1000, @i++,\n\tfor(assign(@j, 0), @j < 1000, @j++,\n\t\tbreak(3) #There are only 2 loops to break out of\n\t))", true)};
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() == 1) {
                if (children.get(0).isDynamic()) {
                    throw new ConfigCompileException("The parameter sent to break() should be hard coded, and should not be dynamically determinable, since this is always a sign of loose code flow, which should be avoided.", t);
                }
                if (!children.get(0).getData().isInstanceOf(CInt.TYPE)) {
                    throw new ConfigCompileException("break() only accepts integer values.", t);
                }
            }
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }
    }

    @api
    @noboilerplate
    @breakable
    @seealso(value={Loops.class})
    public static class _dowhile
    extends AbstractFunction
    implements BranchStatement,
    VariableScope {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CNull.NULL;
        }

        @Override
        public String getName() {
            return "dowhile";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "void {code, condition} Like while, but always runs the code at least once. The condition is checked after each run of the code, and if it is true, the code is run again. break and continue work inside a dowhile, but continuing more than once is pointless, since the loop isn't inherently keeping track of any counters anyways. Breaking multiple times still works however. In general, using brace syntax is preferred: do { code(); } while(@condition); instead of using dowhile() directly.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            block5: {
                try {
                    do {
                        try {
                            parent.eval(nodes[0], env);
                        }
                        catch (LoopContinueException loopContinueException) {
                            // empty catch block
                        }
                    } while (ArgumentValidation.getBoolean(parent.seval(nodes[1], env), t));
                }
                catch (LoopBreakException e) {
                    if (e.getTimes() <= 1) break block5;
                    throw new LoopBreakException(e.getTimes() - 1, t);
                }
            }
            return CVoid.VOID;
        }

        @Override
        public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            super.linkScope(analysis, parentScope, ast, env, exceptions);
            return parentScope;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "do {\n\tmsg('This will only run once');\n} while(false);"), new ExampleScript("Pure functional usage", "dowhile(\n\tmsg('This will only run once')\n, #while\nfalse)")};
        }

        @Override
        public LogLevel profileAt() {
            return LogLevel.WARNING;
        }

        @Override
        public String profileMessageS(List<ParseTree> args) {
            return "Executing function: " + this.getName() + "(<code>, " + args.get(1).toStringVerbose() + ")";
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>(2);
            ret.add(true);
            ret.add(false);
            return ret;
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            return this.isBranch(children);
        }
    }

    @api
    @noboilerplate
    @breakable
    @seealso(value={Loops.class})
    public static class _while
    extends AbstractFunction
    implements BranchStatement,
    VariableScope {
        @Override
        public String getName() {
            return "while";
        }

        @Override
        public String docs() {
            return "void {condition, [code]} While the condition is true, the code is executed. break and continue work inside a dowhile, but continuing more than once is pointless, since the loop isn't inherently keeping track of any counters anyways. Breaking multiple times still works however.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            block5: {
                try {
                    while (ArgumentValidation.getBoolean(parent.seval(nodes[0], env), t)) {
                        if (nodes.length <= 1) continue;
                        try {
                            parent.eval(nodes[1], env);
                        }
                        catch (LoopContinueException loopContinueException) {}
                    }
                }
                catch (LoopBreakException e) {
                    if (e.getTimes() <= 1) break block5;
                    throw new LoopBreakException(e.getTimes() - 1, t);
                }
            }
            return CVoid.VOID;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CNull.NULL;
        }

        @Override
        public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            super.linkScope(analysis, parentScope, ast, env, exceptions);
            return parentScope;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "assign(@i, 5)\nwhile(@i > 0,\n\tmsg(@i)\n\t@i--\n)"), new ExampleScript("With a break", "assign(@i, 0)\nwhile(true,\n\tmsg(@i)\n\t@i++\n\tif(@i > 5, break())\n)")};
        }

        @Override
        public LogLevel profileAt() {
            return LogLevel.WARNING;
        }

        @Override
        public String profileMessageS(List<ParseTree> args) {
            return "Executing function: " + this.getName() + "(" + args.get(0).toStringVerbose() + ", <code>)";
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>();
            ret.add(false);
            ret.add(true);
            return ret;
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            return this.isBranch(children);
        }
    }

    @api
    @noboilerplate
    @breakable
    @seealso(value={foreach.class, Loops.class, ArrayIteration.class})
    public static class foreachelse
    extends foreach {
        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            ParseTree array2 = nodes[0];
            ParseTree elseCode = nodes[nodes.length - 1];
            Mixed data = parent.seval(array2, env);
            if (!data.isInstanceOf(CArray.TYPE) && !(data instanceof CSlice)) {
                throw new CRECastException(this.getName() + " expects an array for parameter 1", t);
            }
            if (!((CArray)data).isEmpty()) {
                ParseTree[] pass = new ParseTree[nodes.length - 1];
                System.arraycopy(nodes, 0, pass, 0, nodes.length - 1);
                nodes[0] = new ParseTree(data, null);
                return super.execs(t, env, parent, pass);
            }
            parent.eval(elseCode, env);
            return CVoid.VOID;
        }

        @Override
        public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            if (ast.numberOfChildren() >= 4) {
                Scope[] scopes;
                Scope arrayScope;
                int ind = 0;
                ParseTree array2 = ast.getChildAt(ind++);
                ParseTree key = ast.numberOfChildren() == 5 ? ast.getChildAt(ind++) : null;
                ParseTree val = ast.getChildAt(ind++);
                ParseTree code = ast.getChildAt(ind++);
                ParseTree elseCode = ast.getChildAt(ind++);
                Scope keyParamScope = arrayScope = analysis.linkScope(parentScope, array2, env, exceptions);
                Scope keyValScope = arrayScope;
                if (key != null) {
                    scopes = analysis.linkParamScope(keyParamScope, keyValScope, key, env, exceptions);
                    keyParamScope = scopes[0];
                    keyValScope = scopes[1];
                }
                scopes = analysis.linkParamScope(keyParamScope, keyValScope, val, env, exceptions);
                Scope valScope = scopes[0];
                analysis.linkScope(valScope, code, env, exceptions);
                analysis.linkScope(arrayScope, elseCode, env, exceptions);
            }
            return parentScope;
        }

        @Override
        public String getName() {
            return "foreachelse";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{4, 5};
        }

        @Override
        public String docs() {
            return "void {array, [key], ivar, code, else} Works like a foreach, except if the array is empty, the else code runs instead. That is, if the code would not run at all, the else condition would. In general, brace syntax and use of foreach(){ } else { } syntax is preferred, instead of using foreachelse directly.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage, with the else code not running", "@array = array(1, 2, 3)\nforeachelse(@array, @val,\n    msg(@val)\n, #else \n    msg('No values in the array')\n)"), new ExampleScript("Empty array, so else block running", "@array = array()\nforeachelse(@array, @val,\n    msg(@val)\n, #else \n    msg('No values in the array')\n)")};
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>(children.size());
            ret.add(false);
            if (children.size() == 5) {
                ret.add(false);
            }
            ret.add(false);
            ret.add(true);
            ret.add(true);
            return ret;
        }
    }

    @api
    @breakable
    @seealso(value={Loops.class, ArrayIteration.class})
    public static class foreach
    extends AbstractFunction
    implements BranchStatement,
    VariableScope {
        private static final String CENTRY = new Compiler.centry().getName();
        private static final String ASSIGN = new DataHandling.assign().getName();
        private static final String SCONCAT = new StringHandling.sconcat().getName();
        private static final String IN = new InKeyword().getKeywordName();

        @Override
        public String getName() {
            return "foreach";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3, 4};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            return CVoid.VOID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            if (nodes.length < 3) {
                throw new CREInsufficientArgumentsException("Insufficient arguments passed to " + this.getName(), t);
            }
            ParseTree array2 = nodes[0];
            ParseTree key = null;
            int offset = 0;
            if (nodes.length == 4) {
                key = nodes[1];
                offset = 1;
            }
            ParseTree value = nodes[1 + offset];
            ParseTree code = nodes[2 + offset];
            Mixed arr = parent.seval(array2, env);
            Mixed ik = null;
            if (key != null && !((ik = parent.eval(key, env)) instanceof IVariable)) {
                throw new CRECastException("Parameter 2 of " + this.getName() + " must be an ivariable", t);
            }
            Mixed iv = parent.eval(value, env);
            if (arr instanceof CSlice) {
                long start = ((CSlice)arr).getStart();
                long finish = ((CSlice)arr).getFinish();
                arr = finish < start ? new ArrayHandling.range().exec(t, env, new CInt(start, t), new CInt(finish - 1L, t), new CInt(-1L, t)) : new ArrayHandling.range().exec(t, env, new CInt(start, t), new CInt(finish + 1L, t));
            }
            if (!(arr instanceof Iterable)) {
                throw new CRECastException("Parameter 1 of " + this.getName() + " must be an Iterable data structure", t);
            }
            if (!(iv instanceof IVariable)) {
                throw new CRECastException("Parameter " + (2 + offset) + " of " + this.getName() + " must be an ivariable", t);
            }
            Iterable one = (Iterable)arr;
            IVariable kkey = (IVariable)ik;
            IVariable two = (IVariable)iv;
            if (one.isAssociative()) {
                LinkedHashSet<Mixed> keySet = new LinkedHashSet<Mixed>(one.keySet());
                int continues = 0;
                for (Mixed c : keySet) {
                    if (continues > 0) {
                        --continues;
                        continue;
                    }
                    if (kkey != null) {
                        env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(kkey.getDefinedType(), kkey.getVariableName(), c, t, env));
                    }
                    env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(two.getDefinedType(), two.getVariableName(), one.get(c.val(), t), t, env));
                    try {
                        parent.eval(code, env);
                    }
                    catch (LoopBreakException e) {
                        int num = e.getTimes();
                        if (num > 1) {
                            e.setTimes(--num);
                            throw e;
                        }
                        return CVoid.VOID;
                    }
                    catch (LoopContinueException e) {
                        continues += e.getTimes() - 1;
                    }
                }
                return CVoid.VOID;
            }
            Iterator iterator = new Iterator(one);
            List<Iterator> arrayAccessList = env.getEnv(GlobalEnv.class).GetArrayAccessIterators();
            try {
                arrayAccessList.add(iterator);
                int continues = 0;
                while (true) {
                    int current = iterator.getCurrent();
                    if (continues > 0) {
                        iterator.incrementCurrent();
                        if (iterator.isBlacklisted(current)) continue;
                        --continues;
                        continue;
                    }
                    if ((long)current >= one.size()) {
                        break;
                    }
                    if (!iterator.isBlacklisted(current)) {
                        if (kkey != null) {
                            env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(kkey.getDefinedType(), kkey.getVariableName(), new CInt(current, t), t, env));
                        }
                        env.getEnv(GlobalEnv.class).GetVarList().set(new IVariable(two.getDefinedType(), two.getVariableName(), one.get(current, t), t, env));
                        try {
                            parent.eval(code, env);
                        }
                        catch (LoopBreakException e) {
                            int num = e.getTimes();
                            if (num > 1) {
                                e.setTimes(--num);
                                throw e;
                            }
                            CVoid cVoid = CVoid.VOID;
                            arrayAccessList.remove(iterator);
                            return cVoid;
                        }
                        catch (LoopContinueException e) {
                            continues += e.getTimes();
                            continue;
                        }
                    }
                    iterator.incrementCurrent();
                }
            }
            finally {
                arrayAccessList.remove(iterator);
            }
            return CVoid.VOID;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CRERangeException.class};
        }

        @Override
        public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            if (ast.numberOfChildren() >= 3) {
                Scope[] scopes;
                Scope arrayScope;
                int ind = 0;
                ParseTree array2 = ast.getChildAt(ind++);
                ParseTree key = ast.numberOfChildren() == 4 ? ast.getChildAt(ind++) : null;
                ParseTree val = ast.getChildAt(ind++);
                ParseTree code = ast.getChildAt(ind++);
                Scope keyParamScope = arrayScope = analysis.linkScope(parentScope, array2, env, exceptions);
                Scope keyValScope = arrayScope;
                if (key != null) {
                    scopes = analysis.linkParamScope(keyParamScope, keyValScope, key, env, exceptions);
                    keyParamScope = scopes[0];
                    keyValScope = scopes[1];
                }
                scopes = analysis.linkParamScope(keyParamScope, keyValScope, val, env, exceptions);
                Scope valScope = scopes[0];
                analysis.linkScope(valScope, code, env, exceptions);
            }
            return parentScope;
        }

        @Override
        public String docs() {
            return "void {array, [key], ivar, code} Walks through array, setting ivar equal to each element in the array, then running code. In addition, foreach(1..4, @i, code()) is also valid, setting @i to 1, 2, 3, 4 each time. The same syntax is valid as in an array slice. If key is set (it must be an ivariable) then the index of each iteration will be set to that. See the examples for a demonstration. ----  Enhanced syntax may also be used in foreach, using the \"in\", \"as\" and \"else\" keywords. See the examples for examples of each structure. Using these keywords makes the structure of the foreach read much better. For instance, with foreach(@value in @array){ } the code very literally reads \"for each value in array\", making ascertaining the behavior of the loop easier. The \"as\" keyword reads less plainly, and so is not recommended for use, but is allowed. Note that the array and value are reversed with the \"as\" keyword. An \"else\" block may be used after the foreach, which will only run if the array provided is empty, that is, the loop code would never run. This provides a good way to provide \"default\" handling. Array modifications while iterating are supported, and are well defined. See [[Array_iteration|the page documenting array iterations]] for full details.";
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Using \"in\" keyword", "@array = array(1, 2, 3);\nforeach(@value in @array){\n\tmsg(@value);\n}"), new ExampleScript("Using \"in\" keyword, with a key", "@array = array(1, 2, 3);\nforeach(@key: @value in @array){\n\tmsg(@key . ': ' . @value);\n}"), new ExampleScript("Using \"as\" keyword", "@array = array(1, 2, 3);\nforeach(@array as @value){\n\tmsg(@value);\n}"), new ExampleScript("With else clause", "@array = array() # Note empty array\nforeach(@value in @array){\n\tmsg(@value);\n} else {\n\tmsg('No values were in the array');\n}"), new ExampleScript("Basic functional usage", "assign(@array, array(1, 2, 3))\nforeach(@array, @i,\n\tmsg(@i)\n)"), new ExampleScript("With braces", "assign(@array, array(1, 2, 3))\nforeach(@array, @i){\n\tmsg(@i)\n}"), new ExampleScript("With a slice", "foreach(1..3, @i){\n\tmsg(@i)\n}"), new ExampleScript("With a slice, counting down", "foreach(3..1, @i){\n\tmsg(@i)\n}"), new ExampleScript("With array keys", "@array = array('one': 1, 'two': 2)\nforeach(@array, @key, @value){\n\tmsg(@key.':'.@value)\n}")};
        }

        @Override
        public LogLevel profileAt() {
            return LogLevel.WARNING;
        }

        @Override
        public String profileMessageS(List<ParseTree> args) {
            return "Executing function: " + this.getName() + "(" + args.get(0).toStringVerbose() + ", " + args.get(1).toStringVerbose() + ", <code>)";
        }

        private boolean isFunction(ParseTree node, String function) {
            return node.getData() instanceof CFunction && node.getData().val().equals(function);
        }

        private boolean isKeyword(ParseTree node, String keyword2) {
            return node.getData() instanceof CKeyword && node.getData().val().equals(keyword2);
        }

        @Override
        public ParseTree postParseRewrite(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
            List<ParseTree> children = ast.getChildren();
            if (children.size() < 2) {
                exceptions.add(new ConfigCompileException("Invalid number of arguments passed to " + this.getName(), ast.getTarget()));
                return null;
            }
            if (this.isFunction(children.get(0), CENTRY)) {
                ParseTree sconcat2 = new ParseTree(new CFunction(new StringHandling.sconcat().getName(), ast.getTarget()), ast.getFileOptions());
                sconcat2.addChild(children.get(0).getChildAt(0));
                for (int i = 0; i < children.get(0).getChildAt(1).numberOfChildren(); ++i) {
                    sconcat2.addChild(children.get(0).getChildAt(1).getChildAt(i));
                }
                children.set(0, sconcat2);
            }
            if (children.get(0).getData() instanceof CFunction && children.get(0).getData().val().equals(new StringHandling.sconcat().getName())) {
                ParseTree array2 = null;
                ParseTree key = null;
                ParseTree value = null;
                List<ParseTree> c = children.get(0).getChildren();
                if (c.size() == 3) {
                    switch (c.get(1).getData().val()) {
                        case "in": {
                            value = c.get(0);
                            array2 = c.get(2);
                            break;
                        }
                        case "as": {
                            value = c.get(2);
                            array2 = c.get(0);
                        }
                    }
                } else if (c.size() == 4) {
                    if ("in".equals(c.get(2).getData().val())) {
                        key = c.get(0);
                        value = c.get(1);
                        array2 = c.get(3);
                    } else if ("as".equals(c.get(1).getData().val())) {
                        array2 = c.get(0);
                        key = c.get(2);
                        value = c.get(3);
                    }
                }
                if (array2 == null) {
                    exceptions.add(new ConfigCompileException("Invalid argument format passed to " + this.getName(), ast.getTarget()));
                    return null;
                }
                if (key != null && key.getData() instanceof CLabel) {
                    if (!(((CLabel)key.getData()).cVal() instanceof IVariable || ((CLabel)key.getData()).cVal() instanceof CFunction && ((CLabel)key.getData()).cVal().val().equals(ASSIGN))) {
                        exceptions.add(new ConfigCompileException("Expected a variable for key, but \"" + key.getData().val() + "\" was found", ast.getTarget()));
                    }
                    key.setData(((CLabel)key.getData()).cVal());
                }
                ArrayList<ParseTree> newChildren = new ArrayList<ParseTree>();
                newChildren.add(array2);
                if (key != null) {
                    newChildren.add(key);
                }
                newChildren.add(value);
                for (int i = 1; i < children.size(); ++i) {
                    newChildren.add(children.get(i));
                }
                children.clear();
                children.addAll(newChildren);
                if (children.get(children.size() - 1).getData() instanceof CFunction && children.get(children.size() - 1).getData().val().equals("else")) {
                    ParseTree foreachelse2 = new ParseTree(new CFunction(new foreachelse().getName(), ast.getTarget()), ast.getFileOptions());
                    children.set(children.size() - 1, children.get(children.size() - 1).getChildAt(0));
                    foreachelse2.setChildren(children);
                    return foreachelse2;
                }
            }
            return null;
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>(children.size());
            ret.add(false);
            if (children.size() == 4) {
                ret.add(false);
            }
            ret.add(false);
            ret.add(true);
            return ret;
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>(children.size());
            for (ParseTree c : children) {
                ret.add(true);
            }
            return ret;
        }
    }

    @api
    @noboilerplate
    @breakable
    public static class forelse
    extends AbstractFunction
    implements BranchStatement,
    VariableScope {
        boolean runAsFor = false;

        public forelse() {
        }

        forelse(boolean runAsFor) {
            this.runAsFor = runAsFor;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return null;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) throws ConfigRuntimeException {
            boolean cond;
            ParseTree assign2 = nodes[0];
            ParseTree condition = nodes[1];
            ParseTree expression = nodes[2];
            ParseTree runnable = nodes[3];
            ParseTree elseCode = null;
            if (!this.runAsFor) {
                elseCode = nodes[4];
            }
            boolean hasRunOnce = false;
            Mixed counter = parent.eval(assign2, env);
            if (!(counter instanceof IVariable)) {
                throw new CRECastException("First parameter of for must be an ivariable", t);
            }
            int _continue2 = 0;
            while (cond = ArgumentValidation.getBoolean(parent.seval(condition, env), t)) {
                hasRunOnce = true;
                if (_continue2 >= 1) {
                    --_continue2;
                    parent.eval(expression, env);
                    continue;
                }
                try {
                    parent.eval(runnable, env);
                }
                catch (LoopBreakException e) {
                    int num = e.getTimes();
                    if (num > 1) {
                        e.setTimes(--num);
                        throw e;
                    }
                    return CVoid.VOID;
                }
                catch (LoopContinueException e) {
                    _continue2 = e.getTimes() - 1;
                    parent.eval(expression, env);
                    continue;
                }
                parent.eval(expression, env);
            }
            if (!hasRunOnce && !this.runAsFor && elseCode != null) {
                parent.eval(elseCode, env);
            }
            return CVoid.VOID;
        }

        @Override
        public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            if (ast.numberOfChildren() >= (this.runAsFor ? 3 : 4)) {
                ParseTree assign2 = ast.getChildAt(0);
                ParseTree cond = ast.getChildAt(1);
                ParseTree exp = ast.getChildAt(2);
                ParseTree code = ast.getChildAt(3);
                ParseTree elseCode = this.runAsFor ? null : ast.getChildAt(4);
                Scope assignScope = analysis.linkScope(parentScope, assign2, env, exceptions);
                Scope condScope = analysis.linkScope(assignScope, cond, env, exceptions);
                Scope codeScope = analysis.linkScope(condScope, code, env, exceptions);
                analysis.linkScope(codeScope, exp, env, exceptions);
                if (elseCode != null) {
                    analysis.linkScope(condScope, code, env, exceptions);
                }
            }
            return parentScope;
        }

        @Override
        public String getName() {
            return "forelse";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{5};
        }

        @Override
        public String docs() {
            return "void {assign, condition, expression1, expression2, else} Works like a normal for loop, but if upon checking the condition the first time, it is determined that it is false (that is, NO code loops are going to be run) the else code is run instead. If the loop runs, even once, it will NOT run the else branch. In general, brace syntax and use of for(){ } else { } syntax is preferred, instead of using forelse directly.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            return Arrays.asList(false, false, true, true, true);
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            return Arrays.asList(true, false, false, true, true);
        }
    }

    @api
    @noboilerplate
    @breakable
    @seealso(value={Loops.class, ArrayIteration.class})
    public static class _for
    extends AbstractFunction
    implements Optimizable,
    BranchStatement,
    VariableScope {
        @Override
        public String getName() {
            return "for";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{4};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) {
            return CVoid.VOID;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            return new forelse(true).execs(t, env, parent, nodes);
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            super.linkScope(analysis, parentScope, ast, env, exceptions);
            return parentScope;
        }

        @Override
        public String docs() {
            return "void {assign, condition, expression1, expression2} Acts as a typical for loop. The assignment is first run. Then, a condition is checked. If that condition is checked and returns true, expression2 is run. After that, expression1 is run. In java syntax, this would be: for(assign; condition; expression1){expression2}. assign must be an ivariable, either a pre defined one, or the results of the assign() function. condition must be a boolean.";
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "for(assign(@i, 0), @i < 5, @i++,\n\tmsg(@i)\n)"), new ExampleScript("With braces", "for(assign(@i, 0), @i < 2, @i++){\n\tmsg(@i)\n}"), new ExampleScript("With continue. (See continue() for more examples)", "for(assign(@i, 0), @i < 2, @i++){\n\tif(@i == 1, continue())\n\tmsg(@i)\n}")};
        }

        @Override
        public LogLevel profileAt() {
            return LogLevel.WARNING;
        }

        @Override
        public String profileMessageS(List<ParseTree> args) {
            return "Executing function: " + this.getName() + "(" + args.get(0).toStringVerbose() + ", " + args.get(1).toStringVerbose() + ", " + args.get(2).toStringVerbose() + ", <code>)";
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            try {
                boolean isInc;
                if (children.get(2).getData() instanceof CFunction && ((isInc = children.get(2).getData().val().equals("postinc")) || children.get(2).getData().val().equals("postdec")) && children.get(2).getChildAt(0).getData() instanceof IVariable) {
                    ParseTree pre = new ParseTree(new CFunction(isInc ? "inc" : "dec", t), children.get(2).getFileOptions());
                    pre.addChild(children.get(2).getChildAt(0));
                    children.set(2, pre);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>();
            ret.add(false);
            ret.add(false);
            ret.add(true);
            ret.add(true);
            return ret;
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            ArrayList<Boolean> ret = new ArrayList<Boolean>();
            ret.add(true);
            ret.add(false);
            ret.add(false);
            ret.add(true);
            return ret;
        }
    }

    @api
    public static class switch_ic
    extends _switch
    implements Optimizable,
    BranchStatement,
    VariableScope {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            throw new Error();
        }

        @Override
        public String getName() {
            return "switch_ic";
        }

        @Override
        public String docs() {
            return "mixed {value, [equals, code]..., [defaultCode]} Provides a case insensitive switch statement, for switching over strings. This works by compiler transformations, transforming this into a normal switch statement, with each case lowercased, and the input to the switch wrapped in to_lower. The case statements must be strings, however, which is the main difference between this method and the normal switch statement. The lowercasing is done with the system's default locale.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_4;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            ParseTree switchTree = super.optimizeDynamic(t, env, envs, children, fileOptions);
            ParseTree condition = children.get(0);
            if (!CFunction.IsFunction(condition, StringHandling.to_lower.class)) {
                ParseTree to_lower2 = new ParseTree(new CFunction(new StringHandling.to_lower().getName(), t), fileOptions);
                to_lower2.addChild(condition);
                children.set(0, to_lower2);
            }
            for (int i = 1; i < children.size() - 1; i += 2) {
                ParseTree child = children.get(i);
                Mixed caseData = child.getData();
                if (caseData instanceof CArray) {
                    CArray newData = new CArray(child.getTarget());
                    for (Mixed cse : ((CArray)caseData).asList()) {
                        if (cse instanceof CString) {
                            CString data = (CString)cse;
                            newData.push(new CString(data.val().toLowerCase(), data.getTarget()), data.getTarget());
                            continue;
                        }
                        throw new ConfigCompileException(this.getName() + " can only accept strings in case statements.", cse.getTarget());
                    }
                    child.setData(newData);
                    continue;
                }
                if (caseData instanceof CString) {
                    CString data = (CString)caseData;
                    child.setData(new CString(data.val().toLowerCase(), data.getTarget()));
                    continue;
                }
                throw new ConfigCompileException(this.getName() + " can only accept strings in case statements.", caseData.getTarget());
            }
            return switchTree;
        }
    }

    @api
    @breakable
    public static class _switch
    extends AbstractFunction
    implements Optimizable,
    BranchStatement,
    VariableScope {
        @Override
        public String getName() {
            return "switch";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "mixed {value, [equals, code]..., [defaultCode]} Provides a switch statement. If none of the conditions match, and no default is provided, void is returned. See the documentation on [[Logic|Logic]] for more information. ---- In addition, slices may be used to indicate ranges of integers that should trigger the specified case. Slices embedded in an array are fine as well. Switch statements also support brace/case/default syntax, as in most languages, althrough unlike most languages, fallthrough isn't supported. Breaking with break() isn't required, but recommended. A number greater than 1 may be sent to break, and breaking out of the switch will consume a \"break counter\" and the break will continue up the chain. If you do use break(), the return value of switch is ignored. See the examples for usage of brace/case/default syntax, which is highly recommended.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInsufficientArgumentsException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public boolean preResolveVariables() {
            return false;
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CNull.NULL;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            block8: {
                Mixed value = parent.seval(nodes[0], env);
                BasicLogic.equals equals2 = new BasicLogic.equals();
                try {
                    for (int i = 1; i <= nodes.length - 2; i += 2) {
                        ParseTree statement = nodes[i];
                        ParseTree code = nodes[i + 1];
                        Mixed evalStatement = parent.seval(statement, env);
                        if (evalStatement instanceof CSlice) {
                            long rangeLeft = ((CSlice)evalStatement).getStart();
                            long rangeRight = ((CSlice)evalStatement).getFinish();
                            if (!value.isInstanceOf(CInt.TYPE)) continue;
                            long v = ArgumentValidation.getInt(value, t);
                            if (!(rangeLeft < rangeRight && v >= rangeLeft && v <= rangeRight || rangeLeft > rangeRight && v >= rangeRight && v <= rangeLeft) && (rangeLeft != rangeRight || v != rangeLeft)) continue;
                            return parent.seval(code, env);
                        }
                        if (evalStatement.isInstanceOf(CArray.TYPE)) {
                            for (String index : ((CArray)evalStatement).stringKeySet()) {
                                Mixed inner = ((CArray)evalStatement).get(index, t);
                                if (inner instanceof CSlice) {
                                    long rangeLeft = ((CSlice)inner).getStart();
                                    long rangeRight = ((CSlice)inner).getFinish();
                                    if (!value.isInstanceOf(CInt.TYPE)) continue;
                                    long v = ArgumentValidation.getInt(value, t);
                                    if (!(rangeLeft < rangeRight && v >= rangeLeft && v <= rangeRight || rangeLeft > rangeRight && v >= rangeRight && v <= rangeLeft) && (rangeLeft != rangeRight || v != rangeLeft)) continue;
                                    return parent.seval(code, env);
                                }
                                if (!equals2.exec(t, env, value, inner).getBoolean()) continue;
                                return parent.seval(code, env);
                            }
                            continue;
                        }
                        if (!equals2.exec(t, env, value, evalStatement).getBoolean()) continue;
                        return parent.seval(code, env);
                    }
                    if (nodes.length % 2 == 0) {
                        return parent.seval(nodes[nodes.length - 1], env);
                    }
                }
                catch (LoopBreakException ex) {
                    if (ex.getTimes() <= 1) break block8;
                    ex.setTimes(ex.getTimes() - 1);
                    throw ex;
                }
            }
            return CVoid.VOID;
        }

        @Override
        public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            List<ParseTree> children = ast.getChildren();
            for (int i = 0; i <= children.size() - 2; i += 2) {
                ParseTree cond = children.get(i);
                ParseTree code = children.get(i + 1);
                Scope condScope = analysis.linkScope(parentScope, cond, env, exceptions);
                analysis.linkScope(analysis.createNewScope(condScope), code, env, exceptions);
            }
            if ((children.size() & 1) == 1) {
                analysis.linkScope(analysis.createNewScope(parentScope), children.get(children.size() - 1), env, exceptions);
            }
            return parentScope;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("With braces/case/default", "switch('theValue'){\n\tcase 'notTheValue':\n\t\tmsg('Nope')\n\t\tbreak();\n\tcase 'theValue':\n\t\tmsg('Success')\n\t\tbreak();\n}"), new ExampleScript("With braces/case/default. Note the lack of fallthrough, even without a break(), except where cases are directly back to back.", "@a = 5\nswitch(@a){\n\tcase 1:\n\tcase 2:\n\t\tmsg('1 or 2');\n\tcase 3..4:\n\t\tmsg('3 or 4');\n\t\tbreak(); // This is optional, as it would break here anyways, but is recommended.\n\tcase 5..6:\n\tcase 8:\n\t\tmsg('5, 6, or 8')\n\tdefault:\n\t\tmsg('Any other value'); # A default is optional\n}\n"), new ExampleScript("With default condition", "switch('noMatch'){\n\tcase 'notIt1':\n\t\tmsg('Nope');\n\t\tbreak();\n\tcase 'notIt2':\n\t\tmsg('Nope');\n\t\tbreak();\n\tdefault:\n\t\tmsg('Success');\n\t\tbreak();\n}"), new ExampleScript("With slices", "switch(5){\n\tcase 1..2:\n\t\tmsg('First');\n\t\tbreak();\n\tcase 3..5:\n\t\tmsg('Second');\n\t\tbreak();\n\tcase 6..8:\n\t\tmsg('Third');\n\t\tbreak();\n}"), new ExampleScript("Functional usage", "switch('theValue',\n\t'notTheValue',\n\t\tmsg('Nope'),\n\t'theValue',\n\t\tmsg('Success')\n)"), new ExampleScript("With multiple matches using an array", "switch('string',\n\tarray('value1', 'value2', 'string'),\n\t\tmsg('Match'),\n\t'value3',\n\t\tmsg('No match')\n)"), new ExampleScript("With slices in an array", "switch(5,\n\tarray(1..2, 3..5),\n\t\tmsg('First'),\n\t6..8,\n\t\tmsg('Second')\n)")};
        }

        @Override
        public ParseTree postParseRewrite(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
            List<ParseTree> children = ast.getChildren();
            Target t = ast.getTarget();
            if (children.size() > 1 && children.get(1).getData() instanceof CFunction && new StringHandling.sconcat().getName().equals(children.get(1).getData().val())) {
                ArrayList<ParseTree> newChildren = new ArrayList<ParseTree>();
                newChildren.add(children.get(0));
                List<ParseTree> c = children.get(1).getChildren();
                ArrayList<ParseTree> lastCodeBlock = new ArrayList<ParseTree>();
                CArray conditions = new CArray(t);
                boolean inCase = false;
                boolean inDefault = false;
                for (int i = 0; i < c.size(); ++i) {
                    ParseTree codeBlock;
                    ParseTree c1 = c.get(i);
                    ParseTree c2 = null;
                    if (i + 1 < c.size()) {
                        c2 = c.get(i + 1);
                    }
                    if (CKeyword.isKeyword(c1, "case") && c2 != null && c2.getData() instanceof CLabel) {
                        if (inDefault) {
                            exceptions.add(new ConfigCompileException("Unexpected case; the default case must come last.", t));
                            return null;
                        }
                        if (lastCodeBlock.size() > 0) {
                            newChildren.add(new ParseTree(conditions, c2.getFileOptions()));
                            conditions = new CArray(t);
                            codeBlock = new ParseTree(new CFunction(new StringHandling.sconcat().getName(), t), c2.getFileOptions());
                            for (ParseTree line : lastCodeBlock) {
                                codeBlock.addChild(line);
                            }
                            if (codeBlock.getChildren().size() == 1) {
                                codeBlock = codeBlock.getChildAt(0);
                            }
                            newChildren.add(codeBlock);
                            lastCodeBlock = new ArrayList();
                        }
                        conditions.push(((CLabel)c2.getData()).cVal(), t);
                        inCase = true;
                        ++i;
                        continue;
                    }
                    if (c1.getData() instanceof CLabel && CKeyword.isKeyword(((CLabel)c1.getData()).cVal(), "default")) {
                        if (lastCodeBlock.size() > 0) {
                            newChildren.add(new ParseTree(conditions, c1.getFileOptions()));
                            conditions = new CArray(t);
                            codeBlock = new ParseTree(new CFunction(new StringHandling.sconcat().getName(), t), c1.getFileOptions());
                            for (ParseTree line : lastCodeBlock) {
                                codeBlock.addChild(line);
                            }
                            if (codeBlock.getChildren().size() == 1) {
                                codeBlock = codeBlock.getChildAt(0);
                            }
                            newChildren.add(codeBlock);
                            lastCodeBlock = new ArrayList();
                        } else if (conditions.size() > 0L) {
                            conditions = new CArray(t);
                        }
                        inDefault = true;
                        continue;
                    }
                    if (!inCase && !inDefault) continue;
                    lastCodeBlock.add(c1);
                }
                if (conditions.size() > 0L) {
                    newChildren.add(new ParseTree(conditions, children.get(0).getFileOptions()));
                }
                if (lastCodeBlock.size() > 0) {
                    ParseTree codeBlock = new ParseTree(new CFunction(new StringHandling.sconcat().getName(), t), ((ParseTree)lastCodeBlock.get(0)).getFileOptions());
                    for (ParseTree line : lastCodeBlock) {
                        codeBlock.addChild(line);
                    }
                    if (codeBlock.getChildren().size() == 1) {
                        codeBlock = codeBlock.getChildAt(0);
                    }
                    newChildren.add(codeBlock);
                }
                children.clear();
                children.addAll(newChildren);
            }
            return null;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            String notConstant = "Cases for a switch statement must be constant, not variable";
            String alreadyContains = "The switch statement already contains a case for this value, remove the duplicate value";
            BasicLogic.equals equals2 = new BasicLogic.equals();
            TreeSet<Mixed> values = new TreeSet<Mixed>((t1, t2) -> {
                if (equals2.exec(Target.UNKNOWN, null, (Mixed)t1, (Mixed)t2).getBoolean()) {
                    return 0;
                }
                return t1.val().compareTo(t2.val());
            });
            boolean hasDefaultCase = (children.size() & 1) == 0;
            for (int i = 1; !(i >= children.size() || hasDefaultCase && i == children.size() - 1); i += 2) {
                if (children.get(i).getData() instanceof CFunction && new DataHandling.array().getName().equals(children.get(i).getData().val())) {
                    CArray data = new CArray(t);
                    for (ParseTree child : children.get(i).getChildren()) {
                        if (Construct.IsDynamicHelper(child.getData())) {
                            throw new ConfigCompileException(notConstant, child.getTarget());
                        }
                        data.push(child.getData(), t);
                    }
                    children.set(i, new ParseTree(data, children.get(i).getFileOptions()));
                }
                if (children.get(i).getData().isInstanceOf(CArray.TYPE)) {
                    List<Mixed> list = ((CArray)children.get(i).getData()).asList();
                    for (Mixed c : list) {
                        if (c instanceof CSlice) {
                            for (Mixed cc : ((CSlice)c).asList()) {
                                if (values.contains(cc)) {
                                    throw new ConfigCompileException(alreadyContains, cc.getTarget());
                                }
                                values.add(cc);
                            }
                            continue;
                        }
                        if (Construct.IsDynamicHelper(c)) {
                            throw new ConfigCompileException(notConstant, c.getTarget());
                        }
                        if (values.contains(c)) {
                            throw new ConfigCompileException(alreadyContains, c.getTarget());
                        }
                        values.add(c);
                    }
                    continue;
                }
                Mixed c = children.get(i).getData();
                if (Construct.IsDynamicHelper(c)) {
                    throw new ConfigCompileException(notConstant, c.getTarget());
                }
                if (values.contains(c)) {
                    throw new ConfigCompileException(alreadyContains, c.getTarget());
                }
                values.add(c);
            }
            if ((children.size() > 3 || children.size() > 1 && children.get(1).getData().isInstanceOf(CArray.TYPE)) && children.size() > 0 && !Construct.IsDynamicHelper(children.get(0).getData())) {
                ParseTree toReturn = null;
                block4: for (int i = 1; i < children.size(); i += 2) {
                    Mixed data = children.get(i).getData();
                    if (!data.isInstanceOf(CArray.TYPE) || data instanceof CSlice) {
                        data = new CArray(t);
                        ((CArray)data).push(children.get(i).getData(), t);
                    }
                    for (Mixed value : ((CArray)data).asList()) {
                        if (value instanceof CSlice) {
                            long rangeLeft = ((CSlice)value).getStart();
                            long rangeRight = ((CSlice)value).getFinish();
                            if (!children.get(0).getData().isInstanceOf(CInt.TYPE)) continue;
                            long v = ArgumentValidation.getInt(children.get(0).getData(), t);
                            if (!(rangeLeft < rangeRight && v >= rangeLeft && v <= rangeRight || rangeLeft > rangeRight && v >= rangeRight && v <= rangeLeft) && (rangeLeft != rangeRight || v != rangeLeft)) continue;
                            toReturn = children.get(i + 1);
                            continue block4;
                        }
                        if (!equals2.exec(t, null, children.get(0).getData(), value).getBoolean()) continue;
                        toReturn = children.get(i + 1);
                        continue block4;
                    }
                }
                if (toReturn == null) {
                    if (children.size() % 2 == 0) {
                        toReturn = children.get(children.size() - 1);
                    } else {
                        return Optimizable.REMOVE_ME;
                    }
                }
                ParseTree ret = new ParseTree(new CFunction(new _switch().getName(), t), fileOptions);
                ret.addChild(new ParseTree(new CInt(1L, t), fileOptions));
                ret.addChild(new ParseTree(new CInt(1L, t), fileOptions));
                ret.addChild(toReturn);
                return ret;
            }
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC, Optimizable.OptimizationOption.PRIORITY_OPTIMIZATION);
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> branches = new ArrayList<Boolean>(children.size());
            branches.add(false);
            if (children.size() == 2) {
                branches.add(true);
            } else {
                for (int i = 1; i < children.size() - 1; i += 2) {
                    branches.add(false);
                    branches.add(true);
                }
                if (children.size() % 2 == 0) {
                    branches.add(true);
                }
            }
            return branches;
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            return this.isBranch(children);
        }
    }

    @api(environments={GlobalEnv.class})
    public static class ifelse
    extends AbstractFunction
    implements Optimizable,
    BranchStatement,
    VariableScope {
        @Override
        public String getName() {
            return "ifelse";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "mixed {[boolean1, code]..., [elseCode]} Provides a more convenient method for running if/else chains. If none of the conditions are true, and there is no 'else' condition, void is returned.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREInsufficientArgumentsException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public boolean preResolveVariables() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return CNull.NULL;
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            if (nodes.length < 2) {
                throw new CREInsufficientArgumentsException("ifelse expects at least 2 arguments", t);
            }
            for (int i = 0; i <= nodes.length - 2; i += 2) {
                ParseTree statement = nodes[i];
                ParseTree code = nodes[i + 1];
                Mixed evalStatement = parent.seval(statement, env);
                if (evalStatement instanceof CIdentifier) {
                    evalStatement = parent.seval(((CIdentifier)evalStatement).contained(), env);
                }
                if (!ArgumentValidation.getBooleanish(evalStatement, t)) continue;
                Mixed ret = env.getEnv(GlobalEnv.class).GetScript().eval(code, env);
                return ret;
            }
            if (nodes.length % 2 == 1) {
                Mixed ret = env.getEnv(GlobalEnv.class).GetScript().seval(nodes[nodes.length - 1], env);
                if (ret instanceof CIdentifier) {
                    return parent.seval(((CIdentifier)ret).contained(), env);
                }
                return ret;
            }
            return CVoid.VOID;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            Scope firstCondScope = null;
            for (int i = 0; i <= ast.numberOfChildren() - 2; i += 2) {
                ParseTree cond = ast.getChildAt(i);
                ParseTree code = ast.getChildAt(i + 1);
                Scope condScope = analysis.linkScope(parentScope, cond, env, exceptions);
                if (firstCondScope == null) {
                    firstCondScope = condScope;
                }
                analysis.linkScope(analysis.createNewScope(condScope), code, env, exceptions);
            }
            if ((ast.numberOfChildren() & 1) == 1) {
                analysis.linkScope(analysis.createNewScope(parentScope), ast.getChildAt(ast.numberOfChildren() - 1), env, exceptions);
            }
            return firstCondScope != null ? firstCondScope : parentScope;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Functional usage", "ifelse(false, msg('This is false'), true, msg('This is true'))"), new ExampleScript("With braces", "if(false){\n\tmsg('This is false')\n} else {\n\tmsg('This is true')\n}"), new ExampleScript("With braces, with else if", "if(false){\n\tmsg('This will not show')\n} else if(false){\n\n\tmsg('This will not show')\n} else {\n\tmsg('This will show')\n}")};
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> branches = new ArrayList<Boolean>(children.size());
            branches.add(false);
            for (int i = 1; i < children.size(); ++i) {
                branches.add(true);
            }
            return branches;
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            return this.isBranch(children);
        }
    }

    @api
    public static class _if
    extends AbstractFunction
    implements Optimizable,
    BranchStatement,
    VariableScope {
        private static final String and = new BasicLogic.and().getName();

        @Override
        public String getName() {
            return "if";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
            ParseTree __else;
            for (ParseTree node : nodes) {
                if (!(node.getData() instanceof CIdentifier)) continue;
                return new ifelse().execs(t, env, parent, nodes);
            }
            ParseTree condition = nodes[0];
            ParseTree __if = nodes[1];
            ParseTree parseTree = __else = nodes.length == 3 ? nodes[2] : null;
            if (ArgumentValidation.getBooleanish(parent.seval(condition, env), t)) {
                return parent.seval(__if, env);
            }
            if (__else == null) {
                return CVoid.VOID;
            }
            return parent.seval(__else, env);
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            return CVoid.VOID;
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
            if (ast.numberOfChildren() < 2) {
                return parentScope;
            }
            Scope condScope = analysis.linkScope(parentScope, ast.getChildAt(0), env, exceptions);
            analysis.linkScope(analysis.createNewScope(condScope), ast.getChildAt(1), env, exceptions);
            if (ast.numberOfChildren() == 3) {
                analysis.linkScope(analysis.createNewScope(condScope), ast.getChildAt(2), env, exceptions);
            }
            return condScope;
        }

        @Override
        public String docs() {
            return "mixed {cond, trueRet, [falseRet]} If the first argument evaluates to a true value, the second argument is returned, otherwise the third argument is returned. If there is no third argument, it returns void.";
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public boolean preResolveVariables() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return false;
        }

        @Override
        public boolean useSpecialExec() {
            return true;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> args, FileOptions fileOptions) throws ConfigCompileException {
            ParseTree _if2;
            if (args.size() < 2) {
                throw new ConfigCompileException("Too few arguments passed to if()", t);
            }
            if (args.size() > 3) {
                throw new ConfigCompileException("if() can only have 3 parameters", t);
            }
            if (args.get(0).isConst()) {
                if (ArgumentValidation.getBoolean(args.get(0).getData(), t)) {
                    return args.get(1);
                }
                if (args.size() == 3) {
                    return args.get(2);
                }
                return Optimizable.REMOVE_ME;
            }
            if (args.get(1).getData() instanceof CFunction && args.get(1).getData().val().equals("if") && args.size() == 2 && (_if2 = args.get(1)).getChildren().size() == 2) {
                ParseTree myCondition = args.get(0);
                ParseTree theirCondition = _if2.getChildAt(0);
                ParseTree theirCode = _if2.getChildAt(1);
                ParseTree andClause = new ParseTree(new CFunction(and, t), fileOptions);
                if (myCondition.getData() instanceof CFunction && myCondition.getData().val().equals(and)) {
                    andClause = myCondition;
                    andClause.addChild(theirCondition);
                } else {
                    andClause.addChild(myCondition);
                    andClause.addChild(theirCondition);
                }
                args.set(0, andClause);
                args.set(1, theirCode);
            }
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Functional usage", "if(true, msg('This is true'), msg('This is false'))"), new ExampleScript("With braces, true condition", "if(true){\n\tmsg('This is true')\n}"), new ExampleScript("With braces, false condition", "msg('Start')\nif(false){\n\tmsg('This will not show')\n}\nmsg('Finish')")};
        }

        @Override
        public List<Boolean> isBranch(List<ParseTree> children) {
            ArrayList<Boolean> branches = new ArrayList<Boolean>(children.size());
            branches.add(false);
            for (int i = 1; i < children.size(); ++i) {
                branches.add(true);
            }
            return branches;
        }

        @Override
        public List<Boolean> isScope(List<ParseTree> children) {
            return this.isBranch(children);
        }
    }
}

