/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.MEnum;
import com.laytonsmith.annotations.OperatorPreferred;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.core;
import com.laytonsmith.annotations.noboilerplate;
import com.laytonsmith.annotations.noprofile;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.compiler.OptimizationUtilities;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.constructs.CLabel;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CResource;
import com.laytonsmith.core.constructs.CSecureString;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREInsufficientArgumentsException;
import com.laytonsmith.core.exceptions.CRE.CRENullPointerException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.CancelCommandException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.ArrayHandling;
import com.laytonsmith.core.functions.Compiler;
import com.laytonsmith.core.functions.CompositeFunction;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.Meta;
import com.laytonsmith.core.functions.ResourceManager;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.natives.interfaces.Sizeable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;

@core
public class StringHandling {
    public static String docs() {
        return "These class provides functions that allow strings to be manipulated";
    }

    @api
    public static class uuid
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            UUIDType type = UUIDType.RANDOM;
            String input = null;
            if (args.length > 0) {
                type = ArgumentValidation.getEnum(args[0], UUIDType.class, t);
            }
            if (args.length > 1) {
                input = Construct.nval(args[1]);
            }
            return new CString(type.generate(input).toString(), t);
        }

        @Override
        public String getName() {
            return "uuid";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0, 1, 2};
        }

        @Override
        public String docs() {
            return "string {type, arg} Returns a UUID (also known as a GUID). Different types of UUIDs can be generated, by default, if no parameters are provided, a random uuid is returned (version 4). For full details on what exactly a uuid is, and what the different versions are, see https://en.wikipedia.org/wiki/Universally_unique_identifier. The arg varies depending on the type, some types do not require an argument, in which case, this parameter will be ignored. <code>type</code> may be one of:\n- " + StringUtils.Join(UUIDType.values(), "\n- ", "\n- ", "\n- ", "", type -> type.name() + " - " + ((UUIDType)type).description + ". This type takes " + StringUtils.PluralTemplateHelper(((UUIDType)type).parameters, "%d argument.", "%d arguments."));
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_3;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Typical usage", "uuid()", "46fa3d0e-0178-4384-8a9c-2f0df1cada2b"), new ExampleScript("Explicit RANDOM uuid", "uuid('RANDOM')", "fb9f9a7b-76c2-40e3-ba20-8ab23553b9d6"), new ExampleScript("NIL uuid", "uuid('NIL')")};
        }

        @MEnum(value="ms.lang.UUIDType")
        public static enum UUIDType {
            RANDOM("Returns a random UUID", 0, input -> UUID.randomUUID()),
            NIL("Returns the nil UUID, that is 00000000-0000-0000-0000-000000000000", 0, input -> new UUID(0L, 0L));

            private final String description;
            private final int parameters;
            private final Generate generator;

            private UUIDType(String description, int parameters, Generate g2) {
                this.description = description;
                this.parameters = parameters;
                this.generator = g2;
            }

            public UUID generate(String input) {
                return this.generator.g(input);
            }

            private static interface Generate {
                public UUID g(String var1);
            }
        }
    }

    @api
    @seealso(value={secure_string.class})
    public static class decrypt_secure_string
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args[0].isInstanceOf(CSecureString.TYPE)) {
                CSecureString secure = ArgumentValidation.getObject(args[0], t, CSecureString.class);
                return secure.getDecryptedCharCArray();
            }
            if (args[0].isInstanceOf(CString.TYPE)) {
                CArray array2 = new CArray(Target.UNKNOWN, args[0].val().length());
                for (char c : args[0].val().toCharArray()) {
                    array2.push(new CString(c, t), t);
                }
                return array2;
            }
            throw new CRECastException("Can only accept strings in " + this.getName(), t);
        }

        @Override
        public String getName() {
            return "decrypt_secure_string";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "array {string} Decrypts a secure_string into a char array. To keep backwards compatibility with strings in general, this function also accepts normal strings, which are not decrypted, but instead simply returned in the same format as if it were a secure_string. See the examples in {{function|secure_string}}.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Use of secure_string and string", "string @secure = secure_string('secure');\nstring @insecure = 'insecure';\nmsg(@secure);\nmsg(@insecure);\nmsg(decrypt_secure_string(@secure));\nmsg(decrypt_secure_string(@insecure));\nmsg(typeof(@secure));\nmsg(typeof(@insecure));\n")};
        }
    }

    @api
    @seealso(value={decrypt_secure_string.class})
    @noboilerplate
    public static class secure_string
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args[0].isInstanceOf(CArray.TYPE)) {
                CArray array2 = ArgumentValidation.getArray(args[0], t);
                return new CSecureString(array2, t);
            }
            String s = args[0].val();
            return new CSecureString(s.toCharArray(), t);
        }

        @Override
        public String getName() {
            return "secure_string";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "secure_string {charArray|string} Constructs a secure_string from a given char array or string. ---- A secure_string is a string which cannot normally be toString'd, and whose underlying representation is encrypted in memory. This should be used for storing passwords or other sensitive data which should in no cases be stored in plain text. Since this extends string, it can generally be used in place of a string, and when done so, cannot accidentally be exposed (via logs or exception messages, or other accidental exposure) unless it is specifically instructed to decrypt and switch to a char array. While this cannot by itself ensure security of the value, it can help prevent most accidental exposures of data by intermediate code. When exported as a string (or imported as a string) other code must be written to ensure safety of those systems. It is recommended that a secure value never be stored as a string, however, this method accepts a string for compatibility reasons.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Demonstrates secure value", "msg(secure_string(\"test\"));"), new ExampleScript("Demonstrates common usage", "secure_string @secure = secure_string(array('p','a','s','s'));\nmsg(@secure); // Won't print the actual password to screen\nmsg(decrypt_secure_string(@secure)); // Prints the actual password (as a char array)"), new ExampleScript("Demonstrates compatibility with other functions", "@profile = array(\n\tuser: 'username',\n\tpassword: secure_string('password')\n);\nmsg(@profile);"), new ExampleScript("Demonstrates compatibility with string class", "string @sec = secure_string('password'); // Not an error, because secure_string extends string\nmsg(decrypt_secure_string(@sec));")};
        }
    }

    @api
    public static class string_multiply
    extends AbstractFunction {
        private static final int PAD_LIMIT = 8192;

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRERangeException.class, CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args[0] instanceof CNull) {
                return CNull.NULL;
            }
            String string = args[0].val();
            int times = ArgumentValidation.getInt32(args[1], t);
            if (times < 0) {
                throw new CRERangeException("Expecting a value >= 0, but " + times + " was found.", t);
            }
            if (times == 0 || string.isEmpty()) {
                return new CString("", t);
            }
            String s = string_multiply.repeat(string, times);
            return new CString(s, t);
        }

        private static String repeat(String str, int repeat) {
            int inputLength = str.length();
            if (repeat == 1 || inputLength == 0) {
                return str;
            }
            if (inputLength == 1 && repeat <= 8192) {
                return string_multiply.padding(repeat, str.charAt(0));
            }
            int outputLength = inputLength * repeat;
            switch (inputLength) {
                case 1: {
                    char ch = str.charAt(0);
                    char[] output1 = new char[outputLength];
                    for (int i = repeat - 1; i >= 0; --i) {
                        output1[i] = ch;
                    }
                    return new String(output1);
                }
                case 2: {
                    char ch0 = str.charAt(0);
                    char ch1 = str.charAt(1);
                    char[] output2 = new char[outputLength];
                    for (int i = repeat * 2 - 2; i >= 0; --i) {
                        output2[i] = ch0;
                        output2[i + 1] = ch1;
                        --i;
                    }
                    return new String(output2);
                }
            }
            StringBuilder buf = new StringBuilder(outputLength);
            for (int i = 0; i < repeat; ++i) {
                buf.append(str);
            }
            return buf.toString();
        }

        private static String padding(int repeat, char padChar) throws IndexOutOfBoundsException {
            char[] buf = new char[repeat];
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = padChar;
            }
            return new String(buf);
        }

        @Override
        public String getName() {
            return "string_multiply";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "string {string, times} Multiplies a string the given number of times. For instance, string_multiply('a', 3) returns 'aaa'. If the string is empty, an empty string is returned. If the string is null, null is returned. If times is 0, an empty string is returned. All other string values are multiplied accordingly. Providing a value less than 0 for times results in a RangeException.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "string_multiply('a', 4)")};
        }
    }

    @api
    public static class levenshtein
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return new CInt(StringUtils.LevenshteinDistance(args[0].val(), args[1].val()), t);
        }

        @Override
        public String getName() {
            return "levenshtein";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "int {string1, string2} Returns the levenshtein distance of two character sequences. For instance, \"123\" and \"133\" would have a string distance of 1, while \"123\" and \"123\" would be 0, since they are the same string.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("", "levenshtein('123', '123')"), new ExampleScript("", "levenshtein('test', 'testing')"), new ExampleScript("", "levenshtein('133', '123')")};
        }
    }

    @api
    public static class unicode_from_char
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CRERangeException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args[0].val().toCharArray().length == 0) {
                throw new CRERangeException("Empty string cannot be converted to unicode.", t);
            }
            int i = Character.codePointAt(args[0].val().toCharArray(), 0);
            return new CInt(i, t);
        }

        @Override
        public String getName() {
            return "unicode_from_char";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "int {character} Returns the unicode code point for a given character. The character is a string, but it should only be 1 code point character (which may be length(@character) == 2).";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "to_radix(unicode_from_char('\\u2665'), 16)")};
        }
    }

    @api
    public static class char_from_unicode
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CRERangeException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            try {
                return new CString(new String(Character.toChars(ArgumentValidation.getInt32(args[0], t))), t);
            }
            catch (IllegalArgumentException ex) {
                throw new CRERangeException("Code point out of range: " + args[0].val(), t);
            }
        }

        @Override
        public String getName() {
            return "char_from_unicode";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "string {unicode} Returns the unicode character for a given unicode value. This is meant for dynamic input that needs converting to a unicode character, if you're hardcoding it, you should just use '\\u1234' syntax instead, however, this is the dynamic equivalent of the \\u string escape, so '\\u1234' == char_from_unicode(parse_int('1234', 16)) == char_from_unicode(0x1234). Despite the name, certain unicode escapes may return multiple characters, so there is no guarantee that length(char_from_unicode(@val)) will equal 1.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "char_from_unicode(parse_int('2665', 16))")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE);
        }
    }

    @api
    public static class string_append
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (args.length < 2) {
                throw new CREInsufficientArgumentsException(this.getName() + " must have 2 arguments at minimum", t);
            }
            CResource m = (CResource)args[0];
            StringBuffer buf = ResourceManager.GetResource(m, StringBuffer.class, t);
            for (int i = 1; i < args.length; ++i) {
                buf.append(args[i].val());
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "string_append";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "void {resource, toAppend...} Appends any number of values to the underlying string builder. This is much more efficient than doing normal concatenation with a string when building a string in a loop. The underlying resource may be converted to a string via a cast, string(@res).";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "@res = res_create_resource('STRING_BUILDER')\nforeach(1..50, @i,\n\tstring_append(@res, @i, '.')\n)\n@string = string(@res)\nres_free_resource(@res) #This line is super important!\nmsg(@string)"), new ExampleScript("Basic usage, showing performance benefits", "@to = 100000\n@t1 = time()\n@res = res_create_resource('STRING_BUILDER')\nforeach(range(0, @to), @i,\n\tstring_append(@res, @i, '.')\n)\nres_free_resource(@res)\n@t2 = time()\n@t3 = time()\n@str = ''\nforeach(range(0, @to), @i,\n\t@str .= @i . '.'\n)\n@t4 = time()\nmsg('Task 1 took '.(@t2 - @t1).'ms under '.@to.' iterations')\nmsg('Task 2 took '.(@t4 - @t3).'ms under '.@to.' iterations')", "Task 1 took 542ms under 100000 iterations\nTask 2 took 28305ms under 100000 iterations\n")};
        }
    }

    @api
    public static class string_from_bytes
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            CByteArray ba2 = ArgumentValidation.getByteArray(args[0], t);
            String encoding = "UTF-8";
            if (args.length == 2) {
                encoding = args[1].val();
            }
            try {
                return new CString(new String(ba2.asByteArrayCopy(), encoding), t);
            }
            catch (UnsupportedEncodingException ex) {
                throw new CREFormatException("Unknown encoding type \"" + encoding + "\"", t);
            }
        }

        @Override
        public String getName() {
            return "string_from_bytes";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "string {byte_array, [encoding]} Returns a new string, given the byte array encoding provided. The encoding defaults to UTF-8, but may be specified. A FormatException is thrown if the encoding type is invalid.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class string_get_bytes
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class, CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            String val = args[0].val();
            String encoding = "UTF-8";
            if (args.length == 2) {
                encoding = args[1].val();
            }
            try {
                return CByteArray.wrap(val.getBytes(encoding), t);
            }
            catch (UnsupportedEncodingException ex) {
                throw new CREFormatException("Unknown encoding type \"" + encoding + "\"", t);
            }
        }

        @Override
        public String getName() {
            return "string_get_bytes";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public String docs() {
            return "byte_array {string, [encoding]} Returns this string as a byte_array, encoded using the specified encoding, or UTF-8 if no encoding is specified. Valid encodings are the encoding types that java supports. If the encoding is invalid, a FormatException is thrown.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    @seealso(value={lsprintf.class})
    public static class sprintf
    extends lsprintf
    implements Optimizable {
        @Override
        public String getName() {
            return "sprintf";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public String docs() {
            return "string {formatString, parameters... | formatString, array(parameters...)} Returns a string formatted to the given formatString specification, using the parameters passed in. The formatString should be formatted according to [http://docs.oracle.com/javase/6/docs/api/java/util/Formatter.html#syntax this standard], with the caveat that the parameter types are automatically cast to the appropriate type, if possible. Calendar/time specifiers, (t and T) expect an integer which represents unix time, but are otherwise valid. All format specifiers in the documentation are valid. This works the same as lsprintf with the locale set to \"DEFAULT\".";
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() < 1) {
                throw new ConfigCompileException(this.getName() + " expects at least 1 argument", t);
            }
            children.add(0, new ParseTree(CNull.NULL, fileOptions));
            return super.optimizeDynamic(t, env, envs, children, fileOptions);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "sprintf('%d', 1)"), new ExampleScript("Multiple arguments", "sprintf('%d%d', 1, '2')"), new ExampleScript("Multiple arguments in an array", "sprintf('%d%d', array(1, 2))"), new ExampleScript("Compile error, missing parameters", "sprintf('%d')", true), new ExampleScript("Other formatting: float with precision (using integer)", "sprintf('%07.3f', 4)"), new ExampleScript("Other formatting: float with precision (with rounding)", "sprintf('%07.3f', 3.4567)"), new ExampleScript("Other formatting: time", "sprintf('%1$tm %1$te,%1$tY', time())", ":06 13,2013"), new ExampleScript("Literal percent sign", "sprintf('%'.'%') // The concatenation is to prevent the website's template system from overriding. It is not needed.", "%"), new ExampleScript("Hexidecimal formatting", "sprintf('%x', 15)"), new ExampleScript("Other formatting: character", "sprintf('%c', 's')"), new ExampleScript("Other formatting: character (with capitalization)", "sprintf('%C', 's')"), new ExampleScript("Other formatting: scientific notation", "sprintf('%e', '2345')"), new ExampleScript("Other formatting: plain string", "sprintf('%s', 'plain string')"), new ExampleScript("Other formatting: boolean", "sprintf('%b', 1)"), new ExampleScript("Other formatting: boolean (with capitalization)", "sprintf('%B', 0)"), new ExampleScript("Other formatting: hash code", "sprintf('%h', 'will be hashed')")};
        }
    }

    @api
    @seealso(value={sprintf.class, Meta.get_locales.class})
    public static class lsprintf
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class, CREInsufficientArgumentsException.class, CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            int i;
            List<FormatString> parsed;
            if (args.length < 2) {
                throw new CREInsufficientArgumentsException(this.getName() + " expects 2 or more arguments", t);
            }
            int numArgs = args.length;
            Locale locale = null;
            String countryCode = Construct.nval(args[0]);
            locale = countryCode == null ? Locale.getDefault() : Static.GetLocale(countryCode);
            if (locale == null) {
                throw new CREFormatException("The given locale was not found on your system: " + countryCode, t);
            }
            String formatString = args[1].val();
            try {
                parsed = this.parse(formatString, t);
            }
            catch (IllegalFormatException e) {
                throw new CREFormatException(e.getMessage(), t);
            }
            ArrayList<Mixed> flattenedArgs = new ArrayList<Mixed>();
            if (numArgs == 3 && args[2].isInstanceOf(CArray.TYPE)) {
                if (((CArray)args[2]).inAssociativeMode()) {
                    throw new CRECastException("If the second argument to " + this.getName() + " is an array, it may not be associative.", t);
                }
                i = 0;
                while ((long)i < ((CArray)args[2]).size()) {
                    flattenedArgs.add(((CArray)args[2]).get(i, t));
                    ++i;
                }
            } else {
                for (i = 2; i < numArgs; ++i) {
                    flattenedArgs.add(args[i]);
                }
            }
            if (this.requiredArgs(parsed) != flattenedArgs.size()) {
                throw new CREInsufficientArgumentsException("The specified format string: \"" + formatString + "\" expects " + this.requiredArgs(parsed) + " argument(s), but " + flattenedArgs.size() + " were provided.", t);
            }
            Object[] params = new Object[flattenedArgs.size()];
            for (int i2 = 0; i2 < this.requiredArgs(parsed); ++i2) {
                Mixed arg = (Mixed)flattenedArgs.get(i2);
                FormatString fs = parsed.get(i2);
                Character c = fs.getExpectedType();
                params[i2] = this.convertArgument(arg, c, i2, t);
            }
            return new CString(String.format(locale, formatString, params), t);
        }

        private Object convertArgument(Mixed arg, Character c, int i, Target t) {
            Object o;
            if (Conversion.isValid(c.charValue())) {
                if (c.charValue() == 't' || c.charValue() == 'T') {
                    o = ArgumentValidation.getInt(arg, t);
                } else if (Conversion.isCharacter(c.charValue())) {
                    String s = arg.val();
                    if (s.length() > 1) {
                        throw new CREFormatException("Expecting a string of length one in argument " + (i + 1) + " in " + this.getName() + "but \"" + s + "\" was found instead.", t);
                    }
                    o = Character.valueOf(s.charAt(0));
                } else {
                    o = Conversion.isFloat(c.charValue()) ? Double.valueOf(ArgumentValidation.getDouble(arg, t)) : (Conversion.isInteger(c.charValue()) ? Long.valueOf(ArgumentValidation.getInt(arg, t)) : (c.charValue() == 'b' || c.charValue() == 'B' ? Boolean.valueOf(ArgumentValidation.getBoolean(arg, t)) : arg.val()));
                }
            } else {
                throw ConfigRuntimeException.CreateUncatchableException("Conversion is invalid: " + c, t);
            }
            return o;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            String locale;
            if (children.size() < 2) {
                throw new ConfigCompileException(this.getName() + " expects 2 or more argument", t);
            }
            if (children.get(0).isConst() && (locale = Construct.nval(children.get(0).getData())) != null && Static.GetLocale(locale) == null) {
                throw new ConfigCompileException("The locale " + locale + " could not be found on this system", t);
            }
            if (children.get(1).isConst()) {
                ParseTree me = new ParseTree(new CFunction(this.getName(), t), children.get(1).getFileOptions());
                me.setChildren(children);
                me.setOptimized(true);
                if (children.size() == 3 && children.get(2).getData() instanceof CFunction && ((CFunction)children.get(2).getData()).getFunction().getName().equals(new DataHandling.array().getName())) {
                    ParseTree array2 = children.get(2);
                    children.remove(2);
                    boolean allIndexesStatic = true;
                    for (int i = 0; i < array2.numberOfChildren(); ++i) {
                        ParseTree child = array2.getChildAt(i);
                        if (child.isDynamic()) {
                            allIndexesStatic = false;
                        }
                        children.add(child);
                    }
                    if (allIndexesStatic) {
                        me.hasBeenMadeStatic(true);
                    }
                }
                try {
                    List<FormatString> parsed = this.parse(children.get(1).getData().val(), t);
                    if (this.requiredArgs(parsed) != children.size() - 2) {
                        throw new CREInsufficientArgumentsException("The specified format string: \"" + children.get(1).getData().val() + "\" expects " + this.requiredArgs(parsed) + " argument(s), but " + (children.size() - 2) + " were provided.", t);
                    }
                    for (int i = 2; i < children.size(); ++i) {
                        if (!children.get(i).isConst()) continue;
                        this.convertArgument(children.get(i).getData(), parsed.get(i - 2).getExpectedType(), i, t);
                    }
                }
                catch (IllegalFormatException e) {
                    throw new CREFormatException(e.getMessage(), t);
                }
                return me;
            }
            return null;
        }

        private List<FormatString> parse(String format, Target t) {
            Object parse;
            ArrayList<FormatString> list = new ArrayList<FormatString>();
            try {
                parse = ReflectionUtils.invokeMethod(Formatter.class, new Formatter(), "parse", new Class[]{String.class}, new Object[]{format});
            }
            catch (ReflectionUtils.ReflectionException e) {
                if (e.getCause() instanceof InvocationTargetException) {
                    Throwable th = e.getCause().getCause();
                    throw new CREFormatException("A format exception was thrown for the argument \"" + format + "\": " + th.getClass().getSimpleName() + ": " + th.getMessage(), t);
                }
                throw ConfigRuntimeException.CreateUncatchableException(e.getMessage(), t);
            }
            Arrayable a = new Arrayable(parse);
            int length2 = a.length();
            for (int i = 0; i < length2; ++i) {
                FormatString s = new FormatString(a.get(i));
                if (s.getExpectedType() == null) continue;
                list.add(s);
            }
            return list;
        }

        private int requiredArgs(List<FormatString> list) {
            HashSet<Integer> knownIndexes = new HashSet<Integer>();
            int count = 0;
            for (FormatString s : list) {
                if (s.isFixed()) continue;
                int index = s.getArgIndex();
                if (index == 0) {
                    ++count;
                    continue;
                }
                knownIndexes.add(index);
            }
            return count += knownIndexes.size();
        }

        @Override
        public String getName() {
            return "lsprintf";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public String docs() {
            return "string {locale, formatString, parameters... | locale, formatString, array(parameters...)} Returns a string formatted to the given formatString specification, using the parameters passed in. Locale should be a string in format, for instance, en_US, nl_NL, no_NO... Which locales are available depends on your system. Use null to use the system's locale. The formatString should be formatted according to [http://docs.oracle.com/javase/6/docs/api/java/util/Formatter.html#syntax this standard], with the caveat that the parameter types are automatically cast to the appropriate type, if possible. Calendar/time specifiers, (t and T) expect an integer which represents unix time, but are otherwise valid. All format specifiers in the documentation are valid.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "lsprintf('en_US', '%d', 1)"), new ExampleScript("Multiple arguments", "lsprintf('en_US', '%d%d', 1, '2')"), new ExampleScript("Multiple arguments in an array", "lsprintf('en_US', '%d%d', array(1, 2))"), new ExampleScript("Compile error, missing parameters", "lsprintf('en_US', '%d')", true), new ExampleScript("Other formatting: float with precision (using integer)", "lsprintf('en_US', '%07.3f', 4)"), new ExampleScript("Other formatting: float with precision (with rounding)", "lsprintf('en_US', '%07.3f', 3.4567)"), new ExampleScript("Other formatting: float with precision in a different locale (with rounding)", "lsprintf('nl_NL', '%07.3f', 3.4567)"), new ExampleScript("Other formatting: time", "lsprintf('en_US', '%1$tm %1$te,%1$tY', time())", ":06 13,2013"), new ExampleScript("Literal percent sign", "lsprintf('en_US', '%'.'%') // The concatenation is to prevent the website's template system from overriding. It is not needed.", "%"), new ExampleScript("Hexidecimal formatting", "lsprintf('en_US', '%x', 15)"), new ExampleScript("Other formatting: character", "lsprintf('en_US', '%c', 's')"), new ExampleScript("Other formatting: character (with capitalization)", "lsprintf('en_US', '%C', 's')"), new ExampleScript("Other formatting: scientific notation", "lsprintf('en_US', '%e', '2345')"), new ExampleScript("Other formatting: plain string", "lsprintf('en_US', '%s', 'plain string')"), new ExampleScript("Other formatting: boolean", "lsprintf('en_US', '%b', 1)"), new ExampleScript("Other formatting: boolean (with capitalization)", "lsprintf('en_US', '%B', 0)"), new ExampleScript("Other formatting: hash code", "lsprintf('en_US', '%h', 'will be hashed')")};
        }

        private static class Arrayable {
            private final Object t;

            public Arrayable(Object o) {
                this.t = o;
            }

            public int length() {
                if (this.t instanceof List) {
                    return ((List)this.t).size();
                }
                return Array.getLength(this.t);
            }

            public Object get(int i) {
                if (this.t instanceof List) {
                    return ((List)this.t).get(i);
                }
                return Array.get(this.t, i);
            }
        }

        private static class FormatString {
            private Object ref;
            private static final Class FORMAT_STRING;
            private static final Class FIXED_STRING;
            private static final Class FORMAT_SPECIFIER;

            public FormatString(Object ref) {
                if (ref == null) {
                    throw new NullPointerException();
                }
                if (!FORMAT_STRING.isAssignableFrom(ref.getClass())) {
                    throw new RuntimeException("Unexpected class type. Was expecting ref to be an instance of " + FORMAT_STRING.getName() + " but was " + ref.getClass().getName());
                }
                this.ref = ref;
            }

            public Character getExpectedType() {
                if (this.ref.getClass() == FIXED_STRING) {
                    return null;
                }
                if (this.ref.getClass() == FORMAT_SPECIFIER) {
                    if (((Boolean)ReflectionUtils.get(FORMAT_SPECIFIER, this.ref, "dt")).booleanValue()) {
                        return Character.valueOf('t');
                    }
                    return (Character)ReflectionUtils.get(FORMAT_SPECIFIER, this.ref, "c");
                }
                throw new RuntimeException("Unknown type: " + this.ref.getClass());
            }

            public int getArgIndex() {
                return (Integer)ReflectionUtils.get(FORMAT_SPECIFIER, this.ref, "index");
            }

            public boolean isFixed() {
                return this.getExpectedType().charValue() == '%' || this.getExpectedType().charValue() == 'n';
            }

            static {
                Class<?> tFormatString = null;
                Class<?> tFixedString = null;
                Class<?> tFormatSpecifier = null;
                for (Class<?> c : Formatter.class.getDeclaredClasses()) {
                    if (c.getSimpleName().equals("FormatString")) {
                        tFormatString = c;
                        continue;
                    }
                    if (c.getSimpleName().equals("FixedString")) {
                        tFixedString = c;
                        continue;
                    }
                    if (!c.getSimpleName().equals("FormatSpecifier")) continue;
                    tFormatSpecifier = c;
                }
                FORMAT_STRING = tFormatString;
                FIXED_STRING = tFixedString;
                FORMAT_SPECIFIER = tFormatSpecifier;
            }
        }

        private static class Conversion {
            static final char DECIMAL_INTEGER = 'd';
            static final char OCTAL_INTEGER = 'o';
            static final char HEXADECIMAL_INTEGER = 'x';
            static final char HEXADECIMAL_INTEGER_UPPER = 'X';
            static final char SCIENTIFIC = 'e';
            static final char SCIENTIFIC_UPPER = 'E';
            static final char GENERAL = 'g';
            static final char GENERAL_UPPER = 'G';
            static final char DECIMAL_FLOAT = 'f';
            static final char HEXADECIMAL_FLOAT = 'a';
            static final char HEXADECIMAL_FLOAT_UPPER = 'A';
            static final char CHARACTER = 'c';
            static final char CHARACTER_UPPER = 'C';
            static final char DATE_TIME = 't';
            static final char DATE_TIME_UPPER = 'T';
            static final char BOOLEAN = 'b';
            static final char BOOLEAN_UPPER = 'B';
            static final char STRING = 's';
            static final char STRING_UPPER = 'S';
            static final char HASHCODE = 'h';
            static final char HASHCODE_UPPER = 'H';
            static final char LINE_SEPARATOR = 'n';
            static final char PERCENT_SIGN = '%';

            private Conversion() {
            }

            static boolean isValid(char c) {
                return Conversion.isGeneral(c) || Conversion.isInteger(c) || Conversion.isFloat(c) || Conversion.isText(c) || c == 't' || Conversion.isCharacter(c);
            }

            static boolean isGeneral(char c) {
                switch (c) {
                    case 'B': 
                    case 'H': 
                    case 'S': 
                    case 'b': 
                    case 'h': 
                    case 's': {
                        return true;
                    }
                }
                return false;
            }

            static boolean isCharacter(char c) {
                switch (c) {
                    case 'C': 
                    case 'c': {
                        return true;
                    }
                }
                return false;
            }

            static boolean isInteger(char c) {
                switch (c) {
                    case 'X': 
                    case 'd': 
                    case 'o': 
                    case 'x': {
                        return true;
                    }
                }
                return false;
            }

            static boolean isFloat(char c) {
                switch (c) {
                    case 'A': 
                    case 'E': 
                    case 'G': 
                    case 'a': 
                    case 'e': 
                    case 'f': 
                    case 'g': {
                        return true;
                    }
                }
                return false;
            }

            static boolean isText(char c) {
                switch (c) {
                    case '%': 
                    case 'n': {
                        return true;
                    }
                }
                return false;
            }
        }
    }

    @api
    @seealso(value={ArrayHandling.array_implode.class})
    public static class split
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "split";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "array {split, string, [limit]} Splits a string into parts, using the split as the index. Though it can be used in every single case you would use reg_split, this does not use regex, and therefore can take a literal split expression instead of needing an escaped regex, and *may* perform better than the regex versions, as it uses an optimized tokenizer split, instead of Java regex. Limit defaults to infinity, but if set, only that number of splits will occur.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            CArray array2 = new CArray(t);
            String split2 = args[0].val();
            String string = args[1].val();
            int limit = Integer.MAX_VALUE;
            if (args.length >= 3) {
                limit = ArgumentValidation.getInt32(args[2], t);
            }
            int sp = 0;
            if (split2.length() == 0) {
                for (int i = 0; i < string.length(); ++i) {
                    array2.push(new CString(string.charAt(i), t), t);
                }
                return array2;
            }
            int splitsFound = 0;
            for (int i = 0; i < string.length() - split2.length() && splitsFound < limit; ++i) {
                if (!string.substring(i, i + split2.length()).equals(split2)) continue;
                ++splitsFound;
                array2.push(new CString(string.substring(sp, i), t), t);
                sp = i + split2.length();
                i += split2.length() - 1;
            }
            if (sp != 0) {
                array2.push(new CString(string.substring(sp, string.length()), t), t);
            } else {
                array2.push(args[1], t);
            }
            return array2;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Simple split on one character. Note that unlike reg_split, no escaping is needed on the period.", "split('.', '1.2.3.4.5')"), new ExampleScript("Split with multiple characters", "split('ab', 'aaabaaabaaabaa')"), new ExampleScript("Split all characters", "split('', 'abcdefg')"), new ExampleScript("Split with limit", "split('|', 'this|is|a|limit', 1)")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    @seealso(value={string_contains.class})
    public static class string_contains_ic
    extends CompositeFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENullPointerException.class, CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public String getName() {
            return "string_contains_ic";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "boolean {haystack, needle} Returns true if the string needle is found anywhere within the string haystack (while ignoring case). This is functionally equivalent to string_position(to_lower(@haystack), to_lower(@needle)) != -1, but is generally clearer.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_4;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN, Optimizable.OptimizationOption.NO_SIDE_EFFECTS);
        }

        @Override
        protected String script() {
            return this.getBundledCode();
        }
    }

    @api
    @seealso(value={string_position.class, string_contains_ic.class})
    public static class string_contains
    extends CompositeFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENullPointerException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public String getName() {
            return "string_contains";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "boolean {haystack, needle} Returns true if the string needle is found anywhere within the string haystack. This is functionally equivalent to string_position(@haystack, @needle) != -1, but is generally clearer.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_2;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN, Optimizable.OptimizationOption.NO_SIDE_EFFECTS);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "string_contains('haystack', 'hay');"), new ExampleScript("Not found", "string_contains('abcd', 'wxyz');")};
        }

        @Override
        protected String script() {
            return this.getBundledCode();
        }
    }

    @api
    @seealso(value={string_contains.class})
    public static class string_position
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "string_position";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public String docs() {
            return "int {haystack, needle} Finds the numeric position of the first occurrence of needle in haystack. haystack is the string to search in, and needle is the string to search with. Returns the position of the needle (starting with 0) or -1 if the string is not found at all.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENullPointerException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            String haystack = Construct.nval(args[0]);
            String needle = Construct.nval(args[1]);
            Static.AssertNonCNull(t, args);
            return new CInt(haystack.indexOf(needle), t);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "string_position('this is the string', 'string')"), new ExampleScript("String not found", "string_position('Where\\'s Waldo?', 'Dunno.')")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    public static class char_is_uppercase
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class, CRECastException.class};
        }

        @Override
        public String getName() {
            return "char_is_uppercase";
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            if (!(Construct.nval(args[0]) instanceof String)) {
                throw new CRECastException(this.getName() + " expects a string as first argument, but type " + args[0].typeof() + " was found.", t);
            }
            String text = Construct.nval(args[0]);
            if (text.length() != 1) {
                throw new CREFormatException("Got \"" + text + "\" instead of expected character.", t);
            }
            char check = text.charAt(0);
            if (!Character.isLetter(check)) {
                throw new CREFormatException("Got \"" + text + "\" instead of alphabetical character.", t);
            }
            return CBoolean.get(Character.isUpperCase(check));
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN, Optimizable.OptimizationOption.NO_SIDE_EFFECTS);
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "boolean {char} Determines if the character provided is uppercase or not. The string must be exactly 1 character long and a letter, otherwise a FormatException is thrown.";
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_2;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "char_is_uppercase('a')"), new ExampleScript("Basic usage", "char_is_uppercase('D')")};
        }
    }

    @api
    @seealso(value={string_starts_with.class})
    public static class string_ends_with
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENullPointerException.class};
        }

        @Override
        public String getName() {
            return "string_ends_with";
        }

        @Override
        public String docs() {
            return "boolean {teststring, keyword} Determines if the provided teststring ends with the provided keyword. Note that this will cast both arguments to strings. This means that the boolean true will match the string 'true' or the integer 1 will match the string '1'. If an empty string is provided for the keyword, it will always return true.";
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            Static.AssertNonCNull(t, args);
            String teststring = Construct.nval(args[0]);
            String keyword2 = Construct.nval(args[1]);
            boolean ret = teststring.endsWith(keyword2);
            return CBoolean.get(ret);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "string_ends_with('[ERROR] Bad message here!!', '!')"), new ExampleScript("Basic usage", "string_ends_with('Spaghetti and cheese', 'Spaghetti')")};
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_2;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN, Optimizable.OptimizationOption.NO_SIDE_EFFECTS);
        }
    }

    @api
    @seealso(value={string_ends_with.class})
    public static class string_starts_with
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRENullPointerException.class};
        }

        @Override
        public String getName() {
            return "string_starts_with";
        }

        @Override
        public String docs() {
            return "boolean {teststring, keyword} Determines if the provided teststring starts with the provided keyword. This could be used to find the prefix of a line, for instance. Note that this will cast both arguments to strings. This means that the boolean true will match the string 'true' or the integer 1 will match the string '1'. If an empty string is provided for the keyword, it will always return true.";
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            Static.AssertNonCNull(t, args);
            String teststring = Construct.nval(args[0]);
            String keyword2 = Construct.nval(args[1]);
            boolean ret = teststring.startsWith(keyword2);
            return CBoolean.get(ret);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage", "string_starts_with('[ERROR] Bad message here!', '[ERROR]')"), new ExampleScript("Basic usage", "string_starts_with('Potato with cheese', 'cheese')")};
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2};
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_2;
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN, Optimizable.OptimizationOption.NO_SIDE_EFFECTS);
        }
    }

    @api
    public static class substr
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "substr";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{2, 3};
        }

        @Override
        public String docs() {
            return "string {str, begin, [end]} Returns a substring of the given string str, starting from index begin, to index end, or the end of the string, if no index is given. If either begin or end are out of bounds of the string, an exception is thrown. substr('hamburger', 4, 8) returns \"urge\", substr('smiles', 1, 5) returns \"mile\", and substr('lightning', 5) returns \"ning\". See also length().";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRERangeException.class, CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_2;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            try {
                String s = args[0].val();
                int begin = ArgumentValidation.getInt32(args[1], t);
                int end = args.length == 3 ? ArgumentValidation.getInt32(args[2], t) : s.length();
                return new CString(s.substring(begin, end), t);
            }
            catch (IndexOutOfBoundsException e) {
                throw new CRERangeException("The indices given are not valid for string '" + args[0].val() + "'", t);
            }
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("", "substr('hamburger', 4, 8)"), new ExampleScript("", "substr('smiles', 1, 5)"), new ExampleScript("", "substr('lightning', 5)"), new ExampleScript("If the indexes are too large", "assign(@big, 25)\nsubstr('small', @big)")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    public static class to_lower
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "to_lower";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "string {str} Returns an all lower case version of str";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_2;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            if (!args[0].isInstanceOf(CString.TYPE)) {
                throw new CREFormatException(this.getName() + " expects a string as first argument, but type " + args[0].typeof() + " was found.", t);
            }
            return new CString(args[0].val().toLowerCase(), t);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("", "to_lower('LOWERCASE')"), new ExampleScript("", "to_lower('MiXeD cAsE')"), new ExampleScript("", "to_lower('Numbers (and SYMBOLS: 25)')")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    public static class to_upper
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "to_upper";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "string {str} Returns an all caps version of str";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREFormatException.class};
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_2;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            if (!args[0].isInstanceOf(CString.TYPE)) {
                throw new CREFormatException(this.getName() + " expects a string as first argument, but type " + args[0].typeof() + " was found.", t);
            }
            return new CString(args[0].val().toUpperCase(), t);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("", "to_upper('uppercase')"), new ExampleScript("", "to_upper('MiXeD cAsE')"), new ExampleScript("", "to_upper('Numbers (and SYMBOLS: 25)')")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    public static class length
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "length";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "int {str | Sizeable} Returns the character length of str, if the value is castable to a string, or the length of the ms.lang.Sizeable object, if an array or other Sizeable object is given.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_1_2;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            if (args[0].isInstanceOf(Sizeable.TYPE)) {
                return new CInt(((Sizeable)args[0]).size(), t);
            }
            return new CInt(args[0].val().length(), t);
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Strings", "length('this is a string')"), new ExampleScript("Arrays", "length(array('1', 2, '3', 4))")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    public static class triml
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "triml";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "string {s} Returns the string s with leading whitespace cut off";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            return new CString(StringUtils.trimLeft(args[0].val()), t);
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("", "'->' . triml('    <- spaces ->    ') . '<-'")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    public static class trimr
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "trimr";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "string {s} Returns the string s with trailing whitespace cut off";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            return new CString(StringUtils.trimRight(args[0].val()), args[0].getTarget());
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("", "'->' . trimr('    <- spaces ->    ') . '<-'")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    public static class trim
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "trim";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "string {s} Returns the string s with leading and trailing whitespace cut off";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            return new CString(args[0].val().trim(), args[0].getTarget());
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("", "'->' . trim('    <- spaces ->    ') . '<-'")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    public static class parse_args
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "parse_args";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1, 2};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            String string = args[0].val();
            boolean useAdvanced = false;
            if (args.length >= 2) {
                useAdvanced = ArgumentValidation.getBoolean(args[1], t);
            }
            ArrayList<CString> a = new ArrayList<CString>();
            if (!useAdvanced) {
                Object sa;
                for (Object s : sa = string.split(" ")) {
                    if (((String)s).trim().isEmpty()) continue;
                    a.add(new CString(((String)s).trim(), t));
                }
            } else {
                for (String s : StringUtils.ArgParser(string)) {
                    a.add(new CString(s.trim(), t));
                }
            }
            Mixed[] csa = new Mixed[a.size()];
            for (int i = 0; i < a.size(); ++i) {
                csa[i] = (Mixed)a.get(i);
            }
            return new CArray(t, csa);
        }

        @Override
        public String docs() {
            return "array {string, [useAdvanced]} Parses string into an array, where string is a space seperated list of arguments. Handy for turning $ into a usable array of items with which to script against. Extra spaces are ignored, so you would never get an empty string as an input. useAdvanced defaults to false, but if true, uses a basic argument parser that supports quotes for allowing arguments with spaces.";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Demonstrates basic usage", "parse_args('This turns into 5 arguments')"), new ExampleScript("Demonstrates usage with extra spaces", "parse_args('This   trims   extra   spaces')"), new ExampleScript("With the advanced mode (escapes are also supported with \\, for instance \\'", "parse_args('This supports \"quoted arguments\"', true)")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    public static class replace
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "replace";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{3};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            String thing = args[0].val();
            String what = args[1].val();
            String that = args[2].val();
            return new CString(thing.replace(what, that), t);
        }

        @Override
        public String docs() {
            return "string {subject, search, replacement} Replaces all instances of 'search' with 'replacement' in 'subject'";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("", "replace('Where in the world is Carmen Sandiego?', 'Carmen Sandiego', 'Waldo')"), new ExampleScript("No match found", "replace('The same thing', 'not found', '404')")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN);
        }
    }

    @api
    @noprofile
    public static class sconcat
    extends AbstractFunction
    implements Optimizable {
        private static final String g = new DataHandling.g().getName();
        private static final String p = new Compiler.p().getName();
        public static final String STRING = new DataHandling._string().getName();

        @Override
        public String getName() {
            return "sconcat";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    b.append(" ");
                }
                b.append(args[i] == null ? "" : args[i].val());
            }
            return new CString(b.toString(), t);
        }

        @Override
        public String docs() {
            return "string {var1, [var2...]} Concatenates any number of arguments together, but puts a space between elements";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            OptimizationUtilities.pullUpLikeFunctions(children, this.getName());
            for (ParseTree child : children) {
                if (!(child.getData() instanceof CLabel)) continue;
                throw new ConfigCompileException("Invalid use of concatenation with label", child.getTarget());
            }
            Iterator<ParseTree> it = children.iterator();
            while (it.hasNext()) {
                ParseTree n = it.next();
                if (!(n.getData() instanceof CFunction) || !g.equals(n.getData().val()) && !p.equals(n.getData().val()) || n.hasChildren()) continue;
                it.remove();
            }
            for (int i = 1; i < children.size(); ++i) {
                ParseTree child2 = children.get(i);
                if (!child2.isConst() || child2.getData() instanceof CKeyword || child2.getData() instanceof CLabel || !children.get(i - 1).isConst() || children.get(i - 1).getData() instanceof CKeyword) continue;
                String s1 = children.get(i - 1).getData().val();
                String s2 = child2.getData().val();
                children.set(i - 1, new ParseTree(new CString(s1 + " " + s2, t), fileOptions));
                children.remove(i);
                --i;
            }
            if (children.size() == 1) {
                ParseTree child = children.get(0);
                if (child.getData() instanceof CKeyword || child.getData() instanceof CLabel) {
                    return child;
                }
                try {
                    if (InstanceofUtil.isInstanceof(child.getData(), CString.TYPE, env)) {
                        return child;
                    }
                }
                catch (IllegalArgumentException child2) {
                    // empty catch block
                }
                ParseTree node = new ParseTree(new CFunction(STRING, t), fileOptions);
                node.addChild(child);
                return node;
            }
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Functional usage", "sconcat('1', '2', '3', '4')"), new ExampleScript("Implied usage, due to no operators", "'1' '2' '3' '4'")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CACHE_RETURN, Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }
    }

    @api
    @OperatorPreferred(value=".")
    public static class concat
    extends AbstractFunction
    implements Optimizable {
        @Override
        public String getName() {
            return "concat";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{Integer.MAX_VALUE};
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[0];
        }

        @Override
        public Mixed exec(Target t, Environment env, Mixed ... args) throws CancelCommandException, ConfigRuntimeException {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                b.append(args[i].val());
            }
            return new CString(b.toString(), t);
        }

        @Override
        public String docs() {
            return "string {var1, [var2...]} Concatenates any number of arguments together, and returns a string";
        }

        @Override
        public boolean isRestricted() {
            return false;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_0_1;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            OptimizationUtilities.pullUpLikeFunctions(children, this.getName());
            for (ParseTree child : children) {
                if (!(child.getData() instanceof CLabel)) continue;
                throw new ConfigCompileException("Invalid use of concatenation with label", child.getTarget());
            }
            return null;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Functional usage", "concat('1', '2', '3', '4')"), new ExampleScript("Symbolic usage", "'1' . '2' . '3' . '4'")};
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.CONSTANT_OFFLINE, Optimizable.OptimizationOption.CACHE_RETURN, Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }
    }
}

