/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import com.laytonsmith.PureUtilities.Common.UIUtils;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class FindDialog
extends JDialog {
    private SearchModel callback;
    private JButton cancelButton;
    private JLabel errorLabel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JRadioButton literalSearchRadioButton;
    private JCheckBox matchCaseCheckbox;
    private JRadioButton regexSearchRadioButton;
    private JList<String> resultsList;
    private JButton searchButton;
    private JTextField searchField;
    private ButtonGroup searchTypeButtonGroup;

    public FindDialog(Frame parent, SearchModel callback) {
        super(parent, true);
        this.initComponents();
        this.setTitle(callback.getDialogTitle());
        UIUtils.centerWindowOnWindow(this, parent);
        this.searchButton.setEnabled(false);
        this.errorLabel.setVisible(false);
        this.searchField.requestFocus();
        this.callback = callback;
    }

    public void doSearch() {
        String regex;
        String prefix;
        this.errorLabel.setVisible(false);
        boolean matchCase = this.matchCaseCheckbox.isSelected();
        boolean literalSearch = this.searchTypeButtonGroup.getSelection() == this.literalSearchRadioButton.getModel();
        String string = prefix = matchCase ? "" : "(?i)";
        if (literalSearch) {
            regex = Pattern.quote(this.searchField.getText());
        } else {
            regex = this.searchField.getText();
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                this.errorLabel.setText("Invalid Regex: " + ex.getMessage());
                this.errorLabel.setVisible(true);
                return;
            }
        }
        regex = prefix + ".*" + regex + ".*";
        List<String> entrySet = this.callback.getEntrySet();
        final LinkedHashMap<Integer, String> results = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < entrySet.size(); ++i) {
            String s = entrySet.get(i);
            if (!s.matches(regex)) continue;
            results.put(i, s);
        }
        if (results.isEmpty()) {
            this.errorLabel.setText("No results found");
            this.errorLabel.setVisible(true);
        } else if (results.size() == 1) {
            this.setVisible(false);
            this.callback.selectedEntry((Integer)new ArrayList(results.keySet()).get(0));
            this.dispose();
        } else {
            this.resultsList.setModel(new ListModel<String>(){

                @Override
                public int getSize() {
                    return results.size();
                }

                @Override
                public String getElementAt(int index) {
                    return (String)results.get(new ArrayList(results.keySet()).get(index));
                }

                @Override
                public void addListDataListener(ListDataListener l) {
                }

                @Override
                public void removeListDataListener(ListDataListener l) {
                }
            });
            this.resultsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JList list = (JList)e.getSource();
                    if (e.getClickCount() == 2) {
                        int index = list.locationToIndex(e.getPoint());
                        FindDialog.this.setVisible(false);
                        FindDialog.this.callback.selectedEntry((Integer)new ArrayList(results.keySet()).get(index));
                        FindDialog.this.dispose();
                    }
                }
            });
        }
    }

    private void initComponents() {
        this.searchTypeButtonGroup = new ButtonGroup();
        this.literalSearchRadioButton = new JRadioButton();
        this.regexSearchRadioButton = new JRadioButton();
        this.matchCaseCheckbox = new JCheckBox();
        this.searchField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.resultsList = new JList();
        this.searchButton = new JButton();
        this.cancelButton = new JButton();
        this.errorLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.searchTypeButtonGroup.add(this.literalSearchRadioButton);
        this.literalSearchRadioButton.setSelected(true);
        this.literalSearchRadioButton.setText("Literal Search");
        this.literalSearchRadioButton.setToolTipText("");
        this.literalSearchRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.literalSearchRadioButtonActionPerformed(evt);
            }
        });
        this.searchTypeButtonGroup.add(this.regexSearchRadioButton);
        this.regexSearchRadioButton.setText("Regex Search");
        this.regexSearchRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.regexSearchRadioButtonActionPerformed(evt);
            }
        });
        this.matchCaseCheckbox.setText("Match Case");
        this.matchCaseCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.matchCaseCheckboxActionPerformed(evt);
            }
        });
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FindDialog.this.searchFieldKeyReleased(evt);
            }
        });
        this.jLabel1.setText("Results");
        this.resultsList.setSelectionMode(0);
        this.resultsList.setToolTipText("Double click to open in main window");
        this.jScrollPane1.setViewportView(this.resultsList);
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.searchButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.errorLabel.setForeground(Color.red);
        this.errorLabel.setText("Error Label");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 665, Short.MAX_VALUE).addComponent(this.searchField).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.literalSearchRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.regexSearchRadioButton)).addComponent(this.matchCaseCheckbox).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.searchButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.errorLabel))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.literalSearchRadioButton).addComponent(this.regexSearchRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.matchCaseCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchButton).addComponent(this.cancelButton).addComponent(this.errorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 174, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.doSearch();
    }

    private void searchFieldKeyReleased(KeyEvent evt) {
        this.searchButton.setEnabled(!this.searchField.getText().trim().isEmpty());
        if (evt.getKeyCode() == 27) {
            this.setVisible(false);
            this.dispose();
        } else if (evt.getKeyCode() == 10 && this.searchButton.isEnabled()) {
            this.doSearch();
        }
    }

    private void literalSearchRadioButtonActionPerformed(ActionEvent evt) {
        this.searchField.requestFocus();
    }

    private void regexSearchRadioButtonActionPerformed(ActionEvent evt) {
        this.searchField.requestFocus();
    }

    private void matchCaseCheckboxActionPerformed(ActionEvent evt) {
        this.searchField.requestFocus();
    }

    public static interface SearchModel {
        public void selectedEntry(int var1);

        public List<String> getEntrySet();

        public String getDialogTitle();
    }
}

