/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.CommandExecutor;
import com.laytonsmith.PureUtilities.Common.Annotations.CheckOverrides;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.TemplateBuilder;
import com.laytonsmith.PureUtilities.Common.UIUtils;
import com.laytonsmith.PureUtilities.DaemonManager;
import com.laytonsmith.PureUtilities.UI.TextDialog;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.commandhelper.CommandHelperFileLocations;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptExecutionQueue;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.ProfilesImpl;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.RuntimeMode;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.functions.OAuth;
import com.laytonsmith.core.profiler.Profiler;
import com.laytonsmith.core.taskmanager.TaskManagerImpl;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.PersistenceNetwork;
import com.laytonsmith.persistence.PersistenceNetworkImpl;
import com.laytonsmith.persistence.ReadOnlyException;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import com.laytonsmith.tools.docgen.localization.AzureKeyInputDialog;
import com.laytonsmith.tools.docgen.localization.AzureMachineTranslation;
import com.laytonsmith.tools.docgen.localization.FindDialog;
import com.laytonsmith.tools.docgen.localization.ForkDatabaseWizard;
import com.laytonsmith.tools.docgen.localization.Locale;
import com.laytonsmith.tools.docgen.localization.LogViewer;
import com.laytonsmith.tools.docgen.localization.MachineTranslation;
import com.laytonsmith.tools.docgen.localization.TextDirection;
import com.laytonsmith.tools.docgen.localization.TranslationMaster;
import com.laytonsmith.tools.docgen.localization.TranslationMemory;
import com.laytonsmith.tools.docgen.localization.TranslationSummary;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@CheckOverrides.SuppressCheckOverrides
public final class LocalizationUI
extends JFrame {
    private static final String FINISHED = "Finished.";
    private boolean unsavedChanges = false;
    private TranslationMaster translations;
    private PersistenceNetwork pn;
    private String azureKey = null;
    private String storedLocation = null;
    private final DaemonManager dm = new DaemonManager();
    private GlobalEnv gEnv;
    private StaticRuntimeEnv staticRuntimeEnv;
    private List<TranslationMemory> currentSegments;
    private TranslationMemory currentMemory;
    private TranslationSummary.TranslationSummaryEntry currentSummary;
    private LogViewer logViewer = new LogViewer(this);
    private JMenuItem aboutMenu;
    private JMenu fileMenu;
    private JRadioButton filterShowAllRadioButton;
    private JRadioButton filterShowSuspectRadioButton;
    private JRadioButton filterShowTranslatableRadioButton;
    private JRadioButton filterShowUncategorizedRadioButton;
    private JRadioButton filterShowUntranslatedRadioButton;
    private ButtonGroup filtersButtonGroup;
    private JLabel filtersLabel;
    private JMenuItem helpMenu;
    private JMenu helpMenuTop;
    private JLabel idLabel;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JLabel localeLabel;
    private JList<String> localeList;
    private JLabel localeSettingsLabel;
    private JTextField localeSettingsLocaleCommentField;
    private JLabel localeSettingsLocaleCommentLabel;
    private JTextField localeSettingsLocaleIdField;
    private JLabel localeSettingsLocaleIdLabel;
    private JButton localeSettingsMachineTranslationClearButton;
    private JTextArea localeSettingsMachineTranslationField;
    private JButton localeSettingsMachineTranslationGenerateButton;
    private JLabel localeSettingsMachineTranslationLabel;
    private JCheckBox localeSettingsMachineTranslationWordWrapCheckbox;
    private JTextArea localeSettingsManualTranslationField;
    private JLabel localeSettingsManualTranslationLabel;
    private JCheckBox localeSettingsManualTranslationWordWrapCheckbox;
    private JPanel localeSettingsPanel;
    private JMenuItem menuAuthorizeOnGithub;
    private JMenuItem menuAzureKey;
    private JMenuItem menuCountUntranslatedChars;
    private JMenuItem menuExit;
    private JMenuItem menuFindSegment;
    private JMenuItem menuForkDatabase;
    private JMenuItem menuJumpToPage;
    private JMenuItem menuLoad;
    private JMenuItem menuMoveDownSegment;
    private JMenuItem menuMoveUpSegment;
    private JMenuItem menuPullRequest;
    private JMenuItem menuSave;
    private JMenuItem menuSaveAndCommit;
    private JMenuItem menuSaveCommitAndPush;
    private JMenuItem menuShowLogs;
    private JMenuItem menuUpdateRepo;
    private JMenu navigationMenu;
    private JLabel pagesLabel;
    private JList<String> pagesList;
    private JProgressBar progressBar;
    private JLabel segmentCountLabel;
    private JLabel segmentDetailsLabel;
    private JPanel segmentDetailsPanel;
    private JLabel segmentsLabel;
    private JList<String> segmentsList;
    private Label statusLabel;
    private JPanel statusPanel;
    private JLabel summaryAppearsOnPagesLabel;
    private JList<String> summaryAppearsOnPagesList;
    private JLabel summaryDataLabel;
    private ButtonGroup summaryEligibleForMachineTranslationButtonGroup;
    private JTextArea summaryEnglishKeyField;
    private JLabel summaryEnglishKeyLabel;
    private JTextField summaryGlobalCommentField;
    private JLabel summaryGlobalCommentLabel;
    private JTextField summaryIdField;
    private JCheckBox summaryIsSuspectSegment;
    private JCheckBox summaryIsUntranslatable;
    private JRadioButton summaryMachineTranslatableNo;
    private JRadioButton summaryMachineTranslatableUncategorizedRadioButton;
    private JRadioButton summaryMachineTranslatableYes;
    private JPanel summaryPanel;
    private JCheckBox summaryWordWrapCheckbox;
    private JMenu toolsMenu;
    private JMenuBar topMenu;
    private JButton viewPageInBrowserButton;

    private LocalizationUI() {
        Thread.setDefaultUncaughtExceptionHandler((t, ex) -> {
            String msg2 = "Exception in thread " + t.getName() + ":\n" + ex.getMessage() + "\n" + StackTraceUtils.GetStacktrace(ex);
            System.err.println(msg2);
            if (this.logViewer != null) {
                this.logViewer.pushLog(msg2);
            }
        });
        this.initComponents();
        this.setUnsavedChanges(false);
        this.setStatus("Welcome to the " + this.getBranding() + " Localization (L10N) UI! To get started, use File->Load... and select your local database, or Tools->Fork Database... to create or checkout an existing one.");
        try {
            this.setIconImage(ImageIO.read(LocalizationUI.class.getResourceAsStream("GearIcon.png")));
        }
        catch (IOException ex2) {
            Logger.getLogger(LocalizationUI.class.getName()).log(Level.SEVERE, null, ex2);
        }
        this.setSummarySettingsEnabled(false);
        this.setLocaleSettingsEnabled(false);
        this.localeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selectedSegment = (String)LocalizationUI.this.segmentsList.getSelectedValue();
                LocalizationUI.this.setupSegmentsList();
                if (selectedSegment != null) {
                    LocalizationUI.this.segmentsList.setSelectedValue(selectedSegment, true);
                }
            }
        });
        this.segmentsList.addListSelectionListener(lse -> {
            if (this.segmentsList.getSelectedIndex() != -1) {
                this.populateSegment(this.currentSegments.get(this.segmentsList.getSelectedIndex()));
            }
        });
        this.pagesList.addListSelectionListener(lse -> {
            this.setupSegmentsList();
            this.viewPageInBrowserButton.setEnabled(this.pagesList.getSelectedIndex() > 0);
        });
    }

    private void initComponents() {
        this.summaryEligibleForMachineTranslationButtonGroup = new ButtonGroup();
        this.filtersButtonGroup = new ButtonGroup();
        this.statusPanel = new JPanel();
        this.statusLabel = new Label();
        this.progressBar = new JProgressBar();
        this.jScrollPane1 = new JScrollPane();
        this.localeList = new JList();
        this.localeLabel = new JLabel();
        this.pagesLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.pagesList = new JList();
        this.segmentDetailsPanel = new JPanel();
        this.summaryDataLabel = new JLabel();
        this.summaryPanel = new JPanel();
        this.idLabel = new JLabel();
        this.summaryIdField = new JTextField();
        this.jScrollPane4 = new JScrollPane();
        this.summaryEnglishKeyField = new JTextArea();
        this.summaryEnglishKeyLabel = new JLabel();
        this.summaryGlobalCommentLabel = new JLabel();
        this.summaryGlobalCommentField = new JTextField();
        this.summaryIsUntranslatable = new JCheckBox();
        this.summaryIsSuspectSegment = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.summaryMachineTranslatableUncategorizedRadioButton = new JRadioButton();
        this.summaryMachineTranslatableYes = new JRadioButton();
        this.summaryMachineTranslatableNo = new JRadioButton();
        this.summaryAppearsOnPagesLabel = new JLabel();
        this.jScrollPane5 = new JScrollPane();
        this.summaryAppearsOnPagesList = new JList();
        this.summaryWordWrapCheckbox = new JCheckBox();
        this.localeSettingsLabel = new JLabel();
        this.localeSettingsPanel = new JPanel();
        this.localeSettingsLocaleIdLabel = new JLabel();
        this.localeSettingsLocaleIdField = new JTextField();
        this.localeSettingsLocaleCommentLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.localeSettingsLocaleCommentField = new JTextField();
        this.localeSettingsMachineTranslationLabel = new JLabel();
        this.jScrollPane6 = new JScrollPane();
        this.localeSettingsMachineTranslationField = new JTextArea();
        this.localeSettingsManualTranslationLabel = new JLabel();
        this.jScrollPane7 = new JScrollPane();
        this.localeSettingsManualTranslationField = new JTextArea();
        this.localeSettingsMachineTranslationWordWrapCheckbox = new JCheckBox();
        this.localeSettingsManualTranslationWordWrapCheckbox = new JCheckBox();
        this.localeSettingsMachineTranslationGenerateButton = new JButton();
        this.localeSettingsMachineTranslationClearButton = new JButton();
        this.segmentDetailsLabel = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.segmentsList = new JList();
        this.segmentsLabel = new JLabel();
        this.filtersLabel = new JLabel();
        this.viewPageInBrowserButton = new JButton();
        this.filterShowAllRadioButton = new JRadioButton();
        this.filterShowUntranslatedRadioButton = new JRadioButton();
        this.filterShowUncategorizedRadioButton = new JRadioButton();
        this.filterShowSuspectRadioButton = new JRadioButton();
        this.filterShowTranslatableRadioButton = new JRadioButton();
        this.segmentCountLabel = new JLabel();
        this.topMenu = new JMenuBar();
        this.fileMenu = new JMenu();
        this.menuLoad = new JMenuItem();
        this.menuUpdateRepo = new JMenuItem();
        this.menuSave = new JMenuItem();
        this.menuSaveAndCommit = new JMenuItem();
        this.menuSaveCommitAndPush = new JMenuItem();
        this.menuPullRequest = new JMenuItem();
        this.menuExit = new JMenuItem();
        this.navigationMenu = new JMenu();
        this.menuFindSegment = new JMenuItem();
        this.menuJumpToPage = new JMenuItem();
        this.menuMoveDownSegment = new JMenuItem();
        this.menuMoveUpSegment = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.menuAzureKey = new JMenuItem();
        this.menuAuthorizeOnGithub = new JMenuItem();
        this.menuForkDatabase = new JMenuItem();
        this.menuCountUntranslatedChars = new JMenuItem();
        this.menuShowLogs = new JMenuItem();
        this.helpMenuTop = new JMenu();
        this.helpMenu = new JMenuItem();
        this.aboutMenu = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.statusPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusLabel.setText("label1");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.progressBar, -2, -1, -2).addComponent(this.statusLabel, -2, -1, -2));
        this.jScrollPane1.setViewportView(this.localeList);
        this.localeLabel.setText("Locale");
        this.pagesLabel.setText("Pages");
        this.jScrollPane2.setViewportView(this.pagesList);
        this.segmentDetailsPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.summaryDataLabel.setText("Summary Data");
        this.summaryPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.idLabel.setText("ID");
        this.summaryIdField.setEditable(false);
        this.summaryIdField.setToolTipText("ID that uniquely distinguishes this string across time and locales");
        this.summaryEnglishKeyField.setEditable(false);
        this.summaryEnglishKeyField.setColumns(20);
        this.summaryEnglishKeyField.setLineWrap(true);
        this.summaryEnglishKeyField.setRows(5);
        this.summaryEnglishKeyField.setToolTipText("Original English word/phrase");
        this.summaryEnglishKeyField.setWrapStyleWord(true);
        this.jScrollPane4.setViewportView(this.summaryEnglishKeyField);
        this.summaryEnglishKeyLabel.setText("English Key");
        this.summaryGlobalCommentLabel.setText("Global Comment (English)");
        this.summaryGlobalCommentField.setForeground(new Color(255, 0, 0));
        this.summaryGlobalCommentField.setToolTipText("Note about this segment to editors of all locales (English only please)");
        this.summaryGlobalCommentField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocalizationUI.this.summaryGlobalCommentFieldKeyReleased(evt);
            }
        });
        this.summaryIsUntranslatable.setText("Is Untranslatable");
        this.summaryIsUntranslatable.setToolTipText("If selected, this entire segment is not eligible for translation to any locale, for instance due to it being a technical string");
        this.summaryIsUntranslatable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.summaryIsUntranslatableActionPerformed(evt);
            }
        });
        this.summaryIsSuspectSegment.setText("Is Suspect Segment");
        this.summaryIsSuspectSegment.setToolTipText("If there is an error in the original English segment or you don't think it should be in the database at all.");
        this.summaryIsSuspectSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.summaryIsSuspectSegmentActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Eligible For Machine Translation");
        this.summaryEligibleForMachineTranslationButtonGroup.add(this.summaryMachineTranslatableUncategorizedRadioButton);
        this.summaryMachineTranslatableUncategorizedRadioButton.setText("Uncategorized");
        this.summaryMachineTranslatableUncategorizedRadioButton.setToolTipText("The default state for all segments");
        this.summaryMachineTranslatableUncategorizedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.summaryMachineTranslatableUncategorizedRadioButtonActionPerformed(evt);
            }
        });
        this.summaryEligibleForMachineTranslationButtonGroup.add(this.summaryMachineTranslatableYes);
        this.summaryMachineTranslatableYes.setText("Yes");
        this.summaryMachineTranslatableYes.setToolTipText("In general, a machine translation will probably be correct");
        this.summaryMachineTranslatableYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.summaryMachineTranslatableYesActionPerformed(evt);
            }
        });
        this.summaryEligibleForMachineTranslationButtonGroup.add(this.summaryMachineTranslatableNo);
        this.summaryMachineTranslatableNo.setText("No");
        this.summaryMachineTranslatableNo.setToolTipText("There is some text in this segment that shouldn't be translated, and cannot be automatically translated");
        this.summaryMachineTranslatableNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.summaryMachineTranslatableNoActionPerformed(evt);
            }
        });
        this.summaryAppearsOnPagesLabel.setText("Appears on Pages");
        this.summaryAppearsOnPagesList.setSelectionMode(0);
        this.summaryAppearsOnPagesList.setToolTipText("Pages this segment appears on. Double click to select the page in the pages list to see it in context.");
        this.summaryAppearsOnPagesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LocalizationUI.this.summaryAppearsOnPagesListMouseClicked(evt);
            }
        });
        this.jScrollPane5.setViewportView(this.summaryAppearsOnPagesList);
        this.summaryWordWrapCheckbox.setSelected(true);
        this.summaryWordWrapCheckbox.setText("Word Wrap");
        this.summaryWordWrapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.summaryWordWrapCheckboxActionPerformed(evt);
            }
        });
        GroupLayout summaryPanelLayout = new GroupLayout(this.summaryPanel);
        this.summaryPanel.setLayout(summaryPanelLayout);
        summaryPanelLayout.setHorizontalGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(summaryPanelLayout.createSequentialGroup().addContainerGap().addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(summaryPanelLayout.createSequentialGroup().addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.idLabel).addComponent(this.summaryEnglishKeyLabel).addComponent(this.summaryGlobalCommentLabel).addGroup(summaryPanelLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.summaryWordWrapCheckbox))).addGap(57, 57, 57).addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 1038, Short.MAX_VALUE).addComponent(this.summaryIdField).addComponent(this.summaryGlobalCommentField))).addGroup(summaryPanelLayout.createSequentialGroup().addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(summaryPanelLayout.createSequentialGroup().addComponent(this.summaryIsUntranslatable).addGap(18, 18, 18).addComponent(this.summaryIsSuspectSegment)).addComponent(this.jLabel1).addGroup(summaryPanelLayout.createSequentialGroup().addComponent(this.summaryMachineTranslatableUncategorizedRadioButton).addGap(18, 18, 18).addComponent(this.summaryMachineTranslatableYes).addGap(18, 18, 18).addComponent(this.summaryMachineTranslatableNo))).addGap(0, 0, Short.MAX_VALUE)).addGroup(summaryPanelLayout.createSequentialGroup().addComponent(this.summaryAppearsOnPagesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane5))).addContainerGap()));
        summaryPanelLayout.setVerticalGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(summaryPanelLayout.createSequentialGroup().addContainerGap().addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idLabel).addComponent(this.summaryIdField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -2, -1, -2).addGroup(summaryPanelLayout.createSequentialGroup().addComponent(this.summaryEnglishKeyLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.summaryWordWrapCheckbox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.summaryGlobalCommentField, -2, -1, -2).addComponent(this.summaryGlobalCommentLabel)).addGap(18, 18, 18).addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.summaryIsUntranslatable).addComponent(this.summaryIsSuspectSegment)).addGap(18, 18, 18).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.summaryMachineTranslatableUncategorizedRadioButton).addComponent(this.summaryMachineTranslatableYes).addComponent(this.summaryMachineTranslatableNo)).addGap(18, 18, 18).addGroup(summaryPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.summaryAppearsOnPagesLabel).addComponent(this.jScrollPane5, -2, 54, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.localeSettingsLabel.setText("Locale Settings");
        this.localeSettingsPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.localeSettingsLocaleIdLabel.setText("Locale ID");
        this.localeSettingsLocaleIdField.setEditable(false);
        this.localeSettingsLocaleIdField.setToolTipText("The locale id that uniquely identifies this translation within this locale");
        this.localeSettingsLocaleCommentLabel.setText("Locale Comment");
        this.jLabel4.setText("(English Preferred)");
        this.localeSettingsLocaleCommentField.setForeground(new Color(255, 0, 0));
        this.localeSettingsLocaleCommentField.setToolTipText("Note about this segment to editors of this specific locale (English is preferred, but can be the locale language can be used as well)");
        this.localeSettingsLocaleCommentField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocalizationUI.this.localeSettingsLocaleCommentFieldKeyReleased(evt);
            }
        });
        this.localeSettingsMachineTranslationLabel.setText("Machine Translation");
        this.localeSettingsMachineTranslationField.setEditable(false);
        this.localeSettingsMachineTranslationField.setColumns(20);
        this.localeSettingsMachineTranslationField.setLineWrap(true);
        this.localeSettingsMachineTranslationField.setRows(5);
        this.localeSettingsMachineTranslationField.setToolTipText("If generated (and allowed due to the settings), the machine generated translation.");
        this.localeSettingsMachineTranslationField.setWrapStyleWord(true);
        this.jScrollPane6.setViewportView(this.localeSettingsMachineTranslationField);
        this.localeSettingsManualTranslationLabel.setText("Manual Translation");
        this.localeSettingsManualTranslationField.setColumns(20);
        this.localeSettingsManualTranslationField.setLineWrap(true);
        this.localeSettingsManualTranslationField.setRows(5);
        this.localeSettingsManualTranslationField.setToolTipText("The manual translation. This overrides the machine translation, if available.");
        this.localeSettingsManualTranslationField.setWrapStyleWord(true);
        this.localeSettingsManualTranslationField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LocalizationUI.this.localeSettingsManualTranslationFieldKeyReleased(evt);
            }
        });
        this.jScrollPane7.setViewportView(this.localeSettingsManualTranslationField);
        this.localeSettingsMachineTranslationWordWrapCheckbox.setSelected(true);
        this.localeSettingsMachineTranslationWordWrapCheckbox.setText("Word Wrap");
        this.localeSettingsMachineTranslationWordWrapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.localeSettingsMachineTranslationWordWrapCheckboxActionPerformed(evt);
            }
        });
        this.localeSettingsManualTranslationWordWrapCheckbox.setSelected(true);
        this.localeSettingsManualTranslationWordWrapCheckbox.setText("Word Wrap");
        this.localeSettingsManualTranslationWordWrapCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.localeSettingsManualTranslationWordWrapCheckboxActionPerformed(evt);
            }
        });
        this.localeSettingsMachineTranslationGenerateButton.setText("Generate");
        this.localeSettingsMachineTranslationGenerateButton.setToolTipText("Generates a machine translation. Only available for the art locale, or if an Azure Key is stored.");
        this.localeSettingsMachineTranslationGenerateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.localeSettingsMachineTranslationGenerateButtonActionPerformed(evt);
            }
        });
        this.localeSettingsMachineTranslationClearButton.setText("Clear");
        this.localeSettingsMachineTranslationClearButton.setToolTipText("Clears the automatic translation. Only do this if the translation is really so bad that English would be better. Instead, create a better manual translation, and leave this as is.");
        this.localeSettingsMachineTranslationClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.localeSettingsMachineTranslationClearButtonActionPerformed(evt);
            }
        });
        GroupLayout localeSettingsPanelLayout = new GroupLayout(this.localeSettingsPanel);
        this.localeSettingsPanel.setLayout(localeSettingsPanelLayout);
        localeSettingsPanelLayout.setHorizontalGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(localeSettingsPanelLayout.createSequentialGroup().addGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(localeSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.localeSettingsLocaleIdLabel).addComponent(this.localeSettingsLocaleCommentLabel))).addGroup(localeSettingsPanelLayout.createSequentialGroup().addGap(48, 48, 48).addComponent(this.jLabel4)).addGroup(localeSettingsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.localeSettingsManualTranslationLabel)).addGroup(localeSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.localeSettingsMachineTranslationWordWrapCheckbox).addComponent(this.localeSettingsMachineTranslationLabel).addComponent(this.localeSettingsManualTranslationWordWrapCheckbox))).addGroup(localeSettingsPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.localeSettingsMachineTranslationGenerateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localeSettingsMachineTranslationClearButton))).addGap(7, 7, 7).addGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.localeSettingsLocaleIdField).addComponent(this.localeSettingsLocaleCommentField).addComponent(this.jScrollPane6, -1, 1073, Short.MAX_VALUE).addComponent(this.jScrollPane7)).addContainerGap()));
        localeSettingsPanelLayout.setVerticalGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(localeSettingsPanelLayout.createSequentialGroup().addContainerGap().addGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localeSettingsLocaleIdLabel).addComponent(this.localeSettingsLocaleIdField, -2, -1, -2)).addGap(18, 18, 18).addGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localeSettingsLocaleCommentLabel).addComponent(this.localeSettingsLocaleCommentField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(localeSettingsPanelLayout.createSequentialGroup().addComponent(this.localeSettingsMachineTranslationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localeSettingsMachineTranslationWordWrapCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localeSettingsMachineTranslationGenerateButton).addComponent(this.localeSettingsMachineTranslationClearButton))).addComponent(this.jScrollPane6, -2, -1, -2)).addGap(23, 23, 23).addGroup(localeSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(localeSettingsPanelLayout.createSequentialGroup().addComponent(this.localeSettingsManualTranslationLabel).addGap(18, 18, 18).addComponent(this.localeSettingsManualTranslationWordWrapCheckbox)).addComponent(this.jScrollPane7, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout segmentDetailsPanelLayout = new GroupLayout(this.segmentDetailsPanel);
        this.segmentDetailsPanel.setLayout(segmentDetailsPanelLayout);
        segmentDetailsPanelLayout.setHorizontalGroup(segmentDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.summaryPanel, -1, -1, Short.MAX_VALUE).addGroup(segmentDetailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(segmentDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.summaryDataLabel).addComponent(this.localeSettingsLabel)).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.localeSettingsPanel, -1, -1, Short.MAX_VALUE));
        segmentDetailsPanelLayout.setVerticalGroup(segmentDetailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(segmentDetailsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.summaryDataLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.summaryPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.localeSettingsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localeSettingsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.segmentDetailsLabel.setText("Segment Details");
        this.jScrollPane3.setViewportView(this.segmentsList);
        this.segmentsLabel.setText("Segments");
        this.filtersLabel.setText("Filters");
        this.viewPageInBrowserButton.setText("View Page In Browser");
        this.viewPageInBrowserButton.setEnabled(false);
        this.viewPageInBrowserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.viewPageInBrowserButtonActionPerformed(evt);
            }
        });
        this.filtersButtonGroup.add(this.filterShowAllRadioButton);
        this.filterShowAllRadioButton.setSelected(true);
        this.filterShowAllRadioButton.setText("Show All");
        this.filterShowAllRadioButton.setToolTipText("Shows all segments");
        this.filterShowAllRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.filterShowAllRadioButtonActionPerformed(evt);
            }
        });
        this.filtersButtonGroup.add(this.filterShowUntranslatedRadioButton);
        this.filterShowUntranslatedRadioButton.setText("Show Untranslated");
        this.filterShowUntranslatedRadioButton.setToolTipText("Shows only segments that are missing any translation at all");
        this.filterShowUntranslatedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.filterShowUntranslatedRadioButtonActionPerformed(evt);
            }
        });
        this.filtersButtonGroup.add(this.filterShowUncategorizedRadioButton);
        this.filterShowUncategorizedRadioButton.setText("Show Uncategorized");
        this.filterShowUncategorizedRadioButton.setToolTipText("Shows only segments that are not categorized for machine translation yet");
        this.filterShowUncategorizedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.filterShowUncategorizedRadioButtonActionPerformed(evt);
            }
        });
        this.filtersButtonGroup.add(this.filterShowSuspectRadioButton);
        this.filterShowSuspectRadioButton.setText("Show Suspect");
        this.filterShowSuspectRadioButton.setToolTipText("Shows only segments that have been marked as suspect");
        this.filterShowSuspectRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.filterShowSuspectRadioButtonActionPerformed(evt);
            }
        });
        this.filtersButtonGroup.add(this.filterShowTranslatableRadioButton);
        this.filterShowTranslatableRadioButton.setText("Show Translatable");
        this.filterShowTranslatableRadioButton.setToolTipText("Shows only segments that are marked as translatable");
        this.filterShowTranslatableRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.filterShowTranslatableRadioButtonActionPerformed(evt);
            }
        });
        this.segmentCountLabel.setText("                      ");
        this.fileMenu.setText("File");
        this.menuLoad.setText("Load...");
        this.menuLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuLoadActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.menuLoad);
        this.menuUpdateRepo.setIcon(new ImageIcon(this.getClass().getResource("/com/laytonsmith/tools/docgen/localization/git_icon16x16.png")));
        this.menuUpdateRepo.setText("Update Repo");
        this.menuUpdateRepo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuUpdateRepoActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.menuUpdateRepo);
        this.menuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.menuSave.setText("Save");
        this.menuSave.setToolTipText("Saves locally, but does not make a commit");
        this.menuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuSaveActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.menuSave);
        this.menuSaveAndCommit.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        this.menuSaveAndCommit.setIcon(new ImageIcon(this.getClass().getResource("/com/laytonsmith/tools/docgen/localization/git_icon16x16.png")));
        this.menuSaveAndCommit.setText("Save and Commit");
        this.menuSaveAndCommit.setToolTipText("Saves and makes a commit to the local repo");
        this.menuSaveAndCommit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuSaveAndCommitActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.menuSaveAndCommit);
        this.menuSaveCommitAndPush.setAccelerator(KeyStroke.getKeyStroke(83, 11));
        this.menuSaveCommitAndPush.setIcon(new ImageIcon(this.getClass().getResource("/com/laytonsmith/tools/docgen/localization/git_icon16x16.png")));
        this.menuSaveCommitAndPush.setText("Save, Commit, and Push");
        this.menuSaveCommitAndPush.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuSaveCommitAndPushActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.menuSaveCommitAndPush);
        this.menuPullRequest.setIcon(new ImageIcon(this.getClass().getResource("/com/laytonsmith/tools/docgen/localization/github_icon16x16.png")));
        this.menuPullRequest.setText("Pull Request");
        this.fileMenu.add(this.menuPullRequest);
        this.menuExit.setText("Exit");
        this.menuExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuExitActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.menuExit);
        this.topMenu.add(this.fileMenu);
        this.navigationMenu.setText("Navigation");
        this.menuFindSegment.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.menuFindSegment.setText("Find Segment...");
        this.menuFindSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuFindSegmentActionPerformed(evt);
            }
        });
        this.navigationMenu.add(this.menuFindSegment);
        this.menuJumpToPage.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        this.menuJumpToPage.setText("Jump to Page");
        this.menuJumpToPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuJumpToPageActionPerformed(evt);
            }
        });
        this.navigationMenu.add(this.menuJumpToPage);
        this.menuMoveDownSegment.setAccelerator(KeyStroke.getKeyStroke(40, 2));
        this.menuMoveDownSegment.setText("Move Down Segment");
        this.menuMoveDownSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuMoveDownSegmentActionPerformed(evt);
            }
        });
        this.navigationMenu.add(this.menuMoveDownSegment);
        this.menuMoveUpSegment.setAccelerator(KeyStroke.getKeyStroke(38, 2));
        this.menuMoveUpSegment.setText("Move Up Segment");
        this.menuMoveUpSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuMoveUpSegmentActionPerformed(evt);
            }
        });
        this.navigationMenu.add(this.menuMoveUpSegment);
        this.topMenu.add(this.navigationMenu);
        this.toolsMenu.setText("Tools");
        this.menuAzureKey.setIcon(new ImageIcon(this.getClass().getResource("/com/laytonsmith/tools/docgen/localization/cognitive_services_logo16x16.png")));
        this.menuAzureKey.setText("Add Azure Key...");
        this.menuAzureKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuAzureKeyActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.menuAzureKey);
        this.menuAuthorizeOnGithub.setIcon(new ImageIcon(this.getClass().getResource("/com/laytonsmith/tools/docgen/localization/github_icon16x16.png")));
        this.menuAuthorizeOnGithub.setText("Authorize on Github");
        this.menuAuthorizeOnGithub.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuAuthorizeOnGithubActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.menuAuthorizeOnGithub);
        this.menuForkDatabase.setIcon(new ImageIcon(this.getClass().getResource("/com/laytonsmith/tools/docgen/localization/github_icon16x16.png")));
        this.menuForkDatabase.setText("Fork Database...");
        this.menuForkDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuForkDatabaseActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.menuForkDatabase);
        this.menuCountUntranslatedChars.setText("Count Untranslated Chars");
        this.menuCountUntranslatedChars.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuCountUntranslatedCharsActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.menuCountUntranslatedChars);
        this.menuShowLogs.setText("Show Logs");
        this.menuShowLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.menuShowLogsActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.menuShowLogs);
        this.topMenu.add(this.toolsMenu);
        this.helpMenuTop.setText("Help");
        this.helpMenu.setIcon(new ImageIcon(this.getClass().getResource("/com/laytonsmith/tools/docgen/localization/help_icon16x16.png")));
        this.helpMenu.setText("Help...");
        this.helpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.helpMenuActionPerformed(evt);
            }
        });
        this.helpMenuTop.add(this.helpMenu);
        this.aboutMenu.setText("About...");
        this.aboutMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LocalizationUI.this.aboutMenuActionPerformed(evt);
            }
        });
        this.helpMenuTop.add(this.aboutMenu);
        this.topMenu.add(this.helpMenuTop);
        this.setJMenuBar(this.topMenu);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 85, -2).addComponent(this.localeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pagesLabel).addComponent(this.jScrollPane2, -2, 267, -2).addComponent(this.viewPageInBrowserButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.segmentCountLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.segmentsLabel).addComponent(this.jScrollPane3, -2, 174, -2).addComponent(this.filtersLabel).addComponent(this.filterShowAllRadioButton).addComponent(this.filterShowUntranslatedRadioButton).addComponent(this.filterShowUncategorizedRadioButton).addComponent(this.filterShowSuspectRadioButton).addComponent(this.filterShowTranslatableRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.segmentDetailsPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.segmentDetailsLabel).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localeLabel).addComponent(this.pagesLabel).addComponent(this.segmentDetailsLabel).addComponent(this.segmentsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.segmentDetailsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewPageInBrowserButton)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filtersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterShowAllRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterShowUntranslatedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterShowUncategorizedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterShowSuspectRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterShowTranslatableRadioButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.segmentCountLabel).addGap(13, 13, 13).addComponent(this.statusPanel, -2, -1, -2)));
        this.pack();
    }

    private void menuLoadActionPerformed(ActionEvent evt) {
        if (!this.unsavedChanges || UIUtils.confirm(this, "Unsaved Changes", "You have unsaved changes, loading will lose them, would you like to continue?")) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.initializeTranslationDb(file);
            }
        }
    }

    private void menuSaveActionPerformed(ActionEvent evt) {
        this.doSave(() -> {});
    }

    private void menuExitActionPerformed(ActionEvent evt) {
        if (!this.unsavedChanges) {
            System.exit(0);
        } else if (UIUtils.confirm(this, "Unsaved Changes", "You have unsaved changes, are you sure you want to quit?")) {
            System.exit(0);
        }
    }

    private void menuAzureKeyActionPerformed(ActionEvent evt) {
        AzureKeyInputDialog d = new AzureKeyInputDialog((Frame)this, (key, save) -> {
            this.azureKey = key;
            if (save && this.pn != null) {
                try {
                    this.pn.set(this.dm, new String[]{"l10n", "azureKey"}, key);
                }
                catch (DataSourceException | ReadOnlyException | IOException | IllegalArgumentException ex) {
                    this.showError("Could not save Azure Key! " + ex.getMessage());
                }
            }
        });
        UIUtils.centerWindowOnWindow(d, this);
        d.setVisible(true);
    }

    private void menuForkDatabaseActionPerformed(ActionEvent evt) {
        if (this.unsavedChanges) {
            this.showError("You have unsaved changes, cannot create a new fork now!");
            return;
        }
        new ForkDatabaseWizard(this, this.logViewer).setVisible(true);
    }

    private void menuFindSegmentActionPerformed(ActionEvent evt) {
    }

    private void menuJumpToPageActionPerformed(ActionEvent evt) {
        final List<String> pages = this.translations.getPages();
        new FindDialog((Frame)this, new FindDialog.SearchModel(){

            @Override
            public void selectedEntry(int index) {
                LocalizationUI.this.pagesList.setSelectedIndex(index + 1);
                LocalizationUI.this.pagesList.ensureIndexIsVisible(index + 1);
            }

            @Override
            public List<String> getEntrySet() {
                return pages;
            }

            @Override
            public String getDialogTitle() {
                return "Find Page";
            }
        }).setVisible(true);
    }

    private void helpMenuActionPerformed(ActionEvent evt) {
        TemplateBuilder builder = new TemplateBuilder();
        builder.addTemplate("wiki", new TemplateBuilder.Generator(){

            @Override
            public String generate(String ... args) {
                return "https://methodscript.com/docs/" + MSVersion.LATEST + "/" + args[0] + ".html";
            }
        });
        String text = builder.build(StreamUtils.GetString(LocalizationUI.class.getResourceAsStream("HelpDialog.html")));
        TextDialog td = new TextDialog((Frame)this, false, text);
        UIUtils.centerWindowOnWindow(td, this);
        td.setVisible(true);
    }

    private void aboutMenuActionPerformed(ActionEvent evt) {
        TemplateBuilder builder = new TemplateBuilder();
        builder.addTemplate("version", new TemplateBuilder.Generator(){

            @Override
            public String generate(String ... args) {
                return MSVersion.LATEST.toString();
            }
        });
        builder.addTemplate("implementation", new TemplateBuilder.Generator(){

            @Override
            public String generate(String ... args) {
                return LocalizationUI.this.getBranding();
            }
        });
        String text = builder.build(StreamUtils.GetString(LocalizationUI.class.getResourceAsStream("AboutDialog.html")));
        TextDialog td = new TextDialog((Frame)this, true, text);
        UIUtils.centerWindowOnWindow(td, this);
        td.setVisible(true);
    }

    private void summaryGlobalCommentFieldKeyReleased(KeyEvent evt) {
        this.updateCurrent();
    }

    private void summaryIsUntranslatableActionPerformed(ActionEvent evt) {
        this.updateCurrent();
    }

    private void summaryIsSuspectSegmentActionPerformed(ActionEvent evt) {
        this.updateCurrent();
    }

    private void summaryMachineTranslatableUncategorizedRadioButtonActionPerformed(ActionEvent evt) {
        this.updateCurrent();
    }

    private void summaryMachineTranslatableYesActionPerformed(ActionEvent evt) {
        this.updateCurrent();
    }

    private void summaryMachineTranslatableNoActionPerformed(ActionEvent evt) {
        this.updateCurrent();
    }

    private void summaryWordWrapCheckboxActionPerformed(ActionEvent evt) {
        this.summaryEnglishKeyField.setLineWrap(this.summaryWordWrapCheckbox.isSelected());
    }

    private void summaryAppearsOnPagesListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            String currentSegment = this.currentMemory.getEnglishKey();
            String page = this.summaryAppearsOnPagesList.getSelectedValue();
            this.pagesList.setSelectedValue(page, true);
            this.segmentsList.setSelectedValue(currentSegment, true);
        }
    }

    private void localeSettingsMachineTranslationWordWrapCheckboxActionPerformed(ActionEvent evt) {
        this.localeSettingsMachineTranslationField.setLineWrap(this.localeSettingsMachineTranslationWordWrapCheckbox.isSelected());
    }

    private void localeSettingsManualTranslationWordWrapCheckboxActionPerformed(ActionEvent evt) {
        this.localeSettingsManualTranslationField.setLineWrap(this.localeSettingsManualTranslationWordWrapCheckbox.isSelected());
    }

    private void localeSettingsLocaleCommentFieldKeyReleased(KeyEvent evt) {
        this.updateCurrent();
    }

    private void localeSettingsManualTranslationFieldKeyReleased(KeyEvent evt) {
        this.updateCurrent();
    }

    private void localeSettingsMachineTranslationGenerateButtonActionPerformed(ActionEvent evt) {
        if (this.localeList.getSelectedIndex() == 0) {
            return;
        }
        String locale = this.localeList.getSelectedValue();
        if (!locale.equals("art") && this.azureKey == null) {
            return;
        }
        TranslationMemory tm = this.currentMemory;
        this.setStatus("Looking up translation...");
        new Thread(() -> {
            String t;
            AzureMachineTranslation mt = new AzureMachineTranslation(this.azureKey);
            try {
                t = mt.translate(locale, this.currentMemory.getEnglishKey());
            }
            catch (MachineTranslation.TranslationException ex) {
                UIUtils.alert(this, "Error", "<html><body>" + ex.getMessage().replace("\n", "<br>") + "</body></html>");
                this.setStatus(FINISHED);
                return;
            }
            tm.setAutomaticTranslation(t);
            EventQueue.invokeLater(() -> {
                this.setStatus(FINISHED);
                this.populateSegment(this.currentMemory);
                this.updateCurrent();
            });
        }, "GenerateTranslationThread").start();
    }

    private void viewPageInBrowserButtonActionPerformed(ActionEvent evt) {
        try {
            UIUtils.openWebpage(new URL("https://methodscript.com" + this.pagesList.getSelectedValue().replace(".tmem.xml", ".html").replace("\\", "/")));
        }
        catch (IOException | URISyntaxException ex) {
            this.showError("Cannot open browser: " + ex.getMessage());
        }
    }

    private void menuMoveDownSegmentActionPerformed(ActionEvent evt) {
        int current = this.segmentsList.getSelectedIndex();
        if (current == this.segmentsList.getModel().getSize()) {
            return;
        }
        this.segmentsList.setSelectedIndex(++current);
        this.segmentsList.ensureIndexIsVisible(current);
    }

    private void menuMoveUpSegmentActionPerformed(ActionEvent evt) {
        int current = this.segmentsList.getSelectedIndex();
        if (current == 0) {
            return;
        }
        this.segmentsList.setSelectedIndex(--current);
        this.segmentsList.ensureIndexIsVisible(current);
    }

    private void menuCountUntranslatedCharsActionPerformed(ActionEvent evt) {
        new Thread(() -> {
            HashMap<Locale, Integer> counts = new HashMap<Locale, Integer>();
            int total = 0;
            for (Locale locale : this.translations.getLocales()) {
                int count = 0;
                List<TranslationMemory> memories = this.translations.getMemoriesForLocale(locale);
                for (TranslationMemory tm : memories) {
                    if (!tm.getMachineTranslation().isEmpty()) continue;
                    count += tm.getEnglishKey().length();
                }
                if (!Locale.getDummyLocale().equals((Object)locale)) {
                    total += count;
                }
                counts.put(locale, count);
            }
            this.setStatus(FINISHED);
            StringBuilder b = new StringBuilder();
            b.append("<html><body>");
            for (Map.Entry e : counts.entrySet()) {
                b.append("<p>Locale: ").append(((Locale)((Object)((Object)e.getKey()))).getEnglishName()).append("; Count: ").append(String.format("%,d", e.getValue())).append("</p>");
            }
            b.append("<p>Total (minus art): ").append(String.format("%,d", total)).append("</p>");
            b.append("</body></html>");
            UIUtils.alert(this, "Character Count", b.toString());
        }, "count-chars").start();
        this.setStatus("Counting characters...");
    }

    private void filterShowAllRadioButtonActionPerformed(ActionEvent evt) {
        this.setupSegmentsList();
    }

    private void filterShowUntranslatedRadioButtonActionPerformed(ActionEvent evt) {
        this.setupSegmentsList();
    }

    private void filterShowUncategorizedRadioButtonActionPerformed(ActionEvent evt) {
        this.setupSegmentsList();
    }

    private void filterShowSuspectRadioButtonActionPerformed(ActionEvent evt) {
        this.setupSegmentsList();
    }

    private void filterShowTranslatableRadioButtonActionPerformed(ActionEvent evt) {
        this.setupSegmentsList();
    }

    private void localeSettingsMachineTranslationClearButtonActionPerformed(ActionEvent evt) {
        this.currentMemory.setAutomaticTranslation("");
        this.updateCurrent();
        this.populateSegment(this.currentMemory);
    }

    private void menuAuthorizeOnGithubActionPerformed(ActionEvent evt) {
        this.authorizeGithub(true, token -> UIUtils.alert(this, "Success", "Github authorization obtained!"));
    }

    private void menuUpdateRepoActionPerformed(ActionEvent evt) {
        if (this.storedLocation == null) {
            this.showError("You must first select a database to load or fork.");
            return;
        }
        if (this.unsavedChanges) {
            this.showError("You cannot update while having unsaved changes, please save and try again.");
        }
        new Thread(() -> {
            try {
                this.setStatus("Updating repo");
                File wd = new File(this.storedLocation);
                String repoStatus = CommandExecutor.Execute(wd, "git", "status", "--porcelain");
                if (!"".equals(repoStatus)) {
                    repoStatus = CommandExecutor.Execute(wd, "git", "status");
                    this.showError("<html><body>Cannot update repo, repository not clean!<br>" + repoStatus.replace("\n", "<br>") + "<br><br>Please manually clean up the repo, or commit, and try again.</body></html>");
                    return;
                }
                CommandExecutor pull = new CommandExecutor("git", "pull");
                pull.setWorkingDir(wd);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                pull.setSystemOut(out);
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                pull.setSystemErr(err);
                int exit2 = pull.start().waitFor();
                if (err.size() > 0 || exit2 != 0) {
                    this.showError("<html><body>Encountered an error while trying to update:<br>" + err.toString("UTF-8").replace("\n", "<br>") + "</body></html>");
                }
                System.out.println(out.toString("UTF-8"));
            }
            catch (IOException | InterruptedException ex) {
                this.showError("Could not update repo: " + ex.getMessage());
            }
        }, "UpdateRepo").start();
    }

    private void menuSaveAndCommitActionPerformed(ActionEvent evt) {
        this.doSave(() -> this.doCommit(() -> {}));
    }

    private void menuSaveCommitAndPushActionPerformed(ActionEvent evt) {
        this.doSave(() -> this.doCommit(() -> this.doPush(() -> {})));
    }

    private void menuShowLogsActionPerformed(ActionEvent evt) {
        this.logViewer.setVisible(true);
    }

    public static void main(String[] args) {
        LocalizationUI.launch(null);
    }

    public static void launch(String database) {
        File f;
        Implementation.forceServerType(Implementation.Type.SHELL);
        ClassDiscovery.getDefaultInstance().addDiscoveryLocation(ClassDiscovery.GetClassContainer(LocalizationUI.class));
        if (database != null) {
            f = new File(database);
            if (!f.exists()) {
                System.err.println(f.getAbsolutePath() + " does not point to an existing directory!");
                System.exit(1);
            }
            if (!f.isDirectory()) {
                System.err.println(f.getAbsolutePath() + " does not point to a directory!");
                System.exit(1);
            }
        } else {
            f = null;
        }
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(LocalizationUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        final LocalizationUI ui = new LocalizationUI();
        ui.initialize();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIUtils.centerWindow(ui);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Insets scnMax = Toolkit.getDefaultToolkit().getScreenInsets(ui.getGraphicsConfiguration());
                int taskBarSize = scnMax.bottom;
                ui.setSize((int)Math.min(screenSize.getWidth(), (double)ui.getWidth()), (int)Math.min(screenSize.getHeight() - (double)taskBarSize, (double)ui.getHeight()));
                ui.setVisible(true);
                if (f != null) {
                    ui.initializeTranslationDb(f);
                } else if (ui.storedLocation != null) {
                    ui.initializeTranslationDb(new File(ui.storedLocation));
                }
            }
        });
    }

    private static PersistenceNetwork getPersistenceNetwork(File config) throws URISyntaxException, IOException, DataSourceException {
        ConnectionMixinFactory.ConnectionMixinOptions options = new ConnectionMixinFactory.ConnectionMixinOptions();
        options.setWorkingDirectory(config.getParentFile().getParentFile());
        return new PersistenceNetworkImpl(config, new URI("sqlite://" + new File(config.getParentFile().getParentFile(), "persistence.db").toString().replace('\\', '/')), options);
    }

    private void initialize() {
        try {
            Static.GenerateStandaloneEnvironment(true);
            this.pn = LocalizationUI.getPersistenceNetwork(MethodScriptFileLocations.getDefault().getPersistenceConfig());
            if (this.pn != null) {
                this.storedLocation = this.pn.get(new String[]{"l10n", "lastLoadedDb"});
                this.azureKey = this.pn.get(new String[]{"l10n", "azureKey"});
            }
            this.gEnv = new GlobalEnv(new MethodScriptExecutionQueue("L10N-UI", "default"), MethodScriptFileLocations.getDefault().getTempDir(), EnumSet.of(RuntimeMode.CMDLINE));
            this.staticRuntimeEnv = new StaticRuntimeEnv(new Profiler(CommandHelperFileLocations.getDefault().getProfilerConfigFile()), this.pn, new ProfilesImpl(MethodScriptFileLocations.getDefault().getProfilesFile()), new TaskManagerImpl());
        }
        catch (Profiles.InvalidProfileException | DataSourceException | IOException | URISyntaxException ex) {
            this.showError("Could not load Persistence Database! " + ex.getMessage());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (LocalizationUI.this.unsavedChanges) {
                    if (UIUtils.confirm(LocalizationUI.this, "Unsaved Changes", "You have unsaved changes, are you sure you want to quit?")) {
                        System.exit(0);
                    }
                } else {
                    System.exit(0);
                }
            }
        });
        this.setInvalidMenus(false);
    }

    private void setInvalidMenus(boolean to) {
        this.menuFindSegment.setEnabled(to);
        this.menuJumpToPage.setEnabled(to);
        this.menuMoveDownSegment.setEnabled(to);
        this.menuMoveUpSegment.setEnabled(to);
        this.menuCountUntranslatedChars.setEnabled(to);
    }

    private void setSummarySettingsEnabled(boolean enabled) {
        UIUtils.setEnabled(enabled, this.summaryGlobalCommentField, this.summaryIsUntranslatable, this.summaryIsSuspectSegment, this.summaryMachineTranslatableUncategorizedRadioButton, this.summaryMachineTranslatableYes, this.summaryMachineTranslatableNo, this.summaryAppearsOnPagesList);
    }

    private void setLocaleSettingsEnabled(boolean enabled) {
        UIUtils.setEnabled(enabled, this.localeSettingsLocaleCommentField, this.localeSettingsMachineTranslationField, this.localeSettingsMachineTranslationGenerateButton, this.localeSettingsMachineTranslationClearButton, this.localeSettingsManualTranslationField);
    }

    private void showError(String text) {
        this.logViewer.pushLog(text);
        UIUtils.alert(this, "Error", text, UIUtils.MessageType.ERROR);
    }

    private String getBranding() {
        try {
            return Implementation.GetServerType().getBranding();
        }
        catch (Exception ex) {
            return "MethodScript";
        }
    }

    void initializeTranslationDb(File path) {
        if (!path.exists()) {
            UIUtils.alert(this, "Error", "Tried to load database at " + path.getAbsolutePath() + " but it could not be found.", UIUtils.MessageType.ERROR);
            return;
        }
        new Thread(() -> {
            try {
                this.translations = new TranslationMaster(path, (current, total) -> this.setProgressStatus("Loading translations from " + path + ", please wait...", current, total));
                if (this.pn != null) {
                    try {
                        this.pn.set(this.dm, new String[]{"l10n", "lastLoadedDb"}, path.getAbsolutePath());
                    }
                    catch (DataSourceException | ReadOnlyException | IllegalArgumentException ex) {
                        Logger.getLogger(LocalizationUI.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            catch (IOException ex) {
                EventQueue.invokeLater(() -> this.showError("Could not load database: " + ex.getMessage()));
                return;
            }
            EventQueue.invokeLater(this::initializeUIFromDatabase);
        }, "Initialize-Translations").start();
        this.setProgressStatus("Loading translations from " + path + ", please wait...", 0.0, 0.0);
    }

    private void initializeUIFromDatabase() {
        this.setStatus(FINISHED);
        this.localeList.setModel(new ListModel<String>(){

            @Override
            public int getSize() {
                return LocalizationUI.this.translations.getLocales().size() + 1;
            }

            @Override
            public String getElementAt(int index) {
                if (index == 0) {
                    return "All Locales";
                }
                return LocalizationUI.this.translations.getLocales().get(index - 1).getLocale();
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.pagesList.setModel(new ListModel<String>(){

            @Override
            public int getSize() {
                return LocalizationUI.this.translations.getPages().size() + 1;
            }

            @Override
            public String getElementAt(int index) {
                if (index == 0) {
                    return "All Pages";
                }
                return LocalizationUI.this.translations.getPages().get(index - 1);
            }

            @Override
            public void addListDataListener(ListDataListener l) {
            }

            @Override
            public void removeListDataListener(ListDataListener l) {
            }
        });
        this.localeList.setSelectedIndex(0);
        this.pagesList.setSelectedIndex(0);
        this.setInvalidMenus(true);
    }

    private void setupSegmentsList() {
        int index = this.pagesList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        Locale locale = this.localeList.getSelectedIndex() == 0 ? Locale.getDummyLocale() : Locale.fromLocale(this.localeList.getSelectedValue());
        if (index == 0) {
            this.currentSegments = this.translations.getMemoriesForLocale(locale);
        } else {
            String page = this.translations.getPages().get(--index);
            this.currentSegments = this.translations.getMemoriesForPage(locale, page);
        }
        this.currentSegments = this.filterSegmentList(this.currentSegments);
        this.segmentCountLabel.setText("Segments: " + this.currentSegments.size());
        Collections.sort(this.currentSegments, (t, t1) -> t.getEnglishKey().compareTo(t1.getEnglishKey()));
        this.segmentsList.setModel(new ListModel<String>(){

            @Override
            public int getSize() {
                return LocalizationUI.this.currentSegments.size();
            }

            @Override
            public String getElementAt(int i) {
                TranslationMemory m = (TranslationMemory)LocalizationUI.this.currentSegments.get(i);
                return m.getEnglishKey();
            }

            @Override
            public void addListDataListener(ListDataListener ll) {
            }

            @Override
            public void removeListDataListener(ListDataListener ll) {
            }
        });
        this.segmentsList.setSelectedIndex(0);
    }

    private List<TranslationMemory> filterSegmentList(List<TranslationMemory> list) {
        boolean showOnlyUntranslated = this.filterShowUntranslatedRadioButton.isSelected();
        boolean showOnlyUncategorized = this.filterShowUncategorizedRadioButton.isSelected();
        boolean showOnlySuspect = this.filterShowSuspectRadioButton.isSelected();
        boolean showOnlyTranslatable = this.filterShowTranslatableRadioButton.isSelected();
        return list.stream().filter(s -> {
            TranslationSummary.TranslationSummaryEntry tse = this.translations.getSummaryForKey(s.getEnglishKey());
            if (showOnlyUntranslated && (!s.getMachineTranslation().isEmpty() || !s.getTranslation().isEmpty() || tse.isUntranslatable() || tse.isSuspectSegment() || tse.getEligibleForMachineTranslation() != null)) {
                return false;
            }
            if (showOnlyUncategorized && (tse.getEligibleForMachineTranslation() != null || tse.isUntranslatable() || tse.isSuspectSegment())) {
                return false;
            }
            if (showOnlySuspect && !tse.isSuspectSegment()) {
                return false;
            }
            return !showOnlyTranslatable || !tse.isUntranslatable() && !tse.isSuspectSegment() && tse.getEligibleForMachineTranslation() == null;
        }).collect(Collectors.toList());
    }

    private Font getFontForLocale(Locale locale) {
        List<String> fonts = locale.getUseFonts();
        Font useFont = null;
        if (fonts.isEmpty()) {
            useFont = new JLabel().getFont();
        }
        if (useFont == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font font : ge.getAllFonts()) {
                if (!fonts.contains(font.getFamily())) continue;
                useFont = font;
                break;
            }
        }
        if (useFont == null) {
            useFont = new JLabel().getFont();
        }
        return new Font(useFont.getName(), 0, 11);
    }

    private void populateSegment(TranslationMemory tm) {
        Font localeFieldFont = this.getFontForLocale(tm.getLocale());
        TranslationSummary.TranslationSummaryEntry summary = this.translations.getSummaryForKey(tm.getEnglishKey());
        this.currentMemory = tm;
        this.currentSummary = summary;
        this.summaryIdField.setText(Integer.toString(summary.getId()));
        this.summaryEnglishKeyField.setText(summary.getEnglishKey());
        this.summaryGlobalCommentField.setText(summary.getComment());
        this.summaryIsUntranslatable.setSelected(summary.isUntranslatable());
        this.summaryIsSuspectSegment.setSelected(summary.isSuspectSegment());
        Boolean eFMT = summary.getEligibleForMachineTranslation();
        if (eFMT == null) {
            this.summaryMachineTranslatableUncategorizedRadioButton.setSelected(true);
        } else if (eFMT.booleanValue()) {
            this.summaryMachineTranslatableYes.setSelected(true);
        } else {
            this.summaryMachineTranslatableNo.setSelected(true);
        }
        this.summaryAppearsOnPagesList.setModel(this.buildListModel(Arrays.asList("Discovering...")));
        this.summaryAppearsOnPagesList.setEnabled(false);
        new Thread(() -> {
            TranslationMemory myTM = tm;
            ArrayList<String> pages = new ArrayList<String>();
            for (String page : this.translations.getPages()) {
                for (TranslationMemory tt : this.translations.getMemoriesForPage(Locale.getDummyLocale(), page)) {
                    if (tt.getId() != tm.getId()) continue;
                    pages.add(page);
                }
            }
            EventQueue.invokeLater(() -> {
                if (tm == myTM) {
                    this.summaryAppearsOnPagesList.setModel(this.buildListModel(pages));
                    this.summaryAppearsOnPagesList.setEnabled(true);
                }
            });
        }, "FindPagesThread").start();
        this.setSummarySettingsEnabled(true);
        if (this.localeList.getSelectedIndex() != 0) {
            if (this.localeList.getSelectedValue().equals("art") || this.azureKey != null) {
                this.localeSettingsMachineTranslationGenerateButton.setEnabled(true);
            }
            this.localeSettingsLocaleIdField.setText(tm.getLocale().getLocale() + "-" + tm.getId());
            this.localeSettingsLocaleCommentField.setText(tm.getComment());
            this.localeSettingsMachineTranslationField.setText(tm.getMachineTranslation());
            this.localeSettingsManualTranslationField.setText(tm.getTranslation());
            this.setLocaleSettingsEnabled(!summary.isSuspectSegment() && !summary.isUntranslatable() && summary.getEligibleForMachineTranslation() != null);
        } else {
            this.setLocaleSettingsEnabled(false);
            this.localeSettingsLocaleIdField.setText("");
            this.localeSettingsLocaleCommentField.setText("");
            this.localeSettingsMachineTranslationField.setText("");
            this.localeSettingsManualTranslationField.setText("");
        }
        this.localeSettingsLocaleCommentField.setFont(localeFieldFont);
        this.localeSettingsMachineTranslationField.setFont(localeFieldFont);
        this.localeSettingsManualTranslationField.setFont(localeFieldFont);
        ComponentOrientation co = tm.getLocale().getTextDirection() == TextDirection.LTR ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
        this.localeSettingsLocaleCommentField.setComponentOrientation(co);
        this.localeSettingsMachineTranslationField.setComponentOrientation(co);
        this.localeSettingsManualTranslationField.setComponentOrientation(co);
        boolean isUntranslatable = this.summaryIsUntranslatable.isSelected();
        UIUtils.setEnabled(!isUntranslatable, this.summaryMachineTranslatableNo, this.summaryMachineTranslatableUncategorizedRadioButton, this.summaryMachineTranslatableYes);
    }

    private void updateCurrent() {
        this.setUnsavedChanges(true);
        this.currentSummary.setComment(this.summaryGlobalCommentField.getText());
        this.currentSummary.setSuspectSegment(this.summaryIsSuspectSegment.isSelected());
        boolean isUntranslatable = this.summaryIsUntranslatable.isSelected();
        this.currentSummary.setUntranslatable(isUntranslatable);
        Boolean eFMT = this.summaryMachineTranslatableYes.isSelected() ? Boolean.valueOf(true) : (this.summaryMachineTranslatableNo.isSelected() ? Boolean.valueOf(false) : null);
        this.currentSummary.setEligibleForMachineTranslation(eFMT);
        if (this.localeList.getSelectedIndex() != 0) {
            this.currentMemory.setComment(this.localeSettingsLocaleCommentField.getText());
            this.currentMemory.setTranslation(this.localeSettingsManualTranslationField.getText());
            this.setLocaleSettingsEnabled(!this.currentSummary.isSuspectSegment() && !this.currentSummary.isUntranslatable());
        }
    }

    private <T> ListModel<T> buildListModel(final List<T> list) {
        return new ListModel<T>(){

            @Override
            public int getSize() {
                return list.size();
            }

            @Override
            public T getElementAt(int i) {
                return list.get(i);
            }

            @Override
            public void addListDataListener(ListDataListener ll) {
            }

            @Override
            public void removeListDataListener(ListDataListener ll) {
            }
        };
    }

    private void setProgressStatus(String status, double current, double total) {
        this.logViewer.pushLog(status);
        EventQueue.invokeLater(() -> {
            this.statusLabel.setText(status);
            this.progressBar.setVisible(true);
            if (current == 0.0 && total == 0.0 || current == total) {
                this.progressBar.setIndeterminate(true);
            } else {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setMaximum((int)total);
                this.progressBar.setValue((int)current);
            }
        });
    }

    private void setStatus(String status) {
        this.logViewer.pushLog(status);
        EventQueue.invokeLater(() -> {
            this.progressBar.setVisible(false);
            this.statusLabel.setText(status);
        });
    }

    private void setSilentStatus(String status) {
        this.logViewer.pushLog(status);
    }

    private void setUnsavedChanges(boolean to) {
        this.unsavedChanges = to;
        String p2 = "";
        if (this.unsavedChanges) {
            p2 = "* ";
        }
        String title2 = p2 + "L10N Interface";
        EventQueue.invokeLater(() -> {
            this.setTitle(title2);
            this.menuSave.setEnabled(this.unsavedChanges);
        });
    }

    public void authorizeGithub(boolean clearFirst, GithubAuthSuccess success) {
        String authorizationUrl = "https://github.com/login/oauth/authorize";
        String clientId = "9574af3fc79384fa690a";
        String clientSecret = "e767193ef18fd213dcde506f8f465e873c1a5927";
        String scope = "public_repo";
        String tokenUrl = "https://github.com/login/oauth/access_token";
        OAuth.x_get_oauth_token.OAuthOptions options = new OAuth.x_get_oauth_token.OAuthOptions(authorizationUrl, clientId, clientSecret, scope, tokenUrl);
        new Thread(() -> {
            try {
                if (clearFirst) {
                    OAuth.clear_oauth_tokens.execute(this.gEnv, clientId);
                }
                options.forcePort = 5346;
                String githubOAuthToken = OAuth.x_get_oauth_token.execute(this.gEnv, options);
                success.token(githubOAuthToken);
            }
            catch (Exception ex) {
                this.showError(ex.getMessage());
            }
        }, "GithubAuth").start();
    }

    private void doSave(Runnable onSuccess) {
        if (this.unsavedChanges) {
            new Thread(() -> {
                try {
                    this.translations.save((current, total) -> this.setProgressStatus("Saving...", current, total));
                    this.setUnsavedChanges(false);
                    this.setStatus(FINISHED);
                    onSuccess.run();
                }
                catch (IOException ex) {
                    UIUtils.alert(this, "Error while saving!", "Could not save the database: " + ex.getMessage(), UIUtils.MessageType.ERROR);
                    this.setStatus("Error saving...");
                }
            }).start();
            this.setProgressStatus("Saving...", 0.0, 0.0);
        } else {
            onSuccess.run();
        }
    }

    private void doCommit(Runnable success) {
        new Thread(() -> {
            try {
                String gitStatus = CommandExecutor.Execute(this.translations.getTranslationDb(), "git", "status", "--porcelain");
                if ("".equals(gitStatus)) {
                    UIUtils.alert(this, "No changes", "No changes to commit!");
                    success.run();
                    return;
                }
                String commitMessage = UIUtils.prompt(this, "Commit Message", "Enter a descriptive commit message, summarizing your changes.");
                CommandExecutor.Execute(this.translations.getTranslationDb(), "git", "add", ".");
                CommandExecutor.Execute(this.translations.getTranslationDb(), "git", "commit", "-m", commitMessage);
                success.run();
            }
            catch (IOException | InterruptedException ex) {
                UIUtils.alert(this, "Error", ex.getMessage());
            }
            finally {
                this.setStatus(FINISHED);
            }
        }, "CommitChanges").start();
        this.setStatus("Committing...");
    }

    private void doPush(Runnable success) {
        new Thread(() -> {
            try {
                String diff = CommandExecutor.Execute(this.translations.getTranslationDb(), "git", "log", "origin/master..master");
                if ("".equals(diff)) {
                    UIUtils.alert(this, "No changes", "No commits need to be pushed.");
                    success.run();
                    return;
                }
                CommandExecutor.Execute(this.translations.getTranslationDb(), "git", "push");
            }
            catch (IOException | InterruptedException ex) {
                UIUtils.alert(this, "Error", ex.getMessage());
            }
            finally {
                this.setStatus(FINISHED);
            }
        }, "PushChanges").start();
        this.setStatus("Pushing...");
    }

    public static interface GithubAuthSuccess {
        public void token(String var1);
    }
}

