/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public interface MachineTranslation {
    public String translate(String var1, String var2) throws TranslationException;

    default public Map<String, String> bulkTranslate(String locale, Set<String> englishStrings, ErrorCallback callback) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String english : englishStrings) {
            try {
                ret.put(english, this.translate(locale, english));
            }
            catch (TranslationException ex) {
                callback.error(ex);
            }
        }
        return ret;
    }

    public static class ArtMachineTranslation {
        public static String doArtTranslation(String english) {
            return english.replace("a", "\u00e5").replace("e", "\u0259").replace("i", "\u00ee").replace("o", "\u00f8").replace("u", "\u00fc").replace("y", "\u028e");
        }

        public static Map<String, String> doArtTranslation(Set<String> english) {
            HashMap<String, String> ret = new HashMap<String, String>();
            for (String s : english) {
                ret.put(s, ArtMachineTranslation.doArtTranslation(s));
            }
            return ret;
        }
    }

    public static interface ErrorCallback {
        public void error(TranslationException var1);
    }

    public static class TranslationException
    extends Exception {
        private final boolean wasFatal;

        public TranslationException(boolean wasFatal) {
            this.wasFatal = wasFatal;
        }

        public TranslationException(Exception cause, boolean wasFatal) {
            super(cause);
            this.wasFatal = wasFatal;
        }

        public TranslationException(String message, Exception cause, boolean wasFatal) {
            super(message, cause);
            this.wasFatal = wasFatal;
        }

        public TranslationException(String message, boolean wasFatal) {
            super(message);
            this.wasFatal = wasFatal;
        }

        public boolean wasFatal() {
            return this.wasFatal;
        }
    }
}

