/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.blocks;

import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCBlockFace;
import com.laytonsmith.abstraction.blocks.MCBlockState;
import com.laytonsmith.abstraction.blocks.MCCommandBlock;
import com.laytonsmith.abstraction.blocks.MCDispenser;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.blocks.MCSign;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCMetadatable;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorld;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockData;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCCommandBlock;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCDispenser;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCMaterial;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCSign;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCBlockFace;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCLegacyMaterial;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.Dispenser;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.Metadatable;

public class BukkitMCBlock
extends BukkitMCMetadatable
implements MCBlock {
    Block b;

    public BukkitMCBlock(Block b) {
        super((Metadatable)b);
        this.b = b;
    }

    public Block __Block() {
        return this.b;
    }

    @Override
    public String toString() {
        return this.b.toString();
    }

    @Override
    public MCMaterial getType() {
        Material type = this.b.getType();
        return type == null ? null : new BukkitMCMaterial(type);
    }

    @Override
    public int getTypeId() {
        if (this.b == null) {
            return 0;
        }
        return Bukkit.getUnsafe().toLegacy(this.b.getType()).getId();
    }

    @Override
    public byte getData() {
        return this.b.getData();
    }

    @Override
    public void setType(MCMaterial mat) {
        this.b.setType((Material)mat.getHandle());
    }

    @Override
    public void setType(MCMaterial mat, boolean physics) {
        this.b.setType((Material)mat.getHandle(), physics);
    }

    @Override
    public void setTypeAndData(int type, byte data, boolean physics) {
        this.b.setBlockData(BukkitMCLegacyMaterial.getBlockData(type, data), physics);
    }

    @Override
    public MCBlockData getBlockData() {
        return new BukkitMCBlockData(this.b.getBlockData());
    }

    @Override
    public void setBlockData(MCBlockData data, boolean physics) {
        this.b.setBlockData((BlockData)data.getHandle(), physics);
    }

    @Override
    public MCBlockState getState() {
        return BukkitConvertor.BukkitGetCorrectBlockState(this.b.getState());
    }

    @Override
    public MCWorld getWorld() {
        return new BukkitMCWorld(this.b.getWorld());
    }

    @Override
    public int getX() {
        return this.b.getX();
    }

    @Override
    public int getY() {
        return this.b.getY();
    }

    @Override
    public int getZ() {
        return this.b.getZ();
    }

    @Override
    public MCSign getSign() {
        return new BukkitMCSign((Sign)this.b.getState());
    }

    @Override
    public boolean isSign() {
        return this.b.getState() instanceof Sign;
    }

    @Override
    public MCCommandBlock getCommandBlock() {
        return new BukkitMCCommandBlock((CommandBlock)this.b.getState());
    }

    @Override
    public boolean isCommandBlock() {
        return this.b.getState() instanceof CommandBlock;
    }

    @Override
    public MCDispenser getDispenser() {
        return new BukkitMCDispenser((Dispenser)this.b.getState());
    }

    @Override
    public boolean isDispenser() {
        return this.b.getType() == Material.DISPENSER;
    }

    @Override
    public Collection<MCItemStack> getDrops() {
        ArrayList<MCItemStack> collection = new ArrayList<MCItemStack>();
        for (ItemStack is : this.b.getDrops()) {
            collection.add(new BukkitMCItemStack(is));
        }
        return collection;
    }

    @Override
    public Collection<MCItemStack> getDrops(MCItemStack tool2) {
        ArrayList<MCItemStack> collection = new ArrayList<MCItemStack>();
        for (ItemStack is : this.b.getDrops(((BukkitMCItemStack)tool2).asItemStack())) {
            collection.add(new BukkitMCItemStack(is));
        }
        return collection;
    }

    @Override
    public boolean isSolid() {
        return this.b.getType().isSolid();
    }

    @Override
    public boolean isFlammable() {
        return this.b.getType().isFlammable();
    }

    @Override
    public boolean isTransparent() {
        return this.b.getType().isTransparent();
    }

    @Override
    public boolean isOccluding() {
        return this.b.getType().isOccluding();
    }

    @Override
    public boolean isBurnable() {
        return this.b.getType().isBurnable();
    }

    @Override
    public boolean isPassable() {
        return this.b.isPassable();
    }

    @Override
    public MCLocation getLocation() {
        return new BukkitMCLocation(this.b.getLocation());
    }

    @Override
    public double getTemperature() {
        return this.b.getTemperature();
    }

    @Override
    public int getLightLevel() {
        return this.b.getLightLevel();
    }

    @Override
    public int getLightFromSky() {
        return this.b.getLightFromSky();
    }

    @Override
    public int getLightFromBlocks() {
        return this.b.getLightFromBlocks();
    }

    @Override
    public int getBlockPower() {
        return this.b.getBlockPower();
    }

    @Override
    public boolean isBlockPowered() {
        return this.b.isBlockPowered();
    }

    @Override
    public boolean isBlockIndirectlyPowered() {
        return this.b.isBlockIndirectlyPowered();
    }

    @Override
    public MCBlock getRelative(MCBlockFace face) {
        return new BukkitMCBlock(this.b.getRelative(face.getModX(), face.getModY(), face.getModZ()));
    }

    @Override
    public MCBlockFace getFace(MCBlock block) {
        return (MCBlockFace)((Object)BukkitMCBlockFace.getConvertor().getAbstractedEnum(this.b.getFace(((BukkitMCBlock)block).b)));
    }

    @Override
    public boolean isEmpty() {
        return this.b == null || this.b.isEmpty();
    }
}

