/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCPotionData;
import com.laytonsmith.abstraction.MCProjectileSource;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCBlockProjectileSource;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCColor;
import com.laytonsmith.abstraction.bukkit.BukkitMCPotionData;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockProjectileSource;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.entities.MCAreaEffectCloud;
import com.laytonsmith.abstraction.enums.MCParticle;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCParticle;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCPotionEffectType;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class BukkitMCAreaEffectCloud
extends BukkitMCEntity
implements MCAreaEffectCloud {
    AreaEffectCloud aec;

    public BukkitMCAreaEffectCloud(Entity aec) {
        super(aec);
        this.aec = (AreaEffectCloud)aec;
    }

    @Override
    public MCPotionData getBasePotionData() {
        return new BukkitMCPotionData(this.aec.getBasePotionData());
    }

    @Override
    public MCColor getColor() {
        return BukkitMCColor.GetMCColor(this.aec.getColor());
    }

    @Override
    public List<MCLivingEntity.MCEffect> getCustomEffects() {
        ArrayList<MCLivingEntity.MCEffect> list = new ArrayList<MCLivingEntity.MCEffect>();
        for (PotionEffect pe : this.aec.getCustomEffects()) {
            list.add(new MCLivingEntity.MCEffect(BukkitMCPotionEffectType.valueOfConcrete(pe.getType()), pe.getAmplifier(), pe.getDuration(), pe.isAmbient(), pe.hasParticles(), pe.hasIcon()));
        }
        return list;
    }

    @Override
    public int getDuration() {
        return this.aec.getDuration();
    }

    @Override
    public int getDurationOnUse() {
        return this.aec.getDurationOnUse();
    }

    @Override
    public MCParticle getParticle() {
        return BukkitMCParticle.valueOfConcrete(this.aec.getParticle());
    }

    @Override
    public float getRadius() {
        return this.aec.getRadius();
    }

    @Override
    public float getRadiusOnUse() {
        return this.aec.getRadiusOnUse();
    }

    @Override
    public float getRadiusPerTick() {
        return this.aec.getRadiusPerTick();
    }

    @Override
    public int getReapplicationDelay() {
        return this.aec.getReapplicationDelay();
    }

    @Override
    public MCProjectileSource getSource() {
        ProjectileSource source = this.aec.getSource();
        if (source instanceof BlockProjectileSource) {
            return new BukkitMCBlockProjectileSource((BlockProjectileSource)source);
        }
        return (MCProjectileSource)((Object)BukkitConvertor.BukkitGetCorrectEntity((Entity)source));
    }

    @Override
    public int getWaitTime() {
        return this.aec.getWaitTime();
    }

    @Override
    public void addCustomEffect(MCLivingEntity.MCEffect effect) {
        PotionEffectType type = (PotionEffectType)effect.getPotionEffectType().getConcrete();
        PotionEffect pe = new PotionEffect(type, effect.getTicksRemaining(), effect.getStrength(), effect.isAmbient(), effect.hasParticles(), effect.showIcon());
        this.aec.addCustomEffect(pe, true);
    }

    @Override
    public void clearCustomEffects() {
        this.aec.clearCustomEffects();
    }

    @Override
    public void setBasePotionData(MCPotionData pd) {
        this.aec.setBasePotionData((PotionData)pd.getHandle());
    }

    @Override
    public void setColor(MCColor color2) {
        this.aec.setColor(BukkitMCColor.GetColor(color2));
    }

    @Override
    public void setDuration(int ticks) {
        this.aec.setDuration(ticks);
    }

    @Override
    public void setDurationOnUse(int ticks) {
        this.aec.setDurationOnUse(ticks);
    }

    @Override
    public void setParticle(MCParticle particle, Object data) {
        Particle type = (Particle)((BukkitMCParticle)particle).getConcrete();
        switch (type) {
            case BLOCK_DUST: 
            case BLOCK_CRACK: 
            case FALLING_DUST: {
                if (data instanceof MCBlockData) {
                    this.aec.setParticle(type, ((MCBlockData)data).getHandle());
                } else {
                    this.aec.setParticle(type, (Object)Material.STONE.createBlockData());
                }
                return;
            }
            case ITEM_CRACK: {
                if (data instanceof MCItemStack) {
                    this.aec.setParticle(type, ((MCItemStack)data).getHandle());
                } else {
                    this.aec.setParticle(type, (Object)new ItemStack(Material.STONE, 1));
                }
                return;
            }
            case REDSTONE: {
                if (data instanceof MCColor) {
                    Particle.DustOptions color2 = new Particle.DustOptions(BukkitMCColor.GetColor((MCColor)data), 1.0f);
                    this.aec.setParticle(type, (Object)color2);
                } else {
                    this.aec.setParticle(type, (Object)new Particle.DustOptions(Color.RED, 1.0f));
                }
                return;
            }
        }
        this.aec.setParticle(type);
    }

    @Override
    public void setRadius(float radius) {
        this.aec.setRadius(radius);
    }

    @Override
    public void setRadiusOnUse(float radius) {
        this.aec.setRadiusOnUse(radius);
    }

    @Override
    public void setRadiusPerTick(float radius) {
        this.aec.setRadiusPerTick(radius);
    }

    @Override
    public void setReapplicationDelay(int ticks) {
        this.aec.setReapplicationDelay(ticks);
    }

    @Override
    public void setSource(MCProjectileSource source) {
        if (source == null) {
            this.aec.setSource(null);
        } else if (source instanceof MCBlockProjectileSource) {
            this.aec.setSource((ProjectileSource)((BlockProjectileSource)source.getHandle()));
        } else {
            this.aec.setSource((ProjectileSource)source.getHandle());
        }
    }

    @Override
    public void setWaitTime(int ticks) {
        this.aec.setWaitTime(ticks);
    }
}

