/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.abstraction.MCAttributeModifier;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCEntityEquipment;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCAttributeModifier;
import com.laytonsmith.abstraction.bukkit.BukkitMCEntityEquipment;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntityProjectileSource;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.enums.MCAttribute;
import com.laytonsmith.abstraction.enums.MCPotionEffectType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCAttribute;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCPotionEffectType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREBadEntityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.BlockIterator;

public class BukkitMCLivingEntity
extends BukkitMCEntityProjectileSource
implements MCLivingEntity {
    LivingEntity le;

    public BukkitMCLivingEntity(Entity ent) {
        super(ent);
        this.le = (LivingEntity)ent;
    }

    @Override
    public double getHealth() {
        return this.le.getHealth();
    }

    @Override
    public void setHealth(double i) {
        this.le.setHealth(i);
    }

    @Override
    public double getMaxHealth() {
        AttributeInstance maxHealth = this.le.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (maxHealth == null) {
            return this.le.getHealth();
        }
        return maxHealth.getValue();
    }

    @Override
    public void setMaxHealth(double health) {
        AttributeInstance maxHealth = this.le.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (maxHealth == null) {
            this.le.setHealth(health);
            return;
        }
        maxHealth.setBaseValue(health);
        if (this.le.getHealth() > health) {
            this.le.setHealth(health);
        }
    }

    @Override
    public void resetMaxHealth() {
        AttributeInstance maxHealth = this.le.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (maxHealth == null) {
            return;
        }
        double defaultHealth = maxHealth.getDefaultValue();
        maxHealth.setBaseValue(defaultHealth);
        if (this.le.getHealth() > defaultHealth) {
            this.le.setHealth(defaultHealth);
        }
    }

    @Override
    public void damage(double i) {
        this.le.damage(i);
    }

    @Override
    public void damage(double amount, MCEntity source) {
        this.le.damage(amount, ((BukkitMCEntity)source).getHandle());
    }

    @Override
    public double getEyeHeight() {
        return this.le.getEyeHeight();
    }

    @Override
    public double getEyeHeight(boolean ignoreSneaking) {
        return this.le.getEyeHeight(ignoreSneaking);
    }

    @Override
    public MCLocation getEyeLocation() {
        return new BukkitMCLocation(this.le.getEyeLocation());
    }

    @Override
    public MCPlayer getKiller() {
        return new BukkitMCPlayer((Entity)this.le.getKiller());
    }

    @Override
    public double getLastDamage() {
        return this.le.getLastDamage();
    }

    @Override
    public MCBlock getTargetSpace(int maxDistance) {
        List<Block> lst = this.getLineOfSight(null, maxDistance, 2);
        return new BukkitMCBlock(lst.get(0));
    }

    @Override
    public List<MCBlock> getLineOfSight(HashSet<MCMaterial> transparent, int maxDistance) {
        List<Block> lst = this.getLineOfSight(transparent, maxDistance, 512);
        ArrayList<MCBlock> retn = new ArrayList<MCBlock>();
        for (Block b : lst) {
            retn.add(new BukkitMCBlock(b));
        }
        return retn;
    }

    private List<Block> getLineOfSight(HashSet<MCMaterial> transparent, int maxDistance, int maxLength) {
        if (maxDistance > 512) {
            maxDistance = 512;
        }
        HashSet<Material> ignored = new HashSet<Material>();
        if (transparent != null) {
            for (MCMaterial mat : transparent) {
                ignored.add((Material)mat.getHandle());
            }
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator(this.le, maxDistance);
        while (itr.hasNext()) {
            Material id;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (!(transparent == null ? !block.isEmpty() : !ignored.contains(id = block.getType()))) continue;
            break;
        }
        return blocks;
    }

    @Override
    public boolean hasLineOfSight(MCEntity other) {
        return this.le.hasLineOfSight(((BukkitMCEntity)other).getHandle());
    }

    @Override
    public int getMaximumAir() {
        return this.le.getMaximumAir();
    }

    @Override
    public int getNoDamageTicks() {
        if (this.le.getNoDamageTicks() < 10) {
            return 0;
        }
        return this.le.getNoDamageTicks() - 10;
    }

    @Override
    public int getRemainingAir() {
        return this.le.getRemainingAir();
    }

    @Override
    public MCBlock getTargetBlock(HashSet<MCMaterial> b, int i) {
        List<Block> blocks = this.getLineOfSight(b, i, 1);
        return new BukkitMCBlock(blocks.get(0));
    }

    @Override
    public boolean hasAI() {
        return this.le.hasAI();
    }

    @Override
    public boolean addEffect(MCPotionEffectType type, int strength, int ticks, boolean ambient, boolean particles, boolean icon) {
        PotionEffect pe = new PotionEffect((PotionEffectType)type.getConcrete(), ticks, strength, ambient, particles, icon);
        return this.le.addPotionEffect(pe, true);
    }

    @Override
    public boolean removeEffect(MCPotionEffectType type) {
        PotionEffectType t = (PotionEffectType)type.getConcrete();
        boolean hasIt = false;
        for (PotionEffect pe : this.le.getActivePotionEffects()) {
            if (pe.getType() != t) continue;
            hasIt = true;
            break;
        }
        this.le.removePotionEffect(t);
        return hasIt;
    }

    @Override
    public void removeEffects() {
        for (PotionEffect pe : this.le.getActivePotionEffects()) {
            this.le.removePotionEffect(pe.getType());
        }
    }

    @Override
    public List<MCLivingEntity.MCEffect> getEffects() {
        ArrayList<MCLivingEntity.MCEffect> effects = new ArrayList<MCLivingEntity.MCEffect>();
        for (PotionEffect pe : this.le.getActivePotionEffects()) {
            MCLivingEntity.MCEffect e = new MCLivingEntity.MCEffect(BukkitMCPotionEffectType.valueOfConcrete(pe.getType()), pe.getAmplifier(), pe.getDuration(), pe.isAmbient(), pe.hasParticles(), pe.hasIcon());
            effects.add(e);
        }
        return effects;
    }

    @Override
    public void setLastDamage(double damage) {
        this.le.setLastDamage(damage);
    }

    @Override
    public void setMaximumAir(int ticks) {
        this.le.setMaximumAir(ticks);
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        this.le.setNoDamageTicks(ticks + 10);
    }

    @Override
    public void setRemainingAir(int ticks) {
        this.le.setRemainingAir(ticks);
    }

    public LivingEntity asLivingEntity() {
        return this.le;
    }

    @Override
    public MCEntityEquipment getEquipment() {
        if (this.le.getEquipment() == null) {
            return null;
        }
        return new BukkitMCEntityEquipment(this.le.getEquipment());
    }

    @Override
    public boolean getCanPickupItems() {
        return this.le.getCanPickupItems();
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        this.le.setCanPickupItems(pickup);
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        return this.le.getRemoveWhenFarAway();
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
        this.le.setRemoveWhenFarAway(remove);
    }

    @Override
    public MCLivingEntity getTarget(Target t) {
        if (!(this.le instanceof Mob)) {
            throw new CREBadEntityException("This type of entity does not have a target API", t);
        }
        LivingEntity target = ((Mob)this.le).getTarget();
        if (target == null) {
            return null;
        }
        return new BukkitMCLivingEntity((Entity)target);
    }

    @Override
    public void setTarget(MCLivingEntity target, Target t) {
        if (!(this.le instanceof Mob)) {
            throw new CREBadEntityException("This type of entity not have a target API", t);
        }
        if (target == null) {
            ((Mob)this.le).setTarget(null);
        } else {
            ((Mob)this.le).setTarget(((BukkitMCLivingEntity)target).asLivingEntity());
        }
    }

    @Override
    public void kill() {
        this.le.setLastDamageCause(new EntityDamageEvent((Entity)this.le, EntityDamageEvent.DamageCause.CUSTOM, this.le.getHealth()));
        this.le.setHealth(0.0);
    }

    @Override
    public MCEntity getLeashHolder() {
        if (this.le.isLeashed()) {
            return BukkitConvertor.BukkitGetCorrectEntity(this.le.getLeashHolder());
        }
        return null;
    }

    @Override
    public boolean isLeashed() {
        return this.le.isLeashed();
    }

    @Override
    public void setLeashHolder(MCEntity holder) {
        if (holder == null) {
            this.le.setLeashHolder(null);
        } else {
            this.le.setLeashHolder(((BukkitMCEntity)holder).getHandle());
        }
    }

    @Override
    public boolean isGliding() {
        return this.le.isGliding();
    }

    @Override
    public void setGliding(Boolean glide) {
        this.le.setGliding(glide.booleanValue());
    }

    @Override
    public void setAI(Boolean ai) {
        this.le.setAI(ai.booleanValue());
    }

    @Override
    public boolean isCollidable() {
        return this.le.isCollidable();
    }

    @Override
    public void setCollidable(boolean collidable) {
        this.le.setCollidable(collidable);
    }

    @Override
    public boolean isTameable() {
        return false;
    }

    private AttributeInstance getAttributeInstance(MCAttribute attr) {
        AttributeInstance instance = this.le.getAttribute((Attribute)BukkitMCAttribute.getConvertor().getConcreteEnum(attr));
        if (instance == null) {
            throw new IllegalArgumentException("This attribute is not applicable to this entity type.");
        }
        return instance;
    }

    @Override
    public double getAttributeValue(MCAttribute attr) {
        return this.getAttributeInstance(attr).getValue();
    }

    @Override
    public double getAttributeDefault(MCAttribute attr) {
        return this.getAttributeInstance(attr).getDefaultValue();
    }

    @Override
    public double getAttributeBase(MCAttribute attr) {
        return this.getAttributeInstance(attr).getBaseValue();
    }

    @Override
    public void setAttributeBase(MCAttribute attr, double base) {
        this.getAttributeInstance(attr).setBaseValue(base);
    }

    @Override
    public void resetAttributeBase(MCAttribute attr) {
        AttributeInstance instance = this.getAttributeInstance(attr);
        instance.setBaseValue(instance.getDefaultValue());
    }

    @Override
    public List<MCAttributeModifier> getAttributeModifiers(MCAttribute attr) {
        Attribute bukkitAttribute = (Attribute)BukkitMCAttribute.getConvertor().getConcreteEnum(attr);
        AttributeInstance instance = this.le.getAttribute(bukkitAttribute);
        if (instance == null) {
            throw new IllegalArgumentException("This attribute is not applicable to this entity type.");
        }
        Collection modifiers = instance.getModifiers();
        ArrayList<MCAttributeModifier> ret = new ArrayList<MCAttributeModifier>();
        for (AttributeModifier modifier : modifiers) {
            ret.add(new BukkitMCAttributeModifier(bukkitAttribute, modifier));
        }
        return ret;
    }

    @Override
    public void addAttributeModifier(MCAttributeModifier modifier) {
        this.getAttributeInstance(modifier.getAttribute()).addModifier((AttributeModifier)modifier.getHandle());
    }

    @Override
    public void removeAttributeModifier(MCAttributeModifier modifier) {
        this.getAttributeInstance(modifier.getAttribute()).removeModifier((AttributeModifier)modifier.getHandle());
    }

    @Override
    public boolean isSleeping() {
        return this.le.isSleeping();
    }
}

