/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.Static;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.material.MaterialData;

public class BukkitMCLegacyMaterial {
    private static final HashMap<String, Material> BY_NAME = new HashMap();
    private static final HashMap<Integer, LegacyMaterialId> BY_ID = new HashMap();

    public static void build() {
        for (LegacyMaterialId legacyMaterialId : LegacyMaterialId.values()) {
            BY_ID.put(legacyMaterialId.getId(), legacyMaterialId);
        }
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_14)) {
            for (Enum enum_ : LegacyMaterialName.values()) {
                BY_NAME.put(enum_.name(), ((LegacyMaterialName)enum_).getNewMaterial());
            }
        }
    }

    public static Material getMaterial(int id) {
        LegacyMaterialId legacy = BY_ID.get(id);
        if (legacy == null) {
            return null;
        }
        return BukkitMCLegacyMaterial.getMaterial(legacy.name());
    }

    public static Material getMaterial(String name) {
        Material mat = Material.getMaterial((String)name, (boolean)true);
        if (mat == null || mat == Material.AIR) {
            mat = BY_NAME.get(name);
        }
        return mat;
    }

    public static Material getMaterial(int id, int data) {
        LegacyMaterialId legacy = BY_ID.get(id);
        if (legacy == null) {
            return null;
        }
        return BukkitMCLegacyMaterial.getMaterial(legacy.name(), data);
    }

    public static Material getMaterial(String type, int data) {
        return BukkitMCLegacyMaterial.getMaterial(Material.getMaterial((String)("LEGACY_" + type)), data);
    }

    public static Material getMaterial(Material legacymat, int data) {
        if (legacymat == null) {
            return null;
        }
        if (legacymat.getMaxDurability() == 0) {
            if (legacymat.equals((Object)Material.LEGACY_ANVIL)) {
                return Bukkit.getUnsafe().fromLegacy(new MaterialData(legacymat, (byte)data), true);
            }
            return Bukkit.getUnsafe().fromLegacy(new MaterialData(legacymat, (byte)data));
        }
        return Bukkit.getUnsafe().fromLegacy(legacymat);
    }

    public static BlockData getBlockData(int id, int data) {
        LegacyMaterialId legacy = BY_ID.get(id);
        if (legacy == null) {
            return Material.AIR.createBlockData();
        }
        Material mat = Material.getMaterial((String)("LEGACY_" + legacy.name()));
        return Bukkit.getUnsafe().fromLegacy(mat, (byte)data);
    }

    public static enum LegacyMaterialName {
        CACTUS_GREEN(Material.GREEN_DYE),
        DANDELION_YELLOW(Material.YELLOW_DYE),
        ROSE_RED(Material.RED_DYE),
        SIGN(Material.OAK_SIGN),
        WALL_SIGN(Material.OAK_WALL_SIGN);

        private final Material mat;

        private LegacyMaterialName(Material mat) {
            this.mat = mat;
        }

        public Material getNewMaterial() {
            return this.mat;
        }
    }

    public static enum LegacyMaterialId {
        AIR(0),
        STONE(1),
        GRASS(2),
        DIRT(3),
        COBBLESTONE(4),
        WOOD(5),
        SAPLING(6),
        BEDROCK(7),
        WATER(8),
        STATIONARY_WATER(9),
        LAVA(10),
        STATIONARY_LAVA(11),
        SAND(12),
        GRAVEL(13),
        GOLD_ORE(14),
        IRON_ORE(15),
        COAL_ORE(16),
        LOG(17),
        LEAVES(18),
        SPONGE(19),
        GLASS(20),
        LAPIS_ORE(21),
        LAPIS_BLOCK(22),
        DISPENSER(23),
        SANDSTONE(24),
        NOTE_BLOCK(25),
        BED_BLOCK(26),
        POWERED_RAIL(27),
        DETECTOR_RAIL(28),
        PISTON_STICKY_BASE(29),
        WEB(30),
        LONG_GRASS(31),
        DEAD_BUSH(32),
        PISTON_BASE(33),
        PISTON_EXTENSION(34),
        WOOL(35),
        PISTON_MOVING_PIECE(36),
        YELLOW_FLOWER(37),
        RED_ROSE(38),
        BROWN_MUSHROOM(39),
        RED_MUSHROOM(40),
        GOLD_BLOCK(41),
        IRON_BLOCK(42),
        DOUBLE_STEP(43),
        STEP(44),
        BRICK(45),
        TNT(46),
        BOOKSHELF(47),
        MOSSY_COBBLESTONE(48),
        OBSIDIAN(49),
        TORCH(50),
        FIRE(51),
        MOB_SPAWNER(52),
        WOOD_STAIRS(53),
        CHEST(54),
        REDSTONE_WIRE(55),
        DIAMOND_ORE(56),
        DIAMOND_BLOCK(57),
        WORKBENCH(58),
        CROPS(59),
        SOIL(60),
        FURNACE(61),
        BURNING_FURNACE(62),
        SIGN_POST(63),
        WOODEN_DOOR(64),
        LADDER(65),
        RAILS(66),
        COBBLESTONE_STAIRS(67),
        WALL_SIGN(68),
        LEVER(69),
        STONE_PLATE(70),
        IRON_DOOR_BLOCK(71),
        WOOD_PLATE(72),
        REDSTONE_ORE(73),
        GLOWING_REDSTONE_ORE(74),
        REDSTONE_TORCH_OFF(75),
        REDSTONE_TORCH_ON(76),
        STONE_BUTTON(77),
        SNOW(78),
        ICE(79),
        SNOW_BLOCK(80),
        CACTUS(81),
        CLAY(82),
        SUGAR_CANE_BLOCK(83),
        JUKEBOX(84),
        FENCE(85),
        PUMPKIN(86),
        NETHERRACK(87),
        SOUL_SAND(88),
        GLOWSTONE(89),
        PORTAL(90),
        JACK_O_LANTERN(91),
        CAKE_BLOCK(92),
        DIODE_BLOCK_OFF(93),
        DIODE_BLOCK_ON(94),
        STAINED_GLASS(95),
        TRAP_DOOR(96),
        MONSTER_EGGS(97),
        SMOOTH_BRICK(98),
        HUGE_MUSHROOM_1(99),
        HUGE_MUSHROOM_2(100),
        IRON_FENCE(101),
        THIN_GLASS(102),
        MELON_BLOCK(103),
        PUMPKIN_STEM(104),
        MELON_STEM(105),
        VINE(106),
        FENCE_GATE(107),
        BRICK_STAIRS(108),
        SMOOTH_STAIRS(109),
        MYCEL(110),
        WATER_LILY(111),
        NETHER_BRICK(112),
        NETHER_FENCE(113),
        NETHER_BRICK_STAIRS(114),
        NETHER_WARTS(115),
        ENCHANTMENT_TABLE(116),
        BREWING_STAND(117),
        CAULDRON(118),
        ENDER_PORTAL(119),
        ENDER_PORTAL_FRAME(120),
        ENDER_STONE(121),
        DRAGON_EGG(122),
        REDSTONE_LAMP_OFF(123),
        REDSTONE_LAMP_ON(124),
        WOOD_DOUBLE_STEP(125),
        WOOD_STEP(126),
        COCOA(127),
        SANDSTONE_STAIRS(128),
        EMERALD_ORE(129),
        ENDER_CHEST(130),
        TRIPWIRE_HOOK(131),
        TRIPWIRE(132),
        EMERALD_BLOCK(133),
        SPRUCE_WOOD_STAIRS(134),
        BIRCH_WOOD_STAIRS(135),
        JUNGLE_WOOD_STAIRS(136),
        COMMAND(137),
        BEACON(138),
        COBBLE_WALL(139),
        FLOWER_POT(140),
        CARROT(141),
        POTATO(142),
        WOOD_BUTTON(143),
        SKULL(144),
        ANVIL(145),
        TRAPPED_CHEST(146),
        GOLD_PLATE(147),
        IRON_PLATE(148),
        REDSTONE_COMPARATOR_OFF(149),
        REDSTONE_COMPARATOR_ON(150),
        DAYLIGHT_DETECTOR(151),
        REDSTONE_BLOCK(152),
        QUARTZ_ORE(153),
        HOPPER(154),
        QUARTZ_BLOCK(155),
        QUARTZ_STAIRS(156),
        ACTIVATOR_RAIL(157),
        DROPPER(158),
        STAINED_CLAY(159),
        STAINED_GLASS_PANE(160),
        LEAVES_2(161),
        LOG_2(162),
        ACACIA_STAIRS(163),
        DARK_OAK_STAIRS(164),
        SLIME_BLOCK(165),
        BARRIER(166),
        IRON_TRAPDOOR(167),
        PRISMARINE(168),
        SEA_LANTERN(169),
        HAY_BLOCK(170),
        CARPET(171),
        HARD_CLAY(172),
        COAL_BLOCK(173),
        PACKED_ICE(174),
        DOUBLE_PLANT(175),
        STANDING_BANNER(176),
        WALL_BANNER(177),
        DAYLIGHT_DETECTOR_INVERTED(178),
        RED_SANDSTONE(179),
        RED_SANDSTONE_STAIRS(180),
        DOUBLE_STONE_SLAB2(181),
        STONE_SLAB2(182),
        SPRUCE_FENCE_GATE(183),
        BIRCH_FENCE_GATE(184),
        JUNGLE_FENCE_GATE(185),
        DARK_OAK_FENCE_GATE(186),
        ACACIA_FENCE_GATE(187),
        SPRUCE_FENCE(188),
        BIRCH_FENCE(189),
        JUNGLE_FENCE(190),
        DARK_OAK_FENCE(191),
        ACACIA_FENCE(192),
        SPRUCE_DOOR(193),
        BIRCH_DOOR(194),
        JUNGLE_DOOR(195),
        ACACIA_DOOR(196),
        DARK_OAK_DOOR(197),
        END_ROD(198),
        CHORUS_PLANT(199),
        CHORUS_FLOWER(200),
        PURPUR_BLOCK(201),
        PURPUR_PILLAR(202),
        PURPUR_STAIRS(203),
        PURPUR_DOUBLE_SLAB(204),
        PURPUR_SLAB(205),
        END_BRICKS(206),
        BEETROOT_BLOCK(207),
        GRASS_PATH(208),
        END_GATEWAY(209),
        COMMAND_REPEATING(210),
        COMMAND_CHAIN(211),
        FROSTED_ICE(212),
        MAGMA(213),
        NETHER_WART_BLOCK(214),
        RED_NETHER_BRICK(215),
        BONE_BLOCK(216),
        STRUCTURE_VOID(217),
        OBSERVER(218),
        WHITE_SHULKER_BOX(219),
        ORANGE_SHULKER_BOX(220),
        MAGENTA_SHULKER_BOX(221),
        LIGHT_BLUE_SHULKER_BOX(222),
        YELLOW_SHULKER_BOX(223),
        LIME_SHULKER_BOX(224),
        PINK_SHULKER_BOX(225),
        GRAY_SHULKER_BOX(226),
        SILVER_SHULKER_BOX(227),
        CYAN_SHULKER_BOX(228),
        PURPLE_SHULKER_BOX(229),
        BLUE_SHULKER_BOX(230),
        BROWN_SHULKER_BOX(231),
        GREEN_SHULKER_BOX(232),
        RED_SHULKER_BOX(233),
        BLACK_SHULKER_BOX(234),
        WHITE_GLAZED_TERRACOTTA(235),
        ORANGE_GLAZED_TERRACOTTA(236),
        MAGENTA_GLAZED_TERRACOTTA(237),
        LIGHT_BLUE_GLAZED_TERRACOTTA(238),
        YELLOW_GLAZED_TERRACOTTA(239),
        LIME_GLAZED_TERRACOTTA(240),
        PINK_GLAZED_TERRACOTTA(241),
        GRAY_GLAZED_TERRACOTTA(242),
        SILVER_GLAZED_TERRACOTTA(243),
        CYAN_GLAZED_TERRACOTTA(244),
        PURPLE_GLAZED_TERRACOTTA(245),
        BLUE_GLAZED_TERRACOTTA(246),
        BROWN_GLAZED_TERRACOTTA(247),
        GREEN_GLAZED_TERRACOTTA(248),
        RED_GLAZED_TERRACOTTA(249),
        BLACK_GLAZED_TERRACOTTA(250),
        CONCRETE(251),
        CONCRETE_POWDER(252),
        STRUCTURE_BLOCK(255),
        IRON_SPADE(256),
        IRON_PICKAXE(257),
        IRON_AXE(258),
        FLINT_AND_STEEL(259),
        APPLE(260),
        BOW(261),
        ARROW(262),
        COAL(263),
        DIAMOND(264),
        IRON_INGOT(265),
        GOLD_INGOT(266),
        IRON_SWORD(267),
        WOOD_SWORD(268),
        WOOD_SPADE(269),
        WOOD_PICKAXE(270),
        WOOD_AXE(271),
        STONE_SWORD(272),
        STONE_SPADE(273),
        STONE_PICKAXE(274),
        STONE_AXE(275),
        DIAMOND_SWORD(276),
        DIAMOND_SPADE(277),
        DIAMOND_PICKAXE(278),
        DIAMOND_AXE(279),
        STICK(280),
        BOWL(281),
        MUSHROOM_SOUP(282),
        GOLD_SWORD(283),
        GOLD_SPADE(284),
        GOLD_PICKAXE(285),
        GOLD_AXE(286),
        STRING(287),
        FEATHER(288),
        SULPHUR(289),
        WOOD_HOE(290),
        STONE_HOE(291),
        IRON_HOE(292),
        DIAMOND_HOE(293),
        GOLD_HOE(294),
        SEEDS(295),
        WHEAT(296),
        BREAD(297),
        LEATHER_HELMET(298),
        LEATHER_CHESTPLATE(299),
        LEATHER_LEGGINGS(300),
        LEATHER_BOOTS(301),
        CHAINMAIL_HELMET(302),
        CHAINMAIL_CHESTPLATE(303),
        CHAINMAIL_LEGGINGS(304),
        CHAINMAIL_BOOTS(305),
        IRON_HELMET(306),
        IRON_CHESTPLATE(307),
        IRON_LEGGINGS(308),
        IRON_BOOTS(309),
        DIAMOND_HELMET(310),
        DIAMOND_CHESTPLATE(311),
        DIAMOND_LEGGINGS(312),
        DIAMOND_BOOTS(313),
        GOLD_HELMET(314),
        GOLD_CHESTPLATE(315),
        GOLD_LEGGINGS(316),
        GOLD_BOOTS(317),
        FLINT(318),
        PORK(319),
        GRILLED_PORK(320),
        PAINTING(321),
        GOLDEN_APPLE(322),
        SIGN(323),
        WOOD_DOOR(324),
        BUCKET(325),
        WATER_BUCKET(326),
        LAVA_BUCKET(327),
        MINECART(328),
        SADDLE(329),
        IRON_DOOR(330),
        REDSTONE(331),
        SNOW_BALL(332),
        BOAT(333),
        LEATHER(334),
        MILK_BUCKET(335),
        CLAY_BRICK(336),
        CLAY_BALL(337),
        SUGAR_CANE(338),
        PAPER(339),
        BOOK(340),
        SLIME_BALL(341),
        STORAGE_MINECART(342),
        POWERED_MINECART(343),
        EGG(344),
        COMPASS(345),
        FISHING_ROD(346),
        WATCH(347),
        GLOWSTONE_DUST(348),
        RAW_FISH(349),
        COOKED_FISH(350),
        INK_SACK(351),
        BONE(352),
        SUGAR(353),
        CAKE(354),
        BED(355),
        DIODE(356),
        COOKIE(357),
        MAP(358),
        SHEARS(359),
        MELON(360),
        PUMPKIN_SEEDS(361),
        MELON_SEEDS(362),
        RAW_BEEF(363),
        COOKED_BEEF(364),
        RAW_CHICKEN(365),
        COOKED_CHICKEN(366),
        ROTTEN_FLESH(367),
        ENDER_PEARL(368),
        BLAZE_ROD(369),
        GHAST_TEAR(370),
        GOLD_NUGGET(371),
        NETHER_STALK(372),
        POTION(373),
        GLASS_BOTTLE(374),
        SPIDER_EYE(375),
        FERMENTED_SPIDER_EYE(376),
        BLAZE_POWDER(377),
        MAGMA_CREAM(378),
        BREWING_STAND_ITEM(379),
        CAULDRON_ITEM(380),
        EYE_OF_ENDER(381),
        SPECKLED_MELON(382),
        MONSTER_EGG(383),
        EXP_BOTTLE(384),
        FIREBALL(385),
        BOOK_AND_QUILL(386),
        WRITTEN_BOOK(387),
        EMERALD(388),
        ITEM_FRAME(389),
        FLOWER_POT_ITEM(390),
        CARROT_ITEM(391),
        POTATO_ITEM(392),
        BAKED_POTATO(393),
        POISONOUS_POTATO(394),
        EMPTY_MAP(395),
        GOLDEN_CARROT(396),
        SKULL_ITEM(397),
        CARROT_STICK(398),
        NETHER_STAR(399),
        PUMPKIN_PIE(400),
        FIREWORK(401),
        FIREWORK_CHARGE(402),
        ENCHANTED_BOOK(403),
        REDSTONE_COMPARATOR(404),
        NETHER_BRICK_ITEM(405),
        QUARTZ(406),
        EXPLOSIVE_MINECART(407),
        HOPPER_MINECART(408),
        PRISMARINE_SHARD(409),
        PRISMARINE_CRYSTALS(410),
        RABBIT(411),
        COOKED_RABBIT(412),
        RABBIT_STEW(413),
        RABBIT_FOOT(414),
        RABBIT_HIDE(415),
        ARMOR_STAND(416),
        IRON_BARDING(417),
        GOLD_BARDING(418),
        DIAMOND_BARDING(419),
        LEASH(420),
        NAME_TAG(421),
        COMMAND_MINECART(422),
        MUTTON(423),
        COOKED_MUTTON(424),
        BANNER(425),
        END_CRYSTAL(426),
        SPRUCE_DOOR_ITEM(427),
        BIRCH_DOOR_ITEM(428),
        JUNGLE_DOOR_ITEM(429),
        ACACIA_DOOR_ITEM(430),
        DARK_OAK_DOOR_ITEM(431),
        CHORUS_FRUIT(432),
        CHORUS_FRUIT_POPPED(433),
        BEETROOT(434),
        BEETROOT_SEEDS(435),
        BEETROOT_SOUP(436),
        DRAGONS_BREATH(437),
        SPLASH_POTION(438),
        SPECTRAL_ARROW(439),
        TIPPED_ARROW(440),
        LINGERING_POTION(441),
        SHIELD(442),
        ELYTRA(443),
        BOAT_SPRUCE(444),
        BOAT_BIRCH(445),
        BOAT_JUNGLE(446),
        BOAT_ACACIA(447),
        BOAT_DARK_OAK(448),
        TOTEM(449),
        SHULKER_SHELL(450),
        IRON_NUGGET(452),
        KNOWLEDGE_BOOK(453),
        GOLD_RECORD(2256),
        GREEN_RECORD(2257),
        RECORD_3(2258),
        RECORD_4(2259),
        RECORD_5(2260),
        RECORD_6(2261),
        RECORD_7(2262),
        RECORD_8(2263),
        RECORD_9(2264),
        RECORD_10(2265),
        RECORD_11(2266),
        RECORD_12(2267);

        private final int id;

        private LegacyMaterialId(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

