/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCSound;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import org.bukkit.Sound;

public class BukkitMCSound
extends MCSound<Sound> {
    public BukkitMCSound(MCSound.MCVanillaSound vanillaSound, Sound sound) {
        super(vanillaSound, sound);
    }

    @Override
    public String name() {
        return this.getAbstracted() == MCSound.MCVanillaSound.UNKNOWN ? this.concreteName() : ((MCSound.MCVanillaSound)((Object)this.getAbstracted())).name();
    }

    @Override
    public String concreteName() {
        Sound concrete = (Sound)this.getConcrete();
        if (concrete == null) {
            return "null";
        }
        return concrete.name();
    }

    public static void build() {
        NULL = new BukkitMCSound(MCSound.MCVanillaSound.UNKNOWN, null);
        for (MCSound.MCVanillaSound v : MCSound.MCVanillaSound.values()) {
            Sound sound;
            if (!v.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                sound = BukkitMCSound.getBukkitType(v);
            }
            catch (IllegalArgumentException | NoSuchFieldError ex) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit Sound for " + v.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCSound wrapper = new BukkitMCSound(v, sound);
            MAP.put(v.name(), wrapper);
        }
    }

    private static Sound getBukkitType(MCSound.MCVanillaSound v) {
        return Sound.valueOf((String)v.name());
    }
}

