/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.FileLocations;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.core.extensions.Extension;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public class MethodScriptFileLocations
extends FileLocations {
    private static MethodScriptFileLocations defaultInstance = null;

    public static MethodScriptFileLocations getDefault() {
        if (defaultInstance == null) {
            MethodScriptFileLocations.setDefault(new MethodScriptFileLocations());
        }
        return defaultInstance;
    }

    public static void setDefault(MethodScriptFileLocations provider) {
        defaultInstance = provider;
        FileLocations.setDefault(defaultInstance);
    }

    public File getJarFile() {
        if (MethodScriptFileLocations.class.getProtectionDomain().getCodeSource().getLocation() == null) {
            URL url = MethodScriptFileLocations.class.getResource("/" + MethodScriptFileLocations.class.getName().replace('.', '/') + ".class");
            String s = url.toString();
            s = s.replaceFirst("file:", "");
            s = StringUtils.replaceLast(s, Pattern.quote(MethodScriptFileLocations.class.getName().replace('.', '/') + ".class"), "");
            return new File(s);
        }
        try {
            return new File(URLDecoder.decode(MethodScriptFileLocations.class.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public File getJarDirectory() {
        return this.getJarFile().getParentFile();
    }

    public File getConfigDirectory() {
        return new File(this.getJarDirectory(), Implementation.GetServerType().getBranding() + "/");
    }

    public File getPreferencesDirectory() {
        return new File(this.getConfigDirectory(), "prefs/");
    }

    public File getPreferencesFile() {
        return new File(this.getPreferencesDirectory(), "preferences.ini");
    }

    public File getCacheDirectory() {
        return new File(this.getConfigDirectory(), ".cache/");
    }

    public File getExtensionsDirectory() {
        return new File(this.getConfigDirectory(), "extensions/");
    }

    public File getExtensionCacheDirectory() {
        return new File(this.getCacheDirectory(), "extensions/");
    }

    public File getLocalPackagesDirectory() {
        return new File(this.getConfigDirectory(), "LocalPackages/");
    }

    public File getPersistenceConfig() {
        return new File(this.getPreferencesDirectory(), "persistence.ini");
    }

    public File getDefaultPersistenceDBFile() {
        return new File(this.getConfigDirectory(), "persistence.db");
    }

    public File getProfilerConfigFile() {
        return new File(this.getPreferencesDirectory(), "profiler.ini");
    }

    public File getSiteDeployFile() {
        return new File(this.getCmdlineInterpreterDirectory(), "site-deploy.ini");
    }

    public File getProfilesFile() {
        return new File(this.getPreferencesDirectory(), "profiles.xml");
    }

    public File getLoggerPreferencesFile() {
        return new File(this.getPreferencesDirectory(), "logger-preferences.ini");
    }

    public File getCmdlineInterpreterDirectory() {
        return new File(System.getProperty("user.home") + "/.mscript");
    }

    public File getCmdlineInterpreterAutoIncludeFile() {
        return new File(this.getCmdlineInterpreterDirectory(), "auto_include.ms");
    }

    public File getExtensionDirectory(Extension ext) {
        return ext.getConfigDir();
    }

    public File getTelemetryConfigFile() {
        return new File(this.getPreferencesDirectory(), "telemetry.ini");
    }
}

