/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.analysis;

import com.laytonsmith.core.compiler.analysis.Declaration;
import com.laytonsmith.core.compiler.analysis.Namespace;
import com.laytonsmith.core.compiler.analysis.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class Scope {
    private final Set<Scope> parents;
    private final Map<Namespace, Set<Scope>> specificParents;
    private final Map<Namespace, Map<String, Declaration>> declarations;
    private final Map<Namespace, List<Reference>> references;

    public Scope() {
        this(null);
    }

    private Scope(Scope parent) {
        this.parents = new HashSet<Scope>();
        if (parent != null) {
            this.parents.add(parent);
        }
        this.specificParents = new HashMap<Namespace, Set<Scope>>();
        this.declarations = new HashMap<Namespace, Map<String, Declaration>>();
        this.references = new HashMap<Namespace, List<Reference>>();
    }

    private Scope(Set<Scope> parents, Map<Namespace, Set<Scope>> specificParents, Map<Namespace, Map<String, Declaration>> declarations, Map<Namespace, List<Reference>> references) {
        this.parents = parents;
        this.specificParents = specificParents;
        this.declarations = declarations;
        this.references = references;
    }

    public void addParent(Scope parent) {
        this.parents.add(parent);
    }

    public Set<Scope> getParents() {
        return this.parents;
    }

    public void containsParent(Scope parent) {
        this.parents.contains(parent);
    }

    public void removeParent(Scope parent) {
        this.parents.remove(parent);
    }

    public void addSpecificParent(Scope parent, Namespace namespace) {
        Set<Scope> parents = this.specificParents.get((Object)namespace);
        if (parents == null) {
            parents = new HashSet<Scope>();
            this.specificParents.put(namespace, parents);
        }
        parents.add(parent);
    }

    public Map<Namespace, Set<Scope>> getSpecificParents() {
        return this.specificParents;
    }

    public Set<Scope> getSpecificParents(Namespace namespace) {
        Set<Scope> parents = this.specificParents.get((Object)namespace);
        return parents == null ? Collections.emptySet() : parents;
    }

    public void addDeclaration(Declaration decl) {
        Map<String, Declaration> declIdMap = this.declarations.get((Object)decl.getNamespace());
        if (declIdMap == null) {
            declIdMap = new HashMap<String, Declaration>();
            this.declarations.put(decl.getNamespace(), declIdMap);
        }
        declIdMap.put(decl.getIdentifier(), decl);
    }

    public void addReference(Reference ref) {
        List<Reference> refList = this.references.get((Object)ref.getNamespace());
        if (refList == null) {
            refList = new ArrayList<Reference>();
            this.references.put(ref.getNamespace(), refList);
        }
        refList.add(ref);
    }

    public Declaration getDeclarationLocal(Namespace namespace, String identifier) {
        Map<String, Declaration> declIdMap = this.declarations.get((Object)namespace);
        if (declIdMap == null) {
            return null;
        }
        return declIdMap.get(identifier);
    }

    public Set<Declaration> getDeclarations(Namespace namespace, String identifier) {
        HashSet<Scope> handledScopes = new HashSet<Scope>();
        Stack<Scope> scopeStack = new Stack<Scope>();
        HashSet<Declaration> decls = new HashSet<Declaration>();
        scopeStack.push(this);
        do {
            Scope scope;
            if (!handledScopes.add(scope = (Scope)scopeStack.pop())) continue;
            Declaration decl = scope.getDeclarationLocal(namespace, identifier);
            if (decl != null) {
                decls.add(decl);
                continue;
            }
            scopeStack.addAll(scope.getParents());
            scopeStack.addAll(scope.getSpecificParents(namespace));
        } while (!scopeStack.empty());
        return decls;
    }

    public Set<Declaration> getReachableDeclarations(Namespace namespace, String identifier) {
        HashSet<Scope> handledScopes = new HashSet<Scope>();
        Stack<Scope> scopeStack = new Stack<Scope>();
        HashSet<Declaration> decls = new HashSet<Declaration>();
        scopeStack.push(this);
        do {
            Scope scope;
            if (!handledScopes.add(scope = (Scope)scopeStack.pop())) continue;
            Declaration decl = scope.getDeclarationLocal(namespace, identifier);
            if (decl != null) {
                decls.add(decl);
            }
            scopeStack.addAll(scope.getParents());
            scopeStack.addAll(scope.getSpecificParents(namespace));
        } while (!scopeStack.empty());
        return decls;
    }

    public Set<Declaration> getAllDeclarationsLocal(Namespace namespace) {
        Map<String, Declaration> declIdMap = this.declarations.get((Object)namespace);
        if (declIdMap == null) {
            return new HashSet<Declaration>();
        }
        return new HashSet<Declaration>(declIdMap.values());
    }

    public Set<Reference> getAllReferencesLocal(Namespace namespace) {
        List<Reference> refList = this.references.get((Object)namespace);
        if (refList == null) {
            return new HashSet<Reference>();
        }
        return new HashSet<Reference>(refList);
    }

    public Scope shallowUnlinkedClone() {
        return new Scope(new HashSet<Scope>(), new HashMap<Namespace, Set<Scope>>(), this.declarations, this.references);
    }
}

