/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.analysis;

import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.analysis.Declaration;
import com.laytonsmith.core.compiler.analysis.IncludeReference;
import com.laytonsmith.core.compiler.analysis.Namespace;
import com.laytonsmith.core.compiler.analysis.ParamDeclaration;
import com.laytonsmith.core.compiler.analysis.ProcDeclaration;
import com.laytonsmith.core.compiler.analysis.ProcRootDeclaration;
import com.laytonsmith.core.compiler.analysis.Reference;
import com.laytonsmith.core.compiler.analysis.Scope;
import com.laytonsmith.core.compiler.analysis.StaticAnalysisConfiguration;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.functions.DataHandling;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.IncludeCache;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

public class StaticAnalysis {
    private static final StaticAnalysisConfiguration CONFIGURATION;
    private final Scope startScope;
    private final Set<Scope> scopes;
    private boolean isMainAnalysis;
    private ParseTree astRootNode = null;
    private Scope endScope = null;
    private Scope globalScope = null;
    private Set<StaticAnalysis> staticAnalyses = new HashSet<StaticAnalysis>();
    private Map<ParseTree, Scope> astScopeMap = new HashMap<ParseTree, Scope>();
    private static StaticAnalysis autoIncludesAnalysis;

    public StaticAnalysis(boolean isMainAnalysis) {
        this(null, isMainAnalysis);
    }

    public StaticAnalysis(Scope parentScope, boolean isMainAnalysis) {
        this.startScope = parentScope != null ? parentScope : new Scope();
        this.scopes = new HashSet<Scope>();
        this.scopes.add(this.startScope);
        this.isMainAnalysis = isMainAnalysis;
        this.staticAnalyses.add(this);
    }

    private StaticAnalysis(Scope startScope, Scope endScope, Set<Scope> scopes, boolean isMainAnalysis, Scope globalScope, ParseTree astRootNode, Set<StaticAnalysis> staticAnalyses, Map<ParseTree, Scope> astScopeMap) {
        this.startScope = startScope;
        this.endScope = endScope;
        this.scopes = scopes;
        this.isMainAnalysis = isMainAnalysis;
        this.globalScope = globalScope;
        this.astRootNode = astRootNode;
        this.staticAnalyses = staticAnalyses;
        this.staticAnalyses.add(this);
        this.astScopeMap = astScopeMap;
    }

    public void analyze(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
        if (!StaticAnalysis.enabled()) {
            return;
        }
        this.scopes.clear();
        this.scopes.add(this.startScope);
        this.astRootNode = ast;
        if (autoIncludesAnalysis != null) {
            if (this.isMainAnalysis) {
                this.startScope.addParent(StaticAnalysis.autoIncludesAnalysis.endScope);
            }
            this.globalScope = StaticAnalysis.autoIncludesAnalysis.globalScope;
        }
        this.endScope = this.linkScope(this.startScope, ast, env, exceptions);
        if (this.isMainAnalysis) {
            this.handleIncludeRefs(env, envs, exceptions);
            this.analyzeFinalScopeGraph(env, exceptions);
        }
    }

    public static void setAndAnalyzeAutoIncludes(List<File> autoIncludes, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
        if (!StaticAnalysis.enabled()) {
            return;
        }
        if (autoIncludes == null || autoIncludes.size() == 0) {
            autoIncludesAnalysis = null;
            return;
        }
        Scope startScope = new Scope();
        StaticAnalysis analysis = new StaticAnalysis(startScope, true);
        analysis.staticAnalyses.remove(analysis);
        Scope inScope = startScope;
        for (File autoInclude : autoIncludes) {
            Scope outScope = analysis.createNewScope();
            inScope.addReference(new IncludeReference(autoInclude.getAbsolutePath(), inScope, outScope, Target.UNKNOWN));
            inScope = outScope;
        }
        analysis.globalScope = analysis.endScope = inScope;
        analysis.handleIncludeRefs(env, envs, exceptions);
        analysis.analyzeFinalScopeGraph(env, exceptions);
        autoIncludesAnalysis = analysis;
    }

    public void analyzeFinalScopeGraph(Environment env, Set<ConfigCompileException> exceptions) {
        int n;
        for (Scope scope : this.scopes) {
            for (Declaration decl : scope.getAllDeclarationsLocal(Namespace.IVARIABLE_ASSIGN)) {
                boolean bl;
                boolean bl2 = bl = !scope.getDeclarations(Namespace.IVARIABLE, decl.getIdentifier()).isEmpty() || scope.getReachableDeclarations(Namespace.IVARIABLE_ASSIGN, decl.getIdentifier()).size() > 1;
                if (bl) {
                    scope.addReference(new Reference(Namespace.IVARIABLE, decl.getIdentifier(), decl.getTarget()));
                    continue;
                }
                scope.addDeclaration(new Declaration(Namespace.IVARIABLE, decl.getIdentifier(), CClassType.AUTO, decl.getTarget()));
            }
        }
        for (Scope scope : this.scopes) {
            for (Declaration decl : scope.getAllDeclarationsLocal(Namespace.IVARIABLE)) {
                Set<Declaration> set;
                if (decl instanceof ParamDeclaration || (set = scope.getReachableDeclarations(Namespace.IVARIABLE, decl.getIdentifier())).size() <= 1) continue;
                set.remove(decl);
                if (set.size() == 1) {
                    Declaration dupDecl = set.iterator().next();
                    exceptions.add(new ConfigCompileException("Duplicate variable declaration: Variable " + decl.getIdentifier() + " is already declared at " + dupDecl.getTarget().toString(), decl.getTarget()));
                    continue;
                }
                TreeSet<Declaration> sortedDupDecls = new TreeSet<Declaration>((d1, d2) -> d1.getTarget().compareTo(d2.getTarget()));
                sortedDupDecls.addAll(set);
                String message = "Duplicate variable declaration: Variable " + decl.getIdentifier() + " is already defined at the following locations:";
                for (Declaration dupDecl : sortedDupDecls) {
                    message = message + "\n" + dupDecl.getTarget().toString();
                }
                exceptions.add(new ConfigCompileException(message, decl.getTarget()));
            }
        }
        HashMap<Scope, Set<Reference>> procReqRefMap = new HashMap<Scope, Set<Reference>>();
        for (Scope scope : this.scopes) {
            for (Reference reference : scope.getAllReferencesLocal(Namespace.PROCEDURE)) {
                Set<Declaration> decls = scope.getDeclarations(Namespace.PROCEDURE, reference.getIdentifier());
                if (decls.isEmpty() && this.globalScope != null) {
                    decls = this.globalScope.getDeclarations(Namespace.PROCEDURE, reference.getIdentifier());
                }
                if (decls.isEmpty()) {
                    Set<Declaration> rootDecls = scope.getDeclarations(Namespace.PROCEDURE, "~PROC_ROOT");
                    if (!rootDecls.isEmpty()) {
                        for (Declaration decl : rootDecls) {
                            ProcRootDeclaration procRootDecl = (ProcRootDeclaration)decl;
                            procRootDecl.procDecl.addRequiredReference(reference);
                        }
                        continue;
                    }
                    exceptions.add(new ConfigCompileException("Procedure cannot be resolved: " + reference.getIdentifier(), reference.getTarget()));
                    continue;
                }
                for (Declaration decl : decls) {
                    procReqRefMap.put(scope, ((ProcDeclaration)decl).getRequiredRefs());
                }
            }
        }
        HashMap handledReferences = new HashMap();
        do {
            boolean bl = false;
            for (Map.Entry entry : procReqRefMap.entrySet()) {
                Scope scope = (Scope)entry.getKey();
                for (Reference ref : (Set)entry.getValue()) {
                    HashSet<Reference> handledRefSet = (HashSet<Reference>)handledReferences.get(scope);
                    if (handledRefSet == null) {
                        handledRefSet = new HashSet<Reference>();
                        handledReferences.put(scope, handledRefSet);
                    }
                    if (handledRefSet.contains(ref) || !scope.getDeclarations(Namespace.PROCEDURE, ref.getIdentifier()).isEmpty()) continue;
                    handledRefSet.add(ref);
                    Set<Declaration> rootDecls = scope.getDeclarations(Namespace.PROCEDURE, "~PROC_ROOT");
                    if (!rootDecls.isEmpty()) {
                        for (Declaration decl : rootDecls) {
                            ProcRootDeclaration procRootDecl = (ProcRootDeclaration)decl;
                            n |= procRootDecl.procDecl.addRequiredReference(ref);
                        }
                        continue;
                    }
                    exceptions.add(new ConfigCompileException("Procedure cannot be resolved: " + ref.getIdentifier(), ref.getTarget()));
                }
            }
        } while (n != false);
        this.typecheck(env, exceptions);
    }

    private void typecheck(Environment env, Set<ConfigCompileException> exceptions) {
        for (StaticAnalysis analysis : this.staticAnalyses) {
            analysis.typecheck(analysis.astRootNode, env, exceptions);
        }
    }

    public CClassType typecheck(ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
        Mixed node = ast.getData();
        if (node instanceof CFunction) {
            CFunction cFunc = (CFunction)node;
            if (cFunc.hasFunction()) {
                Function func = cFunc.getCachedFunction();
                if (func != null) {
                    return func.typecheck(this, ast, env, exceptions);
                }
                return CClassType.AUTO;
            }
            if (cFunc.hasIVariable()) {
                return CClassType.AUTO;
            }
            if (cFunc.hasProcedure()) {
                return CClassType.AUTO;
            }
            throw new Error("Unsupported " + CFunction.class.getSimpleName() + " type in type checking for node with value: " + cFunc.val());
        }
        if (node instanceof IVariable) {
            IVariable ivar = (IVariable)node;
            Scope scope = this.getTermScope(ast);
            if (scope != null) {
                Set<Declaration> decls = scope.getDeclarations(Namespace.IVARIABLE, ivar.getVariableName());
                if (decls.isEmpty()) {
                    exceptions.add(new ConfigCompileException("Variable cannot be resolved: " + ivar.getVariableName(), ivar.getTarget()));
                    return CClassType.AUTO;
                }
                return decls.iterator().next().getType();
            }
            exceptions.add(new ConfigCompileException("Variable cannot be resolved (missing variable scope, this is an internal error that should never happen): " + ivar.getVariableName(), ivar.getTarget()));
            return CClassType.AUTO;
        }
        if (node instanceof Variable) {
            return CString.TYPE;
        }
        try {
            return node.typeof();
        }
        catch (Throwable t) {
            exceptions.add(new ConfigCompileException("Unsupported AST node implementation in type checking: " + node.getClass().getSimpleName(), node.getTarget()));
            return CClassType.AUTO;
        }
    }

    public static void requireType(CClassType type, CClassType expected, Target t, Environment env, Set<ConfigCompileException> exceptions) {
        if (type == expected || type == CClassType.AUTO || type == CNull.TYPE) {
            return;
        }
        if (type == CVoid.TYPE || expected == CVoid.TYPE || expected == CNull.TYPE) {
            exceptions.add(new ConfigCompileException("Expected type " + expected.getSimpleName() + ", but received type " + type.getSimpleName() + " instead.", t));
            return;
        }
        if (!InstanceofUtil.isInstanceof(type, expected, env)) {
            exceptions.add(new ConfigCompileException("Expected type " + expected.getSimpleName() + ", but received type " + type.getSimpleName() + " instead.", t));
        }
    }

    public static void requireAnyType(CClassType type, CClassType[] expected, Target t, Environment env, Set<ConfigCompileException> exceptions) {
        assert (expected.length > 0) : "You must at least provide one expected type to requireAnyType().";
        for (CClassType exp : expected) {
            if (type != exp && type != CClassType.AUTO && type != CNull.TYPE && (type == CVoid.TYPE || exp == CVoid.TYPE || exp == CNull.TYPE) && !InstanceofUtil.isInstanceof(type, exp, env)) continue;
            return;
        }
        if (expected.length == 1) {
            exceptions.add(new ConfigCompileException("Expected type " + expected[0].getSimpleName() + ", but received type " + type.getSimpleName() + " instead.", t));
        } else {
            String types = "";
            for (CClassType exp : expected) {
                types = types + (types.isEmpty() ? exp.getSimpleName() : ", " + exp.getSimpleName());
            }
            exceptions.add(new ConfigCompileException("Expected any of types {" + types + "}, but received type " + type.getSimpleName() + " instead.", t));
        }
    }

    public static IVariable requireIVariable(Mixed node, Target t, Set<ConfigCompileException> exceptions) {
        if (node instanceof IVariable) {
            return (IVariable)node;
        }
        if (node instanceof Variable) {
            exceptions.add(new ConfigCompileException("Expected ivariable, but received variable instead.", t));
            return null;
        }
        try {
            exceptions.add(new ConfigCompileException("Expected ivariable, but received type " + node.getName() + " instead.", t));
        }
        catch (NullPointerException e) {
            exceptions.add(new ConfigCompileException("Expected ivariable, but received " + node.getClass().getSimpleName() + " instead.", t));
        }
        return null;
    }

    public static CClassType requireClassType(Mixed node, Target t, Set<ConfigCompileException> exceptions) {
        if (node instanceof CClassType) {
            return (CClassType)node;
        }
        try {
            exceptions.add(new ConfigCompileException("Expected classtype, but received type " + node.getName() + " instead.", t));
        }
        catch (NullPointerException e) {
            exceptions.add(new ConfigCompileException("Expected classtype, but received " + node.getClass().getSimpleName() + " instead.", t));
        }
        return null;
    }

    private void handleIncludeRefs(Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
        this.compileIncludesLinkCycles(new HashSet<IncludeReference>(), new HashSet<IncludeReference>(), new Stack<IncludeReference>(), env, envs, exceptions);
    }

    private void compileIncludesLinkCycles(Set<IncludeReference> handledRefs, Set<IncludeReference> linkedRefs, Stack<IncludeReference> path, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
        for (IncludeReference includeRef : this.getIncludeRefs()) {
            StaticAnalysis includeAnalysis;
            block11: {
                if (path.contains(includeRef)) {
                    HashSet<Scope> cycleScopes = new HashSet<Scope>();
                    ArrayList<StaticAnalysis> cycleAnalyses = new ArrayList<StaticAnalysis>();
                    for (int i = path.size() - 1; i >= 0; --i) {
                        IncludeReference pathRef = (IncludeReference)path.get(i);
                        if (linkedRefs.add(pathRef)) {
                            File file = Static.GetFileFromArgument(pathRef.getIdentifier(), env, pathRef.getTarget(), null);
                            StaticAnalysis includeAnalysis2 = IncludeCache.getStaticAnalysis(file);
                            if (includeAnalysis2 == null) {
                                this.addDirectedEdge(pathRef.getOutScope(), pathRef.getInScope());
                            } else {
                                cycleAnalyses.add(includeAnalysis2);
                                cycleScopes.addAll(includeAnalysis2.scopes);
                                this.addDirectedEdge(includeAnalysis2.startScope, pathRef.getInScope());
                                this.addDirectedEdge(pathRef.getOutScope(), includeAnalysis2.endScope);
                                this.staticAnalyses.addAll(includeAnalysis2.staticAnalyses);
                            }
                        }
                        if (pathRef.equals(includeRef)) break;
                    }
                    for (StaticAnalysis analysis : cycleAnalyses) {
                        analysis.scopes.addAll(cycleScopes);
                    }
                    continue;
                }
                if (!handledRefs.add(includeRef)) continue;
                try {
                    File file = Static.GetFileFromArgument(includeRef.getIdentifier(), env, includeRef.getTarget(), null);
                    includeAnalysis = IncludeCache.getStaticAnalysis(file);
                    if (includeAnalysis != null) break block11;
                    includeAnalysis = new StaticAnalysis(false);
                    IncludeCache.get(file, env, envs, includeAnalysis, includeRef.getTarget());
                    assert (IncludeCache.getStaticAnalysis(file) != null) : "Failed to cache include analysis.";
                }
                catch (CREException e) {
                    exceptions.add(new ConfigCompileException(e.getMessage(), e.getTarget()));
                    this.addDirectedEdge(includeRef.getOutScope(), includeRef.getInScope());
                    linkedRefs.add(includeRef);
                    continue;
                }
            }
            if (includeAnalysis.endScope == null) {
                exceptions.add(new ConfigCompileException("An error occurred while analyzing included file", includeRef.getTarget()));
                this.addDirectedEdge(includeRef.getOutScope(), includeRef.getInScope());
                linkedRefs.add(includeRef);
                continue;
            }
            path.push(includeRef);
            includeAnalysis.compileIncludesLinkCycles(handledRefs, linkedRefs, path, env, envs, exceptions);
            path.pop();
            if (!linkedRefs.add(includeRef)) continue;
            StaticAnalysis includeAnalysisClone = includeAnalysis.clone();
            this.scopes.addAll(includeAnalysisClone.scopes);
            this.addDirectedEdge(includeAnalysisClone.startScope, includeRef.getInScope());
            this.addDirectedEdge(includeRef.getOutScope(), includeAnalysisClone.endScope);
            this.staticAnalyses.addAll(includeAnalysisClone.staticAnalyses);
        }
    }

    private Set<IncludeReference> getIncludeRefs() {
        HashSet<IncludeReference> refs = new HashSet<IncludeReference>();
        for (Scope scope : this.scopes) {
            for (Reference ref : scope.getAllReferencesLocal(Namespace.INCLUDE)) {
                IncludeReference includeRef = (IncludeReference)ref;
                refs.add(includeRef);
            }
        }
        return refs;
    }

    public void setMainAnalysis(boolean isMainAnalysis) {
        this.isMainAnalysis = isMainAnalysis;
    }

    public Scope getStartScope() {
        return this.startScope;
    }

    public Scope getEndScope() {
        return this.endScope;
    }

    public Scope linkScope(Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
        Mixed node = ast.getData();
        if (node instanceof CFunction) {
            CFunction cFunc = (CFunction)node;
            if (cFunc.hasFunction()) {
                Function func = cFunc.getCachedFunction();
                if (func != null) {
                    return func.linkScope(this, parentScope, ast, env, exceptions);
                }
                return parentScope;
            }
            if (cFunc.hasIVariable()) {
                Scope refScope = this.createNewScope(parentScope);
                refScope.addReference(new Reference(Namespace.IVARIABLE, cFunc.val(), cFunc.getTarget()));
                this.setTermScope(ast, refScope);
                return refScope;
            }
            if (cFunc.hasProcedure()) {
                Scope refScope = this.createNewScope(parentScope);
                refScope.addReference(new Reference(Namespace.PROCEDURE, cFunc.val(), cFunc.getTarget()));
                Scope argScope = refScope;
                for (ParseTree child : ast.getChildren()) {
                    argScope = this.linkScope(argScope, child, env, exceptions);
                }
                return argScope;
            }
            throw new Error("Unsupported " + CFunction.class.getSimpleName() + " type in static analysis for node with value: " + cFunc.val());
        }
        if (node instanceof IVariable) {
            IVariable ivar = (IVariable)node;
            Scope refScope = this.createNewScope(parentScope);
            refScope.addReference(new Reference(Namespace.IVARIABLE, ivar.getVariableName(), ivar.getTarget()));
            this.setTermScope(ast, refScope);
            return refScope;
        }
        return parentScope;
    }

    public Scope[] linkParamScope(Scope paramScope, Scope valScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
        Function func;
        Mixed node = ast.getData();
        if (node instanceof IVariable) {
            IVariable iVar = (IVariable)node;
            Scope newParamScope = this.createNewScope(paramScope);
            newParamScope.addDeclaration(new ParamDeclaration(iVar.getVariableName(), iVar.getDefinedType(), iVar.getTarget()));
            this.setTermScope(ast, newParamScope);
            return new Scope[]{newParamScope, valScope};
        }
        if (node instanceof CFunction && (func = ((CFunction)node).getCachedFunction()) != null && func instanceof DataHandling.assign) {
            return ((DataHandling.assign)func).linkParamScope(this, paramScope, valScope, ast, env, exceptions);
        }
        exceptions.add(new ConfigCompileException("Invalid parameter", node.getTarget()));
        return new Scope[]{paramScope, this.linkScope(valScope, ast, env, exceptions)};
    }

    public Scope createNewScope(Scope parent) {
        Scope scope = this.createNewScope();
        scope.addParent(parent);
        return scope;
    }

    public Scope createNewScope() {
        Scope scope = new Scope();
        this.scopes.add(scope);
        return scope;
    }

    public void addDirectedEdge(Scope child, Scope parent) {
        child.addParent(parent);
    }

    public void removeDirectedEdge(Scope child, Scope parent) {
        child.removeParent(parent);
    }

    public Set<Scope> getRootScopes() {
        HashSet<Scope> ret = new HashSet<Scope>();
        for (Scope scope : this.scopes) {
            if (scope.getParents().size() != 0) continue;
            ret.add(scope);
        }
        return ret;
    }

    public void setTermScope(ParseTree term, Scope scope) {
        this.astScopeMap.put(term, scope);
    }

    public Scope getTermScope(ParseTree term) {
        return this.astScopeMap.get(term);
    }

    public StaticAnalysis clone() {
        return this.clone(new HashMap<Scope, Scope>(), true);
    }

    private StaticAnalysis clone(Map<Scope, Scope> cloneMapping, boolean cloneAnalyses) {
        Scope startScope = StaticAnalysis.cloneScope(this.startScope, cloneMapping);
        Scope endScope = StaticAnalysis.cloneScope(this.endScope, cloneMapping);
        Scope globalScope = StaticAnalysis.cloneScope(this.globalScope, cloneMapping);
        HashSet<Scope> scopesClone = new HashSet<Scope>();
        for (Scope scope : this.scopes) {
            scopesClone.add(StaticAnalysis.cloneScope(scope, cloneMapping));
        }
        HashSet<StaticAnalysis> analysesClone = new HashSet<StaticAnalysis>();
        if (cloneAnalyses) {
            for (StaticAnalysis analysis : this.staticAnalyses) {
                if (analysis == this) continue;
                analysesClone.add(analysis.clone(cloneMapping, false));
            }
        }
        HashMap<ParseTree, Scope> hashMap = new HashMap<ParseTree, Scope>();
        for (Map.Entry<ParseTree, Scope> entry : this.astScopeMap.entrySet()) {
            hashMap.put(entry.getKey(), StaticAnalysis.cloneScope(entry.getValue(), cloneMapping));
        }
        return new StaticAnalysis(startScope, endScope, scopesClone, this.isMainAnalysis, globalScope, this.astRootNode, analysesClone, hashMap);
    }

    private static Scope cloneScope(Scope scope, Map<Scope, Scope> cloneMapping) {
        if (scope == null) {
            return null;
        }
        Scope scopeClone = cloneMapping.get(scope);
        if (scopeClone != null) {
            return scopeClone;
        }
        scopeClone = scope.shallowUnlinkedClone();
        cloneMapping.put(scope, scopeClone);
        for (Scope scope2 : scope.getParents()) {
            scopeClone.addParent(StaticAnalysis.cloneScope(scope2, cloneMapping));
        }
        for (Map.Entry entry : scope.getSpecificParents().entrySet()) {
            Namespace namespace = (Namespace)((Object)entry.getKey());
            for (Scope parent : (Set)entry.getValue()) {
                scopeClone.addSpecificParent(StaticAnalysis.cloneScope(parent, cloneMapping), namespace);
            }
        }
        return scopeClone;
    }

    @Deprecated
    public static boolean enabled() {
        return CONFIGURATION.globalEnable();
    }

    static {
        try {
            CONFIGURATION = StaticAnalysisConfiguration.GetConfiguration();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        autoIncludesAnalysis = null;
    }
}

