/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.compiler.keywords.SimpleBlockKeywordFunction;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CClosure;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.util.List;

@Keyword.keyword(value="closure")
public class ClosureKeyword
extends Keyword {
    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        try {
            if (list.get(keywordPosition).getData() instanceof CFunction) {
                SimpleBlockKeywordFunction.doProcess(this, null, true, list, keywordPosition);
                try {
                    if (list.get(keywordPosition - 1).getData() instanceof CClassType) {
                        ParseTree type = list.remove(keywordPosition - 1);
                        List<ParseTree> children = list.get(keywordPosition - 1).getChildren();
                        children.add(0, type);
                        list.get(keywordPosition - 1).setChildren(children);
                        return keywordPosition - 1;
                    }
                }
                catch (IndexOutOfBoundsException type) {
                    // empty catch block
                }
                return keywordPosition;
            }
            list.set(keywordPosition, new ParseTree(CClosure.TYPE, list.get(keywordPosition).getFileOptions()));
            return keywordPosition;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ConfigCompileException("Unexpected \"closure\" reference", list.get(keywordPosition).getTarget());
        }
    }

    @Override
    public String docs() {
        return "Defines a block of code that functions similar to an anonymous procedure.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }
}

