/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.Map;

public final class Prefilters {
    private Prefilters() {
    }

    public static void match(Map<String, Mixed> map, String key, String actualValue, PrefilterType type) throws PrefilterNonMatchException {
        Prefilters.match(map, key, new CString(actualValue, Target.UNKNOWN), type);
    }

    public static void match(Map<String, Mixed> map, String key, int actualValue, PrefilterType type) throws PrefilterNonMatchException {
        Prefilters.match(map, key, new CInt(actualValue, Target.UNKNOWN), type);
    }

    public static void match(Map<String, Mixed> map, String key, double actualValue, PrefilterType type) throws PrefilterNonMatchException {
        Prefilters.match(map, key, new CDouble(actualValue, Target.UNKNOWN), type);
    }

    public static void match(Map<String, Mixed> map, String key, boolean actualValue, PrefilterType type) throws PrefilterNonMatchException {
        Prefilters.match(map, key, CBoolean.get(actualValue), type);
    }

    public static void match(Map<String, Mixed> map, String key, MCLocation actualValue, PrefilterType type) throws PrefilterNonMatchException {
        Prefilters.match(map, key, ObjectGenerator.GetGenerator().location(actualValue, false), type);
    }

    public static void match(Map<String, Mixed> map, String key, Mixed actualValue, PrefilterType type) throws PrefilterNonMatchException {
        if (map.containsKey(key)) {
            switch (type) {
                case ITEM_MATCH: {
                    Prefilters.ItemMatch(map.get(key), actualValue);
                    break;
                }
                case STRING_MATCH: {
                    Prefilters.StringMatch(map.get(key).val(), actualValue.val());
                    break;
                }
                case MATH_MATCH: {
                    Prefilters.MathMatch(map.get(key), actualValue);
                    break;
                }
                case EXPRESSION: {
                    Mixed exp = map.get(key);
                    if (!exp.val().isEmpty() && exp.val().charAt(0) == '(' && exp.val().charAt(exp.val().length() - 1) == ')') {
                        Prefilters.ExpressionMatch(exp, key, actualValue);
                        break;
                    }
                    throw new CREFormatException("Prefilter expecting expression type, and \"" + exp.val() + "\" does not follow expression format. (Did you surround it in parenthesis?)", exp.getTarget());
                }
                case REGEX: {
                    String regex = map.get(key).val();
                    if (!regex.isEmpty() && regex.charAt(0) == '/' && regex.charAt(regex.length() - 1) == '/') {
                        Prefilters.RegexMatch(regex, actualValue);
                        break;
                    }
                    throw new CREFormatException("Prefilter expecting regex type, and \"" + regex + "\" does not follow regex format", map.get(key).getTarget());
                }
                case MACRO: {
                    Prefilters.MacroMatch(key, map.get(key), actualValue);
                    break;
                }
                case BOOLEAN_MATCH: {
                    Prefilters.BooleanMatch(map.get(key), actualValue);
                    break;
                }
                case LOCATION_MATCH: {
                    Prefilters.LocationMatch(map.get(key), actualValue);
                }
            }
        }
    }

    private static void ItemMatch(Mixed item1, Mixed item2) throws PrefilterNonMatchException {
        String i1 = item1.val().split(":")[0];
        String i2 = item2.val().split(":")[0];
        if (!i1.trim().equals(i2)) {
            throw new PrefilterNonMatchException();
        }
    }

    private static void BooleanMatch(Mixed bool1, Mixed bool2) throws PrefilterNonMatchException {
        if (ArgumentValidation.getBoolean(bool1, Target.UNKNOWN) != ArgumentValidation.getBoolean(bool2, Target.UNKNOWN)) {
            throw new PrefilterNonMatchException();
        }
    }

    private static void LocationMatch(Mixed location1, Mixed location2) throws PrefilterNonMatchException {
        MCLocation l1 = ObjectGenerator.GetGenerator().location(location1, null, location1.getTarget());
        MCLocation l2 = ObjectGenerator.GetGenerator().location(location2, null, Target.UNKNOWN);
        if (!l1.getWorld().equals(l2.getWorld()) || l1.getBlockX() != l2.getBlockX() || l1.getBlockY() != l2.getBlockY() || l1.getBlockZ() != l2.getBlockZ()) {
            throw new PrefilterNonMatchException();
        }
    }

    private static void StringMatch(String string1, String string2) throws PrefilterNonMatchException {
        if (!string1.equals(string2)) {
            throw new PrefilterNonMatchException();
        }
    }

    private static void MathMatch(Mixed one, Mixed two) throws PrefilterNonMatchException {
        try {
            double dOne = ArgumentValidation.getNumber(one, Target.UNKNOWN);
            double dTwo = ArgumentValidation.getNumber(two, Target.UNKNOWN);
            if (dOne != dTwo) {
                throw new PrefilterNonMatchException();
            }
        }
        catch (ConfigRuntimeException e) {
            throw new PrefilterNonMatchException();
        }
    }

    private static void ExpressionMatch(Mixed expression, String key, Mixed dvalue) throws PrefilterNonMatchException {
        Class<?> errClazz;
        Class<?> eClazz;
        String exp = expression.val().substring(1, expression.val().length() - 1);
        boolean inequalityMode = false;
        if (exp.contains("<") || exp.contains(">") || exp.contains("==")) {
            inequalityMode = true;
        }
        String eClass = "com.sk89q.worldedit.internal.expression.Expression";
        String errClass = "com.sk89q.worldedit.internal.expression.ExpressionException";
        try {
            eClazz = Class.forName(eClass);
            errClazz = Class.forName(errClass);
        }
        catch (ClassNotFoundException cnf) {
            throw new CREPluginInternalException("You are missing a required dependency: " + eClass, expression.getTarget(), cnf);
        }
        try {
            Object e = ReflectionUtils.invokeMethod(eClazz, null, "compile", new Class[]{String.class, String[].class}, new Object[]{exp, new String[]{key}});
            double val = (Double)ReflectionUtils.invokeMethod(eClazz, e, "evaluate", new Class[]{double[].class}, new Object[]{new double[]{ArgumentValidation.getDouble(dvalue, Target.UNKNOWN)}});
            if (inequalityMode ? val == 0.0 : val != ArgumentValidation.getDouble(dvalue, Target.UNKNOWN)) {
                throw new PrefilterNonMatchException();
            }
        }
        catch (ReflectionUtils.ReflectionException rex) {
            if (rex.getCause().getClass().isAssignableFrom(errClazz)) {
                throw new CREPluginInternalException("Your expression was invalidly formatted", expression.getTarget(), rex.getCause());
            }
            throw new CREPluginInternalException(rex.getMessage(), expression.getTarget(), rex.getCause());
        }
    }

    private static void RegexMatch(String regex, Mixed value) throws PrefilterNonMatchException {
        regex = regex.substring(1, regex.length() - 1);
        if (!value.val().matches(regex)) {
            throw new PrefilterNonMatchException();
        }
    }

    private static void MacroMatch(String key, Mixed expression, Mixed value) throws PrefilterNonMatchException {
        if (expression.val().isEmpty()) {
            throw new PrefilterNonMatchException();
        }
        if (expression.val().charAt(0) == '(' && expression.val().charAt(expression.val().length() - 1) == ')') {
            Prefilters.ExpressionMatch(expression, key, value);
        } else if (expression.val().charAt(0) == '/' && expression.val().charAt(expression.val().length() - 1) == '/') {
            Prefilters.RegexMatch(expression.val(), value);
        } else {
            Prefilters.StringMatch(expression.val(), value.val());
        }
    }

    public static enum PrefilterType {
        ITEM_MATCH,
        LOCATION_MATCH,
        BOOLEAN_MATCH,
        STRING_MATCH,
        MATH_MATCH,
        REGEX,
        EXPRESSION,
        MACRO;

    }
}

