/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.events.drivers;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.blocks.MCBlockState;
import com.laytonsmith.abstraction.enums.MCTreeType;
import com.laytonsmith.abstraction.events.MCStructureGrowEvent;
import com.laytonsmith.abstraction.events.MCWorldEvent;
import com.laytonsmith.abstraction.events.MCWorldLoadEvent;
import com.laytonsmith.abstraction.events.MCWorldSaveEvent;
import com.laytonsmith.abstraction.events.MCWorldUnloadEvent;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ObjectGenerator;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.events.AbstractEvent;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.Prefilters;
import com.laytonsmith.core.exceptions.EventException;
import com.laytonsmith.core.exceptions.PrefilterNonMatchException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.List;
import java.util.Map;

public final class WorldEvents {
    private WorldEvents() {
    }

    public static String docs() {
        return "Contains events related to the world.";
    }

    @api
    public static class tree_grow
    extends WorldEvent {
        @Override
        public String getName() {
            return "tree_grow";
        }

        @Override
        public Driver driver() {
            return Driver.TREE_GROW;
        }

        @Override
        public String docs() {
            return "{world: <macro> | player: <macro> | type: <macro> | bonemeal: <boolean match>}Fires when a tree grows.{world: The world in which the tree has grown. | type: The tree type, can be one of " + StringUtils.Join((Object[])MCTreeType.values(), ", ", ", or ", " or ") + " | blocks: An array containing all locations of grown blocks. | location: The location of the sapling. | bonemeal: If the tree has grown due to a bonemeal or not. | player: The player who used the bonemeal, or null if no bonemeal was used.}{}{}";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (e instanceof MCStructureGrowEvent) {
                MCPlayer player2;
                MCStructureGrowEvent event = (MCStructureGrowEvent)e;
                Prefilters.match(prefilter, "world", event.getWorld().getName(), Prefilters.PrefilterType.MACRO);
                if (prefilter.containsKey("player") && ((player2 = event.getPlayer()) == null ? !(prefilter.get("player") instanceof CNull) : !player2.getName().equals(prefilter.get("player").val()))) {
                    return false;
                }
                Prefilters.match(prefilter, "type", event.getSpecies().name(), Prefilters.PrefilterType.MACRO);
                Prefilters.match(prefilter, "bonemeal", event.isFromBonemeal(), Prefilters.PrefilterType.BOOLEAN_MATCH);
                return true;
            }
            return false;
        }

        @Override
        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            Map<String, Mixed> r = super.evaluate(e);
            MCStructureGrowEvent event = (MCStructureGrowEvent)e;
            List<MCBlockState> blocks = event.getBlocks();
            CArray a = new CArray(Target.UNKNOWN, blocks.size());
            for (MCBlockState block : blocks) {
                a.push(ObjectGenerator.GetGenerator().location(block.getLocation(), false), Target.UNKNOWN);
            }
            r.put("blocks", a);
            r.put("location", ObjectGenerator.GetGenerator().location(event.getLocation(), false));
            MCPlayer player2 = event.getPlayer();
            r.put("player", player2 == null ? CNull.NULL : new CString(player2.getName(), Target.UNKNOWN));
            r.put("type", new CString(event.getSpecies().name(), Target.UNKNOWN));
            r.put("bonemeal", CBoolean.get(event.isFromBonemeal()));
            return r;
        }

        @Override
        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        @Override
        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }
    }

    @api
    public static class world_save
    extends WorldEvent {
        @Override
        public String getName() {
            return "world_save";
        }

        @Override
        public Driver driver() {
            return Driver.WORLD_SAVE;
        }

        @Override
        public String docs() {
            return "{world: <macro>}Fires when a world is saved.{world: The saved world.}{}{}";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (e instanceof MCWorldSaveEvent) {
                Prefilters.match(prefilter, "world", ((MCWorldEvent)e).getWorld().getName(), Prefilters.PrefilterType.MACRO);
                return true;
            }
            return false;
        }

        @Override
        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        @Override
        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }
    }

    @api
    public static class world_unload
    extends WorldEvent {
        @Override
        public String getName() {
            return "world_unload";
        }

        @Override
        public Driver driver() {
            return Driver.WORLD_UNLOAD;
        }

        @Override
        public String docs() {
            return "{world: <macro>}Fires when a world is unloaded.{world: The unloaded world.}{}{}";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (e instanceof MCWorldUnloadEvent) {
                Prefilters.match(prefilter, "world", ((MCWorldEvent)e).getWorld().getName(), Prefilters.PrefilterType.MACRO);
                return true;
            }
            return false;
        }

        @Override
        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        @Override
        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }
    }

    @api
    public static class world_load
    extends WorldEvent {
        @Override
        public String getName() {
            return "world_load";
        }

        @Override
        public Driver driver() {
            return Driver.WORLD_LOAD;
        }

        @Override
        public String docs() {
            return "{world: <macro>}Fires when a world is loaded.{world: The loaded world.}{}{}";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public boolean matches(Map<String, Mixed> prefilter, BindableEvent e) throws PrefilterNonMatchException {
            if (e instanceof MCWorldLoadEvent) {
                Prefilters.match(prefilter, "world", ((MCWorldEvent)e).getWorld().getName(), Prefilters.PrefilterType.MACRO);
                return true;
            }
            return false;
        }

        @Override
        public boolean modifyEvent(String key, Mixed value, BindableEvent event) {
            return false;
        }

        @Override
        public BindableEvent convert(CArray manualObject, Target t) {
            return null;
        }
    }

    public static abstract class WorldEvent
    extends AbstractEvent {
        @Override
        public Map<String, Mixed> evaluate(BindableEvent e) throws EventException {
            Map<String, Mixed> r = this.evaluate_helper(e);
            r.put("world", new CString(((MCWorldEvent)e).getWorld().getName(), Target.UNKNOWN));
            return r;
        }
    }
}

