/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.objects;

import com.laytonsmith.PureUtilities.ObjectHelpers;
import com.laytonsmith.PureUtilities.SmartComment;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.UnqualifiedClassName;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.natives.interfaces.Commentable;
import com.laytonsmith.core.natives.interfaces.MAnnotation;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.AccessModifier;
import com.laytonsmith.core.objects.ElementDefinition;
import com.laytonsmith.core.objects.ObjectModifier;
import com.laytonsmith.core.objects.ObjectType;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ObjectHelpers.HashCode
@ObjectHelpers.Equals
public class ObjectDefinition
implements Commentable {
    @ObjectHelpers.ToString
    private final List<MAnnotation> annotations;
    @ObjectHelpers.ToString
    private final AccessModifier accessModifier;
    @ObjectHelpers.ToString
    private final Set<ObjectModifier> objectModifiers;
    @ObjectHelpers.ToString
    private final ObjectType objectType;
    @ObjectHelpers.ToString
    private final CClassType type;
    @ObjectHelpers.ToString
    private final Set<UnqualifiedClassName> superclasses;
    @ObjectHelpers.ToString
    private final Set<UnqualifiedClassName> interfaces;
    private final CClassType containingClass;
    private final Target definitionTarget;
    private final Map<String, List<ElementDefinition>> properties;
    private final SmartComment classComment;
    private final List<Object> genericParameters;
    private final Class<? extends Mixed> nativeClass;
    private Set<CClassType> qualifiedSuperclasses;
    private Set<CClassType> qualifiedInterfaces;
    private volatile boolean classesQualified = false;

    public ObjectDefinition(AccessModifier accessModifier, Set<ObjectModifier> objectModifiers, ObjectType objectType, CClassType type, Set<UnqualifiedClassName> superclasses, Set<UnqualifiedClassName> interfaces, CClassType containingClass, Target t, Map<String, List<ElementDefinition>> properties, List<MAnnotation> annotations, SmartComment classComment, List<Object> genericParameters, Class<? extends Mixed> nativeClass) {
        this.accessModifier = accessModifier;
        this.objectModifiers = objectModifiers;
        this.objectType = objectType;
        this.type = type;
        this.superclasses = superclasses;
        this.interfaces = interfaces;
        this.containingClass = containingClass;
        this.definitionTarget = t;
        this.properties = properties;
        this.annotations = annotations;
        this.classComment = classComment;
        this.genericParameters = genericParameters;
        this.nativeClass = nativeClass;
    }

    public String getClassName() {
        return this.getName();
    }

    public FullyQualifiedClassName getFQCN() {
        return this.type.getFQCN();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectDefinition other = (ObjectDefinition)obj;
        return Objects.equals(this.type, other.type);
    }

    public boolean exactlyEquals(Object obj) {
        return ObjectHelpers.DoEquals(this, obj);
    }

    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }

    public String toString() {
        return ObjectHelpers.DoToString(this);
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public Set<ObjectModifier> getObjectModifiers() {
        if (this.objectModifiers.isEmpty()) {
            return EnumSet.noneOf(ObjectModifier.class);
        }
        return EnumSet.copyOf(this.objectModifiers);
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public CClassType getType() {
        return this.type;
    }

    public String getName() {
        return this.type.getFQCN().getFQCN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void qualifyClasses(Environment env) throws ConfigCompileGroupException {
        if (this.classesQualified) {
            return;
        }
        ObjectDefinition objectDefinition = this;
        synchronized (objectDefinition) {
            if (this.classesQualified) {
                return;
            }
            HashSet<ConfigCompileException> uhohs = new HashSet<ConfigCompileException>();
            HashSet<CClassType> superclasses = new HashSet<CClassType>();
            HashSet<CClassType> interfaces = new HashSet<CClassType>();
            for (UnqualifiedClassName ucn : this.superclasses) {
                try {
                    superclasses.add(CClassType.get(ucn.getFQCN(env)));
                }
                catch (ClassNotFoundException ex) {
                    uhohs.add(new ConfigCompileException("Could not find " + ucn.getUnqualifiedClassName(), ucn.getTarget(), ex));
                }
            }
            for (UnqualifiedClassName ucn : this.interfaces) {
                try {
                    interfaces.add(CClassType.get(ucn.getFQCN(env)));
                }
                catch (ClassNotFoundException ex) {
                    uhohs.add(new ConfigCompileException("Could not find " + ucn.getUnqualifiedClassName(), ucn.getTarget(), ex));
                }
            }
            if (!uhohs.isEmpty()) {
                throw new ConfigCompileGroupException(uhohs);
            }
            this.qualifiedSuperclasses = superclasses;
            this.qualifiedInterfaces = interfaces;
            this.classesQualified = true;
        }
    }

    public Set<CClassType> getSuperclasses() {
        if (this.qualifiedSuperclasses == null) {
            throw new Error("qualifyClasses() must be called before getSuperclasses can be used (" + this.getType() + ")");
        }
        return new HashSet<CClassType>(this.qualifiedSuperclasses);
    }

    public Set<CClassType> getInterfaces() {
        if (this.qualifiedSuperclasses == null) {
            throw new Error("qualifyClasses() must be called before getInterfaces can be used (" + this.getType() + ")");
        }
        return new HashSet<CClassType>(this.qualifiedInterfaces);
    }

    public CClassType getContainingClass() {
        return this.containingClass;
    }

    public Target getDefinitionTarget() {
        return this.definitionTarget;
    }

    public Map<String, List<ElementDefinition>> getElements() {
        return this.properties;
    }

    public List<MAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public SmartComment getElementComment() {
        return this.classComment;
    }

    public List<Object> getGenericParameters() {
        return this.genericParameters;
    }

    public boolean isNative() {
        if (!this.getObjectModifiers().contains((Object)ObjectModifier.NATIVE)) {
            return false;
        }
        try {
            NativeTypeList.getNativeClassOrInterfaceRunner(this.type.getFQCN());
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }
}

