/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.ClassLoading.ClassMirror;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.ClassUtils;
import java.io.Serializable;
import java.util.Arrays;

public class ClassReferenceMirror<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ClassReferenceMirror WILDCARD = new ClassReferenceMirror("*");
    private final String name;
    private final String templateTypeName;
    private final ClassReferenceMirror[] genericParameters;

    public static ClassReferenceMirror fromClass(Class c) {
        return new ClassReferenceMirror(ClassUtils.getJVMName(c));
    }

    public ClassReferenceMirror(String name) {
        this.name = name;
        this.genericParameters = new ClassReferenceMirror[0];
        this.templateTypeName = null;
    }

    public ClassReferenceMirror(String name, ClassReferenceMirror[] genericParameters) {
        this.name = name;
        this.genericParameters = genericParameters;
        this.templateTypeName = null;
    }

    public ClassReferenceMirror(String name, String templateTypeName) {
        this.name = name;
        this.genericParameters = null;
        this.templateTypeName = templateTypeName;
    }

    public String getJVMName() {
        return this.name;
    }

    public Class<T> loadClass() throws ClassNotFoundException {
        return this.loadClass(ClassDiscovery.getDefaultInstance().getDefaultClassLoader(), true);
    }

    public Class<T> loadClass(ClassLoader loader, boolean initialize) throws ClassNotFoundException {
        return ClassUtils.forCanonicalName(ClassUtils.getCommonNameFromJVMName(this.name), initialize, loader);
    }

    public boolean isArray() {
        return this.name.startsWith("[");
    }

    public boolean isTemplateDefinition() {
        return this.templateTypeName != null;
    }

    public String getTemplateTypeName() {
        return this.templateTypeName;
    }

    public boolean isTemplateUsage() {
        return this.name.startsWith("T");
    }

    public ClassReferenceMirror[] getGenerics() {
        return Arrays.copyOf(this.genericParameters, this.genericParameters.length);
    }

    public ClassReferenceMirror getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return new ClassReferenceMirror<T>(this.name.substring(1));
    }

    public String toString() {
        if (this.isTemplateDefinition()) {
            // empty if block
        }
        String ret = ClassUtils.getCommonNameFromJVMName(this.name);
        if (this.genericParameters != null && this.genericParameters.length != 0) {
            ret = ret + "<";
            boolean first = true;
            for (ClassReferenceMirror r : this.genericParameters) {
                if (!first) {
                    ret = ret + ", ";
                }
                first = false;
                ret = ret + r.toString();
            }
            ret = ret + ">";
        }
        return ret;
    }

    public int hashCode() {
        int hash2 = 3;
        hash2 = 23 * hash2 + (this.name != null ? this.name.hashCode() : 0);
        return hash2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassReferenceMirror other = (ClassReferenceMirror)obj;
        return !(this.name != null ? !this.name.equals(other.name) : other.name != null);
    }
}

