/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Common;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class StreamUtils {
    public static void Copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len != -1) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }

    public static String GetString(InputStream in) {
        try {
            return StreamUtils.GetString(in, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static String GetString(InputStream in, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (in == null) {
            throw new NullPointerException("InputStream is null");
        }
        InputStreamReader input = new InputStreamReader((InputStream)new BufferedInputStream(in), encoding);
        int charsPerPage = 5000;
        char[] buffer = new char[5000];
        StringBuilder output = new StringBuilder(5000);
        try {
            int read2 = input.read(buffer, 0, buffer.length);
            while (read2 != -1) {
                output.append(buffer, 0, read2);
                read2 = input.read(buffer, 0, buffer.length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return output.toString();
    }

    public static byte[] GetBytes(InputStream in) throws IOException {
        int i;
        BufferedInputStream bis = new BufferedInputStream(in);
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        while ((i = bis.read()) != -1) {
            bytes.add((byte)i);
        }
        return ArrayUtils.unbox(bytes.toArray(new Byte[bytes.size()]));
    }

    public static InputStream GetInputStream(String contents) {
        try {
            return StreamUtils.GetInputStream(contents, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static InputStream GetInputStream(String contents, String encoding) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(contents.getBytes(encoding));
    }

    public static InputStream GetInputStream(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static PrintStream GetSystemOut() {
        try {
            return new PrintStream((OutputStream)System.out, true, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static PrintStream GetSystemErr() {
        try {
            return new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }

    public static final String GetResource(String name, String encoding) throws UnsupportedEncodingException, IllegalArgumentException {
        InputStream is = StackTraceUtils.getCallingClass().getResourceAsStream(name);
        if (is == null) {
            throw new IllegalArgumentException("Could not find resource " + name);
        }
        return StreamUtils.GetString(is, encoding);
    }

    public static final String GetResource(String name) throws IllegalArgumentException {
        try {
            return StreamUtils.GetResource(name, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Error(ex);
        }
    }
}

