/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.MCEntityEquipment;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCEntityEquipment;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLivingEntity;
import com.laytonsmith.abstraction.entities.MCArmorStand;
import com.laytonsmith.abstraction.enums.MCBodyPart;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class BukkitMCArmorStand
extends BukkitMCLivingEntity
implements MCArmorStand {
    ArmorStand as;
    ArmorStandEquipmentProxy ase;

    public BukkitMCArmorStand(Entity le) {
        super((Entity)((LivingEntity)le));
        this.as = (ArmorStand)le;
        this.ase = new ArmorStandEquipmentProxy(this.as);
    }

    @Override
    public MCEntityEquipment getEquipment() {
        return new BukkitMCEntityEquipment(this.ase);
    }

    @Override
    public Map<MCBodyPart, Vector3D> getAllPoses() {
        EnumMap<MCBodyPart, Vector3D> slots = new EnumMap<MCBodyPart, Vector3D>(MCBodyPart.class);
        block8: for (MCBodyPart key : MCBodyPart.values()) {
            switch (key) {
                case Head: {
                    slots.put(key, this.getHeadPose());
                    continue block8;
                }
                case Torso: {
                    slots.put(key, this.getBodyPose());
                    continue block8;
                }
                case ArmLeft: {
                    slots.put(key, this.getLeftArmPose());
                    continue block8;
                }
                case ArmRight: {
                    slots.put(key, this.getRightArmPose());
                    continue block8;
                }
                case LegLeft: {
                    slots.put(key, this.getLeftLegPose());
                    continue block8;
                }
                case LegRight: {
                    slots.put(key, this.getRightLegPose());
                }
            }
        }
        return slots;
    }

    @Override
    public void setAllPoses(Map<MCBodyPart, Vector3D> posemap) {
        for (Map.Entry<MCBodyPart, Vector3D> part : posemap.entrySet()) {
            Vector3D pose = part.getValue();
            switch (part.getKey()) {
                case Head: {
                    this.setHeadPose(pose);
                    break;
                }
                case Torso: {
                    this.setBodyPose(pose);
                    break;
                }
                case ArmLeft: {
                    this.setLeftArmPose(pose);
                    break;
                }
                case ArmRight: {
                    this.setRightArmPose(pose);
                    break;
                }
                case LegLeft: {
                    this.setLeftLegPose(pose);
                    break;
                }
                case LegRight: {
                    this.setRightLegPose(pose);
                }
            }
        }
    }

    @Override
    public MCItemStack getItemInHand() {
        return new BukkitMCItemStack(this.as.getItemInHand());
    }

    @Override
    public void setItemInHand(MCItemStack item) {
        this.as.setItemInHand(item == null ? null : ((BukkitMCItemStack)item).asItemStack());
    }

    @Override
    public MCItemStack getBoots() {
        return new BukkitMCItemStack(this.as.getBoots());
    }

    @Override
    public void setBoots(MCItemStack item) {
        if (item == null) {
            this.as.setBoots(null);
        } else {
            this.as.setBoots(((BukkitMCItemStack)item).asItemStack());
        }
    }

    @Override
    public MCItemStack getLeggings() {
        return new BukkitMCItemStack(this.as.getLeggings());
    }

    @Override
    public void setLeggings(MCItemStack item) {
        this.as.setLeggings(item == null ? null : ((BukkitMCItemStack)item).asItemStack());
    }

    @Override
    public MCItemStack getChestplate() {
        return new BukkitMCItemStack(this.as.getChestplate());
    }

    @Override
    public void setChestplate(MCItemStack item) {
        if (item == null) {
            this.as.setChestplate(null);
        } else {
            this.as.setChestplate(((BukkitMCItemStack)item).asItemStack());
        }
    }

    @Override
    public MCItemStack getHelmet() {
        return new BukkitMCItemStack(this.as.getHelmet());
    }

    @Override
    public void setHelmet(MCItemStack item) {
        if (item == null) {
            this.as.setHelmet(null);
        } else {
            this.as.setHelmet(((BukkitMCItemStack)item).asItemStack());
        }
    }

    @Override
    public Vector3D getBodyPose() {
        EulerAngle pose = this.as.getBodyPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setBodyPose(Vector3D pose) {
        this.as.setBodyPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getLeftArmPose() {
        EulerAngle pose = this.as.getLeftArmPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setLeftArmPose(Vector3D pose) {
        this.as.setLeftArmPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getRightArmPose() {
        EulerAngle pose = this.as.getRightArmPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setRightArmPose(Vector3D pose) {
        this.as.setRightArmPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getLeftLegPose() {
        EulerAngle pose = this.as.getLeftLegPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setLeftLegPose(Vector3D pose) {
        this.as.setLeftLegPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getRightLegPose() {
        EulerAngle pose = this.as.getRightLegPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setRightLegPose(Vector3D pose) {
        this.as.setRightLegPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getHeadPose() {
        EulerAngle pose = this.as.getHeadPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setHeadPose(Vector3D pose) {
        this.as.setHeadPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public boolean hasBasePlate() {
        return this.as.hasBasePlate();
    }

    @Override
    public void setHasBasePlate(boolean basePlate) {
        this.as.setBasePlate(basePlate);
    }

    @Override
    public boolean hasGravity() {
        return this.as.hasGravity();
    }

    @Override
    public void setHasGravity(boolean gravity) {
        this.as.setGravity(gravity);
    }

    @Override
    public boolean isVisible() {
        return this.as.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.as.setVisible(visible);
    }

    @Override
    public boolean hasArms() {
        return this.as.hasArms();
    }

    @Override
    public void setHasArms(boolean arms) {
        this.as.setArms(arms);
    }

    @Override
    public boolean isSmall() {
        return this.as.isSmall();
    }

    @Override
    public void setSmall(boolean small) {
        this.as.setSmall(small);
    }

    @Override
    public Boolean isMarker() {
        return this.as.isMarker();
    }

    @Override
    public void setMarker(boolean marker) {
        this.as.setMarker(marker);
    }

    private class ArmorStandEquipmentProxy
    implements EntityEquipment {
        ArmorStand holder;

        ArmorStandEquipmentProxy(ArmorStand stand) {
            this.holder = stand;
        }

        public Entity getHolder() {
            return this.holder;
        }

        public ItemStack getItemInHand() {
            return this.holder.getItemInHand();
        }

        public void setItemInHand(ItemStack itemStack) {
            this.holder.setItemInHand(itemStack);
        }

        public ItemStack getItemInMainHand() {
            return this.holder.getItemInHand();
        }

        public void setItemInMainHand(ItemStack itemStack) {
            this.holder.setItemInHand(itemStack);
        }

        public ItemStack getItemInOffHand() {
            return this.holder.getEquipment().getItemInOffHand();
        }

        public void setItemInOffHand(ItemStack itemStack) {
            this.holder.getEquipment().setItemInOffHand(itemStack);
        }

        public ItemStack getHelmet() {
            return this.holder.getHelmet();
        }

        public void setHelmet(ItemStack itemStack) {
            this.holder.setHelmet(itemStack);
        }

        public ItemStack getChestplate() {
            return this.holder.getChestplate();
        }

        public void setChestplate(ItemStack itemStack) {
            this.holder.setChestplate(itemStack);
        }

        public ItemStack getLeggings() {
            return this.holder.getLeggings();
        }

        public void setLeggings(ItemStack itemStack) {
            this.holder.setLeggings(itemStack);
        }

        public ItemStack getBoots() {
            return this.holder.getBoots();
        }

        public void setBoots(ItemStack itemStack) {
            this.holder.setBoots(itemStack);
        }

        public ItemStack[] getArmorContents() {
            return new ItemStack[]{this.getBoots(), this.getLeggings(), this.getChestplate(), this.getHelmet()};
        }

        public void setArmorContents(ItemStack[] itemStacks) {
            switch (itemStacks.length) {
                case 4: {
                    this.setHelmet(itemStacks[3]);
                }
                case 3: {
                    this.setChestplate(itemStacks[2]);
                }
                case 2: {
                    this.setLeggings(itemStacks[1]);
                }
                case 1: {
                    this.setBoots(itemStacks[0]);
                }
                case 0: {
                    return;
                }
            }
            this.setHelmet(itemStacks[3]);
            this.setChestplate(itemStacks[2]);
            this.setLeggings(itemStacks[1]);
            this.setBoots(itemStacks[0]);
        }

        public void clear() {
            this.setHelmet(null);
            this.setChestplate(null);
            this.setLeggings(null);
            this.setBoots(null);
            this.setItemInHand(null);
            this.setItemInOffHand(null);
        }

        public float getItemInHandDropChance() {
            return 0.0f;
        }

        public void setItemInHandDropChance(float v) {
        }

        public float getItemInMainHandDropChance() {
            return 0.0f;
        }

        public void setItemInMainHandDropChance(float v) {
        }

        public float getItemInOffHandDropChance() {
            return 0.0f;
        }

        public void setItemInOffHandDropChance(float v) {
        }

        public float getHelmetDropChance() {
            return 0.0f;
        }

        public void setHelmetDropChance(float v) {
        }

        public float getChestplateDropChance() {
            return 0.0f;
        }

        public void setChestplateDropChance(float v) {
        }

        public float getLeggingsDropChance() {
            return 0.0f;
        }

        public void setLeggingsDropChance(float v) {
        }

        public float getBootsDropChance() {
            return 0.0f;
        }

        public void setBootsDropChance(float v) {
        }

        public void setItem(EquipmentSlot es, ItemStack is) {
            switch (es) {
                case HEAD: {
                    this.setHelmet(is);
                    return;
                }
                case CHEST: {
                    this.setChestplate(is);
                    return;
                }
                case LEGS: {
                    this.setLeggings(is);
                    return;
                }
                case FEET: {
                    this.setBoots(is);
                    return;
                }
                case HAND: {
                    this.setItemInMainHand(is);
                    return;
                }
                case OFF_HAND: {
                    this.setItemInOffHand(is);
                    return;
                }
            }
            throw new UnsupportedOperationException("Missing case in ArmorStandEquipmentProxy.setItem!");
        }

        public ItemStack getItem(EquipmentSlot es) {
            switch (es) {
                case HEAD: {
                    return this.getHelmet();
                }
                case CHEST: {
                    return this.getChestplate();
                }
                case LEGS: {
                    return this.getLeggings();
                }
                case FEET: {
                    return this.getBoots();
                }
                case HAND: {
                    return this.getItemInMainHand();
                }
                case OFF_HAND: {
                    return this.getItemInOffHand();
                }
            }
            throw new UnsupportedOperationException("Missing case in ArmorStandEquipmentProxy.getItem!");
        }
    }
}

