/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCBiomeType;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.block.Biome;

public class BukkitMCBiomeType
extends MCBiomeType<Biome> {
    private static final Map<Biome, MCBiomeType> BUKKIT_MAP = new HashMap<Biome, MCBiomeType>();

    public BukkitMCBiomeType(MCBiomeType.MCVanillaBiomeType vanillaBiomeType, Biome biome) {
        super(vanillaBiomeType, biome);
    }

    @Override
    public String name() {
        return this.getAbstracted() == MCBiomeType.MCVanillaBiomeType.UNKNOWN ? this.concreteName() : ((MCBiomeType.MCVanillaBiomeType)((Object)this.getAbstracted())).name();
    }

    @Override
    public String concreteName() {
        Biome b = (Biome)this.getConcrete();
        if (b == null) {
            return "null";
        }
        return b.name();
    }

    public static MCBiomeType valueOfConcrete(Biome test) {
        MCBiomeType type = BUKKIT_MAP.get(test);
        if (type == null) {
            return NULL;
        }
        return type;
    }

    public static void build() {
        NULL = new BukkitMCBiomeType(MCBiomeType.MCVanillaBiomeType.UNKNOWN, null);
        for (MCBiomeType.MCVanillaBiomeType mCVanillaBiomeType : MCBiomeType.MCVanillaBiomeType.values()) {
            Biome type;
            if (!mCVanillaBiomeType.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                type = BukkitMCBiomeType.getBukkitType(mCVanillaBiomeType);
            }
            catch (IllegalArgumentException | NoSuchFieldError ex) {
                MSLog.GetLogger().w(MSLog.Tags.RUNTIME, "Could not find a Bukkit BiomeType for " + mCVanillaBiomeType.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCBiomeType wrapper = new BukkitMCBiomeType(mCVanillaBiomeType, type);
            MAP.put(mCVanillaBiomeType.name(), wrapper);
            BUKKIT_MAP.put(type, wrapper);
        }
        for (MCBiomeType.MCVanillaBiomeType mCVanillaBiomeType : Biome.values()) {
            if (BUKKIT_MAP.containsKey((Object)mCVanillaBiomeType)) continue;
            MAP.put(mCVanillaBiomeType.name(), new BukkitMCBiomeType(MCBiomeType.MCVanillaBiomeType.UNKNOWN, (Biome)mCVanillaBiomeType));
            BUKKIT_MAP.put((Biome)mCVanillaBiomeType, new BukkitMCBiomeType(MCBiomeType.MCVanillaBiomeType.UNKNOWN, (Biome)mCVanillaBiomeType));
        }
    }

    private static Biome getBukkitType(MCBiomeType.MCVanillaBiomeType v) {
        return Biome.valueOf((String)v.name());
    }
}

