/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.Common.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONValue;

public class UpgradeLog {
    private final File logFile;
    private final List<UpgradeTask> tasks;
    private final List<Upgrade> upgrades = new ArrayList<Upgrade>();

    public UpgradeLog(File logFile) {
        this.logFile = logFile;
        this.tasks = new ArrayList<UpgradeTask>();
    }

    public void addUpgradeTask(UpgradeTask task) {
        this.tasks.add(task);
        task.that = this;
    }

    public void runTasks() throws IOException {
        ArrayList<Map<String, String>> jsonUpgrades;
        if (this.logFile.exists()) {
            jsonUpgrades = (List)JSONValue.parse((String)FileUtil.read(this.logFile));
            for (Map map : jsonUpgrades) {
                this.upgrades.add(Upgrade.fromMap(map));
            }
        }
        for (UpgradeTask upgradeTask : this.tasks) {
            if (!upgradeTask.doRun()) continue;
            upgradeTask.run();
        }
        jsonUpgrades = new ArrayList<Map<String, String>>();
        for (Upgrade upgrade : this.upgrades) {
            jsonUpgrades.add(upgrade.toMap());
        }
        String string = JSONValue.toJSONString(jsonUpgrades);
        FileUtil.write(string, this.logFile);
    }

    private static class Upgrade {
        String breadcrumb;
        long upgradeTime;

        private Upgrade() {
        }

        public static Upgrade fromMap(Map<String, String> map) {
            Upgrade u = new Upgrade();
            u.breadcrumb = map.get("breadcrumb");
            u.upgradeTime = Long.parseLong(map.get("upgradeTime"));
            return u;
        }

        public Map<String, String> toMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("breadcrumb", this.breadcrumb);
            map.put("upgradeTime", Long.toString(this.upgradeTime));
            return map;
        }
    }

    public static abstract class UpgradeTask
    implements Runnable {
        UpgradeLog that = null;

        protected boolean hasBreadcrumb(String breadcrumb) {
            for (Upgrade u : this.that.upgrades) {
                if (!u.breadcrumb.equals(breadcrumb)) continue;
                return true;
            }
            return false;
        }

        public abstract boolean doRun();

        protected void leaveBreadcrumb(String breadcrumb) {
            Upgrade u = new Upgrade();
            u.breadcrumb = breadcrumb;
            u.upgradeTime = System.currentTimeMillis();
            this.that.upgrades.add(u);
        }
    }
}

