/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.util.List;

public abstract class SimpleBlockKeywordFunction
extends Keyword {
    public static int doProcess(Keyword keyword2, Integer[] functionArgumentCount, boolean isStandaloneFunction, List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        Target t = list.get(keywordPosition).getTarget();
        if (list.size() > keywordPosition + 1) {
            ParseTree code = list.get(keywordPosition + 1);
            if (SimpleBlockKeywordFunction.isCodeBlock(code)) {
                Integer[] validArgs = functionArgumentCount;
                if (validArgs != null) {
                    int firstClauseArgumentCount = list.get(keywordPosition).getChildren().size();
                    if (validArgs.length == 1) {
                        if (firstClauseArgumentCount != validArgs[0]) {
                            throw new ConfigCompileException("\"" + keyword2.getKeywordName() + "\" blocks " + (firstClauseArgumentCount > validArgs[0] ? "may only" : "must") + " have " + validArgs[0] + " argument" + (validArgs[0] == 1 ? "" : "s") + " passed to the " + keyword2.getKeywordName() + " condition, " + firstClauseArgumentCount + " found.", t);
                        }
                    } else {
                        boolean error = true;
                        Integer[] integerArray = validArgs;
                        int n = integerArray.length;
                        for (int i = 0; i < n; ++i) {
                            int i2 = integerArray[i];
                            if (firstClauseArgumentCount != i2) continue;
                            error = false;
                            break;
                        }
                        if (error) {
                            throw new ConfigCompileException("\"" + keyword2.getKeywordName() + "\" blocks may not have " + firstClauseArgumentCount + " argument" + (firstClauseArgumentCount == 1 ? "" : "s") + " passed to the " + keyword2.getKeywordName() + " condition", t);
                        }
                    }
                }
                list.get(keywordPosition).addChild(SimpleBlockKeywordFunction.getArgumentOrNull(code));
                list.remove(keywordPosition + 1);
            }
        } else if (!isStandaloneFunction) {
            throw new ConfigCompileException("Missing code block, following \"" + keyword2.getKeywordName() + "\"", t);
        }
        return keywordPosition;
    }

    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        return SimpleBlockKeywordFunction.doProcess(this, this.getFunctionArgumentCount(), this.isStandaloneFunction(), list, keywordPosition);
    }

    protected boolean isStandaloneFunction() {
        return true;
    }

    protected abstract Integer[] getFunctionArgumentCount();
}

