/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.ClassLoading.ClassMirror.ClassMirror;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class ExhaustiveVisitor<T> {
    private static final String VISIT = "visit";

    public final void visit(T object) {
        VisitorInfo info = this.getClass().getDeclaredAnnotation(VisitorInfo.class);
        Method candidate = null;
        Class<?> searchFor = object.getClass();
        for (Method m : this.getClass().getMethods()) {
            if (!VISIT.equals(m.getName())) continue;
            Class<?> visitParam = m.getParameterTypes()[0];
            if (info != null && info.directSubclassOnly()) {
                if (!visitParam.isAssignableFrom(searchFor)) continue;
                candidate = m;
                break;
            }
            if (visitParam != searchFor) continue;
            candidate = m;
            break;
        }
        if (candidate == null) {
            throw new NoSuchMethodError("Missing implementation of method with signature (or superclass of):  public void visit(" + searchFor.getName().replace("$", ".") + ") in class " + this.getClass().getName());
        }
        try {
            candidate.invoke((Object)this, object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void verify(ClassMirror<? extends ExhaustiveVisitor> classMirror) throws ClassNotFoundException {
        Class<? extends ExhaustiveVisitor> clazz = classMirror.loadClass();
        System.out.println("Verifying " + clazz);
        VisitorInfo info = clazz.getAnnotation(VisitorInfo.class);
        Class<?> baseClass = classMirror.getGenerics().get(new ClassMirror(ExhaustiveVisitor.class).getClassReference()).get(0).loadClass();
        ArrayList<String> uhohs = new ArrayList<String>();
        HashSet handledClasses = new HashSet();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == ExhaustiveVisitor.class || !VISIT.equals(method.getName()) || (method.getModifiers() & 1) == 0) continue;
            if (method.getReturnType() != Void.TYPE) {
                uhohs.add("Return type of public visit() methods must be void, but " + clazz.getName() + " " + method + " does not conform");
            }
            if (method.getParameterTypes().length != 1) {
                uhohs.add("Public visit() methods must accept exactly one parameter, but" + clazz.getName() + " " + method + " does not conform");
                continue;
            }
            Class<?> param = method.getParameterTypes()[0];
            if (baseClass.isAssignableFrom(param)) {
                handledClasses.add(param);
                continue;
            }
            uhohs.add("Public visit() methods parameters must extend the given base class's type, but the parameter of method " + method + " in " + clazz.getName() + " has a disjoint type than " + baseClass.getName() + ". Make the method non-public, or rename it, if you would like to keep the method.");
        }
        HashSet needsToHandle = new HashSet();
        for (Class<?> c : ClassDiscovery.getDefaultInstance().loadClassesThatExtend(baseClass)) {
            if ((c.getModifiers() & 0x400) != 0) continue;
            if (info != null && info.directSubclassOnly()) {
                if (c.getSuperclass() != baseClass && !Arrays.asList(c.getInterfaces()).contains(c)) continue;
                needsToHandle.add(c);
                continue;
            }
            needsToHandle.add(c);
        }
        if (!needsToHandle.equals(handledClasses)) {
            String s = clazz.getName() + " is missing needed implementations of the visit method. It is required that it handle the following: " + needsToHandle + ", however, it only handles the following: " + handledClasses + ". Please add the following implementations:\n";
            needsToHandle.removeAll(handledClasses);
            for (Class clazz2 : needsToHandle) {
                s = s + "public void visit(" + clazz2.getName().replace("$", ".") + " obj) { /* Implement me */ }\n";
            }
            uhohs.add(s);
        }
        if (!uhohs.isEmpty()) {
            throw new RuntimeException(StringUtils.Join(uhohs, "\n"));
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface VisitorInfo {
        public boolean directSubclassOnly() default false;
    }
}

