/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.UI;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.UIUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class TextDialog
extends JDialog {
    private JEditorPane inputDialog;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JButton okButton;

    public TextDialog(Frame parent, boolean modal, String text) {
        super(parent, modal);
        this.initComponents();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextDialog.this.setVisible(false);
                TextDialog.this.dispose();
            }
        });
        this.inputDialog.setContentType("text/html");
        this.inputDialog.setEditable(false);
        HTMLDocument doc = (HTMLDocument)this.inputDialog.getDocument();
        HTMLEditorKit editorKit = (HTMLEditorKit)this.inputDialog.getEditorKit();
        try {
            editorKit.insertHTML(doc, doc.getLength(), "<html>" + text + "</html>", 0, 0, null);
        }
        catch (IOException | BadLocationException ex) {
            Logger.getLogger(TextDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.inputDialog.setCaretPosition(0);
        this.inputDialog.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    if (url == null) {
                        String id;
                        Element elem;
                        HTMLDocument doc = (HTMLDocument)TextDialog.this.inputDialog.getDocument();
                        Element clicked = e.getSourceElement();
                        Enumeration<?> enu = clicked.getAttributes().getAttributeNames();
                        Object[] attr = (Object[])ReflectionUtils.get(enu.getClass(), enu, "attr");
                        String link = null;
                        block2: for (Object item : attr) {
                            if (!(item instanceof SimpleAttributeSet)) continue;
                            SimpleAttributeSet tag = (SimpleAttributeSet)item;
                            Hashtable table = (Hashtable)ReflectionUtils.get(tag.getClass(), tag, "table");
                            for (Object key : table.keySet()) {
                                if (!(key instanceof HTML.Attribute) || !"href".equals(((HTML.Attribute)key).toString())) continue;
                                link = (String)table.get(key);
                                break block2;
                            }
                            break;
                        }
                        if (link != null && (elem = doc.getElement(id = link.substring(1))) != null) {
                            TextDialog.this.inputDialog.setCaretPosition(elem.getStartOffset());
                            TextDialog.this.inputDialog.scrollToReference(id);
                        }
                    } else {
                        try {
                            UIUtils.openWebpage(url);
                        }
                        catch (IOException | URISyntaxException ex) {
                            Logger.getLogger(TextDialog.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        });
    }

    public void setOKButtonText(String text) {
        this.okButton.setText(text);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.inputDialog = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.okButton.setText("Ok");
        this.okButton.setHorizontalAlignment(11);
        this.okButton.setSelected(true);
        this.jScrollPane2.setAutoscrolls(true);
        this.inputDialog.setBorder(BorderFactory.createBevelBorder(0));
        this.inputDialog.setMinimumSize(new Dimension(20, 10));
        this.jScrollPane2.setViewportView(this.inputDialog);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 376, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.okButton).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 246, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.okButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextDialog td = new TextDialog(null, false, "<font color=\"red\">Hi</font>");
                UIUtils.centerWindow(td);
                td.setVisible(true);
            }
        });
    }
}

