/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Web;

import com.laytonsmith.PureUtilities.Common.ArrayUtils;
import com.laytonsmith.PureUtilities.Common.FileUtil;
import com.laytonsmith.PureUtilities.Common.FileWriteMode;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Web.Cookie;
import com.laytonsmith.PureUtilities.Web.CookieJar;
import com.laytonsmith.PureUtilities.Web.HTTPMethod;
import com.laytonsmith.PureUtilities.Web.HTTPResponse;
import com.laytonsmith.PureUtilities.Web.HTTPResponseCallback;
import com.laytonsmith.PureUtilities.Web.RawHTTPResponse;
import com.laytonsmith.PureUtilities.Web.RequestSettings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.brotli.dec.BrotliInputStream;

public final class WebUtility {
    public static final Set<String> SUPPORTED_ENCODINGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("gzip", "deflate", "br", "identity")));
    private static int urlRetrieverPoolId = 0;
    private static final ExecutorService URL_RETRIEVER_POOL = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "URLRetrieverThread-" + ++urlRetrieverPoolId);
        }
    });

    public static void main(String[] args) throws Exception {
        CookieJar stash = new CookieJar();
        HTTPResponse resp = WebUtility.GetPage(new URL("http://www.google.com/"), HTTPMethod.GET, null, null, stash, true, 60000);
        StreamUtils.GetSystemOut().println(stash.getCookies(new URL("http://www.google.com")));
    }

    private WebUtility() {
    }

    public static HTTPResponse GetPage(URL url, HTTPMethod method, Map<String, List<String>> headers, Map<String, String> parameters, CookieJar cookieStash, boolean followRedirects, int timeout) throws SocketTimeoutException, IOException {
        RequestSettings settings = new RequestSettings().setMethod(method).setHeaders(headers).setParameters(parameters).setCookieJar(cookieStash).setFollowRedirects(followRedirects).setTimeout(timeout);
        return WebUtility.GetPage(url, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HTTPResponse GetPage(URL url, RequestSettings settings) throws SocketTimeoutException, IOException {
        if (settings == null) {
            settings = new RequestSettings();
        }
        if (settings.getDownloadTo() != null && settings.getDownloadStrategy() == FileWriteMode.SAFE_WRITE && settings.getDownloadTo().exists()) {
            throw new IOException("Refusing to download file, destination path already exists [" + settings.getDownloadTo() + "]");
        }
        CookieJar cookieStash = settings.getCookieJar();
        RawHTTPResponse response = WebUtility.getWebStream(url, settings);
        byte[] b = null;
        BufferedInputStream in = new BufferedInputStream(response.getStream());
        if (settings.getDownloadTo() == null) {
            if (settings.getLogger() != null) {
                settings.getLogger().log(Level.INFO, "Reading in response body");
            }
            try {
                b = StreamUtils.GetBytes(in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        if (settings.getLogger() != null) {
            settings.getLogger().log(Level.INFO, "Saving file to [{0}] using {1} strategy", new Object[]{settings.getDownloadTo(), settings.getDownloadStrategy()});
        }
        try {
            FileUtil.write(StreamUtils.GetBytes(in), settings.getDownloadTo(), settings.getDownloadStrategy(), true);
        }
        finally {
            ((InputStream)in).close();
        }
        String httpVersion = "1.0";
        Matcher m = Pattern.compile("HTTP/(\\d+.\\d+).*").matcher(response.getConnection().getHeaderField(0));
        if (m.find()) {
            httpVersion = m.group(1);
        }
        HTTPResponse resp = new HTTPResponse(response.getConnection().getResponseMessage(), response.getConnection().getResponseCode(), response.getConnection().getHeaderFields(), b, httpVersion);
        if (cookieStash != null && resp.getHeaderNames().contains("Set-Cookie")) {
            for (String h : resp.getHeaders("Set-Cookie")) {
                cookieStash.addCookie(new Cookie(h, url));
            }
        }
        return resp;
    }

    public static void GetPage(final URL url, final RequestSettings settings, final HTTPResponseCallback callback) {
        URL_RETRIEVER_POOL.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    HTTPResponse response = WebUtility.GetPage(url, settings);
                    if (callback == null) {
                        return;
                    }
                    callback.response(response);
                }
                catch (IOException ex) {
                    if (callback == null) {
                        return;
                    }
                    callback.error(ex);
                }
            }
        });
    }

    public static HTTPResponse GetPage(URL url) throws IOException {
        return WebUtility.GetPage(url, null);
    }

    public static HTTPResponse GetPage(String url) throws IOException {
        return WebUtility.GetPage(new URL(url));
    }

    public static RawHTTPResponse getWebStream(URL url, RequestSettings requestSettings) throws SocketTimeoutException, IOException {
        InputStream is;
        Object cookies;
        HttpURLConnection conn;
        InetSocketAddress addr;
        if (requestSettings == null) {
            requestSettings = new RequestSettings();
        }
        final RequestSettings settings = requestSettings;
        Logger logger = settings.getLogger();
        HTTPMethod method = settings.getMethod();
        Map<String, List<String>> headers = settings.getHeaders();
        Map<String, List<String>> parameters = settings.getParameters();
        Map<String, List<String>> queryParameters = settings.getQueryParameters();
        CookieJar cookieStash = settings.getCookieJar();
        boolean followRedirects = settings.getFollowRedirects();
        int timeout = settings.getTimeout();
        String username = settings.getUsername();
        String password = settings.getPassword();
        if (logger != null) {
            logger.log(Level.INFO, "Using the following settings:\nHTTP method: {0}\nHeaders: {1}\nParameters: {2}\nRaw parameter Length: {3}\nCookie stash: {4}\nFollow redirects? {5}\nTimeout: {6}\nUsername: {7}\nPassword length: {8}\n", new Object[]{method, headers, parameters, settings.getRawParameter() == null ? "null" : Integer.valueOf(settings.getRawParameter().length), cookieStash, followRedirects, timeout, username, password == null ? "null" : Integer.valueOf(password.length())});
        }
        if (parameters != null && !parameters.isEmpty() && (method == HTTPMethod.GET || method != HTTPMethod.GET && settings.getRawParameter() != null && settings.getRawParameter().length != 0)) {
            StringBuilder b = new StringBuilder(url.getQuery() == null ? "" : url.getQuery());
            if (b.length() != 0) {
                b.append("&");
            }
            b.append(WebUtility.encodeListParameters(parameters));
            parameters = null;
            String query2 = b.toString();
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath() + "?" + query2);
        }
        if (queryParameters != null && !queryParameters.isEmpty()) {
            String query3 = url.getQuery();
            if (query3 == null) {
                query3 = "?";
            }
            query3 = query3 + WebUtility.encodeListParameters(queryParameters);
            url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath() + query3);
        }
        if (logger != null) {
            logger.log(Level.INFO, "Using url: {0}", url);
        }
        Proxy proxy = settings.getProxy() == null ? Proxy.NO_PROXY : settings.getProxy();
        if (logger != null) {
            logger.log(Level.INFO, "Using proxy: {0}", proxy);
        }
        if ((addr = (InetSocketAddress)proxy.address()) != null && addr.isUnresolved()) {
            throw new IOException("Could not resolve the proxy address: " + addr.toString());
        }
        if (logger != null) {
            logger.log(Level.INFO, "Opening connection...");
        }
        if ((conn = (HttpURLConnection)url.openConnection()) instanceof HttpsURLConnection && (settings.getDisableCertChecking() || !settings.getUseDefaultTrustStore() || !settings.getTrustStore().isEmpty())) {
            SSLContext sslc;
            HttpsURLConnection conns = (HttpsURLConnection)conn;
            try {
                sslc = SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IOException(ex);
            }
            TrustManager defaultTrustManager = null;
            if (settings.getUseDefaultTrustStore()) {
                TrustManagerFactory tmf;
                try {
                    tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new RuntimeException(ex);
                }
                try {
                    tmf.init((KeyStore)null);
                }
                catch (KeyStoreException ex) {
                    throw new IOException(ex);
                }
                for (TrustManager tm : tmf.getTrustManagers()) {
                    if (!(tm instanceof X509TrustManager)) continue;
                    defaultTrustManager = tm;
                    break;
                }
            } else {
                defaultTrustManager = null;
            }
            final X509TrustManager finalDefaultTrustManager = (X509TrustManager)defaultTrustManager;
            TrustManager[] overrideTrustManager = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                    throw new CertificateException("Not supported yet");
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
                    if (settings.getDisableCertChecking()) {
                        return;
                    }
                    boolean trusted = true;
                    if (finalDefaultTrustManager != null) {
                        try {
                            finalDefaultTrustManager.checkClientTrusted(xcs, string);
                        }
                        catch (CertificateException ex) {
                            trusted = false;
                        }
                    }
                    if (trusted) {
                        return;
                    }
                    for (X509Certificate c : xcs) {
                        LinkedHashMap<String, String> ts = settings.getTrustStore();
                        for (String fingerprint : ts.keySet()) {
                            fingerprint = fingerprint.toLowerCase().replace(" ", "");
                            try {
                                String scheme = ts.get(fingerprint);
                                String fp = WebUtility.getThumbPrint(c, scheme).toLowerCase().replace(" ", "");
                                if (!fp.equals(fingerprint)) continue;
                                return;
                            }
                            catch (NoSuchAlgorithmException | CertificateEncodingException ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                    }
                    throw new CertificateException();
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    if (settings.getDisableCertChecking()) {
                        return new X509Certificate[0];
                    }
                    if (finalDefaultTrustManager != null) {
                        return finalDefaultTrustManager.getAcceptedIssuers();
                    }
                    return new X509Certificate[0];
                }
            }};
            try {
                sslc.init(null, overrideTrustManager, new SecureRandom());
            }
            catch (KeyManagementException ex) {
                throw new IOException(ex);
            }
            final SSLSocketFactory ssf = sslc.getSocketFactory();
            conns.setSSLSocketFactory(new SSLSocketFactory(){

                @Override
                public String[] getDefaultCipherSuites() {
                    return ssf.getDefaultCipherSuites();
                }

                @Override
                public String[] getSupportedCipherSuites() {
                    return ssf.getSupportedCipherSuites();
                }

                @Override
                public Socket createSocket(Socket socket, String string, int i, boolean bln) throws IOException {
                    return ssf.createSocket(socket, string, i, bln);
                }

                @Override
                public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
                    return ssf.createSocket(string, i);
                }

                @Override
                public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException, UnknownHostException {
                    return ssf.createSocket(string, i, ia, i1);
                }

                @Override
                public Socket createSocket(InetAddress ia, int i) throws IOException {
                    return ssf.createSocket(ia, i);
                }

                @Override
                public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
                    return ssf.createSocket(ia, i, ia1, i1);
                }
            });
        }
        conn.setConnectTimeout(timeout);
        conn.setInstanceFollowRedirects(followRedirects);
        if (cookieStash != null && (cookies = cookieStash.getCookies(url)) != null) {
            conn.setRequestProperty("Cookie", (String)cookies);
        }
        if (username != null && password != null) {
            if (logger != null) {
                logger.log(Level.INFO, "Using Username/Password authentication, adding Authorization header");
            }
            conn.setRequestProperty("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes("UTF-8")), "UTF-8"));
        }
        if (headers != null) {
            for (String key : headers.keySet()) {
                conn.setRequestProperty(key, StringUtils.Join(headers.get(key), ","));
            }
        }
        conn.setRequestMethod(method.name());
        if (parameters != null && !parameters.isEmpty() && !method.equals((Object)HTTPMethod.GET) || settings.getRawParameter() != null) {
            if (logger != null && method.equals((Object)HTTPMethod.GET)) {
                logger.log(Level.WARNING, "Method was set to GET, but raw parameter data was provided, so method is changing to POST.");
            }
            conn.setDoOutput(true);
            byte[] params = ArrayUtils.EMPTY_BYTE_ARRAY;
            if (parameters != null && !parameters.isEmpty()) {
                if (logger != null) {
                    logger.log(Level.INFO, "Parameters are added, and content type set to application/x-www-form-urlencoded");
                }
                params = WebUtility.encodeListParameters(parameters).getBytes("UTF-8");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            } else if (settings.getRawParameter() != null) {
                if (logger != null) {
                    logger.log(Level.INFO, "Raw parameter is added");
                }
                params = settings.getRawParameter();
            }
            conn.setRequestProperty("Content-Length", Integer.toString(params.length));
            if (logger != null) {
                logger.log(Level.INFO, "Content length is {0}", params.length);
                logger.log(Level.INFO, "Writing out request now");
            }
            BufferedOutputStream os = new BufferedOutputStream(conn.getOutputStream());
            ((OutputStream)os).write(params);
            ((OutputStream)os).close();
        }
        if (logger != null) {
            logger.log(Level.INFO, "Output sent");
        }
        try {
            is = conn.getInputStream();
        }
        catch (UnknownHostException e2) {
            throw e2;
        }
        catch (Exception e3) {
            if (logger != null) {
                logger.log(Level.SEVERE, "Exception occurred, {0} response from server", conn.getResponseCode());
            }
            if (e3 instanceof SSLHandshakeException) {
                throw new IOException("Invalid SSL certificate for " + url.getHost() + ". Refusing to connect.");
            }
            is = conn.getErrorStream();
        }
        if (!settings.getDisableCompressionHandling() && conn.getContentEncoding() != null) {
            List compression = Stream.of(conn.getContentEncoding().split(",")).map(e -> e.trim()).collect(Collectors.toList());
            for (String scheme : compression) {
                if ("x-gzip".equals(scheme) || "gzip".equals(scheme)) {
                    if (logger != null) {
                        logger.log(Level.INFO, "Response is gzipped, using a GZIPInputStream");
                    }
                    is = new GZIPInputStream(is);
                    continue;
                }
                if ("deflate".equals(scheme)) {
                    if (logger != null) {
                        logger.log(Level.INFO, "Response is zipped, using an InflaterInputStream");
                    }
                    is = new InflaterInputStream(is);
                    continue;
                }
                if ("br".equals(scheme)) {
                    if (logger != null) {
                        logger.log(Level.INFO, "Response is Brotli compressed, using a BrotliInputStream");
                    }
                    is = new BrotliInputStream(is);
                    continue;
                }
                if (!"identity".equals(scheme) || logger == null) continue;
                logger.log(Level.INFO, "Response is not compressed");
            }
        }
        if (is == null) {
            throw new IOException("Could not connect to " + url);
        }
        return new RawHTTPResponse(conn, is);
    }

    public static String encodeParameters(Map<String, String> parameters) {
        HashMap<String, List<String>> p2 = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(e.getValue());
            p2.put(e.getKey(), list);
        }
        return WebUtility.encodeListParameters(p2);
    }

    public static String encodeListParameters(Map<String, List<String>> parameters) {
        if (parameters == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String key : parameters.keySet()) {
            if (!first) {
                b.append("&");
            }
            first = false;
            List<String> values = parameters.get(key);
            try {
                if (values.size() == 1) {
                    String value = values.get(0);
                    b.append(URLEncoder.encode(key, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
                    continue;
                }
                boolean innerFirst = true;
                for (String value : values) {
                    if (!innerFirst) {
                        b.append("&");
                    }
                    innerFirst = false;
                    b.append(URLEncoder.encode(key + "[]", "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error(ex);
            }
        }
        return b.toString();
    }

    public static String GetPageContents(URL url) throws IOException {
        return new String(WebUtility.GetPage(url).getContent(), "UTF-8");
    }

    public static String GetPageContents(String url) throws IOException {
        return new String(WebUtility.GetPage(url).getContent(), "UTF-8");
    }

    public static byte[] GetPageContentsBinary(URL url) throws IOException {
        return WebUtility.GetPage(url).getContent();
    }

    public static byte[] GetPageContentsBinary(String url) throws IOException {
        return WebUtility.GetPage(url).getContent();
    }

    public static Map<String, String> getQueryMap(String query2) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        if (query2 == null) {
            return map;
        }
        for (String param : params = query2.split("&")) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    public static Map<String, List<String>> getQueryMapList(String query2) {
        String[] params;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (query2 == null) {
            return map;
        }
        for (String param : params = query2.split("&")) {
            List<String> values;
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            if (name.endsWith("[]")) {
                name = name.substring(0, name.length() - 2);
            }
            if (map.containsKey(name)) {
                values = (List)map.get(name);
            } else {
                values = new ArrayList();
                map.put(name, values);
            }
            values.add(value);
        }
        return map;
    }

    public static String getThumbPrint(X509Certificate cert, String encryptionScheme) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = cert.getEncoded();
        md.update(der);
        byte[] digest = md.digest();
        return StringUtils.toHex(digest);
    }
}

