/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCBlockStateMeta;
import com.laytonsmith.abstraction.blocks.MCBlockState;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemMeta;
import com.laytonsmith.core.Static;
import java.util.logging.Level;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitMCBlockStateMeta
extends BukkitMCItemMeta
implements MCBlockStateMeta {
    BlockStateMeta bsm;

    public BukkitMCBlockStateMeta(BlockStateMeta meta) {
        super((ItemMeta)meta);
        this.bsm = meta;
    }

    @Override
    public MCBlockState getBlockState() {
        return this.getBlockState(false);
    }

    @Override
    public MCBlockState getBlockState(boolean copy) {
        BlockState bs;
        BlockStateMeta meta = this.bsm;
        if (copy) {
            meta = (BlockStateMeta)meta.clone();
        }
        try {
            bs = meta.getBlockState();
        }
        catch (Exception ex) {
            Static.getLogger().log(Level.WARNING, ex.getMessage() + " when trying to get the BlockState from " + this.bsm.toString());
            return null;
        }
        return BukkitConvertor.BukkitGetCorrectBlockState(bs);
    }

    @Override
    public void setBlockState(MCBlockState state) {
        this.bsm.setBlockState((BlockState)state.getHandle());
    }
}

