/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCProjectileSource;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.entities.MCProjectile;
import com.laytonsmith.abstraction.enums.MCEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class BukkitMCEntityProjectileSource
extends BukkitMCEntity
implements MCProjectileSource {
    ProjectileSource eps;

    public BukkitMCEntityProjectileSource(Entity source) {
        super(source);
        if (!(source instanceof ProjectileSource)) {
            throw new IllegalArgumentException("Tried to construct BukkitMCEntityProjectileSource from invalid source.");
        }
        this.eps = (ProjectileSource)source;
    }

    @Override
    public MCProjectile launchProjectile(MCEntityType projectile) {
        EntityType et = (EntityType)projectile.getConcrete();
        Class c = et.getEntityClass();
        Projectile proj = this.eps.launchProjectile(c.asSubclass(Projectile.class));
        MCEntity mcproj = BukkitConvertor.BukkitGetCorrectEntity((Entity)proj);
        if (mcproj instanceof MCProjectile) {
            return (MCProjectile)mcproj;
        }
        return null;
    }

    @Override
    public MCProjectile launchProjectile(MCEntityType projectile, Vector3D init) {
        EntityType et = (EntityType)projectile.getConcrete();
        Class c = et.getEntityClass();
        Vector vector = new Vector(init.X(), init.Y(), init.Z());
        Projectile proj = this.eps.launchProjectile(c.asSubclass(Projectile.class), vector);
        MCEntity mcproj = BukkitConvertor.BukkitGetCorrectEntity((Entity)proj);
        if (mcproj instanceof MCProjectile) {
            return (MCProjectile)mcproj;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.eps.toString();
    }

    @Override
    public int hashCode() {
        return this.eps.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof BukkitMCEntityProjectileSource && this.eps.equals(((BukkitMCEntityProjectileSource)obj).eps);
    }
}

