/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockData;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCMaterial;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCFirework;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCHanging;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCItem;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLivingEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCProjectile;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCThrownPotion;
import com.laytonsmith.abstraction.entities.MCFirework;
import com.laytonsmith.abstraction.entities.MCHanging;
import com.laytonsmith.abstraction.entities.MCItem;
import com.laytonsmith.abstraction.entities.MCProjectile;
import com.laytonsmith.abstraction.entities.MCThrownPotion;
import com.laytonsmith.abstraction.enums.MCDamageCause;
import com.laytonsmith.abstraction.enums.MCEntityType;
import com.laytonsmith.abstraction.enums.MCEquipmentSlot;
import com.laytonsmith.abstraction.enums.MCRegainReason;
import com.laytonsmith.abstraction.enums.MCRemoveCause;
import com.laytonsmith.abstraction.enums.MCSpawnReason;
import com.laytonsmith.abstraction.enums.MCTargetReason;
import com.laytonsmith.abstraction.enums.MCUnleashReason;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCDamageCause;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEntityType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCRegainReason;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCRemoveCause;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCSpawnReason;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCUnleashReason;
import com.laytonsmith.abstraction.events.MCCreatureSpawnEvent;
import com.laytonsmith.abstraction.events.MCEntityChangeBlockEvent;
import com.laytonsmith.abstraction.events.MCEntityDamageByEntityEvent;
import com.laytonsmith.abstraction.events.MCEntityDamageEvent;
import com.laytonsmith.abstraction.events.MCEntityDeathEvent;
import com.laytonsmith.abstraction.events.MCEntityEnterPortalEvent;
import com.laytonsmith.abstraction.events.MCEntityExplodeEvent;
import com.laytonsmith.abstraction.events.MCEntityInteractEvent;
import com.laytonsmith.abstraction.events.MCEntityPortalEvent;
import com.laytonsmith.abstraction.events.MCEntityRegainHealthEvent;
import com.laytonsmith.abstraction.events.MCEntityTargetEvent;
import com.laytonsmith.abstraction.events.MCEntityToggleGlideEvent;
import com.laytonsmith.abstraction.events.MCEntityUnleashEvent;
import com.laytonsmith.abstraction.events.MCFireworkExplodeEvent;
import com.laytonsmith.abstraction.events.MCHangingBreakEvent;
import com.laytonsmith.abstraction.events.MCHangingPlaceEvent;
import com.laytonsmith.abstraction.events.MCItemDespawnEvent;
import com.laytonsmith.abstraction.events.MCItemSpawnEvent;
import com.laytonsmith.abstraction.events.MCPlayerDropItemEvent;
import com.laytonsmith.abstraction.events.MCPlayerInteractAtEntityEvent;
import com.laytonsmith.abstraction.events.MCPlayerInteractEntityEvent;
import com.laytonsmith.abstraction.events.MCPlayerPickupItemEvent;
import com.laytonsmith.abstraction.events.MCPotionSplashEvent;
import com.laytonsmith.abstraction.events.MCProjectileHitEvent;
import com.laytonsmith.abstraction.events.MCProjectileLaunchEvent;
import com.laytonsmith.annotations.abstraction;
import com.laytonsmith.core.Static;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class BukkitEntityEvents {

    public static class BukkitMCEntityUnleashEvent
    implements MCEntityUnleashEvent {
        EntityUnleashEvent ide;

        public BukkitMCEntityUnleashEvent(Event event) {
            this.ide = (EntityUnleashEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.ide;
        }

        @Override
        public MCEntity getEntity() {
            return new BukkitMCEntity(this.ide.getEntity());
        }

        @Override
        public MCUnleashReason getReason() {
            return (MCUnleashReason)((Object)BukkitMCUnleashReason.getConvertor().getAbstractedEnum(this.ide.getReason()));
        }
    }

    public static class BukkitMCEntityPortalEvent
    implements MCEntityPortalEvent {
        EntityPortalEvent epe;

        public BukkitMCEntityPortalEvent(Event event) {
            this.epe = (EntityPortalEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.epe;
        }

        @Override
        public MCEntity getEntity() {
            return new BukkitMCEntity(this.epe.getEntity());
        }

        @Override
        public void setTo(MCLocation newloc) {
            World w = (World)newloc.getWorld().getHandle();
            Location loc = new Location(w, newloc.getX(), newloc.getY(), newloc.getZ());
            this.epe.setTo(loc);
            if (Static.getServer().getMinecraftVersion().lt(MCVersion.MC1_14)) {
                this.useTravelAgent();
            }
        }

        @Override
        public MCLocation getFrom() {
            return new BukkitMCLocation(this.epe.getFrom());
        }

        @Override
        public MCLocation getTo() {
            if (this.epe.getTo() == null) {
                return null;
            }
            return new BukkitMCLocation(this.epe.getTo());
        }

        @Override
        public void setCancelled(boolean state) {
            this.epe.setCancelled(state);
        }

        @Override
        public boolean isCancelled() {
            return this.epe.isCancelled();
        }

        private Object getTravelAgent() {
            return ReflectionUtils.invokeMethod(PlayerPortalEvent.class, this.epe, "getPortalTravelAgent");
        }

        private void useTravelAgent() {
            ReflectionUtils.set(PlayerPortalEvent.class, this.epe, "useTravelAgent", true);
        }

        @Override
        public int getSearchRadius() {
            try {
                return this.epe.getSearchRadius();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                try {
                    Object ta = this.getTravelAgent();
                    return (Integer)ReflectionUtils.invokeMethod(ta, "getSearchRadius");
                }
                catch (ReflectionUtils.ReflectionException reflectionException) {
                    return 128;
                }
            }
        }

        @Override
        public void setSearchRadius(int radius) {
            try {
                this.epe.setSearchRadius(radius);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            try {
                this.useTravelAgent();
                Object ta = this.getTravelAgent();
                ReflectionUtils.set(ta.getClass(), ta, "searchRadius", radius);
            }
            catch (ReflectionUtils.ReflectionException reflectionException) {
                // empty catch block
            }
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCEntityRegainHealthEvent
    implements MCEntityRegainHealthEvent {
        EntityRegainHealthEvent e;

        public BukkitMCEntityRegainHealthEvent(Event e) {
            this.e = (EntityRegainHealthEvent)e;
        }

        @Override
        public Object _GetObject() {
            return this.e;
        }

        @Override
        public double getAmount() {
            return this.e.getAmount();
        }

        @Override
        public void setAmount(double amount) {
            this.e.setAmount(amount);
        }

        @Override
        public MCEntity getEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.e.getEntity());
        }

        @Override
        public MCRegainReason getRegainReason() {
            return (MCRegainReason)((Object)BukkitMCRegainReason.getConvertor().getAbstractedEnum(this.e.getRegainReason()));
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCFireworkExplodeEvent
    implements MCFireworkExplodeEvent {
        FireworkExplodeEvent e;

        public BukkitMCFireworkExplodeEvent(Event e) {
            this.e = (FireworkExplodeEvent)e;
        }

        @Override
        public Object _GetObject() {
            return this.e;
        }

        @Override
        public MCFirework getEntity() {
            return new BukkitMCFirework((Entity)this.e.getEntity());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCEntityToggleGlideEvent
    implements MCEntityToggleGlideEvent {
        EntityToggleGlideEvent e;

        public BukkitMCEntityToggleGlideEvent(Event e) {
            this.e = (EntityToggleGlideEvent)e;
        }

        @Override
        public Object _GetObject() {
            return this.e;
        }

        @Override
        public boolean isGliding() {
            return this.e.isGliding();
        }

        @Override
        public MCEntity getEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.e.getEntity());
        }

        @Override
        public MCEntityType getEntityType() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.e.getEntity()).getType();
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCHangingPlaceEvent
    implements MCHangingPlaceEvent {
        HangingPlaceEvent hpe;

        public BukkitMCHangingPlaceEvent(Event event) {
            this.hpe = (HangingPlaceEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.hpe;
        }

        @Override
        public MCHanging getEntity() {
            return new BukkitMCHanging((Entity)this.hpe.getEntity());
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.hpe.getPlayer());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCHangingBreakEvent
    implements MCHangingBreakEvent {
        HangingBreakEvent hbe;

        public BukkitMCHangingBreakEvent(Event event) {
            this.hbe = (HangingBreakEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.hbe;
        }

        @Override
        public MCHanging getEntity() {
            return new BukkitMCHanging((Entity)this.hbe.getEntity());
        }

        @Override
        public MCRemoveCause getCause() {
            return (MCRemoveCause)((Object)BukkitMCRemoveCause.getConvertor().getAbstractedEnum(this.hbe.getCause()));
        }

        @Override
        public MCEntity getRemover() {
            if (this.hbe instanceof HangingBreakByEntityEvent) {
                return BukkitConvertor.BukkitGetCorrectEntity(((HangingBreakByEntityEvent)this.hbe).getRemover());
            }
            return null;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCEntityInteractEvent
    implements MCEntityInteractEvent {
        EntityInteractEvent eie;

        public BukkitMCEntityInteractEvent(Event event) {
            this.eie = (EntityInteractEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.eie;
        }

        @Override
        public MCEntity getEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.eie.getEntity());
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.eie.getBlock());
        }

        @Override
        public boolean isCancelled() {
            return this.eie.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.eie.setCancelled(cancelled);
        }
    }

    public static class BukkitMCEntityChangeBlockEvent
    implements MCEntityChangeBlockEvent {
        EntityChangeBlockEvent ecb;

        public BukkitMCEntityChangeBlockEvent(Event event) {
            this.ecb = (EntityChangeBlockEvent)event;
        }

        @Override
        public MCEntity getEntity() {
            return new BukkitMCEntity(this.ecb.getEntity());
        }

        @Override
        public MCBlock getBlock() {
            return new BukkitMCBlock(this.ecb.getBlock());
        }

        @Override
        public MCMaterial getTo() {
            return new BukkitMCMaterial(this.ecb.getTo());
        }

        @Override
        public MCBlockData getBlockData() {
            return new BukkitMCBlockData(this.ecb.getBlockData());
        }

        @Override
        public boolean isCancelled() {
            return this.ecb.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.ecb.setCancelled(cancelled);
        }

        @Override
        public Object _GetObject() {
            return this.ecb;
        }
    }

    public static class BukkitMCEntityEnterPortalEvent
    implements MCEntityEnterPortalEvent {
        EntityPortalEnterEvent epe;

        public BukkitMCEntityEnterPortalEvent(Event event) {
            this.epe = (EntityPortalEnterEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.epe;
        }

        @Override
        public MCEntity getEntity() {
            return new BukkitMCEntity(this.epe.getEntity());
        }

        @Override
        public MCLocation getLocation() {
            return new BukkitMCLocation(this.epe.getLocation());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCTargetEvent
    implements MCEntityTargetEvent {
        EntityTargetEvent pie;

        public BukkitMCTargetEvent(Event e) {
            this.pie = (EntityTargetEvent)e;
        }

        public static BukkitMCTargetEvent _instantiate(Entity entity, LivingEntity target, EntityTargetEvent.TargetReason reason) {
            return new BukkitMCTargetEvent((Event)new EntityTargetEvent(((BukkitMCEntity)entity).getHandle(), (Entity)((LivingEntity)((BukkitMCLivingEntity)target).getLivingEntity()), reason));
        }

        @Override
        public Object _GetObject() {
            return this.pie;
        }

        @Override
        public MCEntity getTarget() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.pie.getTarget());
        }

        @Override
        public void setTarget(MCEntity target) {
            if (target == null) {
                this.pie.setTarget(null);
            } else {
                this.pie.setTarget(((BukkitMCEntity)target).getHandle());
            }
        }

        @Override
        public MCEntity getEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.pie.getEntity());
        }

        @Override
        public MCEntityType getEntityType() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.pie.getEntity()).getType();
        }

        @Override
        public MCTargetReason getReason() {
            return MCTargetReason.valueOf(this.pie.getReason().name());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCEntityDamageByEntityEvent
    extends BukkitMCEntityDamageEvent
    implements MCEntityDamageByEntityEvent {
        EntityDamageByEntityEvent event;

        public BukkitMCEntityDamageByEntityEvent(Event e) {
            super(e);
            this.event = (EntityDamageByEntityEvent)e;
        }

        @Override
        public MCEntity getDamager() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.event.getDamager());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCEntityDamageEvent
    implements MCEntityDamageEvent {
        EntityDamageEvent event;

        public BukkitMCEntityDamageEvent(Event e) {
            this.event = (EntityDamageEvent)e;
        }

        @Override
        public Object _GetObject() {
            return this.event;
        }

        @Override
        public MCDamageCause getCause() {
            return (MCDamageCause)((Object)BukkitMCDamageCause.getConvertor().getAbstractedEnum(this.event.getCause()));
        }

        @Override
        public MCEntity getEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.event.getEntity());
        }

        @Override
        public double getFinalDamage() {
            return this.event.getFinalDamage();
        }

        @Override
        public double getDamage() {
            return this.event.getDamage();
        }

        @Override
        public void setDamage(double damage) {
            this.event.setDamage(damage);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerPickupItemEvent
    implements MCPlayerPickupItemEvent {
        EntityPickupItemEvent e;

        public BukkitMCPlayerPickupItemEvent(Event e) {
            this.e = (EntityPickupItemEvent)e;
        }

        @Override
        public int getRemaining() {
            return this.e.getRemaining();
        }

        @Override
        public MCItem getItem() {
            return new BukkitMCItem((Entity)this.e.getItem());
        }

        @Override
        public void setItemStack(MCItemStack stack) {
            ItemStack is = (ItemStack)stack.getHandle();
            this.e.setCancelled(true);
            this.e.getItem().remove();
            if (is != null && !is.getType().equals((Object)Material.AIR)) {
                ((Player)this.e.getEntity()).getInventory().addItem(new ItemStack[]{is});
                this.e.getEntity().getWorld().playSound(this.e.getItem().getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 2.0f);
            }
        }

        @Override
        public boolean isCancelled() {
            return this.e.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.e.setCancelled(cancelled);
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.e.getEntity());
        }

        @Override
        public Object _GetObject() {
            return this.e;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerDropItemEvent
    implements MCPlayerDropItemEvent {
        PlayerDropItemEvent e;

        public BukkitMCPlayerDropItemEvent(Event e) {
            this.e = (PlayerDropItemEvent)e;
        }

        @Override
        public MCItem getItemDrop() {
            return new BukkitMCItem((Entity)this.e.getItemDrop());
        }

        @Override
        public void setItemStack(MCItemStack stack) {
            ItemStack is = (ItemStack)stack.getHandle();
            if (is == null || is.getType().equals((Object)Material.AIR)) {
                this.e.getItemDrop().remove();
            } else {
                this.e.getItemDrop().setItemStack(is);
            }
        }

        @Override
        public boolean isCancelled() {
            return this.e.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.e.setCancelled(cancelled);
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.e.getPlayer());
        }

        @Override
        public Object _GetObject() {
            return this.e;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerInteractAtEntityEvent
    extends BukkitMCPlayerInteractEntityEvent
    implements MCPlayerInteractAtEntityEvent {
        PlayerInteractAtEntityEvent e;

        public BukkitMCPlayerInteractAtEntityEvent(Event event) {
            super(event);
            this.e = (PlayerInteractAtEntityEvent)event;
        }

        @Override
        public Vector3D getClickedPosition() {
            Vector v = this.e.getClickedPosition();
            return new Vector3D(v.getX(), v.getY(), v.getZ());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerInteractEntityEvent
    implements MCPlayerInteractEntityEvent {
        PlayerInteractEntityEvent e;

        public BukkitMCPlayerInteractEntityEvent(Event event) {
            this.e = (PlayerInteractEntityEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.e;
        }

        @Override
        public MCEntity getEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.e.getRightClicked());
        }

        @Override
        public boolean isCancelled() {
            return this.e.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.e.setCancelled(cancelled);
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.e.getPlayer());
        }

        @Override
        public MCEquipmentSlot getHand() {
            if (this.e.getHand() == EquipmentSlot.HAND) {
                return MCEquipmentSlot.WEAPON;
            }
            return MCEquipmentSlot.OFF_HAND;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCCreatureSpawnEvent
    implements MCCreatureSpawnEvent {
        CreatureSpawnEvent e;

        public BukkitMCCreatureSpawnEvent(Event event) {
            this.e = (CreatureSpawnEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.e;
        }

        @Override
        public MCLivingEntity getEntity() {
            return (MCLivingEntity)BukkitConvertor.BukkitGetCorrectEntity((Entity)this.e.getEntity());
        }

        @Override
        public MCLocation getLocation() {
            return new BukkitMCLocation(this.e.getLocation());
        }

        @Override
        public MCSpawnReason getSpawnReason() {
            return (MCSpawnReason)((Object)BukkitMCSpawnReason.getConvertor().getAbstractedEnum(this.e.getSpawnReason()));
        }

        @Override
        public void setType(MCEntityType type) {
            this.e.setCancelled(true);
            this.e.getLocation().getWorld().spawnEntity(this.e.getLocation(), EntityType.valueOf((String)type.name()));
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCEntityDeathEvent
    implements MCEntityDeathEvent {
        EntityDeathEvent e;

        public BukkitMCEntityDeathEvent(Event e) {
            this.e = (EntityDeathEvent)e;
        }

        @Override
        public Object _GetObject() {
            return this.e;
        }

        @Override
        public int getDroppedExp() {
            return this.e.getDroppedExp();
        }

        @Override
        public List<MCItemStack> getDrops() {
            List islist = this.e.getDrops();
            ArrayList<MCItemStack> drops = new ArrayList<MCItemStack>();
            for (ItemStack is : islist) {
                drops.add(new BukkitMCItemStack(is));
            }
            return drops;
        }

        @Override
        public void clearDrops() {
            this.e.getDrops().clear();
        }

        @Override
        public void addDrop(MCItemStack is) {
            this.e.getDrops().add(((BukkitMCItemStack)is).__ItemStack());
        }

        @Override
        public MCLivingEntity getEntity() {
            return new BukkitMCLivingEntity((Entity)this.e.getEntity());
        }

        @Override
        public void setDroppedExp(int exp) {
            this.e.setDroppedExp(exp);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPotionSplashEvent
    implements MCPotionSplashEvent {
        PotionSplashEvent pse;

        public BukkitMCPotionSplashEvent(Event event) {
            this.pse = (PotionSplashEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.pse;
        }

        @Override
        public MCThrownPotion getEntity() {
            return new BukkitMCThrownPotion((Entity)this.pse.getEntity());
        }

        @Override
        public Map<MCLivingEntity, Double> getAffectedEntities() {
            HashMap<MCLivingEntity, Double> ret = new HashMap<MCLivingEntity, Double>();
            for (LivingEntity le : this.pse.getAffectedEntities()) {
                ret.put(new BukkitMCLivingEntity((Entity)le), this.pse.getIntensity(le));
            }
            return ret;
        }

        @Override
        public void setIntensity(MCLivingEntity le, double intensity) {
            this.pse.setIntensity(((BukkitMCLivingEntity)le).asLivingEntity(), intensity);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCProjectileLaunchEvent
    implements MCProjectileLaunchEvent {
        ProjectileLaunchEvent ple;

        public BukkitMCProjectileLaunchEvent(Event event) {
            this.ple = (ProjectileLaunchEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.ple;
        }

        @Override
        public MCProjectile getEntity() {
            return (MCProjectile)BukkitConvertor.BukkitGetCorrectEntity((Entity)this.ple.getEntity());
        }

        @Override
        public MCEntityType getEntityType() {
            return BukkitMCEntityType.valueOfConcrete(this.ple.getEntityType());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCProjectileHitEvent
    implements MCProjectileHitEvent {
        ProjectileHitEvent phe;

        public BukkitMCProjectileHitEvent(Event event) {
            this.phe = (ProjectileHitEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.phe;
        }

        @Override
        public MCProjectile getEntity() {
            return new BukkitMCProjectile((Entity)this.phe.getEntity());
        }

        @Override
        public MCEntityType getEntityType() {
            return BukkitMCEntityType.valueOfConcrete(this.phe.getEntityType());
        }

        @Override
        public MCEntity getHitEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.phe.getHitEntity());
        }

        @Override
        public MCBlock getHitBlock() {
            Block blk = this.phe.getHitBlock();
            if (blk == null) {
                return null;
            }
            return new BukkitMCBlock(blk);
        }

        public static BukkitMCProjectileHitEvent _instantiate(MCProjectile p2) {
            return new BukkitMCProjectileHitEvent((Event)new ProjectileHitEvent((Projectile)p2.getHandle()));
        }
    }

    public static class BukkitMCEntityExplodeEvent
    implements MCEntityExplodeEvent {
        EntityExplodeEvent e;

        public BukkitMCEntityExplodeEvent(Event event) {
            this.e = (EntityExplodeEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.e;
        }

        @Override
        public MCEntity getEntity() {
            return BukkitConvertor.BukkitGetCorrectEntity(this.e.getEntity());
        }

        @Override
        public List<MCBlock> getBlocks() {
            ArrayList<MCBlock> ret = new ArrayList<MCBlock>();
            for (Block b : this.e.blockList()) {
                ret.add(new BukkitMCBlock(b));
            }
            return ret;
        }

        @Override
        public void setBlocks(List<MCBlock> blocks) {
            this.e.blockList().clear();
            for (MCBlock b : blocks) {
                this.e.blockList().add(((BukkitMCBlock)b).__Block());
            }
        }

        @Override
        public MCLocation getLocation() {
            return new BukkitMCLocation(this.e.getLocation());
        }

        @Override
        public float getYield() {
            return this.e.getYield();
        }

        @Override
        public void setYield(float power) {
            this.e.setYield(power);
        }
    }

    public static class BukkitMCItemSpawnEvent
    implements MCItemSpawnEvent {
        ItemSpawnEvent ise;

        public BukkitMCItemSpawnEvent(Event event) {
            this.ise = (ItemSpawnEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.ise;
        }

        @Override
        public MCItem getEntity() {
            return new BukkitMCItem((Entity)this.ise.getEntity());
        }

        @Override
        public MCLocation getLocation() {
            return new BukkitMCLocation(this.ise.getLocation());
        }
    }

    public static class BukkitMCItemDespawnEvent
    implements MCItemDespawnEvent {
        ItemDespawnEvent ide;

        public BukkitMCItemDespawnEvent(Event event) {
            this.ide = (ItemDespawnEvent)event;
        }

        @Override
        public Object _GetObject() {
            return this.ide;
        }

        @Override
        public MCItem getEntity() {
            return new BukkitMCItem((Entity)this.ide.getEntity());
        }

        @Override
        public MCLocation getLocation() {
            return new BukkitMCLocation(this.ide.getLocation());
        }
    }
}

