/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.annotations.MEnum;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CDecimal;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CMutablePrimitive;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CNumber;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Booleanish;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class ArgumentValidation {
    private static final Pattern VALID_DOUBLE = Pattern.compile("[\\x00-\\x20]*[+-]?((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.(\\p{Digit}+)([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?)[\\x00-\\x20]*");

    private ArgumentValidation() {
    }

    public static Mixed getItemFromArray(CArray object, String key, Target t, Mixed defaultItem) throws ConfigRuntimeException {
        if (object.containsKey(key)) {
            return object.get(key, t);
        }
        if (defaultItem == null) {
            throw new CREFormatException("Expected the key \"" + key + "\" to be present, but it was not found.", t);
        }
        return defaultItem;
    }

    public static CArray getArray(Mixed construct, Target t) {
        if (construct.isInstanceOf(CArray.TYPE)) {
            return (CArray)construct;
        }
        throw new CRECastException("Expecting array, but received " + construct.val(), t);
    }

    public static <T extends Mixed> T getObject(Mixed construct, Target t, Class<T> clazz) {
        if (clazz.isAssignableFrom(construct.getClass())) {
            return (T)construct;
        }
        String expectedClassName = ClassDiscovery.GetClassAnnotation(clazz, typeof.class).value();
        String actualClassName = ClassDiscovery.GetClassAnnotation(construct.getClass(), typeof.class).value();
        throw new CRECastException("Expecting " + expectedClassName + " but received " + construct.val() + " (" + actualClassName + ") instead.", t);
    }

    public static double getNumber(Mixed c, Target t) {
        double d;
        if (c instanceof CMutablePrimitive) {
            c = ((CMutablePrimitive)c).get();
        }
        if (c == null || c instanceof CNull) {
            return 0.0;
        }
        if (c instanceof CNumber) {
            d = ((CNumber)c).getNumber();
        } else if (c instanceof CString) {
            try {
                d = Double.parseDouble(c.val());
            }
            catch (NumberFormatException e) {
                throw new CRECastException("Expecting a number, but received \"" + c.val() + "\" instead", t);
            }
        } else if (c instanceof CBoolean) {
            d = ((CBoolean)c).getBoolean() ? 1.0 : 0.0;
        } else {
            if (c instanceof CDecimal) {
                throw new CRECastException("Expecting a number, but received a decimal value instead. This cannot be automatically cast, please use double(@decimal) to manually cast down to a double.", t);
            }
            throw new CRECastException("Expecting a number, but received \"" + c.val() + "\" instead", t);
        }
        return d;
    }

    public static boolean isNumber(Mixed c) {
        return c instanceof CNumber || VALID_DOUBLE.matcher(c.val()).matches();
    }

    public static double getDouble(Mixed c, Target t) {
        if (c instanceof CMutablePrimitive) {
            c = ((CMutablePrimitive)c).get();
        }
        try {
            return ArgumentValidation.getNumber(c, t);
        }
        catch (ConfigRuntimeException e) {
            throw new CRECastException("Expecting a double, but received " + c.val() + " instead", t);
        }
    }

    public static float getDouble32(Mixed c, Target t) {
        if (c instanceof CMutablePrimitive) {
            c = ((CMutablePrimitive)c).get();
        }
        double delta = 1.0E-7;
        double l = ArgumentValidation.getDouble(c, t);
        float f = (float)l;
        if (Math.abs((double)f - l) > delta) {
            throw new CRERangeException("Expecting a 32 bit float, but a larger value was found: " + l, t);
        }
        return f;
    }

    public static long getInt(Mixed c, Target t) {
        long i;
        if (c instanceof CMutablePrimitive) {
            c = ((CMutablePrimitive)c).get();
        }
        if (c == null || c instanceof CNull) {
            return 0L;
        }
        if (c.isInstanceOf(CInt.TYPE)) {
            i = ArgumentValidation.getObject(c, t, CInt.class).getInt();
        } else if (c.isInstanceOf(CBoolean.TYPE)) {
            i = ArgumentValidation.getObject(c, t, CBoolean.class).getBoolean() ? 1L : 0L;
        } else {
            try {
                i = Long.parseLong(c.val());
            }
            catch (NumberFormatException e) {
                throw new CRECastException("Expecting an integer, but received \"" + c.val() + "\" instead", t);
            }
        }
        return i;
    }

    public static int getInt32(Mixed c, Target t) {
        long l;
        int i;
        if (c instanceof CMutablePrimitive) {
            c = ((CMutablePrimitive)c).get();
        }
        if ((long)(i = (int)(l = ArgumentValidation.getInt(c, t))) != l) {
            throw new CRERangeException("Expecting a 32 bit integer, but a larger value was found: " + l, t);
        }
        return i;
    }

    public static short getInt16(Mixed c, Target t) {
        long l;
        short s;
        if (c instanceof CMutablePrimitive) {
            c = ((CMutablePrimitive)c).get();
        }
        if ((long)(s = (short)(l = ArgumentValidation.getInt(c, t))) != l) {
            throw new CRERangeException("Expecting a 16 bit integer, but a larger value was found: " + l, t);
        }
        return s;
    }

    public static byte getInt8(Mixed c, Target t) {
        long l;
        byte b;
        if (c instanceof CMutablePrimitive) {
            c = ((CMutablePrimitive)c).get();
        }
        if ((long)(b = (byte)(l = ArgumentValidation.getInt(c, t))) != l) {
            throw new CRERangeException("Expecting an 8 bit integer, but a larger value was found: " + l, t);
        }
        return b;
    }

    public static boolean getBooleanObject(Mixed c, Target t) {
        return ArgumentValidation.getBooleanish(c, t);
    }

    @Deprecated
    public static boolean getBoolean(Mixed c, Target t) {
        return ArgumentValidation.getBooleanish(c, t);
    }

    public static boolean getBooleanish(Mixed c, Target t) {
        if (c instanceof CVoid) {
            return false;
        }
        if (c instanceof CMutablePrimitive) {
            c = ((CMutablePrimitive)c).get();
        }
        if (c == null) {
            return false;
        }
        if (c instanceof Booleanish) {
            return ((Booleanish)c).getBooleanValue(t);
        }
        throw new CRECastException("Could not convert value of type " + c.typeof() + " to a " + Booleanish.TYPE, t);
    }

    public static CByteArray getByteArray(Mixed c, Target t) {
        if (c instanceof CByteArray) {
            return (CByteArray)c;
        }
        if (c instanceof CNull) {
            return new CByteArray(t, 0);
        }
        throw new CRECastException("Expecting byte array, but found " + c.typeof() + " instead.", t);
    }

    public static CClassType getClassType(Mixed c, Target t) {
        if (c instanceof CClassType) {
            return (CClassType)c;
        }
        throw new CRECastException("Expecting a ClassType, but found " + c.typeof() + " instead.", t);
    }

    public static String getString(Mixed c, Target t) {
        return c.val();
    }

    public static String getStringObject(Mixed c, Target t) {
        if (!c.isInstanceOf(CString.class)) {
            throw new CRECastException("Expected a string, but found " + c.typeof() + " instead.", t);
        }
        return c.val();
    }

    public static boolean anyDoubles(Mixed ... c) {
        for (Mixed c1 : c) {
            if (!(c1 instanceof CDouble) && (!(c1 instanceof CString) || c1.val().indexOf(".", 1) <= -1)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyStrings(Mixed ... c) {
        for (Mixed c1 : c) {
            if (!(c1 instanceof CString)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyNulls(Mixed ... c) {
        for (Mixed c1 : c) {
            if (!(c1 instanceof CNull)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyBooleans(Mixed ... c) {
        for (Mixed c1 : c) {
            if (!(c1 instanceof CBoolean)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Enum<T>> T getEnum(Mixed c, Class<T> enumClass, Target t) {
        String val = c.val();
        try {
            return Enum.valueOf(enumClass, val);
        }
        catch (IllegalArgumentException e) {
            String name = "java:" + enumClass.getName();
            MEnum menum = enumClass.getAnnotation(MEnum.class);
            if (menum != null) {
                name = menum.value();
            }
            throw new CRECastException("Cannot find enum of type " + name + " with value \"" + val + "\". Valid options are: " + StringUtils.Join(enumClass.getEnumConstants(), ", ", ", or "), t);
        }
    }

    public static <T extends Enum<T>> Set<T> getEnumSet(Mixed c, Class<T> enumClass, Target t) {
        if (c instanceof CNull) {
            return EnumSet.noneOf(enumClass);
        }
        if (!c.isInstanceOf(CArray.TYPE)) {
            Mixed val = c;
            c = new CArray(t);
            ((CArray)c).push(val, t);
        }
        CArray ca = (CArray)c;
        EnumSet<T> set = EnumSet.noneOf(enumClass);
        for (Mixed v : ca.asList()) {
            set.add(ArgumentValidation.getEnum(v, enumClass, t));
        }
        return set;
    }
}

