/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler.keywords;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CKeyword;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import java.util.List;

@Keyword.keyword(value="try")
public class TryKeyword
extends Keyword {
    @Override
    public int process(List<ParseTree> list, int keywordPosition) throws ConfigCompileException {
        int i;
        if (list.get(keywordPosition).getData() instanceof CFunction && list.get(keywordPosition).getData().val().equals("try")) {
            return keywordPosition;
        }
        this.validateCodeBlock(list.get(keywordPosition + 1), "Expecting braces after try keyword");
        ParseTree complexTry = new ParseTree(new CFunction("complex_try", list.get(keywordPosition).getTarget()), list.get(keywordPosition).getFileOptions());
        complexTry.addChild(TryKeyword.getArgumentOrNull(list.get(keywordPosition + 1)));
        if (list.size() <= keywordPosition + 2 || !this.nodeIsCatchKeyword(list.get(keywordPosition + 2)) && !this.nodeIsFinallyKeyword(list.get(keywordPosition + 2))) {
            throw new ConfigCompileException("Expecting \"catch\" or \"finally\" keyword to follow try, but none found", complexTry.getTarget());
        }
        int numHandledChildren = 2;
        for (i = keywordPosition + 2; i < list.size() && (this.nodeIsCatchKeyword(list.get(i)) || this.nodeIsFinallyKeyword(list.get(i))); i += 2) {
            if (list.size() <= i + 1) {
                throw new ConfigCompileException("catch must be followed by a code block, but none was found", list.get(i).getTarget());
            }
            this.validateCodeBlock(list.get(i + 1), "Expecting code block after catch, but none found");
            if (list.get(i).getData() instanceof CFunction) {
                ParseTree n = list.get(i);
                if (n.getChildren().size() != 1) {
                    throw new ConfigCompileException("Unexpected parameters passed to the \"catch\" clause. Exactly one argument must be passed.", n.getTarget());
                }
                complexTry.addChild(n.getChildAt(0));
                complexTry.addChild(TryKeyword.getArgumentOrNull(list.get(i + 1)));
            } else {
                if (list.size() > i + 2 && this.nodeIsCatchKeyword(list.get(i + 2))) {
                    throw new ConfigCompileException("A finally block must be the final clause in the try/[catch]/finally statement", list.get(i + 2).getTarget());
                }
                complexTry.addChild(TryKeyword.getArgumentOrNull(list.get(i + 1)));
            }
            numHandledChildren += 2;
        }
        for (i = 0; i < numHandledChildren - 1; ++i) {
            list.remove(keywordPosition);
        }
        list.set(keywordPosition, complexTry);
        return keywordPosition;
    }

    private boolean nodeIsCatchKeyword(ParseTree node) {
        return node.getData() instanceof CFunction && node.getData().val().equals("catch");
    }

    private boolean nodeIsFinallyKeyword(ParseTree node) {
        return node.getData() instanceof CKeyword && node.getData().val().equals("finally");
    }

    @Override
    public String docs() {
        return "Used in combination with catch and finally, provides a mechanism to catch and handle expected and unexpected exceptions, and using finally, provides a mechanism to always run certain code, no matter the result of the code in the try block.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }
}

