/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Sizes;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.CRE.CREReadOnlyException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.ArrayAccess;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.natives.interfaces.Sizeable;
import com.laytonsmith.core.objects.ObjectModifier;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;

@typeof(value="ms.lang.byte_array")
public class CByteArray
extends CArray
implements Sizeable,
ArrayAccess {
    public static final CClassType TYPE = CClassType.get(CByteArray.class);
    private static final int INITIAL_SIZE = 1024;
    private static final int SCALE_MULTIPLIER = 2;
    private ByteBuffer data;
    private int maxValue = 0;
    private String value = null;

    public static CByteArray wrap(byte[] b, Target t) {
        CByteArray ba2 = new CByteArray(t, 0);
        ba2.data = ByteBuffer.wrap(b);
        ba2.maxValue = b.length;
        return ba2;
    }

    public CByteArray(Target t) {
        this(t, 1024);
    }

    public CByteArray(Target t, int capacity) {
        super(t, 1024);
        this.data = ByteBuffer.allocate(capacity);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    public void setOrder(ByteOrder bo) {
        this.data.order(bo);
    }

    public ByteOrder getOrder() {
        return this.data.order();
    }

    private void checkSize(int need, Integer pos) {
        int spos = pos == null ? this.data.position() : pos.intValue();
        this.maxValue = Math.max(this.maxValue, spos + need);
        if (spos + need >= this.data.limit()) {
            int newSize = this.data.limit() * 2;
            if (newSize <= 0) {
                newSize = 1;
            }
            ByteBuffer temp = ByteBuffer.allocate(newSize);
            int position = this.data.position();
            this.data.rewind();
            temp.put(this.data);
            this.data = temp;
            this.data.position(position);
        }
        this.value = null;
    }

    @Override
    public String val() {
        if (this.value == null) {
            int position = this.data.position();
            this.data.rewind();
            try {
                this.value = new String(this.data.array(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error(ex);
            }
            this.data.position(position);
        }
        return this.value;
    }

    public void rewind() {
        this.data.rewind();
    }

    public void putByte(byte b, Integer pos) {
        this.checkSize(Sizes.sizeof(Byte.TYPE), pos);
        if (pos != null) {
            this.data.position(pos);
        }
        this.data.put(b);
    }

    public void putChar(char c, Integer pos) {
        this.checkSize(Sizes.sizeof(Character.TYPE), pos);
        if (pos == null) {
            this.data.putChar(c);
        } else {
            this.data.putChar(pos, c);
        }
    }

    public void putDouble(double d, Integer pos) {
        this.checkSize(Sizes.sizeof(Double.TYPE), pos);
        if (pos == null) {
            this.data.putDouble(d);
        } else {
            this.data.putDouble(pos, d);
        }
    }

    public void putFloat(float f, Integer pos) {
        this.checkSize(Sizes.sizeof(Float.TYPE), pos);
        if (pos == null) {
            this.data.putFloat(f);
        } else {
            this.data.putFloat(pos, f);
        }
    }

    public void putInt(int i, Integer pos) {
        this.checkSize(Sizes.sizeof(Integer.TYPE), pos);
        if (pos == null) {
            this.data.putInt(i);
        } else {
            this.data.putInt(pos, i);
        }
    }

    public void putLong(long l, Integer pos) {
        this.checkSize(Sizes.sizeof(Long.TYPE), pos);
        if (pos == null) {
            this.data.putLong(l);
        } else {
            this.data.putLong(pos, l);
        }
    }

    public void putShort(short s, Integer pos) {
        this.checkSize(Sizes.sizeof(Short.TYPE), pos);
        if (pos == null) {
            this.data.putShort(s);
        } else {
            this.data.putShort(pos, s);
        }
    }

    public byte getByte(Integer pos) {
        if (pos == null) {
            return this.data.get();
        }
        return this.data.get(pos);
    }

    public char getChar(Integer pos) {
        if (pos == null) {
            return this.data.getChar();
        }
        return this.data.getChar(pos);
    }

    public double getDouble(Integer pos) {
        if (pos == null) {
            return this.data.getDouble();
        }
        return this.data.getDouble(pos);
    }

    public float getFloat(Integer pos) {
        if (pos == null) {
            return this.data.getFloat();
        }
        return this.data.getFloat(pos);
    }

    public int getInt(Integer pos) {
        if (pos == null) {
            return this.data.getInt();
        }
        return this.data.getInt(pos);
    }

    public long getLong(Integer pos) {
        if (pos == null) {
            return this.data.getLong();
        }
        return this.data.getLong(pos);
    }

    public short getShort(Integer pos) {
        if (pos == null) {
            return this.data.getShort();
        }
        return this.data.getShort(pos);
    }

    public void putBytes(CByteArray d, Integer pos) {
        this.putBytes(d.asByteArrayCopy(), pos);
    }

    public void putBytes(byte[] d, Integer pos) {
        this.checkSize(d.length, pos);
        if (pos != null) {
            this.data.position(pos);
        }
        this.data.put(d);
    }

    public CByteArray getBytes(int size, Integer pos) {
        CByteArray ba2 = new CByteArray(this.getTarget(), 0);
        byte[] d = new byte[size];
        if (pos != null) {
            this.data.position(pos);
        }
        this.data.get(d);
        ba2.data = ByteBuffer.wrap(d);
        return ba2;
    }

    @Override
    public long size() {
        return this.maxValue;
    }

    public int capacity() {
        return this.data.capacity();
    }

    public void writeUTF8String(String string, Integer pos, String encoding) throws IndexOutOfBoundsException, UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        byte[] array2 = string.getBytes(encoding);
        this.checkSize(array2.length + Sizes.sizeof(Short.TYPE), pos);
        if (pos != null) {
            this.data.position(pos);
        }
        if (array2.length > Short.MAX_VALUE) {
            throw new IndexOutOfBoundsException("The length of the string cannot be greater than 32767. If you must encode a string longer than this, you must write the string out yourself.");
        }
        this.data.putShort((short)array2.length);
        this.data.put(array2);
    }

    public String readUTF8String(Integer pos, String encoding) throws UnsupportedEncodingException {
        if (pos != null) {
            this.data.position(pos);
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        byte[] array2 = new byte[this.data.getShort()];
        this.data.get(array2);
        return new String(array2, encoding);
    }

    public CArray asArray(Target t) {
        return new CArrayByteBacking(this.asByteArrayCopy(), t);
    }

    public byte[] asByteArrayCopy() {
        byte[] src = this.data.array();
        byte[] dest = new byte[this.maxValue];
        System.arraycopy(src, 0, dest, 0, this.maxValue);
        return dest;
    }

    @Override
    public boolean canBeAssociative() {
        return false;
    }

    @Override
    public Mixed slice(int begin, int end, Target t) {
        return this.getBytes(end - begin, begin);
    }

    @Override
    public boolean isAssociative() {
        return false;
    }

    @Override
    public Set<Mixed> keySet() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    protected CArray deepClone(CArray array2, Target t, ArrayList<CArray[]> cloneRefs) {
        CByteArray that = (CByteArray)array2;
        byte[] original = that.data.array();
        byte[] newArray = new byte[that.maxValue];
        System.arraycopy(original, 0, newArray, 0, that.maxValue);
        return CByteArray.wrap(newArray, t);
    }

    @Override
    public Mixed get(Mixed index, Target t) throws ConfigRuntimeException {
        int i = ArgumentValidation.getInt32(index, t);
        byte b = this.getByte(i);
        return new CInt(b, t);
    }

    @Override
    public String docs() {
        return "A byte_array represents low level byte data.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{CArray.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[]{Sizeable.TYPE, ArrayAccess.TYPE};
    }

    @typeof(value="ms.lang.ByteBackingArray")
    private static class CArrayByteBacking
    extends CArray {
        public static final CClassType TYPE = CClassType.get(CArrayByteBacking.class);
        private final byte[] backing;
        private String value = null;

        public CArrayByteBacking(byte[] backing, Target t) {
            super(t);
            this.backing = backing;
        }

        @Override
        public void reverse(Target t) {
            throw new CREByteArrayReadOnlyException("Arrays copied from ByteArrays are read only", t);
        }

        @Override
        public void push(Mixed c, Integer i, Target t) {
            throw new CREByteArrayReadOnlyException("Arrays copied from ByteArrays are read only", t);
        }

        @Override
        public void set(Mixed index, Mixed c, Target t) {
            throw new CREByteArrayReadOnlyException("Arrays copied from ByteArrays are read only", t);
        }

        @Override
        public Mixed get(Mixed index, Target t) {
            int i = ArgumentValidation.getInt32(index, t);
            try {
                return new CInt(this.backing[i], t);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new CRERangeException("Index out of range. Found " + i + ", but array length is only " + this.backing.length, t);
            }
        }

        @Override
        public long size() {
            return this.backing.length;
        }

        @Override
        public String val() {
            if (this.value == null) {
                try {
                    this.value = new String(this.backing, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new Error(ex);
                }
            }
            return this.value;
        }

        @Override
        public boolean inAssociativeMode() {
            return false;
        }

        @Override
        protected List<Mixed> getArray() {
            throw new RuntimeException("This error should not happen. Please report this bug to the developers");
        }

        @Override
        protected SortedMap<String, Mixed> getAssociativeArray() {
            throw new Error("This error should not happen. Please report this bug to the developers");
        }

        @Override
        public String docs() {
            return "A read-only subclass of array, which is used to make reading byte arrays more efficient.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_1;
        }

        @Override
        public CClassType[] getInterfaces() {
            return CClassType.EMPTY_CLASS_ARRAY;
        }

        @Override
        public CClassType[] getSuperclasses() {
            return new CClassType[]{CArray.TYPE};
        }

        @Override
        public Set<ObjectModifier> getObjectModifiers() {
            return EnumSet.of(ObjectModifier.STATIC);
        }

        @Override
        public CClassType getContainingClass() {
            return TYPE;
        }

        @typeof(value="ms.lang.ByteArrayReadOnlyException")
        public static class CREByteArrayReadOnlyException
        extends CREReadOnlyException {
            public static final CClassType TYPE = CClassType.get(CREByteArrayReadOnlyException.class);

            public CREByteArrayReadOnlyException(String msg2, Target t) {
                super(msg2, t);
            }

            public CREByteArrayReadOnlyException(String msg2, Target t, Throwable ex) {
                super(msg2, t, ex);
            }

            @Override
            public String docs() {
                return "An exception which is thrown if the array copied from a byte array is attempted to be written to.";
            }

            @Override
            public Version since() {
                return MSVersion.V3_3_1;
            }

            @Override
            public CClassType[] getInterfaces() {
                return super.getInterfaces();
            }

            @Override
            public CClassType[] getSuperclasses() {
                return super.getSuperclasses();
            }

            @Override
            public Set<ObjectModifier> getObjectModifiers() {
                return EnumSet.of(ObjectModifier.STATIC);
            }

            @Override
            public CClassType getContainingClass() {
                return TYPE;
            }
        }
    }
}

